---
layout: post
title: Руководство по включению межсайтовой изоляции
authors:
  - agektmr
date: 2021-02-09
updated: 2021-08-05
subhead: Межсайтовая изоляция позволяет использовать на веб-странице такие мощные функции, как SharedArrayBuffer. В этой статье объясняется, как включить межсайтовую изоляцию на сайте.
description: Межсайтовая изоляция позволяет использовать на веб-странице такие мощные функции, как SharedArrayBuffer. В этой статье объясняется, как включить межсайтовую изоляцию на сайте.
tags:
  - security
---

В этом руководстве показано, как включить межсайтовую изоляцию, которая необходима для использования [`SharedArrayBuffer`](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/SharedArrayBuffer), [`performance.measureUserAgentSpecificMemory()`](/monitor-total-page-memory-usage/) и [высокоточного таймера](https://developer.chrome.com/blog/cross-origin-isolated-hr-timers/).

Прежде чем включать межсайтовую изоляцию, оцените, как она повлияет на рекламные места и другие межсайтовые ресурсы на вашем сайте.

{% Details %} {% DetailsSummary %} Определите, где на вашем сайте используется функция `SharedArrayBuffer`

Начиная с версии Chrome 92, функции, использующие `SharedArrayBuffer`, больше не смогут работать без межсайтовой изоляции. Если вы попали на эту страницу из-за сообщения о нежелательности использования `SharedArrayBuffer`, то, вероятно, сайт или один из встроенных в него ресурсов использует `SharedArrayBuffer`. Чтобы не нарушить работу компонентов сайта, сначала определите, где именно применяется эта функция.

{% endDetailsSummary %}

{% Aside 'objective' %}

- Включите межсайтовую изоляцию, если хотите продолжать использование `SharedArrayBuffer`.
- Если вы используете сторонний код, в котором присутствует `SharedArrayBuffer`, попросите стороннего поставщика внести изменения. {% endAside %}

Если вы не знаете точно, где на сайте используется `SharedArrayBuffer`, воспользуйтесь одним из двух способов:

- примените Chrome DevTools;
- (дополнительно) соберите отчеты о нежелательных функциях.

Если вы уже точно знаете, где используется `SharedArrayBuffer`, перейдите к разделу [«Анализ влияния межсайтовой изоляции»](#analysis).

### Chrome DevTools

С помощью [Chrome DevTools](https://developer.chrome.com/docs/devtools/open/) можно проверить качество кода на сайте.

1. [Откройте Chrome DevTools](https://developer.chrome.com/docs/devtools/open/) на странице, где может использоваться `SharedArrayBuffer`.
2. Выберите панель **Console (Консоль)**.
3. Если на странице используется `SharedArrayBuffer`, то отобразится следующее сообщение:
    ```text
    [Deprecation] SharedArrayBuffer will require cross-origin isolation as of M92, around May 2021. See https://developer.chrome.com/blog/enabling-shared-array-buffer/ for more details. common-bundle.js:535
    ```
4. Имя файла и номер строки в конце сообщения (например, `common-bundle.js:535`) указывают на источник происхождения `SharedArrayBuffer`. Если это сторонняя библиотека, попросите ее разработчика устранить проблему. Если же это часть кода вашего сайта, включите межсайтовую изоляцию, как указано ниже.

<figure>{% Img src="image/YLflGBAPWecgtKJLqCJHSzHqe2J2/GOgkyjAabePTc8AG22F7.png", alt="Предупреждение в консоли DevTools об использовании SharedArrayBuffer без межсайтовой изоляции", width="800", height="163" %} <figcaption> Предупреждение в консоли DevTools об использовании SharedArrayBuffer без межсайтовой изоляции. </figcaption></figure>

### (Дополнительно) Отчеты о нежелательных функциях

В некоторых браузерах есть [функция отчетности о нежелательных API](https://wicg.github.io/deprecation-reporting/) на маршруте до указанной конечной точки.

1. [Настройте сервер отчетов о нежелательных функциях и получите URL-адрес отчета](/coop-coep/#set-up-reporting-endpoint). Это можно сделать с помощью общедоступной службы или самостоятельно.
2. Используя полученный URL-адрес, установите следующий HTTP-заголовок для страниц, на которых может применяться `SharedArrayBuffer`.
    ```http
    Report-To: {"group":"default","max_age":86400,"endpoints":[{"url":"THE_DEPRECATION_ENDPOINT_URL"}]}
    ```
3. Как только заголовок начнет передаваться дальше, конечная точка, которую вы зарегистрировали, станет собирать отчеты о нежелательных функциях.

Пример реализации приведен здесь: [https://cross-origin-isolation.glitch.me](https://cross-origin-isolation.glitch.me).

{% endDetails %}

## Анализ влияния межсайтовой изоляции {: #analysis}

Правда было бы здорово оценивать влияние межсайтовой изоляции, не нарушая работу сайта? Именно это позволяют сделать HTTP-заголовки [`Cross-Origin-Opener-Policy-Report-Only`](https://developer.mozilla.org/docs/Web/HTTP/Headers/Cross-Origin-Opener-Policy) и [`Cross-Origin-Embedder-Policy-Report-Only`](https://developer.mozilla.org/docs/Web/HTTP/Headers/Cross-Origin-Embedder-Policy).

1. Задайте заголовок [`Cross-Origin-Opener-Policy-Report-Only: same-origin`](/coop-coep/#1.-set-the-cross-origin-opener-policy:-same-origin-header-on-the-top-level-document) в документе верхнего уровня. Как следует из названия, этот заголовок только лишь отправляет отчеты о влиянии, которое `COOP: same-origin` **может** оказать на сайт, но не отключает связь с всплывающими окнами.
2. Настройте функцию отчетности и веб-сервер для получения и сохранения отчетов.
3. Задайте заголовок [`Cross-Origin-Embedder-Policy-Report-Only: require-corp`](/coop-coep/#3.-use-the-coep-report-only-http-header-to-assess-embedded-resources) в документе верхнего уровня. Именно этот заголовок позволяет, не нарушая работу сайта, проследить, как включение `COEP: require-corp` повлияет на него. Вы можете настроить этот заголовок для отправки отчетов на тот же сервер отчетов, который настроили на предыдущем шаге.

{% Aside %} Можно также [включить столбец **Domain (Домен)**](https://developer.chrome.com/docs/devtools/network/#information) на панели **Network (Сеть)** в Chrome DevTools, чтобы получить общее представление о том, какие ресурсы будут затронуты. {% endAside %}

{% Aside 'caution' %}

После включения межсайтовой изоляции загрузка ресурсов из разных источников, на которую вы не давали явного разрешения, будет заблокирована, а документ верхнего уровня не сможет взаимодействовать со всплывающими окнами.

Мы изучали разные способы масштабирования `Cross-Origin-Resource-Policy`, поскольку межсайтовая изоляция требует явного разрешения на загрузку для всех вспомогательных ресурсов. В итоге было решено пойти от обратного и ввести [новый «безучетный» (credentialless) режим COEP](https://github.com/mikewest/credentiallessness/), который позволяет загружать ресурсы без заголовка CORP, удаляя все их учетные данные. Мы еще окончательно не определились с тем, как это должно работать, но надеемся, что данный режим снизит для вас трудоемкость проверки того, что вспомогательные ресурсы отправляют заголовок `Cross-Origin-Resource-Policy`.

Кроме того, известно, что заголовок `Cross-Origin-Opener-Policy: same-origin` нарушит те интеграции, которым требуется взаимодействие между окнами из разных источников, например OAuth и платежные формы. Чтобы хотя бы частично решить эту проблему, мы изучаем возможность [ослабления условия](https://github.com/whatwg/html/issues/6364) включения межсайтовой изоляции для `Cross-Origin-Opener-Policy: same-origin-allow-popups`, что позволит сохранить связь с окном, которое открылось самостоятельно.

Если вам не удается включить межсайтовую изоляцию из-за этих проблем, рекомендуем [зарегистрироваться в пробной версии источника](https://developer.chrome.com/blog/enabling-shared-array-buffer/#origin-trial) и подождать, пока не появятся новые режимы. Пробная версия источника будет поддерживаться до тех пор, пока не появятся такие режимы.

{% endAside %}

## Снижение влияния межсайтовой изоляции

Если вы уже определили, какие ресурсы затронет межсайтовая изоляция, придерживайтесь следующих общих рекомендаций о том, как решить проблему с этими ресурсами:

1. Для таких межсайтовых ресурсов, как изображения, скрипты, таблицы стилей, блоки iframe и другие, задайте заголовок [`Cross-Origin-Resource-Policy: cross-origin`](https://resourcepolicy.fyi/#cross-origin). Для локальных ресурсов сайта установите заголовок [`Cross-Origin-Resource-Policy: same-site`](https://resourcepolicy.fyi/#same-origin).
2. Добавьте атрибут `crossorigin` в тег HTML документа верхнего уровня, если ресурс загружается с помощью [CORS](/cross-origin-resource-sharing/) (пример: `<img src="example.jpg" crossorigin>`).
3. Если межсайтовые ресурсы, загруженные в блоки iframe, включают в себя еще один уровень блоков iframe, то рекурсивно выполните действия, описанные в этом разделе, прежде чем двигаться дальше.
4. Убедившись, что все межсайтовые ресурсы имеют разрешение на загрузку, установите заголовок `Cross-Origin-Embedder-Policy: require-corp` для межсайтовых ресурсов, которые загружаются в блоки iframe.
5. Убедитесь в отсутствии межсайтовых всплывающих окон, использующих функцию `postMessage()`. После включения межсайтовой изоляции они точно перестанут работать. Переместите эту функциональность в другой документ, на который не действует межсайтовая изоляция, или используйте другой способ передачи данных (например, HTTP-запросы).

## Включение межсайтовой изоляции

Если вы уже определили, как снизить влияние межсайтовой изоляции, придерживайтесь следующих общих рекомендаций о том, как включить межсайтовую изоляцию:

1. Задайте заголовок `Cross-Origin-Opener-Policy: same-origin` в документе верхнего уровня. Если ранее вы уже задали заголовок `Cross-Origin-Opener-Policy-Report-Only: same-origin`, замените его. Это заблокирует обмен данными между документом верхнего уровня и его всплывающими окнами.
2. Задайте заголовок `Cross-Origin-Embedder-Policy: require-corp` в документе верхнего уровня. Если ранее вы уже задали заголовок `Cross-Origin-Embedder-Policy-Report-Only: require-corp`, замените его. Это заблокирует загрузку межсайтовых ресурсов, не имеющих явного разрешения на загрузку.
3. Убедитесь, что `self.crossOriginIsolated` возвращает `true` в консоли—это означает, что на странице включена межсайтовая изоляция.

{% Aside 'gotchas' %}

Включить межсайтовую изоляцию на локальном сервере затруднительно, так как обычные серверы не поддерживают отправку заголовков. Вы можете запустить Chrome с флагом командной строки `--enable-features=SharedArrayBuffer`, чтобы включить использование `SharedArrayBuffer` без межсайтовой изоляции. Узнайте, [как запускать Chrome с флагом командной строки на соответствующих платформах](https://www.chromium.org/developers/how-tos/run-chromium-with-flags).

{% endAside %}

## Ресурсы

- [Как изолировать сайт от других источников с помощью COOP и COEP](/coop-coep/)
- [Обновления, связанные с SharedArrayBuffer, в версиях Chrome 88 для Android и Chrome 92 для ПК](https://developer.chrome.com/blog/enabling-shared-array-buffer/)
