---
layout: post
title: Что такое прогрессивные веб-приложения?
authors:
  - samrichard
  - petelepage
date: 2020-01-06
updated: 2020-02-24
description: |2-

  Введение в прогрессивные веб-приложения (PWA) и три столпа, которые

  отделяют их от других веб-приложений.
tags:
  - progressive-web-apps
---

Интернет — невероятная платформа. Он повсеместно распространен, доступен с разных устройств и операционных систем, модель безопасности ориентирована на пользователя, при этом не существует единой компании, которая бы контролировала его спецификацию или реализацию. Все это делает Интернет уникальной платформой для разработки программного обеспечения. Учитываю присущую ему линкабельность, в Интернете можно искать что угодно и делиться тем, что вы нашли, с кем угодно и где угодно. Когда бы вы ни зашли на веб-сайт, вы работаете с актуальной версией, и ваше пребывание на сайте может длиться ровно столько, сколько вам понадобится. Веб-приложения доступны *кому угодно, где угодно и на любых устройствах* благодаря единой базе исходного кода.

Платформо-зависимые приложения известны своей невероятной функциональностью и надежностью. Они располагаются на главных экранах, в доках и на панелях задач, работают независимо от сетевого подключения, запускаются в собственном автономном режиме, могут читать и записывать файлы из локальной файловой системы, получать доступ к оборудованию, подключенному через USB, последовательный порт или Bluetooth, и даже взаимодействовать с данными, хранящимися на вашем устройстве, такими как контакты и события в календаре. В этих приложениях вы можете делать снимки, просматривать список воспроизведения на главном экране или управлять воспроизведением песен параллельно работе с другим приложением. Платформо-зависимые приложения ощущаются как *часть* устройства, на котором они работают.

<figure>{% Img src="image/tcFciHGuF3MxnTr1y5ue01OGLBn2/1DKtUFjXLJbiiruKA9P1.svg", alt="График, иллюстрирующий относительные возможности и охват платформо-зависимых приложений с широкими возможностями, веб-приложений с широким охватом и прогрессивных веб-приложений, которые имеют и широкие возможности, и большой охват.", width="370", height="367" %} <figcaption> Возможности и охват платформо-зависимых приложений, веб-приложений и прогрессивных веб-приложений. </figcaption></figure>

Если рассматривать платформо-зависимые приложения и веб-приложения с точки зрения возможностей и охвата, платформо-зависимые приложения предоставляют больше возможностей, а веб-приложения более доступны. Но где в этой парадигме находятся прогрессивные веб-приложения?

Прогрессивные веб-приложения (PWA) созданы и улучшены с помощью современных API-интерфейсов, чтобы обеспечить расширенные возможности, надежность и возможность установки, будучи доступными *любым пользователям где угодно и на любых устройствах* благодаря единой базе исходного кода.

## Три столпа приложений

Прогрессивные веб-приложения — это веб-приложения, разработанные таким образом, чтобы обеспечивать функциональность, надежность и легкость установки. Эти три столпа делают взаимодействие с ними похожим на работу с платформо-зависимыми приложениями.

### Функциональность

Сеть сегодня вполне функциональна сама по себе. Например, вы можете создать гиперлокальное приложение для видеочата, используя WebRTC, геолокацию и push-уведомления. Можно сделать это приложение устанавливаемым и перенести разговоры в виртуальное пространство с помощью WebGL и WebVR. С появлением Web Assembly разработчики получили возможность подключаться к другим экосистемам, таким как C, C++ и Rust, таким образом привнося в Интернет результаты десятков лет работы над функционалом. Например, [Squoosh.app](https://squoosh.app/) применяет эту технологию для улучшенного сжатия изображений.

До недавнего времени такими возможностями могли похвастаться лишь платформо-зависимые приложения. Хотя некоторые функции по-прежнему недоступны для Интернета, новые и будущие API-интерфейсы стремятся это изменить, расширяя возможности Интернета с помощью таких функций, как доступ к файловой системе, элементы управления мультимедиа, значки приложений и полная поддержка буфера обмена. Все эти возможности основаны на безопасной и ориентированной на пользователя сетевой модели разрешений, благодаря которой пользователи могут переходить на веб-сайты, ничего не опасаясь.

Благодаря современным, новым и готовящимся к выпуску API, а также Web Assembly, веб-приложения стали беспрецедентно функциональными, и спектр их возможностей продолжает расширяться.

### Надежность

Надежные прогрессивные веб-приложения работают быстро и стабильно независимо от подключения к сети.

Скорость имеет решающее значение во *взаимодействии* пользователей с вашим продуктом. Например, если время загрузки страницы увеличивается с 1 до 10 секунд, вероятность ухода пользователя [возрастает на 123%](https://www.thinkwithgoogle.com/marketing-resources/data-measurement/mobile-page-speed-new-industry-benchmarks/). Работа не останавливается после события `onload`. Пользователи не должны задумываться о том, было ли зарегистрировано их действие — например, нажатие кнопки — или нет. Прокрутка и анимация должны казаться плавными. Производительность влияет на все — и то, как пользователи воспринимают ваше приложение, и то, как оно на самом деле работает.

Наконец, надежные приложения должны работать независимо от сетевого подключения. Пользователи ожидают, что приложения будут запускаться при медленном или нестабильном сетевом подключении или даже в автономном режиме. Предполагается, что последний контент, с которым взаимодействовал пользователь, например медиатреки или билеты и маршруты, будет доступен и пригоден для эксплуатации даже в тех случаях, когда есть трудности <br>с получением запроса на сервер. Если запрос не удается послать, ожидается, что приложение выдаст сообщение о проблеме, а не просто сбой.

Пользователям нравятся приложения с минимальным временем отклика и предсказуемым ходом работы.

### Устанавливаемость

Установленные прогрессивные веб-приложения запускаются в отдельном окне вместо вкладки браузера. Их можно запустить с главного экрана, дока, панели задач или из буфера пользователя. Можно искать их на устройстве и перелистывать их с помощью переключателя приложений, что дает пользователю ощущение, будто эти приложения — часть устройства, на котором они установлены.

После установки веб-приложения открываются новые возможности. Становятся доступны сочетания клавиш, которые обычно зарезервированы при работе в браузере. Прогрессивные веб-приложения можно регистрировать для получения контента из других приложений или выбирать в качестве приложения по умолчанию для обработки различных типов файлов.

Когда прогрессивное веб-приложение перемещается из вкладки в отдельное окно, пользователи начинают по-другому его воспринимать и взаимодействовать с ним.

## Лучшее из двух миров

По своей сути прогрессивные веб-приложения — это просто веб-приложения. Благодаря прогрессивному усовершенствованию в современных браузерах доступны новые возможности. С использованием сервис-воркеров и манифеста веб-приложений веб-приложения становятся надежными и устанавливаемыми. Если новые возможности окажутся недоступны, пользователи все равно смогут работать с основным функционалом.

Цифры не врут! Компании, запустившие прогрессивные веб-приложения, добились впечатляющих результатов. Например, в Twitter количество просматриваемых за сеанс страниц увеличилось на 65%, количество твитов — на 75%, а показатель отказов снизился на 20%, при этом размер приложения уменьшился более чем на 97%. После перехода на PWA трафик Nikkei увеличился в 2,3 раза, число подписок выросло на 58%, а количество активных пользователей за день — на 49%. Hulu перешла с платформо-зависимого десктопного приложения на прогрессивное веб-приложение, и количество повторных посещений увеличилось на 27%.

Прогрессивные веб-приложения предоставляют уникальную возможность создавать веб-интерфейсы, которые понравятся вашим пользователям. Используя новейшие веб-функции, обеспечивающие расширенные возможности и надежность, прогрессивные веб-приложения позволяют устанавливать *то, что вы создаете, любым пользователям где угодно и на любых устройствах* при помощи единой базы исходного кода.
