---
layout: post
title: Шаблоны для продвижения установки PWA
authors:
  - pjmclachlan
  - mustafakurtuldu
date: 2019-06-04
updated: 2020-06-17
description: |2-

  Как продвигать установку прогрессивных веб-приложений: рекомендации.
tags:
  - progressive-web-apps
feedback:
  - api
---

Установка прогрессивного веб-приложения (PWA) может упростить пользователям его поиск и использование. Даже при продвижении через браузер некоторые пользователи не понимают, что они могут установить PWA, поэтому может быть полезно предоставить интерфейс в приложении, который можно будет использовать для его продвижения и установки.

<figure data-float="right">{% Img src="image/tcFciHGuF3MxnTr1y5ue01OGLBn2/PtJp54jasjOYyh9Soqzu.png", alt="Скриншот простой кнопки установки в PWA.", width="800", height="368" %} <figcaption> Простая кнопка установки в вашем PWA. </figcaption></figure>

Этот список ни в коем случае не является исчерпывающим, но с него можно начать знакомство с различными способами продвижения установки вашего PWA. Независимо от того, *какие алгоритмы* вы используете, все они приводят к одному и тому же коду, запускающему процесс установки, описанный в разделе «[Как обеспечить персональный интерфейс установки приложения](/customize-install/)».

## Рекомендации по продвижению установки PWA {: #best-practices }

Есть несколько рекомендаций, которые применимы независимо от того, какие алгоритмы продвижения вы используете на своем сайте.

- Не включайте рекламу в пути пользователей. Например, призыв к действию стоит поместить на странице входа в PWA под формой входа и кнопкой отправки. Некорректное использование шаблонов продвижения снижает удобство использования вашего PWA и отрицательно влияет на показатели вовлеченности.
- Включите возможность временно или полностью отклонить рекламу. Если пользователь это сделает, запомните его предпочтения и выдавайте запрос повторно только в том случае, если пользователь будет контактировать с вашим контентом, например, при входе в систему или совершении покупки.
- Комбинируйте эти методики в разных частях своего PWA, но будьте осторожны, чтобы не перегружать и не раздражать пользователя рекламой установки.
- Показывайте рекламу только **после** срабатывания [события `beforeinstallprompt`](/customize-install/#beforeinstallprompt).

## Автоматическое продвижение в браузере {: #browser-promotion }

При [соблюдении определенных критериев](/install-criteria/) большинство браузеров автоматически сообщают пользователю, что ваше прогрессивное веб-приложение можно установить. Например, Chrome для десктопов показывает кнопку установки в омнибоксе.

<div class="switcher">
  <figure id="browser-install-promo">{% Img src="image/tcFciHGuF3MxnTr1y5ue01OGLBn2/zIfRss5zOrZ49c4VdJ52.png", alt="Скриншот омнибокса с отображаемым индикатором установки.", width="800", height="307" %} <figcaption> Браузер показывает рекламу установки (на десктопе) </figcaption></figure>
  <figure>{% Img src="image/tcFciHGuF3MxnTr1y5ue01OGLBn2/kRjcsxlHDZa9Nqg2Fpei.png", alt="Скриншот браузера, предлагающего установку.", width="800", height="307" %} <figcaption> Браузер показывает рекламу установки (на мобильном устройстве)</figcaption></figure>
</div>

Chrome для Android покажет пользователю небольшую информационную панель, однако этого можно избежать, вызвав `preventDefault()` в событии `beforeinstallprompt`. Если не вызывать `preventDefault()`, баннер будет показан при первом посещении вашего сайта пользователем, если критерии устанавливаемости на Android выполнены, а в следующий раз — примерно через 90 дней.

## Рекламные шаблоны интерфейса приложения {: #app-ui-patterns }

Рекламные шаблоны интерфейса приложения могут применяться практически для любого типа PWA и встречаться внутри приложения, например, в навигации по сайту и баннерах. Как и для любых других типов рекламного шаблона, важно знать контекст пользователя, чтобы свести к минимуму прерывание его пути.

Обдуманный запуск рекламного интерфейса поможет достичь большего количества установок и избежать вмешательства в пути пользователей, которые не заинтересованы в установке.

### Простая кнопка установки {: #simple-button }

Простейший возможный UX — это кнопка «Установить» или «Получить приложение» в соответствующем месте вашего веб-контента. Убедитесь, что кнопка не блокирует другие важные функции и не мешает пользователю просматривать ваше приложение.

<figure>{% Img src="image/tcFciHGuF3MxnTr1y5ue01OGLBn2/kv0x9hxZ0TLVaIiP4Bqx.png", alt="Пользовательская кнопка установки", width="800", height="448" %} <figcaption> Простая кнопка установки </figcaption></figure>

### Фиксированный заголовок {: #header }

Это кнопка установки, которая является частью заголовка вашего сайта. Заголовок также часто включает в себя элементы брендинга сайта, например, логотип и бургер-меню. Заголовки могут иметь фиксированную позицию (`position:fixed`) или нет в зависимости от функциональности вашего сайта и потребностей пользователей.

<figure>{% Img src="image/tcFciHGuF3MxnTr1y5ue01OGLBn2/GPJdkXcpNLR30r2zo7RR.png", alt="Настраиваемая кнопка установки в заголовке", width="800", height="448" %} <figcaption> Настраиваемая кнопка установки в заголовке </figcaption></figure>

При правильном использовании реклама установки PWA в заголовке вашего сайта упрощает возврат лояльных клиентов. Пространство в заголовке PWA ценится дорого, поэтому убедитесь, что ваш призыв к установке имеет соответствующий размер и смотрится более важным, чем другой контент в заголовке, но при этом ненавязчиво.

<figure data-float="right">{% Img src="image/tcFciHGuF3MxnTr1y5ue01OGLBn2/L01AoSoy7LNk1ttMMax0.png", alt="Настраиваемая кнопка установки в заголовке", width="800", height="430" %} <figcaption> Настраиваемая кнопка установки в заголовке </figcaption></figure>

Важно:

- Не показывайте кнопку установки до срабатывания события `beforeinstallprompt`.
- Рассчитывайте актуальность установки для своих пользователей. Продумайте выборочный таргетинг, чтобы показывать рекламу только тем пользователям, которые могут получить от нее выгоду.
- Эффективно используйте драгоценное пространство заголовка. Подумайте, что еще было бы полезно предложить вашему пользователю в заголовке, и взвесьте приоритет рекламы установки по сравнению с другими вариантами.

### Меню навигации {: #nav }

<figure data-float="right">{% Img src="image/tcFciHGuF3MxnTr1y5ue01OGLBn2/aT7NHi8lbsZW8TOm3Gaw.png", alt="Настраиваемая кнопка установки в меню навигации", width="800", height="1117" %} <figcaption> Добавьте кнопку установки или рекламу в выдвижное меню навигации. </figcaption></figure>

Меню навигации отлично подходит для продвижения установки приложения, поскольку пользователи, открывающие меню, сигнализируют о взаимодействии с вашим контентом.

Важно:

- Не мешайте важному навигационному контенту. Поместите рекламу установки PWA под другими пунктами меню.
- Дайте краткое и актуальное объяснение того, почему пользователю будет выгодна установка вашего PWA.

### Целевая страница {: #landing }

Назначение целевой страницы — продвигать ваши продукты и услуги, поэтому здесь уместно широко продвигать преимущества установки вашего PWA.

<figure data-float="right">{% Img src="image/tcFciHGuF3MxnTr1y5ue01OGLBn2/7q09M12HFxgIiWhKPGma.png", alt="Настраиваемое диалоговое окно установки на целевой странице", width = "800", height = "1117" %}<figcaption> Настраиваемое диалоговое окно установки на целевой странице </figcaption></figure>

Сначала изложите конкурентное предложение вашего сайта, а затем расскажите посетителям, что они получат от установки.

Важно:

- Обращайтесь к функциям, которые наиболее важны для ваших посетителей, и выделяйте ключевые слова, которые могли привести их на вашу целевую страницу.
- Сделайте рекламу установки и призыв к действию привлекательными, но только после того, как четко изложите свое конкурентное предложение. В конце концов, это ваша целевая страница.
- Стоит добавить рекламу установки в той части приложения, где пользователи проводят большую часть времени.

### Баннер установки {: #banner }

<figure data-float="right">{% Img src="image/tcFciHGuF3MxnTr1y5ue01OGLBn2/7fLCQQhdk2OzrQD3Xh4E.png", alt="Настраиваемый баннер установки вверху страницы.", width="800", height="1000" %} <figcaption> Скрываемый баннер вверху страницы. </figcaption></figure>

Большинство пользователей сталкивались с установочными баннерами в мобильных приложениях и знакомы с взаимодействиями, предлагаемыми баннером. Баннеры следует использовать осторожно, потому что они могут помешать пользователю.

Важно:

- Дождитесь, пока пользователь проявит интерес к вашему сайту, прежде чем показывать баннер. Если пользователь закрывает ваш баннер, не показывайте его снова, пока пользователь не инициирует событие конверсии, которое указывает на более высокий уровень взаимодействия с вашим контентом, например, покупку в Интернет-магазине или регистрацию учетной записи.
- Кратко объясните пользу от установки PWA в баннере. Например, вы можете обозначить отличия в установке PWA и приложений для iOS/Android, упомянув, что ваше приложение почти не использует хранилище на устройстве пользователя или что оно будет установлено мгновенно без перенаправления в магазин.

### Временный интерфейс {: #temporary-ui }

Временный пользовательский интерфейс, такой как шаблон дизайна [Snackbar](https://material.io/components/snackbars/), уведомляет пользователя и позволяет ему легко выполнить действие, в данном случае установить приложение. При правильном использовании эти виды шаблонов интерфейса не прерывают работу пользователя и обычно автоматически отклоняются, если пользователь их игнорирует.

<figure>{% Img src="image/tcFciHGuF3MxnTr1y5ue01OGLBn2/6DySYRtyegazEfMcWXQL.png", alt="Настраиваемый баннер установки в виде снекбара.", width="800", height="448" %} <figcaption> Скрываемый снекбар, показывающий возможность установки PWA. </figcaption></figure>

Покажите снекбар после нескольких взаимодействий с вашим приложением. Появляясь при загрузке страницы или вне контекста, он может оказаться незамеченным или вызвать когнитивную перегрузку. Когда это произойдет, пользователи просто закроют все, что видят. И помните, что новые пользователи вашего сайта могут быть не готовы установить PWA. Поэтому перед использованием этого шаблона лучше подождать, пока у вас не появятся четкие сигналы интереса от пользователя, например, повторные посещения, вход пользователя в систему или подобное событие конверсии.

<figure data-float="right">{% Img src="image/tcFciHGuF3MxnTr1y5ue01OGLBn2/d8dwdIe1rYSgd0JdCGtt.png", alt="Настраиваемый баннер установки в виде снекбара.", width="800", height="424" %} <figcaption> Скрываемый снекбар, показывающий возможность установки PWA. </figcaption></figure>

Важно:

- Показывайте снекбар от 4 до 7 секунд, давая пользователям достаточно времени, чтобы увидеть и отреагировать на него, и при этом не мешая им.
- Не показывайте его поверх другого временного пользовательского интерфейса, такого как баннеры и т. д.
- Подождите, пока у вас не появятся четкие сигналы интереса от пользователя, прежде чем использовать этот шаблон, например, повторные посещения, вход пользователя в систему или подобное событие конверсии.

## После конверсии

Момент после события конверсии пользователя, например, после покупки в Интернет-магазине — отличная возможность прорекламировать установку вашего PWA. Пользователь явно заинтересован в вашем контенте, и конверсия часто сигнализирует о том, что пользователь снова воспользуется вашими услугами.

<figure>{% Img src="image/tcFciHGuF3MxnTr1y5ue01OGLBn2/DrepSPFAm64d5cvTFoXe.png", alt="Скриншот рекламы установки после конверсии.", width="800", height="448" %} <figcaption> Реклама установки после того, как пользователь совершил покупку. </figcaption></figure>

### Бронирование или оформление заказа {: #journey }

<figure data-float="right">{% Img src="image/tcFciHGuF3MxnTr1y5ue01OGLBn2/bOYZM2UiWK5itVSpjKWO.png", alt="Реклама после пользовательского пути.", width="800", height="1419" %} <figcaption> Реклама после пользовательского пути. </figcaption></figure>

Покажите рекламу установки во время или после последовательного пути пользователя, например, при бронировании или оформлении заказа. Зачастую, показывая рекламу после того, как пользователь завершил путь, ее можно сделать более заметной.

Важно:

- Включите соответствующий призыв к действию. Какие пользователи выиграют от установки вашего приложения и почему? Какое отношение это имеет к пути, который они сейчас проходят?
- Если у вашего бренда есть уникальные предложения для пользователей установленных приложений, обязательно упомяните их здесь.
- Не используйте рекламу в следующих шагах в пользовательском пути, иначе это может отрицательно повлиять на показатели завершения пути. Обратите внимание, что в приведенном выше примере электронной коммерции ключевой призыв к оформлению заказа находится над рекламой установки приложения.

### Регистрация, вход и выход из системы {: #sign-up }

Этот подход является частным случаем шаблона продвижения для [пользовательского пути](#journey), где карточка с рекламой может быть более заметной.

<figure data-float="right">{% Img src="image/tcFciHGuF3MxnTr1y5ue01OGLBn2/PQXqSqtwRSwyELdJMjtd.png", alt="Настраиваемая кнопка установки на странице регистрации.", width="800", height="1117" %} <figcaption> Настраиваемая кнопка установки на странице регистрации.</figcaption></figure>

Эти страницы обычно просматривают только заинтересованные пользователи, для которых ценность вашего PWA уже сформулирована. Кроме того, часто на этих страницах не так много другого полезного контента. В результате можно сделать призыв к действию более крупным, поскольку он не мешает пользователям.

Важно:

- Не прерывайте путь пользователя через форму регистрации. Если это многоэтапный процесс, вам стоит подождать, пока пользователь не завершит путь.
- Продвигайте функции, наиболее актуальные для зарегистрированного пользователя.
- Стоит добавить дополнительную рекламу установки в разделах приложения, где выполнен вход.

## Встроенные рекламные шаблоны

Встроенные рекламные методики переплетают рекламу с контентом сайта. Зачастую это выглядит более тонко, чем продвижение в пользовательском интерфейсе приложения, которое требует компромиссов. Вам нужно, чтобы ваша реклама была достаточно заметной, чтобы заинтересованные пользователи обратили на нее внимание, но не настолько, чтобы это ухудшало качество вашего взаимодействия с пользователем.

### Внутри ленты {: #in-feed }

Реклама установки в ленте появляется между новостными статьями или другими информационными карточками в вашем PWA.

<figure data-float="right">{% Img src="image/tcFciHGuF3MxnTr1y5ue01OGLBn2/LS5qSE2vicfjRBBkA47a.png", alt="Реклама установки в ленте контента.", width="800", height="1000" %} <figcaption> Реклама установки в ленте контента. </figcaption></figure>

Ваша цель — показать пользователям, как удобнее получать доступ к интересующему их контенту. Сосредоточьтесь на продвижении функций и возможностей, которые будут полезны вашим пользователям.

Важно:

- Ограничьте частоту показа рекламы, чтобы не раздражать пользователей.
- Дайте вашим пользователям возможность отклонять рекламу.
- Запоминайте, когда пользователь выбирает скрыть рекламу.
