---
layout: post
title: Как прогрессивные веб-приложения помогают добиться успеха в бизнесе
authors:
  - sfourault
date: 2020-05-20
updated: 2020-05-20
description: Создайте качественное бизнес-обоснование для своего прогрессивного веб-приложения. Узнайте, когда совершать инвестиции и как измерять их успешность.
tags:
  - progressive-web-apps
---

Многие компании включают прогрессивные веб-приложения в свои планы модернизации веб-сайтов и адаптации к новым ожиданиям пользователей. Как и при появлении любых других новых концепций и технических возможностей, у вас могут возникнуть вопросы: этого ли хотят мои клиенты, насколько это будет способствовать развитию моего бизнеса, какие возможности технически осуществимы?

{% Img src="image/admin/o70RxMcAQVPrjxH34a8r.jpg", alt="Выявление заинтересованных лиц", width="800", height="254" %}

В процессе формирования стратегии в области цифровых технологий зачастую участвуют несколько заинтересованных сторон: менеджера по продуктам и директора по маркетингу интересует, как повлияет каждая функция на бизнес, технический директор оценивает возможность реализации технологий и их надежность, исследователи пользовательских интерфейсов проверяют, решает ли та или иная функция реальные проблемы клиентов.

В данной статье мы постараемся помочь вам ответить на эти три вопроса и сформировать проект прогрессивного веб-приложения. Вы начнете с анализа потребностей своих клиентов, попытаетесь удовлетворить эти потребности с помощью функций прогрессивного веб-приложения и измерите влияние, которое каждая функция оказывает на бизнес.

## Прогрессивные веб-приложения удовлетворяют потребности клиентов {: #solve-customer-needs }

Одно из правил, которым мы любим следовать в Google при создании продуктов, — «[сосредоточьтесь на пользователе, и адаптируйте к этому все остальное](https://www.google.com/about/philosophy.html)». Думайте *прежде всего о пользователях*: каковы потребности моих клиентов и каким образом прогрессивное веб-приложение сможет их удовлетворить?

{% Img src="image/admin/TcmXmWb5mSUqal98NIAH.jpg", alt="Выявление потребностей клиентов", width="800", height="262" %}

Изучая пользователей, мы обнаружили несколько интересных закономерностей.

- Пользователи ненавидят задержки и ненадежные мобильные приложения: уровень стресса, вызываемый задержками на мобильных устройствах, [сопоставим с уровнем стресса при просмотре фильма ужасов](https://blog.hubspot.com/marketing/mobile-website-load-faster).
- При просмотре веб-страниц или совершении покупок 50% пользователей смартфонов с большей вероятностью будут использовать сайты для мобильных устройств, потому что они [не хотят загружать приложения](https://www.thinkwithgoogle.com/data/smartphone-user-mobile-shopping-preferences/).
- Одна из основных причин удаления приложений — [ограниченный размер хранилищ](https://www.thinkwithgoogle.com/data/why-users-uninstall-travel-apps/) на устройствах (а установленное веб-приложение обычно занимает менее 1 МБ).
- Пользователи смартфонов с большей вероятностью будут совершать покупки на сайтах для мобильных устройств, [предлагающих соответствующие рекомендации](https://www.thinkwithgoogle.com/data/smartphone-mobile-app-and-site-purchase-data/) по продуктам, и 85% пользователей смартфонов считают, что [уведомления на мобильных устройствах полезны](https://www.thinkwithgoogle.com/data/smartphone-user-notification-preferences/).

На основе этих наблюдений мы выяснили, что клиенты предпочитают быстрые, поддерживающие установку, надежные и увлекательные решения (концепция F.I.R.E.).

## В прогрессивных веб-приложениях используются современные возможности Интернета {: #modern-capabilities }

В прогрессивных веб-приложениях используется ряд рекомендаций и современные веб-API, которые предназначены для удовлетворения потребностей ваших клиентов. Благодаря им ваш сайт будет быстрым, надежным и интересным. Кроме того, его можно будет установить на устройстве.

Например, использование служебного сценария для [кэширования ресурсов](/service-workers-cache-storage/) и [предварительного получения данных на основе прогнозов](/precache-with-workbox/) повышает скорость работы и надежность сайта. Если вы добавите возможность установки для своего сайта, клиенты смогут легко получать к нему доступ на начальном экране или в средстве запуска приложений. А новые API, например [Web Push Notifications](https://developer.mozilla.org/docs/Web/API/Push_API/Best_Practices), упрощают повторное привлечение пользователей с помощью персонализированного контента и повышают их лояльность.

{% Img src="image/admin/rP0eNCflNYOhzjPi1Lq5.jpg", alt="Повышение удобства пользователей с помощью новых возможностей", width="800", height="393" %}

## Понимание влияния, которое прогрессивное веб-приложение оказывает на бизнес {: #business-impact }

В зависимости от вида вашей деятельности успех в бизнесе может определяться разными характеристиками, в том числе указанными ниже.

- Увеличение времени, которое пользователи тратят на ваш сервис
- Уменьшение показателей отказов для ваших лидов
- Повышение коэффициентов конверсии
- Увеличение количества возвращающихся посетителей

Большинство проектов прогрессивных веб-приложений приводит к повышению коэффициента конверсии для мобильных устройств. Дополнительные сведения можно изучить в многочисленных [примерах](https://www.pwastats.com/). В зависимости от ваших целей вы можете сделать более приоритетными те аспекты прогрессивных веб-приложений, которые имеют большее значение для вашего бизнеса, и это нормально. Функции прогрессивных веб-приложений можно выбрать и запускать по отдельности.

Давайте оценим влияние, которое каждая из этих замечательных функций FIRE оказывает на бизнес.

### Как наличие быстро работающего веб-сайта влияет на бизнес {: #impact-fast }

Недавнее [исследование, проведенное компанией Deloitte Digital](https://www2.deloitte.com/ie/en/pages/consulting/articles/milliseconds-make-millions.html), показало, что скорость загрузки страниц значительно влияет на бизнес-метрики.

Существует много способов оптимизировать как скорость работы сайта, так и важные пути для всех пользователей. Если вы не знаете, с чего начать, загляните в наш раздел «[Быстрая загрузка](/fast/)» и с помощью [Lighthouse](https://developer.chrome.com/docs/lighthouse/overview/) расставьте приоритеты, чтобы устранить самые существенные недостатки.

Работая над оптимизацией скорости, часто измеряйте скорость работы своего сайта с помощью соответствующих средств и метрик. Это позволит отслеживать ход работы. Измеряйте метрики с помощью [Lighthouse](https://developer.chrome.com/docs/lighthouse/overview/), установите четкие цели, например [получить «хорошие» оценки Core Web Vitals](/vitals/#core-web-vitals), и [включите бюджет на повышение производительности в процесс разработки](/incorporate-performance-budgets-into-your-build-tools/). Благодаря ежедневным измерениям и [методологии оценки пользы, которую приносит скорость](/value-of-speed/), вы сможете определить, какое влияние оказывают постепенные изменения скорости, и подсчитать, какой дополнительный доход приносит ваша работа.

{% Img src="image/admin/yyRfQaDL3NcGhB0f79RN.jpg", alt="Измерение пользы, которую приносит скорость, и коррелирование этого показателя с количеством конверсий", width="800", height="306" %}

В 2019 году руководство Ebay поставило [цель увеличить скорость работы веб-сайта](/shopping-for-speed-on-ebay/). Сотрудники компании использовали ряд методов, например бюджет повышения производительности, оптимизацию критически важного пути и предварительное получение данных на основе прогнозов. Они пришли к выводу, что при каждом уменьшении времени загрузки страницы с результатами поиска на 100 миллисекунд количество добавлений товаров в корзину увеличивалось на 0,5%.

{% Img src="image/admin/Qq3wo5UOqzC1ugnTzdqT.jpg", alt="Уменьшение времени загрузки страниц eBay на 100 мс приводило к увеличению количества добавлений товаров в корзину на 0,5%", width="800", height="184" %}

### Влияние веб-сайта, поддерживающего установку, на бизнес {: #impact-installable }

Почему вам нужно, чтобы пользователь установил ваше прогрессивное веб-приложение? Чтобы ему было проще вернуться на ваш сайт. Если для установки приложения в ОС Android требуется выполнить как минимум три дополнительных действия (перенаправление в Play Store, загрузка, перезапуск приложения для Android в верхней части воронки), установка прогрессивного веб-приложения выполняется без проблем одним щелчком мыши и не отвлекает пользователя от текущей воронки конверсии.

{% Img src="image/admin/u1jcKrBBOHEzSz3SqhEB.jpg", alt="Процесс установки должен быть простым", width="800", height="239" %}

После установки прогрессивного веб-приложения пользователь может запустить его, щелкнув значок на начальном экране. Кроме того, оно будет отображаться на панели приложений при переключении между приложениями и пользователи смогут находить его с помощью функции поиска приложений. Мы называем такое приложение динамическим приложением Discover-Launch-Switch, а возможность установки прогрессивного веб-приложения упрощает доступ к нему.

Помимо того что прогрессивное веб-приложение будет доступно через привычные поверхности обнаружения и запуска на устройстве, оно запускается точно так же, как приложения, созданные для платформы: в автономном режиме, отдельно от браузера. Кроме того, оно использует службы устройства на уровне ОС, например средство переключения между приложениями, и параметры устройства.

Люди, установившие прогрессивное веб-приложение, скорее всего будут вашими самыми заинтересованными пользователями с более высокими метриками вовлеченности, чем у случайных посетителей. Перечень преимуществ включает большее количество повторных посещений, увеличение времени, проводимого на сайте, и более высокие коэффициенты конверсии, которые часто равны показателям для пользователей приложений, созданных для платформ, на мобильных устройствах.

Чтобы прогрессивное веб-приложение можно было установить, оно должно соответствовать [основным критериям](/install-criteria/). Если оно соответствует этим критериям, вы сможете [предлагать установить его](/promote-install/) в пользовательском интерфейсе на компьютерах и мобильных устройствах, в том числе на устройствах с iOS.

{% Img src="image/admin/5sH5YX7kFrwv4f6duqVf.jpg", alt="Прогрессивные веб-приложения можно установить везде", width="800", height="227" %}

После того, как вы начнете предлагать установить свое прогрессивное веб-приложение, нужно определить, сколько пользователей устанавливают его и каким образом они используют его.

Чтобы ваш сайт установило максимальное количество пользователей, можно [попробовать использовать разные](https://pwa-book.awwwards.com/chapter-4) рекламные сообщения (например, «установите за одну секунду» или «добавьте наш ярлык, чтобы следить за своим заказом»), различные места размещения (в баннере в заголовке, в канале). Кроме того, попробуйте предлагать его на разных этапах воронки (на второй посещенной странице или после бронирования).

Чтобы понять, куда уходят ваши пользователи и как повысить показатель их удержания, можно [измерять](https://pwa-book.awwwards.com/chapter-8) характеристики воронки установки четырьмя указанными ниже способами.

- Количество пользователей, соответствующих требованиям для установки веб-приложения
- Количество пользователей, которые щелкнули предложение установить приложение в пользовательском интерфейсе
- Количество пользователей, которые согласились на установку, а затем отказались от нее
- Количество пользователей, которые успешно установили веб-приложение

Вы можете начать предлагать установить свое прогрессивное веб-приложение всем своим пользователям или применить более осторожный подход, экспериментируя только с небольшой группой пользователей.

Через несколько дней или недель у вас будут данные, позволяющие измерить влияние веб-приложения на ваш бизнес. Как ведут себя люди, переходящие на сайт с помощью установленного ярлыка? Увеличиваются ли для них показатели вовлечения и конверсии?

Чтобы разделить пользователей, которые установили ваше прогрессивное веб-приложение, на сегменты, отслеживайте [событие `appinstalled`](/customize-install/#detect-install) и используйте JavaScript, чтобы [проверять, находятся ли пользователи в автономном режиме](/customize-install/#detect-launch-type) (что указывает на использование установленного прогрессивного веб-приложения). Затем используйте полученные данные в качестве переменных или показателей для отслеживания аналитики.

{% Img src="image/admin/H2U4jKTmATNzVJQ3WNCO.jpg", alt="Измерение пользы от установки", width="800", height="253" %}

Интересен [пример использования, связанный с компанией Weekendesk](https://www.thinkwithgoogle.com/_qs/documents/8971/Weekendesk_PWA_-_EXTERNAL_CASE_STUDY.pdf): чтобы добиться максимального показателя установки, она предлагает установить ве6-приложение на второй посещенной странице. В результате в компании заметили, что клиенты, возвращающиеся с использованием значка на главном экране, более чем в два раза чаще бронируют номера у них.

{% Img src="image/admin/eR23C2o1adHq5tATNw34.jpg", alt="Для пользователей, установивших веб-приложение, наблюдается в 2,5 раза больший показатель конверсии", width="800", height="201" %}

Установка прогрессивного веб-приложения — отличный способ заставить посетителей вернуться на ваш сайт и повысить лояльность клиентов. Вы также можете подумать о персонализации интерфейса для этих премиум-пользователей.

Если у вас уже есть приложение, созданное для платформы, вы можете сначала предлагать его, а затем предложить прогрессивное веб-приложением тем, кто отказался установить основное приложение или не отреагировал на баннер установки приложения. Некоторые из ваших «частично вовлеченных» пользователей, возможно, не соответствуют пороговому значению для установки приложения из магазина приложений. Этой когорте пользователей можно предложить возможность установки прогрессивного веб-приложения, которую часто воспринимают как более простой и требующий меньше усилий процесс.

{% Img src="image/admin/iNQalNPhjdBueuqPHiad.jpg", alt="Прогрессивные веб-приложения позволяют добраться до «частично вовлеченных» пользователей", width="800", height="229" %}

### Влияние надежного веб-сайта на бизнес {: #impact-reliable }

В браузере Chrome есть игра с динозавром, в которую можно поиграть, когда у пользователя отсутствует подключение к сети. В нее играют более [270 миллионов раз](https://www.blog.google/products/chrome/chrome-dino/) в месяц. Это впечатляющее число показывает, что ненадежность сетей открывает большие возможности, особенно на рынках с ненадежными или дорогими сетями мобильной связи, например в Индии, Бразилии, Мексике или Индонезии.

При запуске приложения, установленного из магазина приложений, пользователи ожидают, что оно откроется независимо от наличия подключения к Интернету. Прогрессивные веб-приложения должны работать так же.

Как минимум, необходимо отобразить простую страницу для автономного режима, на которой пользователю будет сообщено, что приложение недоступно без подключения к сети. Затем сделайте еще один шаг вперед: предоставьте пользователю ряд [функций, которые будут полезны в автономном режиме](https://pwa-book.awwwards.com/chapter-6). Например, вы можете предоставить доступ к билетам или посадочным талонам, автономным спискам желаний, контактной информации для центров обработки вызовов, статьям или рецептам, которые пользователь недавно просматривал, и т. д.

{% Img src="image/admin/ubglZLCoddAfB5cl8JSz.jpg", alt="Будьте полезны даже в автономном режиме", width="800", height="243" %}

После того, как вы реализуете [надежную среду для пользователя](https://pwa-book.awwwards.com/chapter-6), вам, возможно, потребуется измерить ее характеристики — сколько пользователей переходят в автономный режим, в каких географических регионах это происходит и остаются ли пользователи на веб-сайте после восстановления подключения к сети?

Использование веб-приложения в автономном режиме можно измерять, записывая результаты проверки связи средствами аналитики, когда пользователь переходит в [автономный режим или снова подключается к сети](https://pwa-book.awwwards.com/chapter-8). Вы получите информацию о том, какое количество пользователей продолжает просматривать ваш веб-сайт после восстановления подключения к сети.

{% Img src="image/admin/UfjYsWQWJjVIk2sp5bnE.jpg", alt="В компании Trivago обнаружили, что 67% пользователей, которые снова подключались к сети, продолжали просматривать сайт", width="800", height="272" %}

[Пример с Trivago](https://www.thinkwithgoogle.com/intl/en-154/insights-inspiration/case-studies/trivago-embrace-progressive-web-apps-as-the-future-of-mobile/) показывает, как прогрессивное веб-приложение может способствовать выполнению ваших бизнес-целей: 67% пользователей, которые снова подключились к Интернету после перехода в автономный режим (приблизительно 3% пользователей), продолжали просматривать сайт.

### Влияние привлекательного веб-сайта на бизнес {: #impact-engaging }

Благодаря push-уведомлениям, доставляемым через Интернет, пользователи могут подписываться на новости с сайтов, которые им нравятся. Это позволяет эффективно повторно привлекать таких пользователей, предлагая им персонализированный релевантный контент.

Но будьте осторожны. Если вы попросите пользователя подписаться на веб-уведомления при первом посещении вашего сайта, не рассказав о преимуществах, которые дает это действие, такая просьба может быть расценена как спам и, возможно, создаст отрицательный настрой у пользователя. Предлагая подписаться на уведомления, обязательно следуйте [рекомендациям](https://developers.google.com/web/fundamentals/push-notifications/permission-ux). Чтобы пользователи разрешали вам показывать им уведомления, предоставьте взамен полезные возможности, например возможность получать информацию о задержках поездов, отслеживать цены, получать сведения о товарах, отсутствующих на складе, и т. д.

Технически [push-уведомления](https://developers.google.com/web/fundamentals/push-notifications/) в Интернете работают в фоновом режиме благодаря служебному сценарию. Их часто отправляют системы, созданные для управления кампаниями (например, Firebase). Эта функция очень полезна для бизнеса при работе с пользователями мобильных устройств (с ОС Android) и компьютеров: она повышает показатель повторных посещений, а также последующих продаж и конверсий.

Чтобы оценить эффективность своих push-кампаний, вам потребуется измерить всю воронку.

- Количество пользователей, соответствующих требованиям на получение push-уведомлений
- Количество пользователей, щелкнувших индивидуализированное уведомление в пользовательском интерфейсе
- Количество пользователей, дающих согласие на получение push-уведомлений
- Количество пользователей, получающих push-уведомления
- Количество пользователей, вовлекаемых с помощью уведомлений
- Конверсия и вовлечение пользователей, пришедших из уведомления

{% Img src="image/admin/UpzfxBDi3e66cZ9gzkkS.jpg", alt="Измерение пользы push-уведомлений, рассылаемых через Интернет", width="800", height="255" %}

Есть много отличных примеров использования push-уведомлений в Интернете, например [компания Carrefour, которая увеличила показатель конверсии в 4,5 раза](https://useinsider.com/case-studies/carrefour/), повторно вовлекая пользователей, оставивших товары в корзине.

## Постепенный (функция за функцией) запуск прогрессивных веб-приложений {: #feature-by-feature }

Прогрессивные веб-приложения — это современные веб-сайты, которые извлекают выгоду из огромного охвата пользователей в Интернете и предлагают удобные функции, которые нравятся пользователям и имеются в приложениях для Android, iOS или компьютеров. В них используются рекомендации и современные веб-API, которые можно реализовать независимо друг от друга (в зависимости от специфики и приоритетов вашей компании).

{% Img src="image/admin/7g1j2z7h5m9QSHQhHceM.jpg", alt="Постепенный запуск прогрессивного веб-приложения", width="800", height="253" %}

Чтобы ускорить модернизацию вашего веб-сайта и превратить его в настоящее прогрессивное веб-приложение, мы рекомендуем проявить гибкость: запускайте функции постепенно, одну за другой. Во-первых, вместе со своими пользователями проанализируйте, какие функции принесут им наибольшую пользу, затем предоставьте полученные сведения своим дизайнерам и разработчикам и, наконец, не забудьте точно измерить, сколько дополнительных денег принесло ваше прогрессивное веб-приложение.
