---
layout: post
title: Ориентированные на пользователя показатели производительности
authors:
  - philipwalton
date: 2019-11-08
description: Ориентированные на пользователя показатели производительностиважный инструмент, который позволит лучше понять текущую ситуацию и улучшить работу вашего сайта таким образом, чтобы это приносило пользу реальным пользователям.
tags:
  - performance
  - metrics
---

Мы все слышали, как важна производительность. Но что именно понимается под производительностью и «быстрыми» веб-сайтами?

Правда в том, что производительностьпонятие относительное:

- Сайт может одновременно быть быстрым для одного пользователя и медленным для другого, при условии, что первый пользователь работает на мощном устройстве в быстрой сети, а второйна устройстве из нижнего ценового сегмента в медленной сети.
- Два сайта могут загрузиться одновременно, но может *показаться,* что один загружается быстрее (если он загружает контент постепенно, а не ждет до последнего, чтобы отобразить хоть что-либо).
- Может *показаться,* что сайт в начале загружается быстро, но затем отвечает очень медленно (или вообще не реагирует) на действия пользователя.

Поэтому производительность следует рассматривать с точки зрения объективных критериев, которые можно измерить количественно с достаточной степенью точности. Эти критерии известны как *метрики*.

Но то, что метрика основана на объективных критериях и может быть измерена количественно, вовсе не означает, что эти измерения полезны.

## Определение метрик

В прошлом производительность в Интернете измерялась с помощью события <code>[load](https://developer.mozilla.org/docs/Web/API/Window/load_event)</code>. Но, несмотря на то, что <code>load</code>четко определенный момент жизненного цикла страницы, он не обязательно соответствует тому, что волнует пользователя.

Например, сервер может практически мгновенно загрузить минимальную страницу, а затем отложить выборку и отображение контента на странице на несколько секунд уже после срабатывания события `load`. Хотя технически такая страница может иметь быстрое время загрузки, оно не будет соответствовать времени загрузки страницы для пользователя.

В течение последних нескольких лет члены команды Chrome в сотрудничестве с [W3C Web Performance Working Group](https://www.w3.org/webperf/) работали над стандартизацией набора новых API и показателей, которые более точно измеряют то, как пользователи воспринимают производительность веб-страницы.

Метрики созданы на основании важных для пользователя вопросов:

<table id="questions">
  <tr>
    <td><strong>Происходит ли загрузка?</strong></td>
    <td>Навигация началась успешно? Сервер ответил?</td>
  </tr>
  <tr>
    <td><strong>Страница пригодна к использованию?</strong></td>
    <td>Достаточно ли отрисованного контента для того, чтобы пользователи могли с ним взаимодействовать?</td>
  </tr>
  <tr>
    <td><strong>Можно ли взаимодействовать со страницей?</strong></td>
    <td>Могут ли пользователи взаимодействовать со страницей или она занята?</td>
  </tr>
  <tr>
    <td><strong>Страница восхитительна?</strong></td>
    <td>Взаимодействия с элементами страницы проходят плавно и естественно, без задержек и рывков?</td>
  </tr>
</table>

## Как измеряются метрики

Метрики производительности обычно измеряются одним из двух способов:

- **В лабораторных условиях:** используются инструменты для имитации загрузки страницы в согласованной контролируемой среде.
- **В полевых условиях**: берутся показатели реальных пользователей, фактически загружающих страницу и взаимодействующих с ней.

Чтобы обеспечить хорошую производительность веб-страницы, лучше использовать оба способа, которые дополняют друг друга.

### В лабораторных условиях

Тестирование производительности в лабораторных условиях имеет важное значение при разработке новых функций. Ведь измерить характеристики производительности разрабатываемых функций на реальных пользователях невозможно, поэтому тестирование функций в лабораторных условиях до выпускалучший способ предотвратить снижение производительности.

### В полевых условиях

Хотя лабораторное тестирование и предоставляет косвенные показатели производительности, но оно необязательно отражает то, как пользователи воспринимают ваш сайт в реальных условиях.

Производительность сайта может сильно различаться в зависимости от возможностей устройства пользователя и условий его сети. Она также может варьироваться в зависимости от того, взаимодействует ли пользователь со страницей.

Более того, загрузка страниц не может быть детерминированной. Например, сайты, загружающие персонализированный контент или рекламу, могут иметь совершенно разные характеристики производительности от пользователя к пользователю. Лабораторный тест не выявит этих различий.

Единственный способ по-настоящему узнать, как сайт работает для пользователей,это измерить его производительность в реальных условиях, когда пользователи загружают сайт и взаимодействуют с ним. Этот тип измерения обычно называется [мониторингом реальных пользователей (Real User Monitoring)](https://en.wikipedia.org/wiki/Real_user_monitoring) или сокращенно RUM.

## Типы метрик

Есть несколько других типов метрик, которые имеют отношение к тому, как пользователи воспринимают производительность.

- **Воспринимаемая скорость загрузки:** как быстро страница может загружаться и отображать все визуальные элементы на экране.
- **Отзывчивость при загрузке**: как быстро страница может загружаться и выполнять любой требуемый код JavaScript с тем, чтобы компоненты своевременно реагировали на взаимодействие с пользователем.
- **Отзывчивость в среде выполнения:** как быстро после загрузки страница может реагировать на взаимодействие с пользователем.
- **Визуальная стабильность**: изменяются ли элементы на странице неожиданным для пользователей образом, что потенциально мешает взаимодействию?
- **Плавность:** отображаются ли переходы и анимация с постоянной частотой кадров и плавно ли происходит переход из одного состояния в другое?

Ни одной отдельной метрики недостаточно, чтобы учесть все характеристики производительности страницы.

## Главные метрики для отслеживания

- **[Первая отрисовка контента (FCP)](/fcp/) :** измеряет время от начала загрузки страницы до отображения на экране любой части содержимого страницы *([лабораторная](#in-the-lab), [полевая](#in-the-field))*.
- **[Скорость загрузки основного контента (LCP)](/lcp/):** измеряет время от начала загрузки страницы до момента, когда на экране отображается самый большой текстовый блок или элемент изображения *([лабораторная](#in-the-lab), [полевая](#in-the-field))*.
- **[Время ожидания до первого взаимодействия с контентом (FID)](/fid/) :** измеряет время от момента, когда пользователь впервые взаимодействует с сайтом (то есть, когда он щелкает ссылку, нажимает кнопку или использует настраиваемый элемент управления на основе JavaScript) до момента, когда браузер действительно сможет ответить на это взаимодействие *([полевая](#in-the-field))*.
- **[Время до интерактивности (TTI)](/tti/)**: измеряет время с начала загрузки страницы до момента ее визуального отображения, загрузки начальных сценариев (если таковые имеются) и способности страницы быстро и надежно реагировать на ввод пользователя *([лабораторная](#in-the-lab))*.
- **[Общее время блокировки (TBT)](/tbt/)**: измеряет общее количество времени между FCP и TTI, когда основной поток был заблокирован на достаточно долгое время, чтобы предотвратить реакцию на ввод *([лабораторная](#in-the-lab))*.
- **[Совокупное смещение макета (CLS)](/cls/):** измеряет совокупную оценку всех неожиданных сдвигов макета, которые происходят между моментом начала загрузки страницы и изменением ее [состояния жизненного цикла](https://developer.chrome.com/blog/page-lifecycle-api/) на скрытое. *([лабораторная](#in-the-lab), [полевая](#in-the-field))*

В этот список вошли далеко не все метрики производительности, ориентированные на пользователя (например, время отклика и плавность выполнения в настоящее время не рассматриваются).

В некоторых случаях будут введены новые показатели для охвата недостающих областей, но в других случаях наиболее ценные аналитические данные предоставят показатели, специально разработанные для вашего сайта.

## Пользовательские метрики

Перечисленные выше метрики производительности позволяют получить общее представление о характеристиках производительности большинства сайтов в Интернете. Более того, общий для всех сайтов набор метрик дает возможность сравнивать полученные результаты с результатами конкурентов.

Однако бывает, что конкретный сайт в некотором роде уникален. Значит, для получения полной картины производительности требуется использовать дополнительные метрики. Например, метрика LCP измеряет скорость загрузки основного контента, но иногда самый большой элемент не является частью основного содержимого страницы, и, следовательно, LCP может оказаться бесполезной для анализа производительности.

Для решения таких случаев рабочая группа по веб-производительности также стандартизировала API-интерфейсы более низкого уровня, которые могут быть полезны для реализации собственных пользовательских показателей:

- [User Timing API](https://w3c.github.io/user-timing/)
- [Long Tasks API](https://w3c.github.io/longtasks/)
- [Element Timing API](https://wicg.github.io/element-timing/)
- [Navigation Timing API](https://w3c.github.io/navigation-timing/)
- [Resource Timing API](https://w3c.github.io/resource-timing/)
- [Server timing](https://w3c.github.io/server-timing/)

Ознакомьтесь со статьей [«Пользовательские метрики»](/custom-metrics/), чтобы узнать, как использовать эти API для измерения характеристик производительности вашего сайта.
