---
layout: post
title: Время до интерактивности (TTI)
authors:
  - philipwalton
date: 2019-11-07
updated: 2020-06-15
description: В этой статье описывается метрика TTI (Время до интерактивности) и объясняются принципы ее измерения
tags:
  - performance
  - metrics
---

{% Aside %} Время до интерактивности (TTI)важный [лабораторный показатель](/user-centric-performance-metrics/#in-the-lab) для измерения [отзывчивости при загрузке](/user-centric-performance-metrics/#types-of-metrics). Данная метрика позволяет определить случаи, когда страница *выглядит* интерактивной, но на самом деле таковой не является. Низкое значение показателя TTI гарантирует, что страница [пригодна к использованию](/user-centric-performance-metrics/#questions). {% endAside %}

## Что такое TTI?

Метрика TTI измеряет время с момента начала загрузки страницы до момента загрузки ее основных подресурсов. Метрика показывает, насколько быстро страница способна реагировать на действия пользователя.

Чтобы рассчитать TTI на основании [трассировки производительности](https://developer.chrome.com/docs/devtools/evaluate-performance/reference/) веб-страницы, выполните следующие действия:

1. Запуститите метрику [FCP (Первая отрисовка контента)](/fcp/).
2. Перемещаясь по временной шкале вперед, найдите период *тихого окна (quiet window)*—временной интервал продолжительностью не менее пяти секунд, на протяжении которого отсутствуют [длительные задачи](/custom-metrics/#long-tasks-api) и выполняется не более двух сетевых запросов (GET). 
3. Перемещаясь по временной шкале назад, найдите последнюю длительную задачу перед тихим окном, остановитесь на FCP, если длительных задач не было.
4. TTIэто время окончания последней длительной задачи перед наступлением тихого окна (при отсутствии длительных задач значение TTI будет равняться значению FCP).

Следующая диаграмма поможет визуализировать описанные выше действия:

{% Img src="image/admin/WZM0n4aXah67lEyZugOT.svg", alt="Временная шкала загрузки страницы, показывающая, как вычислить TTI", width="800", height="473", linkTo=true %}

В прошлом при проведении оптимизации страниц некоторые разработчики уделяли внимание ускорению рендеринга в ущерб показателю TTI.

Такие методы, как рендеринг на стороне сервера (SSR), могут привести к сценариям, в которых страница *выглядит* интерактивной (то есть ссылки и кнопки видны на экране), но на *самом деле* она не интерактивна, потому что основной поток заблокирован или код JavaScript, управляющий этими элементами, не загружен.

Когда пользователи пытаются взаимодействовать со страницей, которая только выглядит интерактивной, это вызывает у них реакцию следующих двух типов:

- В лучшем случае их будет раздражать медленный отклик страницы.
- В худшем случае они решат, что страница неисправна, и, скорее всего, уйдут. Более того, они могут разувериться в ценности вашего бренда.

Чтобы избежать подобных проблем, приложите все усилия для минимизации разницы между FCP и TTI. А в случаях, когда существует действительно заметная разница, с помощью визуальных индикаторов дайте пользователю понять, что компоненты на странице еще не интерактивны.

## Как измерить TTI

TTIэто показатель, который лучше всего измерять [в лабораторных условиях](/user-centric-performance-metrics/#in-the-lab). Оптимальный способ измерить TTIзапустить проверку производительности Lighthouse для вашего сайта. Подробнее об этом см. в [документации Lighthouse по TTI](/tti/).

### Инструменты для измерения в лабораторных условиях

- [Lighthouse](https://developer.chrome.com/docs/lighthouse/overview/)
- [WebPageTest](https://www.webpagetest.org/)

{% Aside %} Не рекомендуется измерять TTI в полевых условиях, поскольку взаимодействие с пользователем может повлиять на TTI страницы таким образом, что это приведет к большим расхождениям со значениями в отчетах. Чтобы оценить интерактивность страницы в полевых условиях, следует измерить [FID (Время ожидания до первого взаимодействия с контентом)](/fid/). {% endAside %}

## Какое значение показателя TTI можно считать хорошим?

Для обеспечения удобства работы пользователей сайты должны стремиться к тому, чтобы время до интерактивного взаимодействия составляло менее **5 секунд** при тестировании на **мобильных устройствах среднего уровня производительности**.

Подробная информация о влиянии TTI страницы на показатель производительности в Lighthouse приводится в статье [«Как Lighthouse определяет ваш показатель TTI»](https://developer.chrome.com/docs/lighthouse/performance/interactive/#how-lighthouse-determines-your-tti-score).

## Как улучшить показатель TTI

Чтобы узнать, как улучшить TTI для конкретного сайта, можно запустить проверку производительности с помощью Lighthouse и обратить внимание на любые конкретные [возможности улучшения](https://developer.chrome.com/docs/lighthouse/performance/#opportunities), предлагаемые проверкой.

Чтобы узнать, как улучшить TTI в целом (для любого сайта), обратитесь к следующим руководствам по производительности:

- [Минимизация JavaScript](https://developer.chrome.com/docs/lighthouse/performance/unminified-javascript/)
- [Предварительное подключение к нужным источникам](https://developer.chrome.com/docs/lighthouse/performance/uses-rel-preconnect/)
- [Предварительная загрузка ключевых запросов](https://developer.chrome.com/docs/lighthouse/performance/uses-rel-preload/)
- [Уменьшение влияния стороннего кода](https://developer.chrome.com/docs/lighthouse/performance/third-party-summary/)
- [Минимизация глубины вложенности критических запросов](https://developer.chrome.com/docs/lighthouse/performance/critical-request-chains/)
- [Уменьшение времени выполнения JavaScript](https://developer.chrome.com/docs/lighthouse/performance/bootup-time/)
- [Минимизация работы основного потока](https://developer.chrome.com/docs/lighthouse/performance/mainthread-work-breakdown/)
- [Поддержание малого количества запросов и объемов передаваемых данных](https://developer.chrome.com/docs/lighthouse/performance/resource-summary/)
