---
layout: post
title: Общее время блокировки (TBT)
authors:
  - philipwalton
date: 2019-11-07
updated: 2020-06-15
description: В этой статье описывается метрика TBT (Общее время блокировки) и объясняются принципы ее измерения
tags:
  - performance
  - metrics
---

{% Aside %}

Общее время блокировки (TBT)важный [лабораторный показатель](/user-centric-performance-metrics/#in-the-lab) для измерения [отзывчивости при загрузке,](/user-centric-performance-metrics/#types-of-metrics) так как данный показатель помогает количественно оценить степень неинтерактивности страницы до того момента, как она станет надежно интерактивной. Низкое значение показателя TBT гарантирует, что страница [пригодна к использованию](/user-centric-performance-metrics/#questions).

{% endAside %}

## Что такое TBT?

Метрика Total Blocking Time (TBT) измеряет общее количество времени между [FCP (Первой отрисовкой контента)](/fcp/) и [TTI (Временем до интерактивности)](/tti/). В данный период времени основной поток блокируется и не реагирует на действия пользователя.

Основной поток считается «заблокированным» каждый раз, когда возникает [длительная задача](/custom-metrics/#long-tasks-api)задача, которая выполняется в основном потоке более 50 миллисекунд (мс). Мы говорим, что основной поток «заблокирован», потому что браузер не может прервать выполняемую задачу. Если пользователь *взаимодействует* со страницей в середине длительной задачи, браузер ждет завершения задачи, прежде чем ответить на действия пользователя.

Если задача достаточно длительная (более 50 мс), вполне вероятно, что пользователь заметит задержку и воспримет страницу как «подвисающую» или «глючную».

*Время блокировки* данной длительной задачиэто ее продолжительность, превышающая 50 мс. И *общее время блокировки* для страницыэто сумма *временных интервалов блокировок* для каждой длительной задачи, возникающей между FCP и TTI.

Для примера рассмотрим следующую схему основного потока браузера во время загрузки страницы:

{% Img src="image/admin/clHG8Yv239lXsGWD6Iu6.svg", alt="Временная шкала задач в основном потоке", width="800", height="156", linkTo=true %}

На временной шкале выше пять задач, три из которых являются длительными, так как их продолжительность превышает 50 мс. Следующая диаграмма показывает время блокировки для каждой из длительных задач:

{% Img src="image/tcFciHGuF3MxnTr1y5ue01OGLBn2/xKxwKagiz8RliuOI2Xtc.svg", alt="Временная шкала с отмеченным временем блокировки задач в основном потоке", width="800", height="156", linkTo=true %}

Таким образом, хотя общее время, затрачиваемое на выполнение задач в основном потоке, составляет 560 мс, только 345 мс считаются временем блокировки.

<table>
  <tr>
    <th></th>
    <th>Продолжительность задачи</th>
    <th>Время блокировки задачи</th>
  </tr>
  <tr>
    <td>Первая задача</td>
    <td>250 мс</td>
    <td>200 мс</td>
  </tr>
  <tr>
    <td>Вторая задача</td>
    <td>90 мс</td>
    <td>40 мс</td>
  </tr>
  <tr>
    <td>Третья задача</td>
    <td>35 мс</td>
    <td>0 мс</td>
  </tr>
  <tr>
    <td>Четвертая задача</td>
    <td>30 мс</td>
    <td>0 мс</td>
  </tr>
  <tr>
    <td>Пятая задача</td>
    <td>155 мс</td>
    <td>105 мс</td>
  </tr>
  <tr>
    <td colspan="2"><strong>Общее время блокировки</strong></td>
    <td><strong>345 мс</strong></td>
  </tr>
</table>

### Как TBT соотносится с TTI?

TBTотличный вспомогательный показатель для TTI, потому что он помогает количественно оценить степень неинтерактивности страницы до того, как она станет надежно интерактивной.

TTI считает страницу «надежно интерактивной», если в основном потоке не выполняются длительные задачи в течение как минимум пяти секунд. Это означает, что три задачи по 51 мс, распределенные на 10 секунд, могут отодвинуть TTI так же далеко, как и одна 10-секундная задача, но эти два сценария будут сильно отличаться для пользователя, пытающегося взаимодействовать со страницей.

В первом случае для трех задач по 51 мс значение TBT составит **3 мс**. Тогда как для одиночной 10-секундной задачи TBT будет равно **9950 мс**. Чем больше значение TBT во втором случае, тем хуже впечатления пользователя.

## Как измерить TBT

TBTэто показатель, который лучше всего измерять [в лабораторных условиях](/user-centric-performance-metrics/#in-the-lab). Оптимальный способ измерить TBTзапустить проверку производительности Lighthouse для вашего сайта. Подробнее об этом см. в [документации Lighthouse по TBT](https://developer.chrome.com/docs/lighthouse/performance/lighthouse-total-blocking-time/).

### Инструменты для измерения в лабораторных условиях

- [Chrome DevTools](https://developer.chrome.com/docs/devtools/)
- [Lighthouse](https://developer.chrome.com/docs/lighthouse/overview/)
- [WebPageTest](https://www.webpagetest.org/)

{% Aside %} Не рекомендуется измерять TBT в полевых условиях, поскольку взаимодействие с пользователем может повлиять на TBT страницы таким образом, что это приведет к большим расхождениям со значениями в отчетах. Чтобы оценить интерактивность страницы в полевых условиях, следует измерить [FID (Время ожидания до первого взаимодействия с контентом)](/fid/). {% endAside %}

## Какое значение показателя TBT можно считать хорошим?

Для обеспечения удобства работы пользователей сайты должны стремиться к тому, чтобы общее время блокировки не превышало **300 миллисекунд** при тестировании на **мобильных устройствах среднего уровня производительности**.

Подробная информация о влиянии TBT страницы на показатель производительности в Lighthouse приводится в статье [«Как Lighthouse определяет ваш показатель TBT»](https://developer.chrome.com/docs/lighthouse/performance/lighthouse-total-blocking-time/#how-lighthouse-determines-your-tbt-score).

## Как улучшить показатель TBT

Чтобы узнать, как улучшить TBT для конкретного сайта, можно запустить проверку производительности с помощью Lighthouse и обратить внимание на любые конкретные [возможности улучшения](https://developer.chrome.com/docs/lighthouse/performance/#opportunities), предлагаемые проверкой.

Чтобы узнать, как улучшить TBT в целом (для любого сайта), обратитесь к следующим руководствам по производительности:

- [Уменьшение влияния стороннего кода](https://developer.chrome.com/docs/lighthouse/performance/third-party-summary/)
- [Уменьшение времени выполнения JavaScript](https://developer.chrome.com/docs/lighthouse/performance/bootup-time/)
- [Минимизация работы основного потока](https://developer.chrome.com/docs/lighthouse/performance/mainthread-work-breakdown/)
- [Поддержание малого количества запросов и объемов передаваемых данных](https://developer.chrome.com/docs/lighthouse/performance/resource-summary/)
