---
layout: post
title: Время ожидания до первого взаимодействия с контентом (FID)
authors:
  - philipwalton
date: 2019-11-07
updated: 2022-07-18
description: В этой статье описывается метрика FID (Время ожидания до первого взаимодействия с контентом) и объясняются принципы ее измерения
tags:
  - performance
  - metrics
---

{% Aside %} Время ожидания до первого взаимодействия с контентом (FID)важная, ориентированная на пользователя метрика для измерения [отзывчивости при загрузке](/user-centric-performance-metrics/#types-of-metrics). Данная метрика позволяет количественно оценить опыт пользователей при попытке взаимодействия с неотвечающими страницами. Низкое значение показателя FID свидетельствует о том, что страница [пригодна для использования](/user-centric-performance-metrics/#questions). {% endAside %}

Все мы знаем, как важно произвести хорошее первое впечатление. Это важно не только при знакомстве с новыми людьми, но и при знакомстве пользователей со страницей в Интернете.

В Интернете хорошее первое впечатление может повлиять на то, станет ли посетитель сайта лояльным клиентом или он уйдет и больше не вернется. Вопрос в том, что именно производит хорошее впечатление и как вы оцениваете, какое впечатление ваш сайт производит на пользователей?

В Интернете первое впечатление складывается из совершенно разных составляющих: начиная от дизайна и визуальной привлекательности сайта, и заканчивая скоростью загрузки и отзывчивостью.

Трудно оценить, насколько пользователям нравится дизайн сайта с веб-API, но можно довольно легко измерить скорость загрузки и отзывчивость сайта!

Первое впечатление пользователей о том, как быстро загружается сайт, можно измерить с помощью метрики [FCP (Первая отрисовка контента)](/fcp/). Но то, как быстро сайт может рисовать пиксели на экране,лишь одна из составляющих успеха. Не менее важно, насколько быстро реагирует сайт, когда пользователи пытаются взаимодействовать с этими пикселями!

Показатель FID (Время ожидания до первого взаимодействия с контентом) помогает измерить первое впечатление пользователя об интерактивности и быстродействии сайта.

## Что такое FID?

FID измеряет время от момента, когда пользователь впервые взаимодействует со страницей (то есть, когда он щелкает ссылку, нажимает кнопку или использует настраиваемый элемент управления на основе JavaScript), до момента, когда браузер действительно сможет начать реагировать на сигналы от обработчиков событий в ответ на это взаимодействие.

<picture>
  <source srcset="{{ "image/tcFciHGuF3MxnTr1y5ue01OGLBn2/eXyvkqRHQZ5iG38Axh1Z.svg" | imgix }}" media="(min-width: 640px)" width="400", height="100">
  {% Img src="image/tcFciHGuF3MxnTr1y5ue01OGLBn2/Se4TiXIdp8jtLJVScWed.svg", alt="Хорошие значения fid - 2,5 секунды, низкие значения больше 4,0 секунд, и все, что находится между ними, требует улучшения", width="400", height="300" %}
</picture>

### Какое значение показателя FID можно считать хорошим?

Для обеспечения удобства работы пользователей сайты должны стремиться к тому, чтобы время ожидания до первого взаимодействия с контентом составляло **100 миллисекунд** или меньше. Чтобы убедиться, что вы достигли этой цели для большинства пользователей, рекомендуется в качестве порогового значения использовать **75-й процентиль** загрузки страниц, сегментированный по мобильным и настольным устройствам.

{% Aside %} Чтобы узнать больше об исследованиях и методологии, лежащих в основе этой рекомендации, см. [«Определение пороговых значений показателей Core Web Vitals»](/defining-core-web-vitals-thresholds/) {% endAside %}

## Подробнее о FID

Как разработчики, которые пишут код, реагирующий на события, мы часто предполагаем, что код будет запущен немедленно, как только событие произойдет. Но, как пользователи, мы часто сталкиваемся с обратным: при попытках взаимодействовать с загружаемой на телефоне веб-страницей ничего не происходит, отсюда сплошное разочарование.

Как правило, задержка ввода возникает из-за того, что основной поток браузера занят чем-то другим, поэтому он (пока) не может отвечать пользователю. Одна из распространенных причин этого — браузер занят синтаксическим анализом и выполнением большого JavaScript-файла, загруженного приложением. При этом он не может запускать прослушиватели событий, потому что загружаемый JavaScript может потребовать от него выполнять другие действия.

{% Aside 'gotchas' %} FID измеряет только «задержку» обработки событий. Он не измеряет ни время обработки событий, ни время, необходимое браузеру для обновления пользовательского интерфейса после запуска обработчиков событий. Хотя это время действительно влияет на взаимодействие с пользователем, включение его как части FID будет побуждать разработчиков реагировать на события асинхронно, что улучшит метрику, но, вероятно, ухудшит восприятие. Ниже более подробно описывается, [почему учитывается только задержка ввода.](#why-only-consider-the-input-delay) {% endAside %}

Рассмотрим следующую временную шкалу загрузки типичной веб-страницы:

{% Img src="image/admin/9tm3f6pwlHMqNKuFvaP0.svg", alt="Пример трассировки загрузки страницы", width="800", height="260", linkTo=true %}

Эта визуализация показывает страницу, которая выполняет несколько сетевых запросов на ресурсы (скорее всего, файлы CSS и JS) и, после завершения загрузки этих ресурсов, они обрабатываются в основном потоке.

Это приводит к периодам, когда основной поток на какое-то время занят. Эти [задачи](https://html.spec.whatwg.org/multipage/webappapis.html#concept-task) обозначены блоками бежевого цвета.

Длительное время ожидания до первого взаимодействия с контентом обычно возникает между [Первой отрисовкой контента (FCP)](/fcp/) и [Временем до интерактивности (TTI)](/tti/), потому что страница визуализировала часть контента, но еще не стала в достаточной мере интерактивной. Чтобы это проиллюстрировать, на временную шкалу были добавлены FCP и TTI:

{% Img src="image/admin/24Y3T5sWNuZD9fKhkuER.svg", alt="Пример трассировки загрузки страницы с FCP и TTI", width="800", height="340", linkTo=true %}

Возможно, вы заметили, что между FCP и TTI проходит довольно много времени (в том числе три [длинные задачи](/custom-metrics/#long-tasks-api)). Если пользователь пытается взаимодействовать со страницей в течение этого времени (например, щелкнуть ссылку), будет задержка между моментом получения щелчка и моментом ответа основного потока.

Подумайте, что произойдет, если пользователь попытается взаимодействовать со страницей в начале самой длинной задачи:

{% Img src="image/admin/krOoeuQ4TWCbt9t6v5Wf.svg", alt="Пример трассировки загрузки страницы с FCP, TTI и FID", width="800", height="380", linkTo=true %}

Поскольку ввод происходит, когда браузер выполняет задачу, ему необходимо завершить задачу, прежде чем реагировать на ввод. Время ожиданияэто значение FID для этого пользователя на этой странице.

{% Aside %} В этом примере пользователь случайно взаимодействовал со страницей в начале периода наибольшей загрузки основного потока. Если бы пользователь начал взаимодействовать со страницей мгновением раньше (во время периода простоя), браузер мог бы ответить сразу. Эта разница во входной задержке подчеркивает важность рассмотрения распределения значений FID при составлении отчетов по метрике. Вы можете узнать больше об этом в разделе статьи, посвященном анализу данных FID и составлению отчетов по ним. {% endAside %}

### Что делать, если у взаимодействия нет прослушивателя событий?

FID измеряет разницу между моментом получения события ввода и моментом следующего простоя основного потока. Это означает, что FID измеряется **даже в тех случаях, когда прослушиватель событий не был зарегистрирован**. Причина в том, что для многих взаимодействий с пользователем не требуется прослушиватель событий, но для их запуска *необходимо*, чтобы основной поток находился в режиме ожидания.

Например, все HTML-элементы в списке ниже должны ждать завершения выполняемых задач в основном потоке, прежде чем отвечать на действия пользователя:

- текстовые поля, флажки и переключатели (`<input>`, `<textarea>`);
- выпадающие списки (`<select>`);
- ссылки (`<a>`).

### Почему рассматривается только первое взаимодействие?

Хотя длительное время ожидания до любого взаимодействия с контентом может вызвать негативные впечатления у пользователя, рекомендуется измерять именно время ожидания до первого взаимодействия по нескольким причинам:

- Время ожидания до первого взаимодействия с контентом формирует первое впечатление пользователя об отзывчивости сайта. Первые впечатления имеют решающее значение при создании общего впечатления о качестве и надежности сайта.
- Сегодня самые большие проблемы с интерактивностью в Интернете возникают во время загрузки страницы. Поэтому работа над улучшением первого взаимодействия с пользователем на сайте окажет положительное влияние на улучшение общей интерактивности Интернета.
- Решения для устранения длительного времени ожидания до первого взаимодействия с контентом (разделение кода, предварительная загрузка меньшего количества скриптов JavaScript и т. д.) не являются универсальными. Выделив эти показатели, можно предоставить веб-разработчикам более конкретные рекомендации по производительности.

### Что считается первым взаимодействием с контентом?

FID — это показатель, который измеряет скорость отклика страницы во время загрузки. Таким образом, он фокусируется только на событиях ввода от дискретных действий, таких как клики, касания и нажатия клавиш.

Другие взаимодействия, такие как прокрутка и масштабирование, являются непрерывными действиями и имеют совершенно другие ограничения производительности (кроме того, браузеры часто могут скрывать задержку, выполняя их в отдельном потоке).

Другими словами, FID фокусируется на R (responsiveness : отзывчивости) в [модели производительности RAIL](/rail/), тогда как прокрутка и масштабирование больше связаны с A (animation : анимацией), и их характеристики производительности следует оценивать отдельно.

### Что делать, если пользователь никогда не взаимодействует с вашим сайтом?

Не все пользователи будут взаимодействовать с вашим сайтом при каждом посещении. И не все взаимодействия имеют отношение к FID (как упоминалось в предыдущем разделе). Кроме того, первые взаимодействия одних пользователей будут происходить в неудобное время (когда основной поток занят в течение длительного периода времени), а других пользователейв удобное время (когда основной поток простаивает).

Это означает, что будут пользователи без FID, с низкими значениями FID и, вероятно, с высокими значениями FID.

Способы отслеживания, составления отчетов и анализа FID, скорее всего, будут отличаться от способов, применяемых при работе с другими метриками. Подробнее об этом в следующем разделе.

### Зачем учитывать только задержку при вводе?

Как упоминалось выше, FID измеряет только «задержку» обработки событий. Он не измеряет ни время обработки событий, ни время, необходимое браузеру для обновления пользовательского интерфейса после запуска обработчиков событий.

Несмотря на то, что данное время важно для пользователя и *влияет* на его впечатления о сайте, оно не включено в эту метрику, так как это могло бы побудить разработчиков добавить обходные пути, которые фактически ухудшат работу с сайтом. Например, разработчики могли бы заключить логику обработчика событий в асинхронный обратный вызов (через `setTimeout()` или `requestAnimationFrame()`), чтобы отделить ее от задачи, связанной с событием. Результатом будет улучшение значения метрики, но более медленный отклик, воспринимаемый пользователем.

Однако, хотя FID измеряет только часть «задержки» события, разработчики, которые хотят отслеживать большую часть жизненного цикла события, могут сделать это с помощью [Event Timing API](https://wicg.github.io/event-timing/). См. руководство по [пользовательским метрикам](/custom-metrics/#event-timing-api) для получения более подробной информации.

## Как измерить FID

Измерить FID можно только в [полевых условиях](/user-centric-performance-metrics/#in-the-field), так как для измерения требуется, чтобы реальный пользователь взаимодействовал с вашей страницей. Инструменты для измерения FID перечислены ниже.

{% Aside %} FID требует наличия реального пользователя, поэтому данный показатель нельзя измерить в лабораторных условиях. Однако показатель [общего времени блокировки (TBT)](/tbt/) поддается лабораторным измерениям, хорошо коррелирует с FID в полевых условиях, а также фиксирует проблемы, влияющие на интерактивность. Оптимизация, улучшающая TBT в лабораторных условиях, также должна улучшить FID для ваших пользователей. {% endAside %}

### Инструменты для измерения в полевых условиях

- Отчет [Chrome User Experience Report](https://developer.chrome.com/docs/crux/)
- [PageSpeed Insights](https://pagespeed.web.dev/)
- [Search Console (отчет Core Web Vitals report)](https://support.google.com/webmasters/answer/9205520)
- [JavaScript-библиотека `web-vitals`](https://github.com/GoogleChrome/web-vitals)

### Измерение FID в JavaScript

{% BrowserCompat 'api.PerformanceEventTiming' %}

Чтобы измерить FID с помощью JavaScript, можно воспользоваться [Event Timing API](https://wicg.github.io/event-timing). В следующем примере показано, как создать [`PerformanceObserver`](https://developer.mozilla.org/docs/Web/API/PerformanceObserver), который прослушивает записи [`first-input`](https://wicg.github.io/event-timing/#sec-performance-event-timing) и регистрирует их в консоли:

```js
new PerformanceObserver((entryList) => {
  for (const entry of entryList.getEntries()) {
    const delay = entry.processingStart - entry.startTime;
    console.log('FID candidate:', delay, entry);
  }
}).observe({type: 'first-input', buffered: true});
```

{% Aside 'warning' %} Этот код показывает только, как регистрировать записи `first-input` в консоль и вычислять их задержку. Однако измерение FID в JavaScript сложнее. Подробности ниже. {% endAside %}

В приведенном выше примере значение задержки записи `first-input` измеряется путем получения разницы между отметками времени записей `startTime` и `processingStart`. В большинстве случаев это будет значение FID; однако не все записи `first-input` действительны для измерения FID.

Далее приведем различия между тем, что сообщает API, и тем, как рассчитывается метрика.

#### Различия между метрикой и API

- API будет отправлять записи `first-input` для страниц, загруженных в фоновых вкладках, но эти страницы следует игнорировать при вычислении FID.
- API также будет отправлять записи `first-input`, если страница была загружена в фоновом режиме до первого ввода, но эти страницы тоже следует игнорировать при вычислении FID (вводы учитываются только в том случае, если страница всё время была на переднем плане).
- API не сообщает о записях `first-input`, когда страницы восстанавливаются функцией [back/forward cache](/bfcache/#impact-on-core-web-vitals), но в данных случаях следует измерять FID, поскольку пользователи воспринимают такие посещения страниц как отдельные.
- API не сообщает о вводах внутри iframe, но для правильного измерения FID их нужно учитывать. Элементы iframe могут использовать API, чтобы сообщать о своих записях `first-input` в родительский фрейм для агрегирования.

Чтобы не запоминать все эти тонкости, разработчики могут использовать для измерения FID [JavaScript-библиотеку `web-vitals`](https://github.com/GoogleChrome/web-vitals), которая обрабатывает эти случаи (где это возможно):

```js
import {onFID} from 'web-vitals';

// Measure and log FID as soon as it's available.
onFID(console.log);
```

Полный пример измерения FID в JavaScript приводится в [исходном коде `onFID()`](https://github.com/GoogleChrome/web-vitals/blob/main/src/onFID.ts).

{% Aside %} В некоторых случаях (например, в iframe с перекрестным происхождением) невозможно измерить FID в JavaScript. См. подробности в разделе [«Ограничения»](https://github.com/GoogleChrome/web-vitals#limitations) библиотеки `web-vitals` {% endAside %}

### Анализ и отчетность по данным FID

Из-за ожидаемой дисперсии значений FID очень важно, чтобы при составлении отчета по FID вы смотрели на распределение значений и сосредотачивались на более высоких процентилях.

Хотя для всех пороговых значений Core Web Vitals [выбирается](/defining-core-web-vitals-thresholds/#choice-of-percentile) 75-й процентиль, для FID настоятельно рекомендуется смотреть на 95–99-й процентили, поскольку они будут соответствовать особенно плохим первым впечатлениям пользователей от сайта и покажут области, которые больше всего нуждаются в улучшении.

Это утверждение верно и при сегментации отчетов по категориям или типам устройств. Например, если вы запускаете отдельные отчеты для настольных компьютеров и мобильных устройств, уделите особое внимание диапазону FID с 95-го по 99-й процентили в обеих этих категориях.

## Как улучшить показатель FID

Чтобы узнать, как улучшить FID для конкретного сайта, можно запустить проверку производительности с помощью Lighthouse и обратить внимание на любые конкретные [возможности улучшения](https://developer.chrome.com/docs/lighthouse/performance/#opportunities), предлагаемые проверкой.

Хотя FID является полевым показателем, а Lighthouse — инструментом для работы с лабораторными показателями, рекомендации по улучшению FID и [Общего времени блокировки (TBT)](/tbt/) совпадают.

Подробные сведения о том, как улучшить FID, см. в статье [«Оптимизация FID»](/optimize-fid/). Дополнительные рекомендации по отдельным методам повышения производительности, которые также могут улучшить FID, смотрите в следующих статьях:

- [Уменьшение влияния стороннего кода](https://developer.chrome.com/docs/lighthouse/performance/third-party-summary/)
- [Уменьшение времени выполнения JavaScript](https://developer.chrome.com/docs/lighthouse/performance/bootup-time/)
- [Минимизация работы основного потока](https://developer.chrome.com/docs/lighthouse/performance/mainthread-work-breakdown/)
- [Поддержание малого количества запросов и объемов передаваемых данных](https://developer.chrome.com/docs/lighthouse/performance/resource-summary/)

{% include 'content/metrics/metrics-changelog.njk' %}
