---
layout: post
title: Почему важна скорость?
authors:
  - bojanpavic
  - ansteychris
  - jlwagner
description: Скорость имеет важное значение для комфорта пользователей. Задержки, вызванные скоростью мобильного соединения, не просто раздражают пользователей, но и могут негативно отражаться на бизнес-результатах.
web_lighthouse: N/A
date: 2019-05-01
updated: 2020-07-23
tags:
  - performance
---

Потребители все чаще полагаются на мобильные устройства для доступа к цифровому контенту и услугам, и если вы изучите аналитику своего сайта, то, вероятно, только убедитесь в истинности этого утверждения. Кроме того, потребители стали более требовательными, чем раньше, и когда они оценивают уровень комфорта от использования вашего сайта, то сравнивают вас не только с вашими конкурентами, но и с ведущими сервисами, которыми они пользуются каждый день.

В этой статье кратко рассказывается о проведенных исследованиях, посвященных взаимосвязи между производительностью сайтов и их коммерческой успешностью.

## Производительность — это ключ к удержанию пользователей

<figure data-float="right">
  <blockquote>
    <p>Производительность напрямую влияет на прибыль нашей компании.</p>
    <cite>
      <p data-md-type="paragraph"><a href="https://www.youtube.com/watch?v=Xryhxi45Q5M&amp;feature=youtu.be&amp;t=1366">Pinterest</a></p>
    </cite>
  </blockquote></figure>

Производительность сайтов играет важную роль в успехе любого онлайн-бизнеса. Высокопроизводительные сайты лучше привлекают и удерживают пользователей, чем медленные сайты.

Сокращение субъективного времени ожидания на 40% позволило Pinterest [увеличить число регистраций и переходов из поисковых систем на 15%](https://medium.com/@Pinterest_Engineering/driving-user-growth-with-performance-improvements-cfc50dafadd7).

Компания COOK сократила среднее время загрузки страницы на 850 миллисекунд, и это привело к [увеличению конверсии на 7%, снижению показателя отказов на 7%, а также 10-процентному увеличению количества просмотренных страниц за сеанс](https://www.nccgroup.trust/globalassets/resources/uk/case-studies/web-performance/cook-case-study.pdf).

Исследования также продемонстрировали негативное влияние низкой производительности на достижение бизнес-целей. Например, компания [BBC](https://www.creativebloq.com/features/how-the-bbc-builds-websites-that-scale) обнаружила, что каждая последующая секунда, затрачиваемая на загрузку их сайта, приводила к потере дополнительных 10% пользователей.

## Производительность позволяет повысить конверсию

Удержание пользователей имеет решающее значение для повышения конверсии. Медленная скорость сайтов негативно влияет на доход, а быстрые сайты повышают коэффициент конверсии.

Компания [Mobify](http://resources.mobify.com/2016-Q2-mobile-insights-benchmark-report.html) обнаружила, что каждые 100 мс, сэкономленные при загрузке домашней страницы, позволили увеличить сеансовую конверсию на 1,11%, благодаря чему среднегодовой доход вырос почти на 380 000 $. Кроме того, снижение на 100 мс задержки при загрузке страницы оформления заказа позволило увеличить сеансовую конверсию на 1,55%, что, в свою очередь, увеличило среднегодовой доход почти на 530 000 $.

Когда [компания AutoAnything вдвое сократила время загрузки страницы](https://www.digitalcommerce360.com/2010/08/19/web-accelerator-revs-conversion-and-sales-autoanything/), их продажи выросли на 12–13%.

Компания [Furniture Village](https://www.thinkwithgoogle.com/intl/en-gb/success-stories/uk-success-stories/furniture-village-and-greenlight-slash-page-load-times-boosting-user-experience/), занимающаяся розничными продажами, провела аудит скорости своего сайта и разработала план по решению выявленных проблем. Реализация плана позволила сократить время загрузки страницы на 20% и повысить коэффициент конверсии на 10%.

## Производительность повышает комфорт пользователей

Скорость имеет важное значение для комфорта пользователей. Согласно [исследованию потребительского поведения](https://www.ericsson.com/en/press-releases/2016/2/streaming-delays-mentally-taxing-for-smartphone-users-ericsson-mobility-report), задержки при использовании мобильного соединения вызывают у пользователей такой же сильный стресс, как при просмотре фильма ужасов или решении математической задачи, и более сильный, чем во время ожидания в очереди на кассе.

При загрузке сайта проходит какое-то время, прежде чем пользователь сможет увидеть контент. Пока этого не произойдет, нет смысла и говорить о каком-либо опыте взаимодействия с сайтом. При использовании быстрого соединения задержка является минимальной, однако при медленном соединении ожидание занимает много времени. По мере того как страница постепенно загружает ресурсы, пользователи могут столкнуться с дополнительными проблемами.

<figure> {% Img src="image/admin/W0ctiX3cMOfWnNF6AQMg.png", alt="Покадровое сравнение скорости загрузки страницы. Первая последовательность показывает загрузку страницы на медленном соединении, а вторая — на быстром.", width="800", height="264" %} <figcaption>Сравнение скорости загрузки страницы при использовании медленного соединения (вверху) и быстрого соединения (внизу).</figcaption></figure>

Производительность — это основополагающий аспект пользовательского комфорта. Когда сайт перегружен избыточным кодом, браузер вынужден тратить на его загрузку мегабайты трафика из тарифного плана пользователя. Мобильные устройства обладают ограниченной мощностью процессора и объемом памяти. Они с трудом справляются с выполнением неоптимизированного кода, объем которого может показаться нам небольшим. Это приводит к низкой производительности и зависаниям. Исходя из того, что нам известно о человеческом поведении, пользователи терпят медленные приложения лишь до поры до времени, а затем от них отказываются.

## Производительность — это часть заботы о людях

Сайты и приложения с низкой производительностью могут причинять реальный вред людям, которые ими пользуются.

[Поскольку мобильные пользователи по-прежнему составляют большую часть пользователей Интернета во всем мире](http://gs.statcounter.com/platform-market-share/desktop-mobile-tablet), важно помнить, что многие из них выходят в сеть через мобильные сети LTE, 4G, 3G и даже 2G. Как отмечает в [своем исследовании реальной производительности](https://calibreapp.com/blog/beyond-the-bubble) Бен Шварц из Calibre, стоимость тарифных планов с предоплатой трафика снижается, что, в свою очередь, делает Интернет доступным для тех, кто раньше не мог его себе позволить. Мобильные устройства и доступ в Интернет больше не являются роскошью. Они повсеместно используются людьми для того, чтобы ориентироваться и действовать во все более взаимосвязанном мире.

[Средний размер веб-страниц неуклонно растет как минимум с 2011 года](http://beta.httparchive.org/reports/state-of-the-web#bytesTotal), и эта тенденция, похоже, сохраняется. Поскольку на загрузку типичной веб-страницы тратится много трафика, пользователи вынуждены тратить больше денег, пополняя счет мобильного телефона.

Быстрые и простые сайты не только экономят деньги пользователей, но и могут сыграть решающее значение для пользователей, находящихся в кризисной ситуации. Учреждения общественной важности, такие как больницы, клиники и кризисные центры, имеют сайты, при помощи которых распространяют важную информацию, необходимую пользователям в критические моменты. [Хотя для эффективного восприятия важной информации в стрессовые моменты крайне важен продуманный дизайн](https://aneventapart.com/news/post/eric-meyer-designing-for-crisis), ни в коем случае нельзя недооценивать важность быстрой доставки этой информации. Это часть наших обязанностей.

## Начните работу над повышением скорости вашего сайта {: #get-started }

Ознакомьтесь с [Core Web Vitals](/vitals/#core-web-vitals), чтобы узнать о показателях, на которые, по мнению Google, должны ориентироваться все сайты.

<blockquote>
  <p>Мы продолжаем работу в этом направлении и сегодня расскажем, как перечисленные показатели будут учитываться в обновленном алгоритме ранжирования результатов поиска. Мы собираемся внедрить новый сигнал, объединяющий показатели Core Web Vitals с введенными ранее сигналами. Так мы сможем получать более полное представление о том, насколько удобна для пользователей та или иная страница.</p>
  <cite><a href="https://webmasters.googleblog.com/2020/05/evaluating-page-experience.html">Оценка удобства страниц</a>, официальный блог Google Webmaster Central</cite>
</blockquote>

Затем ознакомьтесь с разделом [Быстрое время загрузки](/fast/), где вы найдете множество советов и приемов, позволяющих повысить или сохранить скорость.
