---
layout: post
title: Удаление неиспользуемого кода
subhead: |
  Npm упрощает добавление кода в проект. Но так ли уж нужны все эти лишние байты?
authors:
  - houssein
date: 2018-11-05
description: |
  Реестры вроде npm изменили экосистему JavaScript к лучшему: они позволяют легко скачать и использовать более полумиллиона общедоступных пакетов. Но часто мы добавляем библиотеки, которые используем не полностью. Поэтому нужно анализировать пакеты и находить неиспользуемый код.
codelabs:
  - codelab-remove-unused-code
tags:
  - performance
---

Реестры вроде [npm](https://docs.npmjs.com/getting-started/what-is-npm) изменили
экосистему JavaScript к лучшему: они позволяют легко скачать и использовать
более _полумиллиона_ общедоступных пакетов. Но часто мы добавляем библиотеки,
которые используем не полностью. Поэтому нужно **анализировать пакеты**
и находить неиспользуемый код, а затем удалять **неиспользуемые** и **ненужные** библиотеки.

## Анализ пакета

С помощью DevTools можно легко узнать размер сетевых запросов:
{% Instruction 'devtools-network', 'ol' %}
{% Instruction 'disable-cache', 'ol' %}
{% Instruction 'reload-page', 'ol' %}

{% Img src="image/admin/aq6QZj5p4KTuaWnUJnLC.png", alt="Панель «Сеть» (Network) с запросом пакета", width="800", height="169" %}

Вкладка [Покрытие](https://developer.chrome.com/docs/devtools/coverage/)
(Coverage) в DevTools также сообщает, какое количество CSS- и JS-кода в приложении
не используется.

{% Img src="image/admin/xlPdOMaeykJhYqGcaMJr.png", alt="Покрытие кода в DevTools", width="800", height="562" %}

Указав полную конфигурацию Lighthouse через Node CLI, с помощью аудита
«Неиспользуемый JavaScript» (Unused JavaScript) можно отслеживать, какое количество
неиспользуемого кода поставляется с приложением.

{% Img src="image/admin/tdC0d65gEIiHZy6eyo82.png", alt="Аудит «Unused JavaScript» в Lighthouse", width="800", height="347" %}

Если в качестве упаковщика вы используете [webpack](https://webpack.js.org/),
то разобраться в том, что входит в комплект, вам поможет
[Webpack Bundle Analyzer](https://github.com/webpack-contrib/webpack-bundle-analyzer). Добавьте этот плагин в файл
конфигурации webpack обычным образом:

```js/4
module.exports = {
  //...
  plugins: [
    //...
    new BundleAnalyzerPlugin()
  ]
}
```

Webpack обычно используется для одностраничных приложений.
Но и в других сборщиках (например, [Parcel](https://parceljs.org/) и
[Rollup](https://rollupjs.org/guide/en)) тоже есть инструменты визуализации,
которые пригодятся для анализа пакета.

При перезагрузке приложения с добавленным плагином отображается масштабируемая
древовидная карта всего пакета.

{% Img src="image/admin/pLAHEtl5C011wTk2IJij.png", alt="Webpack Bundle Analyzer", width="800", height="468" %}

Эта визуализация позволяет определить, какие части пакета
больше других, а также получить представление обо всех импортируемых
библиотеках. Таким образом можно определить, есть ли у вас неиспользуемые
или ненужные библиотеки.

## Удаление неиспользуемых библиотек

На предыдущем изображении древовидной карты довольно много пакетов
в одном домене `@firebase`. Если вашему сайту нужен только компонент базы данных firebase,
то обновите настройки импорта и получите эту библиотеку:

```js/1-2/0
import firebase from 'firebase';
import firebase from 'firebase/app';
import 'firebase/database';
```

Помните, что для более крупных приложений этот процесс будет значительно
сложнее.

Если вам попадется загадочный пакет, который, казалось бы,
нигде не применяется, посмотрите, какие из зависимостей верхнего уровня
его используют. Попробуйте импортировать из этого пакета только нужные компоненты.
Если библиотека не используется, удалите ее.  Если библиотека не нужна для начальной
загрузки страницы, попробуйте [отложить ее загрузку](/reduce-javascript-payloads-with-code-splitting).

Если вы используете webpack, просмотрите [список плагинов, которые
автоматически удаляют неиспользуемый код из популярных библиотек](https://github.com/GoogleChromeLabs/webpack-libs-optimizations).

{% Aside 'codelab' %}
[Удаление неиспользуемого кода.](/codelab-remove-unused-code)
{% endAside %}

## Удаление ненужных библиотек

Не каждую библиотеку можно легко разбить на части и выборочно импортировать.
В этом случае подумайте, можно ли удалить библиотеку целиком. Не стоит
забывать, что можно реализовать собственное решение или использовать
более «легкую» альтернативу. Однако также важно оценить сложность и необходимые
для этого усилия, прежде чем удалять библиотеку из приложения полностью.