---
layout: post
title: Измеряем производительность с помощью модели RAIL
description: |2-

  Модель RAIL позволяет дизайнерам и разработчикам уверенно проводить оптимизацию производительности, что критически влияет на взаимодействие с пользователем. Узнайте, какие цели и принципы устанавливает модель RAIL и какие инструменты вы можете использовать для их достижения.
date: 2020-06-10
tags:
  - performance
  - animations
  - devtools
  - lighthouse
  - metrics
  - mobile
  - network
  - rendering
  - ux
---

**RAIL** — это **ориентированная на пользователя** модель производительности, которая обеспечивает структурированный подход к оптимизации производительности. Модель разбивает пользовательское взаимодействие на ключевые действия (например, нажатие, прокрутка, загрузка) и помогает определить цели производительности для каждого из них.

Аббревиатура RAIL обозначает четыре различных аспекта жизненного цикла веб-приложения: ответ (response), анимация (animation), ожидание (idle) и загрузка (load). Пользователи ожидают разной производительности для каждой из этих ситуаций, поэтому цели производительности определяются на основе контекста и [UX-исследования того, как пользователи воспринимают задержки](https://www.nngroup.com/articles/response-times-3-important-limits/).

<figure>{% Img src="image/admin/uc1IWVOW2wEhIY6z4KjJ.png", alt="Четыре части модели производительности RAIL: ответ, анимация, ожидание и загрузка.", width="800", height="290" %}<figcaption> 4 части модели производительности RAIL </figcaption></figure>

## Сосредоточьтесь на пользователе

Сфокусируйте свою работу на пользователе. В таблице ниже описаны ключевые показатели того, как пользователи воспринимают задержки производительности:

<table class="table-wrapper scrollbar">
  <thead>Восприятие пользователем задержек производительности</thead>
  <tr>
    <td>От 0 до 16 мс</td>
    <td>Пользователи на исключение чутко отслеживают движение и не любят задержек при анимации. Они воспринимают анимацию как плавную, если каждую секунду рендерится 60 новых кадров. Это 16 мс на кадр, включая время, необходимое браузеру, чтобы отобразить новый кадр на экране. У приложения при этом остается около 10 мс на создание кадра.</td>
  </tr>
  <tr>
    <td>От 0 до 100 мс</td>
    <td>Если отвечать на действия пользователей в пределах этого временного окна, пользователи будут воспринимать результат как мгновенный. При большей длительности связь между действием и реакцией нарушается.</td>
  </tr>
  <tr>
    <td>От 100 до 1000 мс</td>
    <td>В этом интервале все ощущается частью естественного и непрерывного процесса выполнения задач. Большинство пользователей Интернета воспринимает загрузку страниц или смену представления как задачу.</td>
  </tr>
  <tr>
    <td>1000 мс или более</td>
    <td>По истечении 1000 миллисекунд (1 секунда) пользователи теряют внимание к выполняемой задаче.</td>
  </tr>
  <tr>
    <td>10000 мс или более</td>
    <td>По прошествии 10000 миллисекунд (10 секунд) пользователи разочаровываются и, скорее всего, откажутся от задачи. Позже они могут вернуться, а могут и не вернуться.</td>
  </tr>
</table>

{% Aside %} Пользователи по-разному воспринимают задержки производительности в зависимости от состояния сети и оборудования. Например, загрузка сайтов на мощном настольном компьютере при быстром соединении Wi-Fi обычно происходит менее чем за 1 секунду, и пользователи к этому привыкли. Загрузка сайтов на мобильные устройства с медленным 3G-подключением занимает больше времени, поэтому мобильные пользователи обычно более терпеливы, и загрузка на мобильных устройствах за 5 секунд — более реалистичная цель. {% endAside %}

## Цели и принципы

В контексте RAIL термины **цели** и **принципы** имеют особое значение:

- **Цели**. Ключевые показатели производительности, касающиеся работы пользователя. Например, от нажатия до отрисовки должно проходить не более 100 миллисекунд. Поскольку человеческое восприятие относительно постоянно, в ближайшее время эти цели вряд ли изменятся.

- **Принципы**. Рекомендации, которые помогут вам достичь цели. Они могут быть привязаны к текущему оборудованию и условиям сетевого подключения, следовательно, со временем могут измениться.

## Ответ: обрабатывайте события не дольше 50 мс

**Цель**: завершить переход, инициированный пользовательским вводом, в течение 100 мс, чтобы пользователи чувствовали, что взаимодействие происходит мгновенно.

**Принципы**:

- Чтобы обеспечить видимый ответ в течение 100 мс, обрабатывайте события ввода пользователя в течение 50 мс. Это касается большинства действий ввода, таких как нажатие кнопок, переключение элементов управления формы или запуск анимации. Это не относится к перетаскиванию касанием или прокрутке.

- Хотя это может показаться нелогичным, немедленный ответ на ввод пользователя — не всегда верное решение. Интервал в 100 мс можно использовать для другой дорогостоящей работы, но с осторожностью, чтобы не заблокировать пользователя. По возможности проводите работу в фоновом режиме.

- Обеспечьте обратную связь для всех действий, выполнение которых занимает более 50 мс.

### 50 мс или 100 мс?

Если цель в том, чтобы отреагировать на ввод менее чем за 100 мс, почему же тогда наш бюджет составляет всего 50 мс? Это связано с тем, что помимо обработки ввода обычно выполняется другая работа, и она занимает часть времени, доступного для получения приемлемого ответа на ввод. Когда приложение выполняет работу рекомендованными фрагментами по 50 мс во время простоя, это означает, что ввод может быть поставлен в очередь на срок до 50 мс, если он производится во время одного из этих фрагментов работы. Учитывая это, можно с уверенностью предположить, что на фактическую обработку ввода остается всего 50 мс. Этот эффект представлен на диаграмме ниже, которая показывает, как полученный во время простоя ввод ставится в очередь, сокращая доступное время обработки:

<figure>{% Img src="image/admin/I7HDZ9qGxe0jAzz6PxNq.png", alt="Диаграмма, показывающая, как полученный во время простоя ввод помещается в очередь, сокращая доступное время обработки ввода до 50 мс", width="800", height="400" %} <figcaption>Как ожидание влияет на бюджет ответа на ввод.</figcaption></figure>

## Анимация: создавайте кадр за 10 мс

**Цели**:

- Выдавайте каждый кадр анимации за 10 мс или меньше. Технически максимальный бюджет для каждого кадра составляет 16 мс (1000 мс /ыв 60 кадров в секунду ≈ 16 мс), но браузерам требуется около 6 мс для рендеринга каждого кадра, поэтому рекомендуется 10 мс на кадр.

- Стремитесь к визуальной плавности. Пользователи замечают, когда частота кадров меняется.

**Принципы**:

- В таких условиях высокой нагрузки, как анимация, главное — ничего не делать там, где это возможно, и выполнять абсолютный минимум в остальных случаях. По возможности используйте отклик в 100 мс, чтобы предварительно рассчитать дорогостоящую работу: так вы повысите свои шансы на достижение 60 кадров в секунду.

- Информацию о различных стратегиях оптимизации анимации см. в разделе «[Производительность рендеринга»](/rendering-performance/).

{% Aside %} Различайте все типы анимации. Анимация — это не только навороченные эффекты пользовательского интерфейса. Каждое из этих взаимодействий считается анимацией:

- Визуальные анимации, такие как входы и выходы, [преобразования](https://www.webopedia.com/TERM/T/tweening.html), а также индикаторы загрузки.
- Прокрутка. Сюда также относится смахивание, когда пользователь начинает прокрутку, затем отпускает, и страница продолжает прокручиваться.
- Перетаскивание. Анимации часто следуют за действиями пользователя, такими как панорамирование карты или масштабирование пальцем. {% endAside %}

## Ожидание: максимизируйте время простоя

**Цель**: максимально увеличьте время простоя, чтобы повысить вероятность того, что страница ответит на ввод пользователя в течение 50 мс.

**Принципы**:

- Используйте время простоя для завершения отложенной работы. Например, при начальной загрузки страницы загрузите как можно меньше данных, а затем используйте [время простоя](https://developer.mozilla.org/docs/Web/API/Window/requestIdleCallback) для загрузки остальных.

- Выполняйте работу во время простоя не более 50 мс. Превысив этот интервал, вы рискуете помешать приложению реагировать на ввод пользователя в течение 50 мс.

- Если пользователь взаимодействует со страницей во время простоя, взаимодействие с пользователем всегда должно иметь наивысший приоритет и прерывать работу во время простоя.

## Загрузка: доставляйте контент и переходите в интерактивный режим менее чем за 5 секунд

Когда страницы загружаются медленно, внимание пользователя отвлекается и он воспринимает задачу как невыполненную. Для быстро загружаемых сайтов характерны [более длительные средние сеансы, меньший процент отказов и более высокая просматриваемость рекламы](https://www.thinkwithgoogle.com/intl/en-154/insights-inspiration/research-data/need-mobile-speed-how-mobile-latency-impacts-publisher-revenue/).

**Цели**:

- Оптимизация для быстрой загрузки с учетом возможностей устройства и сети ваших пользователей. На данный момент для первых загрузок стоит стремиться к загрузке страницы и переходу в [интерактивный режим](/tti/) за [5 секунд или меньше на мобильных устройствах среднего уровня с медленным 3G-подключением](/performance-budgets-101/#establish-a-baseline).

- Для последующих загрузок хорошей целью будет загрузка страницы менее чем за 2 секунды.

{% Aside %}

Имейте в виду, что со временем эти цели могут измениться.

{% endAside %}

**Принципы**:

- Проверьте свою скорость загрузки на мобильных устройствах и сетевых подключениях, которые распространены среди ваших пользователей. Вы можете использовать [отчет об работе с пользователями Chrome (CrUX)](/chrome-ux-report/), чтобы узнать, как [распределены подключения](https://developer.chrome.com/blog/chrome-ux-report-looker-studio-dashboard/#using-the-dashboard) ваших пользователей. Если данные для вашего сайта недоступны, [The Mobile Economy 2019](https://www.gsma.com/mobileeconomy/) предлагает взять за основу телефон Android среднего класса, такой как Moto G4, и медленную 3G-сеть (время приема-передачи 400 мс, скорость передачи 400 кбит/с). Эта комбинация доступна на [WebPageTest](https://www.webpagetest.org/easy).

- Имейте в виду, что хотя мобильное устройство среднестатистического пользователя может сообщать о своем подключении к 2G, 3G или 4G, в действительности [эффективная скорость соединения](/adaptive-serving-based-on-network-quality/#how-it-works) часто значительно ниже из-за потери пакетов и непостоянства сети.

- [Устраняйте ресурсы, блокирующие рендеринг](https://developer.chrome.com/docs/lighthouse/performance/render-blocking-resources/).

- Для создания ощущения полной загрузки не обязательно загружать все ресурсы за 5 секунд. Применяйте [отложенную загрузку изображений](/browser-level-image-lazy-loading/), [разделение кода JavaScript](/reduce-javascript-payloads-with-code-splitting/) и другие [оптимизации, предлагаемые на web.dev](/fast/).

{% Aside %} Определите факторы, влияющие на скорость загрузки страницы:

- Скорость и задержка сети
- Аппаратное обеспечение (например, медленные процессоры)
- Замещение кеша
- Различия в кешировании L2/L3
- Анализ JavaScript {% endAside %}

## Инструменты для измерения RAIL

Есть несколько инструментов, которые помогут вам автоматизировать измерения RAIL. Какой из них лучше использовать, зависит от того, какой тип информации вам нужен и какой тип рабочего процесса вы предпочитаете.

### Chrome DevTools

[Chrome DevTools](https://developer.chrome.com/docs/devtools/) обеспечивает углубленный анализ всего, что происходит во время загрузки или запуска вашей страницы. См. раздел «[Aнализ производительности во время выполнения](https://developer.chrome.com/docs/devtools/evaluate-performance/)», чтобы ознакомиться с пользовательским интерфейсом панели «**Производительность**».

Следующие функции DevTools особенно важны:

- [Замедлите работу процессора](https://developer.chrome.com/docs/devtools/evaluate-performance/reference/#cpu-throttle), чтобы смоделировать менее мощное устройство.

- [Замедлите работу сети](https://developer.chrome.com/docs/devtools/evaluate-performance/reference/#network-throttle), чтобы имитировать более медленные соединения.

- [Просматривайте активность основного потока](https://developer.chrome.com/docs/devtools/evaluate-performance/reference/#main), чтобы отслеживать все события, произошедшие в основном потоке во время записи.

- [Просматривайте действия основного потока в таблице](https://developer.chrome.com/docs/devtools/evaluate-performance/reference/#activities), чтобы отсортировать действия в зависимости от того, какие из них занимали больше всего времени.

- [Анализируйте количество кадров в секунду (FPS)](https://developer.chrome.com/docs/devtools/evaluate-performance/reference/#fps), чтобы определить, насколько плавно работает ваша анимация.

- [Отслеживайте использование ЦП, размер кучи JS, узлы DOM, число макетов в секунду и многое другое](https://developers.google.com/web/updates/2017/11/devtools-release-notes#perf-monitor) в режиме реального времени с помощью **монитора производительности**.

- [Визуализируйте сетевые запросы](https://developer.chrome.com/docs/devtools/evaluate-performance/reference/#network), которые произошли во время записи, с помощью раздела «**Сеть**».

- [Делайте снимки экрана во время записи](https://developer.chrome.com/docs/devtools/evaluate-performance/reference/#screenshots), чтобы точно воспроизвести то, как страница выглядела во время загрузки, как сработала анимация и т. д.

- [Просматривайте взаимодействия](https://developer.chrome.com/docs/devtools/evaluate-performance/reference/#interactions), чтобы быстро определить, что произошло на странице после взаимодействия с ней пользователя.

- [Находите проблемы с производительностью прокрутки в режиме реального времени](https://developer.chrome.com/docs/devtools/evaluate-performance/reference/#scrolling-performance-issues), подсвечивая страницу при срабатывании потенциально проблемного прослушивателя.

- [Просматривайте события рисования в режиме реального времени](https://developer.chrome.com/docs/devtools/evaluate-performance/reference/#paint-flashing), чтобы определять дорогостоящие события рисования, которые могут повлиять на производительность вашей анимации.

### Lighthouse

[Lighthouse](https://developer.chrome.com/docs/lighthouse/overview/) доступен в Chrome DevTools по адресу [web.dev/measure](/measure/) как расширение Chrome, как модуль Node.js и в WebPageTest. Вы даете ему URL-адрес, он имитирует устройство среднего класса с медленным 3G-соединением, выполняет серию аудитов на странице, а затем дает отчет о скорости загрузки и предложения по ее улучшению.

Наиболее важны следующие аудиты:

**Response**

- [Максимальная потенциальная задержка первого ввода (First Input Delay)](https://developer.chrome.com/docs/lighthouse/performance/lighthouse-max-potential-fid/). Оценивает, как долго ваше приложение будет реагировать на ввод данных пользователем, исходя из времени простоя основного потока.

- [Не использует пассивные прослушиватели для повышения производительности прокрутки](https://developer.chrome.com/docs/lighthouse/best-practices/uses-passive-event-listeners/).

- [Общее время блокировки (Total Blocking Time)](https://developer.chrome.com/docs/lighthouse/performance/lighthouse-total-blocking-time/). Измеряет общее время, в течение которого страница блокируется от ответа на действия пользователя, такие как щелчки мыши, касания экрана или нажатия клавиатуры.

- [Время до интерактивности (Time To Interactive)](https://developers.google.com/web/tools/lighthouse/audits/consistently-interactive). Определяет момент времени, когда пользователь сможет стабильно взаимодействовать со всеми элементами страницы.

**Load**

- [Не регистрирует сервис-воркер, который управляет страницей и start_url](https://developer.chrome.com/docs/lighthouse/pwa/service-worker/). Сервис-воркер может кешировать общие ресурсы на устройстве пользователя, сокращая время, затрачиваемое на получение ресурсов по сети.

- [Загрузка страницы в мобильных сетях происходит недостаточно быстро](https://developer.chrome.com/docs/lighthouse/pwa/load-fast-enough-for-pwa/).

- [Устраняйте ресурсы, блокирующие рендеринг](https://developers.google.com/web/tools/lighthouse/audits/blocking-resources).

- [Отложите закадровые изображения](https://developer.chrome.com/docs/lighthouse/performance/offscreen-images/). Отложите загрузку закадровых изображений до тех пор, пока они не понадобятся.

- [Правильно масштабируйте изображения](https://developer.chrome.com/docs/lighthouse/performance/uses-responsive-images/). Не показывайте изображения, размер которых значительно превышает размер, отображаемый в мобильной области просмотра.

- [Избегайте цепочки критических запросов](https://developer.chrome.com/docs/lighthouse/performance/critical-request-chains/).

- [Не использует HTTP/2 для всех своих ресурсов](https://developer.chrome.com/docs/lighthouse/best-practices/uses-http2/).

- [Эффективно кодируйте изображения](https://developer.chrome.com/docs/lighthouse/performance/uses-optimized-images/).

- [Включите сжатие текста](https://developer.chrome.com/docs/lighthouse/performance/uses-text-compression/).

- [Избегайте чрезмерных нагрузок на сеть](https://developer.chrome.com/docs/lighthouse/performance/total-byte-weight/).

- [Избегайте чрезмерного размера DOM](https://developer.chrome.com/docs/lighthouse/performance/dom-size/). Уменьшите количество сетевых байтов, доставив только те узлы DOM, которые необходимы для рендеринга страницы.

### WebPageTest

WebPageTest — это инструмент веб-производительности, который использует реальные браузеры для доступа к веб-страницам и сбора метрик времени. Введите URL-адрес на [webpagetest.org/easy](https://webpagetest.org/easy), чтобы получить подробный отчет о скорости загрузки страницы на реальном устройстве Moto G4 с медленным 3G-соединением. Вы также можете настроить его для включения аудита Lighthouse.

## Резюме

RAIL — это оптика, позволяющая рассматривать работу пользователя с веб-сайтом как маршрут, состоящий из различных взаимодействий. Оцените, как пользователи воспринимают ваш сайт, чтобы задать цели производительности, которые оказывают наибольшее влияние на взаимодействие с пользователем.

- Сосредоточьтесь на пользователе.

- Отвечайте на ввод пользователя менее чем за 100 мс.

- Выдавайте кадр менее чем за 10 мс при анимации или прокрутке.

- Увеличьте время простоя основного потока.

- Загружайте интерактивный контент менее чем за 5000 мс.
