---
layout: post
title: Использование отложенной загрузки для ускорения отрисовки страницы
authors:
  - jlwagner
  - rachelandrew
date: 2019-08-16
updated: 2020-06-09
description: |2-

  В этой статье объясняется, что такое отложенная загрузка и зачем может понадобиться откладывать загрузку элементов на сайте.
tags:
  - performance
  - images
---

Доля [изображений](http://beta.httparchive.org/reports/state-of-images?start=earliest&end=latest) и [видео](http://beta.httparchive.org/reports/page-weight#bytesVideo) в типичной полезной нагрузке сайта может быть очень значительной. К сожалению, владельцы проекта не всегда будут готовы убрать медиаресурсы из имеющихся приложений. Такая ситуация может быть очень неприятной, особенно если все заинтересованные стороны хотят улучшить работу сайта, но не могут договориться, каким образом это следует делать. К счастью, с помощью отложенной загрузки можно снизить начальную полезную нагрузку страницы *и* время загрузки, не убирая контент.

## Что такое отложенная загрузка {: #what }

При отложенной загрузке некритичные ресурсы загружаются не во время первоначальной загрузки страницы, а по необходимости. Что касается изображений, то некритичными часто считаются те, что находятся «вне кадра». Если вы использовали Lighthouse и изучали возможности для улучшения сайта, вы могли видеть соответствующие рекомендации — например, от аудита [Отложите изображения «вне кадра»](https://developer.chrome.com/docs/lighthouse/performance/offscreen-images/) (Defer offscreen images):

<figure>   {% Img src="image/admin/63NnMISWUUWD3mvAliwe.png", alt="Скриншот аудита «Отложите изображения &quot;вне кадра&quot;» (Defer offscreen images) в Lighthouse", width="800", height="102" %}   <figcaption>Один из аудитов производительности Lighthouse заключается в том, чтобы определить изображения «вне кадра», загрузку которых можно отложить</figcaption></figure>

Вы наверняка видели отложенную загрузку в действии — она выглядит примерно так:

- Вы заходите на страницу и начинаете прокручивать ее по мере чтения содержимого.
- В какой-то момент в область просмотра попадает изображение-плейсхолдер.
- Это изображение внезапно заменяется тем, которое должно быть на этом месте.

Пример отложенной загрузки изображений можно увидеть на популярной платформе публикаций [Medium](https://medium.com/), которая во время загрузки страницы размещает небольшие изображения-плейсхолдеры, которые затем заменяются отложенными изображениями по мере их появления в области просмотра.

<figure>   {% Img src="image/admin/p5ahQ67QtZ20bgto7Kpy.jpg", alt="Скриншот сайта Medium в момент просмотра, демонстрирующий работу отложенной загрузки. Слева — размытый плейсхолдер, справа — загруженный ресурс", width="800", height="493" %}   <figcaption>Пример отложенной загрузки изображений в действии. При загрузке страницы размещается изображение-плейсхолдер (слева), которое при появлении в области просмотра заменяется окончательным изображением, загружаемым по необходимости</figcaption></figure>

Если вы не знакомы с отложенной загрузкой, вам может быть интересно, насколько эффективен этот подход, и каковы его преимущества. Тогда читайте дальше!

## Зачем откладывать загрузку изображений и видео, а не просто *загружать* их? {: #why }

Потому что вы, вполне вероятно, загружаете то, что пользователь никогда не увидит, и это проблема — по нескольким причинам:

- Расход трафика. Если трафик не тарифицируется, то это, конечно, не самое худшее, что может произойти (хотя емкость канала можно было бы потратить и на загрузку других ресурсов, которые пользователь совершенно точно увидит). Но если трафик ограничен, то загрузка того, что пользователь не увидит, может оказаться пустой тратой его денег.
- Расход процессорного времени, батареи и других системных ресурсов. После скачивания мультимедийного ресурс браузер должен его декодировать и отобразить содержимое в области просмотра.

Отложенная загрузка изображений и видео сокращает время начальной загрузки страницы, начальный размер страницы и использование системных ресурсов, и всё это положительно влияет на производительность.

## Реализация отложенной загрузки {: #implementing }

Реализовать отложенную загрузку можно несколькими способами. При выборе решения необходимо учитывать, какие браузеры вы поддерживаете, а также загрузку чего конкретно вы пытаетесь отложить.

Современные браузеры реализуют [встроенную отложенную загрузку](/browser-level-image-lazy-loading/), которую можно задействовать с помощью атрибута `loading` на изображениях и окнах iframe. Чтобы обеспечить совместимость со старыми браузерами и выполнять отложенную загрузку без встроенной поддержки, можно реализовать собственное решение на JavaScript. Также в этом может помочь ряд библиотек. Подробнее обо всех этих походах смотрите в статьях на сайте:

- [Отложенная загрузка изображений](/lazy-loading-images/).
- [Отложенная загрузка видео](/lazy-loading-video/).

Кроме того, мы составили список [возможных проблем с отложенной загрузкой](/lazy-loading-best-practices) и нюансов, на которые следует обратить внимание при реализации.

## Заключение

При надлежащем использовании отложенная загрузка изображений и видео может существенно снизить время время начальной загрузки и полезную нагрузку страниц на сайте. У пользователей не будет расходоваться трафик и ресурсы на обработку медиафайлов, которые они, возможно, никогда не увидят. При этом нужные файлы при необходимости будут отображаться.

Как метод повышения производительности отложенная загрузка практически не имеет минусов. Если у вас на сайте много встроенных изображений, она поможет сократить число ненужных загрузок. Пользователи сайта и владельцы проекта обязательно это оценят!
