---
layout: post
title: Оптимизация изображений при помощи специализированных CDN
authors:
  - katiehempenius
description: CDN для изображений отлично справляются с их оптимизацией. Переход на CDN для изображений может сократить размер изображений в байтах на 40–80%.
date: 2019-08-14
codelabs:
  - install-thumbor
tags:
  - performance
---

## Зачем использовать CDN для изображений?

Сети доставки контента (CDN) для изображений отлично справляются с их оптимизацией. Переход на CDN для изображений может сократить размер изображений в байтах [на 40–80%](https://www.youtube.com/watch?v=YJGCZCaIZkQ&t=1010s). Теоретически можно достичь тех же результатов, используя только скрипты сборки, но это редко удается на практике.

## Что такое CDN для изображений?

CDN для изображений предназначены специально для их преобразования, оптимизации и доставки. Можно также рассматривать их как API для доступа к изображениям, используемым на вашем сайте, и выполнения над ними различных операций. URL-адрес, используемый для загрузки изображения из CDN, не только указывает на конкретное изображение, но и содержит такие параметры, как размер, формат и качество. Таким образом можно с легкостью создавать варианты изображений для различных сценариев использования.

<figure>{% Img src="image/admin/OIF2VcXp8P6O7tQvw53B.jpg", alt="Обмен запросами и ответами между клиентом и CDN для изображений. При помощи параметров, таких как размер и формат, можно запрашивать разные варианты одного изображения.", width="800", height="408" %} <figcaption> Примеры преобразований, которые могут выполнять CDN для изображений в соответствии с параметрами, указанными в URL-адресе. </figcaption></figure>

От скриптов, оптимизирующих изображения на этапе сборки, CDN для изображений отличаются тем, что генерируют новые версии изображений по мере необходимости. Поэтому CDN лучше, чем скрипты сборки, подходят для создания изображений с высоким уровнем персонализации для каждого отдельного клиента.

## Указание параметров оптимизации в URL-адресах, используемых при обращении к CDN для изображений

В URL-адресах, используемых сетями CDN для изображений, указывается важная информация об изображении, а также о преобразованиях и оптимизациях, которые требуется выполнить. Формат URL-адресов зависит от конкретной сети CDN, но общие принципы у них схожие. Давайте рассмотрим некоторые из наиболее распространенных функций.

<figure>{% Img src="image/admin/GA4udXeYUEjHSY4N0Qew.jpg", alt="URL-адреса изображений обычно содержат следующие компоненты: источник, изображение, ключ безопасности и список преобразований.", width="800", height="127" %}</figure>

### Источник

CDN для изображений может размещаться как на вашем собственном домене, так и на домене самой сети. Сторонние CDN для изображений обычно предоставляют платную возможность использовать собственный домен. Использование собственного домена упрощает возможный переход на другую сеть CDN для изображений, поскольку URL-адреса при этом останутся без изменений.

В примере выше используется не собственный домен сайта, а домен, принадлежащий CDN («example-cdn.com»), с персонализированным поддоменом.

### Изображение

CDN для изображений, как правило, поддерживают автоматическую загрузку необходимых изображений из исходного местоположения. Для этого в URL-адресе изображения, генерируемого CDN, обычно указывается полная ссылка на *исходное изображение*. Например, URL-адрес может выглядеть следующим образом: `https://my-site.example-cdn.com/https://flowers.com/daisy.jpg/quality=auto`. При открытии этого URL-адреса будет загружено и оптимизировано изображение по адресу `https://flowers.com/daisy.jpg`.

Еще один распространенный способ загрузки изображений в CDN — это их отправка в API CDN при помощи HTTP-запроса POST.

### Ключ безопасности

Ключ безопасности нужен для того, чтобы посторонние люди не могли генерировать новые версии ваших изображений. Если эта функция включена, для каждой новой версии изображения потребуется уникальный ключ. Пользователь, изменивший параметры URL-адреса изображения, но не указавший действительный ключ безопасности, не сможет сгенерировать новую версию. За генерацию и отслеживание ключей безопасности отвечает сама сеть CDN для изображений.

### Преобразования

CDN для изображений предоставляют десятки, а иногда и сотни операций преобразования изображений. Список операций указывается в строке URL-адреса, и указать их можно неограниченное количество. В контексте оптимизации веб-страниц наиболее важные операции — это изменение размера, плотности пикселей, формата и степени сжатия. Именно за счет этих операций переход на CDN позволяет существенно сократить размер изображений.

Как правило, существует некий оптимальный набор параметров оптимизации, поэтому некоторые CDN могут выполнять такие преобразования в «автоматическом» режиме. Например, вместо того чтобы явно указывать формат WebP, можно позволить CDN автоматически выбирать оптимальный формат для выдачи. При выборе оптимальных параметров оптимизации CDN может руководствоваться данными из следующих источников:

- [подсказки клиента](https://developer.chrome.com/blog/automating-resource-selection-with-client-hints/) (такие, как ширина области просмотра, DPR и ширина изображения);
- заголовок [`Save-Data`](https://developer.mozilla.org/docs/Web/HTTP/Headers/Save-Data);
- заголовок запроса [User-Agent](https://developer.mozilla.org/docs/Web/HTTP/Headers/User-Agent);
- [Network Information API](https://developer.mozilla.org/docs/Web/API/Network_Information_API).

К примеру, пользователям Edge изображения могут выдаваться в формате JPEG XR, пользователям Chrome — в WebP, а пользователям устаревших браузеров — в JPEG.  Автоматическая настройка популярна, так как позволяет использовать при оптимизации изображений все многочисленные наработки, накопленные сетью CDN, и при этом не требует обновлять код, когда сеть запускает поддержку новых технологий.

## Типы CDN для изображений

CDN для изображений можно разделить на две категории: самостоятельно размещаемые и сторонние.

### Самостоятельно размещаемые CDN для изображений

Самостоятельно размещаемые CDN могут быть хорошим решением для сайтов с техническим персоналом, который в состоянии поддерживать собственную инфраструктуру.

На сегодняшний день единственное решение, позволяющее самостоятельно разместить CDN для изображений, — это [Thumbor](https://github.com/thumbor/thumbor). Thumbor бесплатен и имеет открытый исходный код, но в целом менее функционален, чем большинство коммерческих CDN, а его документация местами неполная. В число сайтов, использующих Thumbor, входят [Wikipedia](https://wikitech.wikimedia.org/wiki/Thumbor), [Square](https://medium.com/square-corner-blog/dynamic-images-with-thumbor-a430a1cfcd87) и [99designs](https://99designs.com/tech-blog/blog/2013/07/01/thumbnailing-with-thumbor/). Инструкции по его настройке см. в статье [Как установить CDN для изображений Thumbor](/install-thumbor).

### Сторонние CDN для изображений

Сторонние CDN для изображений предоставляют функции CDN в качестве услуги. Подобно облачным провайдерам, предоставляющим за абонентскую плату серверы и другую инфраструктуру, CDN для изображений предоставляют услуги оптимизации и доставки изображений. Поскольку за реализацию технических аспектов отвечает сама сеть CDN, начало работы является несложным и занимает 10–15 минут, хотя полный перенос крупного сайта может занять гораздо дольше. Сторонние CDN для изображений, как правило, предлагают тарифы, рассчитанные на различные уровни нагрузки, а у большинства также доступен бесплатный тариф или пробный период, который позволит вам ознакомиться с продуктом.

## Выбор CDN для изображений

Существует множество хороших реализаций CDN для изображений. Некоторые из них более функциональны, но любая из них поможет вам сократить размер изображений в байтах и тем самым ускорить загрузку страниц. Помимо функциональности, при выборе CDN для изображений следует учитывать стоимость, качество поддержки и документации, а также простоту настройки или перенесения сайта.

Кроме того, прежде чем сделать выбор, вы можете попробовать различные решения в работе. Ниже приведены ссылки на проекты Codelabs с инструкциями по быстрой настройке различных CDN для изображений.
