---
layout: codelab
title: Предварительно загружайте веб-шрифты для повышения скорости загрузки
authors:
  - gmimani
description: В этом codelab вы узнаете, как повысить производительность страницы путем предварительной загрузки веб-шрифтов.
date: 2018-04-23
glitch: web-dev-preload-webfont?path=index.html
related_post: preload-critical-assets
tags:
  - performance
---

{% include 'content/devtools-headsup.njk' %}

Этот codelab демонстрирует, как предварительно загрузить веб-шрифты с помощью `rel="preload"`, чтобы удалить любые мигания нестилизованного текста (FOUT).

## Измерение

Прежде чем добавлять какие-либо оптимизации, сначала измерьте, как работает веб-сайт. {% Instruction 'preview', 'ol' %} {% Instruction 'audit-performance', 'ol' %}

В сгенерированном отчете Lighthouse последовательность выборки ресурсов показана в разделе **Maximum critical path latency (Максимальная задержка критического пути)**.

{% Img src="image/admin/eperh8ZUnjhsDlnJdNIG.png", alt="Веб-шрифты присутствуют в цепочке критических запросов.", width="704", height="198" %}

В приведенной выше проверке веб-шрифты являются частью цепочки критических запросов и загружаются последними. [**Цепочка критических запросов**](https://developer.chrome.com/docs/lighthouse/performance/critical-request-chains/) представляет собой порядок выборки ресурсов браузером. В данном приложении веб-шрифты (Pacfico и Pacifico-Bold) определены с помощью правила [@font-face](https://developers.google.com/web/fundamentals/performance/optimizing-content-efficiency/webfont-optimization#defining_a_font_family_with_font-face) и являются последним ресурсом, получаемым браузером в цепочке критических запросов. Обычно веб-шрифты загружаются в отложенном режиме, а это означает, что они не загрузятся, пока не будут загружены критические ресурсы (CSS, JS).

Вот последовательность ресурсов, загружаемых в приложении:

{% Img src="image/admin/9oBNjZORrBj6X8RVlr9t.png", alt="Веб-шрифты загружаются в отложенном режиме.", width="583", height="256" %}.

## Предварительная загрузка веб-шрифтов

Чтобы избежать FOUT, можно предварительно загрузить необходимые веб-шрифты. Добавьте элемент `Link` для этого приложения в начало документа:

```html
<head>
 <!-- ... -->
 <link rel="preload" href="/assets/Pacifico-Bold.woff2" as="font" type="font/woff2" crossorigin>
</head>
```

Атрибуты `as="font" type="font/woff2"` сообщают браузеру, что нужно загрузить этот ресурс как шрифт, и помогают в определении приоритета очереди ресурсов.

Атрибут `crossorigin` указывает, должен ли ресурс быть получен с помощью CORS-запроса, поскольку шрифт может быть из другого домена. Без этого атрибута предварительно загруженный шрифт будет игнорироваться браузером.

Поскольку в заголовке страницы используется шрифт Pacifico-Bold, мы добавили тег предварительной загрузки, чтобы получить его еще быстрее. Предварительная загрузка шрифта Pacifico.woff2 не важна, поскольку он стилизует текст, расположенный ниже области просмотра.

Перезагрузите приложение и снова запустите Lighthouse. Проверьте раздел **Maximum critical path latency (Максимальная задержка критического пути)**.

{% Img src="image/admin/lC85s7XSc8zEXgtwLsFu.png", alt="Веб-шрифт Pacifico-Bold предварительно загружен и удален из цепочки критических запросов", width="645", height="166" %}

Обратите внимание, как `Pacifico-Bold.woff2` удаляется из цепочки критических запросов. Он загружается ранее в приложении.

{% Img src="image/admin/BrXidcKZfCbbUbkcSwas.png", alt="Веб-шрифт Pacifico-Bold предварительно загружен", width="553", height="254" %}

При предварительной загрузке браузер знает, что ему нужно загрузить этот файл раньше. Важно отметить, что при неправильном использовании предварительная загрузка может нанести вред производительности, делая ненужные запросы к ресурсам, которые не используются.
