---
layout: post
title: Как избежать скрытия текста во время загрузки шрифта
authors:
  - katiehempenius
description: |2-

  Часто шрифты — это большие файлы, на загрузку которых требуется время. Поэтому некоторые

  браузеры скрывают текст, пока шрифт не загрузится (что вызывает так называемое «внезапное появление текста»). Если

  вы стремитесь повысить эффективность работы сайта, этого внезапного появления

  текста следует избегать — лучше сразу показывать содержимое страницы с использованием системного шрифта.
date: 2018-11-05
codelabs:
  - codelab-avoid-invisible-text
tags:
  - performance
feedback:
  - api
---

## Суть проблемы

Часто шрифты — это большие файлы, на загрузку которых требуется время. Поэтому некоторые браузеры скрывают текст, пока шрифт не загрузится (что вызывает так называемое «внезапное появление текста»). Если вы стремитесь повысить эффективность работы сайта, этого внезапного появления текста следует избегать — лучше сразу показывать содержимое страницы с использованием системного шрифта (что приведет к «кратковременному показу текста без стилей»).

## Мгновенный показ текста

В этом руководстве описаны два способа мгновенного показа текста. Первый — очень простой, но [поддерживается](https://caniuse.com/#search=font-display) не всеми браузерами. Второй — более сложный, но зато поддерживается всеми браузерами. Выбирайте тот, который вы реализуете и будете поддерживать.

## Вариант № 1: использовать «font-display»

<div class="table-wrapper scrollbar">
  <table>
    <thead>
      <tr>
        <th>Было</th>
        <th>Стало</th>
      </tr>
    </thead>
    <tbody>
      <tr>
        <td>
<code>@font-face {
  font-family: Helvetica;
}
</code>
        </td>
        <td>
<code>@font-face {
  font-family: Helvetica;
  &lt;strong&gt;font-display: swap;&lt;/strong&gt;
}
</code>
        </td>
      </tr>
    </tbody>
  </table>
</div>

API [`font-display`](https://developer.mozilla.org/docs/Web/CSS/@font-face/font-display) позволяет указать стратегию отображения шрифтов. Ключевое слово `swap` сообщает браузеру, что текст, использующий этот шрифт, должен выводиться сразу — системным шрифтом. Как только нестандартный шрифт будет загружен, он заменит системный.

Если браузер не поддерживает `font-display`, он следует поведению по умолчанию для загрузки шрифтов. Посмотреть, какие браузеры поддерживают `font-display`, можно [здесь](https://caniuse.com/#search=font-display).

Поведение по умолчанию при загрузке шрифтов для популярных браузеров:

<div class="table-wrapper scrollbar">
  <table>
    <thead>
      <tr>
        <th><strong>Браузер</strong></th>
        <th><strong>Поведение по умолчанию, если шрифт не готов…</strong></th>
      </tr>
    </thead>
    <tbody>
      <tr>
        <td>Edge</td>
        <td>Пока нужный шрифт не готов, используется системный шрифт. Затем шрифт заменяется.</td>
      </tr>
      <tr>
        <td>Chrome</td>
        <td>           Скрывает текст максимум на три секунды. Если по истечении этого времени шрифт не готов, используется           системный шрифт, пока нужный шрифт не загрузится. Затем шрифт заменяется.</td>
      </tr>
      <tr>
        <td>Firefox</td>
        <td>           Скрывает текст максимум на три секунды. Если по истечении этого времени шрифт не готов, используется           системный шрифт, пока нужный шрифт не загрузится. Затем шрифт заменяется.</td>
      </tr>
      <tr>
        <td>Safari</td>
        <td>Скрывает текст, пока шрифт не будет готов.</td>
      </tr>
    </tbody>
  </table>
</div>

## Вариант № 2: не использовать нестандартные шрифты, пока они не загрузятся

Приложив немного больше усилий, можно реализовать единообразное поведение во всех браузерах.

Реализацию этого подхода можно разделить на три этапа:

- Не использовать нестандартный шрифт при начальной загрузке страницы. В этом случае браузер сразу выводит текст системным шрифтом.
- Определить завершение загрузки нестандартного шрифта. Это можно сделать парой строк кода на JavaScript — благодаря библиотеке [FontFaceObserver](https://github.com/bramstein/fontfaceobserver).
- Обновить стиль страницы с использованием нестандартного шрифта.

Чтобы реализовать такое поведение, понадобится кое-что подправить:

- Изменить CSS-код так, чтобы при начальной загрузке страницы нестандартный шрифт не использовался.
- Добавить на страницу скрипт, который определяет завершение загрузки нестандартного шрифта, а затем обновляет стиль страницы.

{% Aside 'codelab' %} [Использование Font Face Observer для мгновенного показа текста](/codelab-avoid-invisible-text). {% endAside %}

## Проверка

Запустите Lighthouse, чтобы проверить, использует ли сайт `font-display: swap` для отображения текста:

{% Instruction 'audit-performance', 'ol' %}

Сайт должен проходить аудит **Показ текста во время загрузки веб-шрифтов** (Ensure text remains visible during webfont load).
