---
title: Интеграция с пользовательским интерфейсом обмена ресурсами ОС с помощью Web Share API
subhead: Веб-приложения могут использовать те же системные возможности обмена ресурсами, что и нативные приложения.
authors:
  - joemedley
date: 2019-11-08
updated: 2021-07-09
hero: image/admin/ruvEms3AeSZvlEI01DKo.png
alt: Иллюстрация, демонстрирующая, что веб-приложения могут использовать системный пользовательский интерфейс для обмена контентом.
description: С помощью Web Share API веб-приложения могут использовать те же системные возможности обмена ресурсами, что и нативные приложения. Web Share API позволяет веб-приложениям обмениваться ссылками, текстом и файлами с другими приложениями, установленными на устройстве, так же, как это делают нативные приложения.
tags:
  - blog
  - capabilities
feedback:
  - api
stack_overflow_tag: web-share
---

С помощью Web Share API веб-приложения могут использовать те же системные возможности обмена ресурсами, что и нативные приложения. Web Share API позволяет веб-приложениям обмениваться ссылками, текстом и файлами с другими приложениями, установленными на устройстве, так же, как это делают нативные приложения.

{% Aside %} Возможность делиться ресурсами — лишь половина чуда. Когда вы чем-то делитесь, можно сделать веб-приложение целью, то есть направить ему данные, ссылки, текст и файлы из нативных или других веб-приложений. Подробную информацию о том, как зарегистрировать свое приложение в качестве цели для обмена ресурсами см. в публикации «[Получение общих данных](/web-share-target/)». {% endAside %}

## Общее представление и использование

<figure data-float="right">{% Img src="image/admin/cCXNoHbXAfkAQzTTuS0Z.png", alt="Средство выбора целевого ресурса на уровне системы с установленным PWA в качестве опции.", width="370", height="349" %} <figcaption> Средство выбора целевого ресурса на уровне системы с установленным PWA в качестве опции. </figcaption></figure>

### Возможности и ограничения

Web Share API имеет следующие возможности и ограничения:

- Его можно использовать только на сайте, [доступ к которому осуществляется через HTTPS](https://www.chromium.org/Home/chromium-security/prefer-secure-origins-for-powerful-new-features).
- Он должен вызываться в ответ на действие пользователя, например, клик. Вызвать его через обработчик `onload` невозможно.
- С его помощью можно делиться URL-адресами, текстом или файлами.
- С января 2021 года он доступен в Safari, Android в форках Chromium, ChromeOS и Chrome для Windows. Chrome для MacOS все еще находится в разработке. См. подробности в [MDN](https://developer.mozilla.org/docs/Web/API/Navigator/share#Browser_compatibility).

### Обмен ссылками и текстом

Чтобы поделиться ссылками и текстом, используйте метод `share()` на основе обещаний с обязательным объектом свойств. Чтобы браузер не генерировал `TypeError`, объект должен содержать хотя бы одно из следующих свойств: `title`, `text`, `url` или `files`. К примеру, можно поделиться текстом без URL-адреса или наоборот. Разрешение всех трех членов расширяет гибкость вариантов использования. Допустим, после выполнения приведенного ниже кода пользователь выбрал приложение электронной почты в качестве цели. Параметр `title` может стать темой письма, `text` — телом сообщения, а файлы — вложениями.

```js
if (navigator.share) {
  navigator.share({
    title: 'web.dev',
    text: 'Откройте для себя web.dev.',
    url: 'https://web.dev/',
  })
    .then(() => console.log('Удалось поделиться'))
    .catch((error) => console.log('Не удалось поделиться', error));
}
```

Если на вашем сайте несколько URL-адресов для одного и того же контента, поделитесь каноническим URL-адресом страницы вместо текущего URL-адреса. Вместо того, чтобы делиться `document.location.href`, вам нужно найти тег `<meta>` канонического URL-адреса в `<head>` страницы и поделиться им. Так вы улучшите взаимодействие с пользователем. Этот подход не только предотвращает перенаправления, но также гарантирует, что по URL-адресу, которым вы поделились, пользователю будет показан корректный интерфейс для конкретного клиента. Например, если друг поделился мобильным URL-адресом, а вы просматриваете его на настольном компьютере, вы должны увидеть версию для настольного компьютера:

```js
let url = document.location.href;
const canonicalElement = document.querySelector('link[rel=canonical]');
if (canonicalElement !== null) {
    url = canonicalElement.href;
}
navigator.share({url});
```

### Обмен файлами

Чтобы поделиться файлами, сначала проверьте и вызовите `navigator.canShare()`. Затем включите массив файлов в вызов `navigator.share()`:

```js/0-5
if (navigator.canShare && navigator.canShare({ files: filesArray })) {
  navigator.share({
    files: filesArray,
    title: 'Фотографии из отпуска',
    text: 'Фото с 27 сентября по 14 октября.',
  })
  .then(() => console.log('Удалось поделиться.'))
  .catch((error) => console.log('Не удалось поделиться', error));
} else {
  console.log(`Ваша система не поддерживает обмен файлами.`);
}
```

Обратите внимание, что в этом примере обнаружение функций реализуется путем проверки `navigator.canShare()`, а не `navigator.share()`. Объект данных, передаваемый в `canShare()`, поддерживает только свойство `files`. Можно делиться изображениями, видео, аудио и текстовыми файлами. (См. [разрешенные расширения файлов в Chromium](https://docs.google.com/document/d/1tKPkHA5nnJtmh2TgqWmGSREUzXgMUFDL6yMdVZHqUsg/edit?usp=sharing).) В будущем могут быть добавлены другие типы файлов.

## Пример использования Santa Tracker

<figure data-float="right">{% Img src="image/admin/2I5iOXaOpzEJlEbM694n.png", alt="Приложение Santa Tracker показывает кнопку «Поделиться».", width="343", height="600" %} <figcaption> Кнопка «Поделиться» в Santa Tracker. </figcaption></figure>

Проект с открытым исходным кодом [Santa Tracker](https://santatracker.google.com/) стал в Google праздничной традицией. Вы можете отмечать каждый декабрь, принимая участие в играх и образовательных мероприятиях.

В 2016 году команда Santa Tracker использовала Web Share API на Android. Этот API идеально подходил для мобильных устройств. Ранее разработчики удалили кнопки «Поделиться» на мобильных устройствах, потому что не смогли вместить несколько целей для обмена данными в ограниченное пространство.

Однако с помощью Web Share API они смогли представить одну кнопку, сэкономив драгоценные пиксели. Они также обнаружили, что с задействованным Web Share API пользователи делятся ресурсами примерно на 20% чаще, чем без включенного API. Перейдите в [Santa Tracker](https://santatracker.google.com/) и посмотрите, как работает Web Share.

## Поддержка браузера

Поддержка браузером Web Share API имеет нюансы, и рекомендуется использовать обнаружение функций (как описано в предыдущих примерах кода) вместо того, чтобы предполагать, что поддерживается конкретный метод.

По состоянию на начало 2021 года использование API для обмена заголовком, текстом и URL-адресом поддерживается в:

- Safari 12 или новее в macOS и iOS.
- Chrome 75 или новее для Android и 89 или новее в ChromeOS и Windows.

Использование API для обмена файлами поддерживается в:

- Safari 15 или новее в macOS и iOS.
- Chrome 75 или новее для Android и 89 или новее в ChromeOS и Windows.

(Большинство браузеров на основе Chromium, например Edge, имеют ту же поддержку этой функции, что и соответствующая версия Chrome.)

### Поддержите API

Собираетесь использовать Web Share API? Ваша публичная поддержка помогает команде Chrome расставлять функции в порядке приоритетности и показывает другим поставщикам браузеров, насколько важно их поддерживать.

Отправьте твит на [@ChromiumDev](https://twitter.com/ChromiumDev), используя хэштег [`#WebShare`](https://twitter.com/search?q=%23WebShare&src=recent_search_click&f=live), и сообщите нам, где и как вы его используете.

## Полезные ссылки

- [Демонстрации Web Share](https://w3c.github.io/web-share/demos/share-files.html)
- [Библиотека заготовок PWA](https://github.com/GoogleChrome/samples/blob/gh-pages/web-share/README.md#web-share-demo)
