---
title: Инструменты для измерения Core Web Vitals
subhead: Теперь ваши любимые средства разработчика могут измерять показатели Core Web Vitals.
authors:
  - addyosmani
  - egsweeny
date: 2020-05-28
description: Прочтите о недавно объявленной поддержке измерения Core Web Vitals в популярных инструментах веб-разработчиков, таких как Lighthouse, PageSpeed Insights, Chrome UX Report и многих других.
hero: image/admin/wNtXgv1OE2OETdiSzi8l.png
thumbnail: image/admin/KxBRBQe5CRZpCxNYyW2H.png
alt: Логотип Chrome User Experience, логотип PageSpeed Insights, логотип Lighthouse, логотип Search Console, логотип Chrome DevTools, логотип расширения Web Vitals.
tags:
  - blog
  - web-vitals
  - performance
---

Недавно объявленная инициатива [Web Vitals](/vitals/) предоставляет единое руководство по сигналам качества, которые необходимы всем сайтам для обеспечения удобного взаимодействия с пользователем в Интернете. Мы рады сообщить, что **все популярные инструменты Google для веб-разработчиков теперь поддерживают измерение Core Web Vitals**, помогая вам более легко диагностировать и устранять проблемы взаимодействия с пользователем. Сюда входят [Lighthouse](https://github.com/GoogleChrome/lighthouse), [PageSpeed Insights](https://pagespeed.web.dev/), [Chrome DevTools](https://developer.chrome.com/docs/devtools/), [Search Console](https://search.google.com/search-console/about), [инструмент измерения web.dev](/measure/), [расширение Web Vitals для Chrome](https://chrome.google.com/webstore/detail/web-vitals/ahfhijdlegdabablpippeagghigmibma) и новый (!)[Chrome UX Report](https://developer.chrome.com/docs/crux/) API.

Поскольку поисковая система Google теперь оценивает [удобство взаимодействия со страницами](https://webmasters.googleblog.com/2020/05/evaluating-page-experience.html) на основании Core Web Vitals, важно, чтобы эти метрики были максимально доступными и действенными.

<figure>{% Img src="image/admin/V00vjrHmwzljYo04f3d3.png", alt="Обзор Chrome и инструментов поиска, поддерживающих показатели Core Web Vitals", width="800", height="509" %}</figure>

{% Aside 'key-term' %} **Инструменты для измерения в лабораторных условиях** позволяют понять, как *потенциальный пользователь* будет воспринимать ваш веб-сайт, и предлагают воспроизводимые результаты для отладки. **Инструменты для измерения в полевых условиях** позволяют понять, как *реальные пользователи* воспринимают ваш сайт; этот тип измерения часто называют мониторингом реальных пользователей (RUM). Каждый [лабораторный или полевой инструмент](/how-to-measure-speed/#lab-data-vs-field-data) может быть полезен для оптимизации вашего взаимодействия с пользователем. {% endAside %}

Чтобы начать свой путь к оптимизации взаимодействия с пользователем с помощью Core Web Vitals, попробуйте следующий рабочий процесс:

- Используйте новый отчет Core Web Vitals report в Search Console, чтобы определить группы страниц, требующие внимания (на основе полевых данных).
- После того как вы определили страницы, которые нуждаются в доработке, используйте PageSpeed Insights (на основе Lighthouse и Chrome UX Report) для диагностики лабораторных и полевых проблем на странице. PageSpeed Insights (PSI) доступен через Search Console, или вы можете ввести URL-адрес напрямую в PSI.
- Готовы оптимизировать свой сайт локально в лабораторных условиях? Используйте Lighthouse и Chrome DevTools, чтобы измерить Core Web Vitals и получить действенные рекомендации о том, что именно нужно исправить. Расширение Web Vitals для Chrome позволяет просматривать показатели на рабочем столе в режиме реального времени.
- Нужна настраиваемая панель управления Core Web Vitals? Используйте обновленную панель инструментов CrUX или новый Chrome UX Report API для полевых данных и PageSpeed Insights API для лабораторных данных.
- Ищете руководство? web.dev/measure может измерить вашу страницу и показать вам приоритетный набор руководств и кодовых таблиц для оптимизации, используя данные PSI.
- Наконец, перед развертыванием изменений в рабочей среде используйте Lighthouse CI для запросов на включение внесённых изменений, чтобы убедиться в отсутствии регрессий в Core Web Vitals.

После этого введения давайте более подробно рассмотрим конкретные обновления для каждого инструмента!

### Lighthouse

Lighthouseэто автоматизированный инструмент аудита веб-сайтов, который помогает разработчикам диагностировать проблемы и определять возможности для улучшения взаимодействия с пользователями сайтов. Lighthouse измеряет несколько параметров качества взаимодействия с пользователем в лабораторной среде, включая производительность и доступность. Последняя версия Lighthouse ([6.0](/lighthouse-whats-new-6.0/), выпущена в середине мая 2020 г.) включает дополнительные проверки, новые показатели и недавно составленную оценку производительности.

<figure>{% Img src="image/admin/4j72CWywp2D88Xti8zBf.png", alt="Lighthouse 6.0 с актуальными показателями Core Web Vitals", width="800", height="527" %}</figure>

В отчет Lighthouse 6.0 добавлены три новых метрики. Две из нихэто [LCP](/lcp/) (Скорость загрузки основного контента) и [CLS](/cls/) (Совокупное смещение макета), которые представляют собой лабораторные реализации Core Web Vitals и предоставляют важную диагностическую информацию для оптимизации взаимодействия с пользователем, поэтому они включены в отчет и учитываются при расчете оценки производительности.

Третья новая метрика, включенная в Lighthouse,[TBT](/tbt/) (Общее время блокировки)хорошо коррелирует с полевой метрикой [FID](/fid/) (Время ожидания до первого взаимодействия с контентом), также входящей в состав Core Web Vitals. Следуя рекомендациям, представленным в отчете Lighthouse, и оптимизируя свои показатели, вы обеспечите наилучший возможный опыт для своих пользователей.

Обновлены также все связанные Lighthouse продукты, включая [Lighthouse CI,](https://github.com/GoogleChrome/lighthouse-ci) который позволяет легко измерять Core Web Vitals по запросам на включение внесённых изменений до их объединения и развертывания.

<figure>
  {% Img src="image/admin/aOm5ZAIUbspjcyRMIXbn.png", alt="Lighthouse CI, экран представления различий для LCP", width="800", height="498" %}
</figure>

Чтобы узнать больше о последних обновлениях в Lighthouse, ознакомьтесь с нашей публикацией в блоге[«Новые возможности Lighthouse 6.0».](/lighthouse-whats-new-6.0/)

### PageSpeed Insights

[PageSpeed Insights](https://pagespeed.web.dev/) (PSI) сообщает о производительности страницы в лабораторных и полевых условиях для мобильных и настольных устройств. Инструмент предоставляет обзор того, как реальные пользователи воспринимают страницу (на основе отчета Chrome UX), и набор действенных рекомендаций для владельца сайта по улучшению восприятия страницы (предоставлено Lighthouse).

PageSpeed Insights и [PageSpeed Insights API](https://developers.google.com/speed/docs/insights/v5/get-started) также были обновлены для использования Lighthouse 6.0 и теперь поддерживают измерение Core Web Vitals в разделах отчета по лабораторным и полевым измерениям! Показатели Core Web Vitals помечены синим флажком (см. ниже).

<figure>
  {% Img src="image/admin/l1posckVsR7JeVGnk6Jv.png", alt="Экран PageSpeed Insights с лабораторными и полевыми метриками Core Web Vitals", width="800", height="873" %}
</figure>

Тогда как [Search Console](https://search.google.com/search-console/) предоставляет владельцам сайтов отличный обзор для проблемных групп страниц, PSI помогает определить возможности каждой страницы по улучшению взаимодействия. В PSI можно наглядно увидеть, соответствует ли ваша страница пороговым значениям всех Core Web Vitalsв верхней части отчета указано, **прошла страница оценку Core Web Vitals** или **не прошла**.

### CrUX

Отчет [Chrome UX](https://developer.chrome.com/docs/crux/) (CrUX)это общедоступный набор данных о реальном пользовательском восприятии миллионов веб-сайтов. Отчет измеряет полевые метрики Core Web Vitals. В отличие от лабораторных данных, данные CrUX поступают от [зарегистрированных пользователей](https://developer.chrome.com/docs/crux/methodology/#user-eligibility) в полевых условиях. Используя эти данные, разработчики могут понять распределение реального пользовательского опыта на собственных сайтах или даже на сайтах конкурентов. Если у вас нет RUM на сайте, CrUX может предоставить быстрый и простой способ оценить ваши Core Web Vitals. [Набор данных CrUX на BigQuery](https://developer.chrome.com/docs/crux/bigquery/) включает в себя подробные данные о производительности для всех Core Web Vitals и доступен в виде ежемесячных снепшотов на уровне источника.

Единственный способ по-настоящему узнать, как сайт работает для пользователей,это реально измерить его производительность в полевых условиях, когда пользователи загружают сайт и взаимодействуют с ним. Этот тип измерения обычно называется мониторингом реальных пользователей или сокращенно RUM. Даже если у вас нет RUM на сайте, CrUX может предоставить быстрый и простой способ оценить Core Web Vitals.

**Представляем CrUX API**

Сегодня мы рады анонсировать [CrUX API](http://developers.google.com/web/tools/chrome-user-experience-report/api/reference/)быстрый и бесплатный способ легко интегрировать рабочие процессы разработки с измерением качества на уровне источника и URL-адреса для следующих полевых показателей:

- скорость загрузки основного контента (LCP);
- совокупное смещение макета (CLS);
- время ожидания до первого взаимодействия с контентом (FID);
- первая отрисовка контента (FCP).

Разработчики могут делать запрос по источнику или URL-адресу и сегментировать результаты по различным форм-факторам. API обновляется ежедневно и суммирует данные за предыдущие 28 дней (в отличие от набора данных BigQuery, который агрегируется ежемесячно). API имеет те же ослабленные квоты на запросы к общедоступным API, которые мы устанавливаем для другого нашего APIAPI PageSpeed Insights (25 000 запросов в день).

Ниже приведена [демонстрация](https://developer.chrome.com/blog/chrome-ux-report-api/) использования CrUX API для визуализации показателей Core Web Vitals с распределением по **«хорошо»**, **«требует улучшения»** и **«плохо»**:

<figure>{% Img src="image/admin/ye3CMKfacSItYA2lqItP.png", alt="Демонстрация Chrome User Experience Report API с метриками Core Web Vitals", width="800", height="523" %}</figure>

В будущих выпусках мы планируем расширить API, чтобы обеспечить доступ к дополнительным параметрам и показателям набора данных CrUX.

**Обновленная панель управления CrUX**

Обновленная [панель CrUX Dashboard](http://g.co/chromeuxdash) позволяет легко отслеживать производительность источника с течением времени, и теперь можно использовать панель для мониторинга распределения всех показателей Core Web Vitals. Чтобы начать работу с панелью, ознакомьтесь с нашим [руководством](https://developer.chrome.com/blog/chrome-ux-report-looker-studio-dashboard/) на web.dev.

<figure>{% Img src="image/admin/OjbICyhI21RNfGXrFP1x.png", alt="Панель инструментов отчета Chrome UX Report с метриками Core Web Vitals на новой целевой странице", width="800", height="497" %}</figure>

Мы сделали новую целевую страницу Core Web Vitals, чтобы можно было с первого взгляда увидеть, как работает ваш сайт. Мы будем рады отзывам обо всех инструментах CrUX; чтобы поделиться своими мыслями и вопросами, напишите нам в Твиттере [@ChromeUXReport](https://twitter.com/chromeuxreport) или в [Google Group](https://groups.google.com/a/chromium.org/g/chrome-ux-report).

### Панель производительности Chrome DevTools

**События Debug Layout Shift в разделе Experience**

На панели **Performance** в Chrome DevTools появился новый раздел **[Experience](https://developers.google.com/web/updates/2020/05/devtools#cls)**, с помощью которого можно обнаруживать неожиданные смещения макета. Это полезно для поиска и устранения проблем визуальной нестабильности на вашей странице, которые учитываются в метрике CLS (Совокупное смещение макета).

<figure>{% Img src="image/admin/VMbZAgKCi5V6FiQyu631.png", alt="Совокупное смещение макета отображается в виде красных записей на панели производительности", width="800", height="517" %}</figure>

Выберите Layout Shift, чтобы просмотреть сведения о смещении макета на вкладке **Summary**. Чтобы визуализировать, где произошло смещение, наведите указатель мыши на поля **Moved from** и **Moved to**.

**Готовность к отладке взаимодействия с TBT в нижнем колонтитуле**

Показатель TBT (Общее время блокировки) можно измерить с помощью лабораторных инструментов, это отличный косвенный показатель для FID (Времени ожидания до первого взаимодействия с контентом). TBT измеряет общее количество времени между [FCP (Первой отрисовкой контента)](/fcp/) и [TTI (Временем до интерактивности)](/tti/), когда основной поток был заблокирован на достаточно долгое время, чтобы предотвратить реакцию на ввод. Оптимизация производительности, улучшающая TBT в лабораторных условиях, должна улучшить FID в полевых условиях.

<figure>
  {% Img src="image/admin/WufuLpvrZfgbRn70C74V.png", alt="Общее время блокировки, отображаемое в нижнем колонтитуле панели производительности DevTools", width="800", height="517" %}
</figure>

TBT теперь отображается в нижнем колонтитуле панели **Performance** в Chrome DevTools при измерении производительности страницы:

{% Instruction 'devtools-performance', 'ol' %}

1. Щелкните **Record**.
2. Обновите страницу вручную.
3. Дождитесь загрузки страницы, затем остановите запись.

Дополнительные сведения см. в разделе [«Новые возможности DevTools (Chrome 84)»](https://developers.google.com/web/updates/2020/05/devtools#cls).

### Search Console

Новый отчет [Core Web Vitals report](https://support.google.com/webmasters/answer/9205520) в Search Console помогает определить проблемные группы страниц вашего сайта на основании реальных (полевых) данных из CrUX. Производительность URL-адресов сгруппирована по статусу, типу метрики и группе URL-адресов (группы похожих веб-страниц).

<figure>
  {% Img src="image/admin/BjTUt0xdWXD9hrLsbhLK.png", alt="Новый отчет Core Web Vitals Report в Search Console", width="800", height="1000" %}
</figure>

Отчет основан на трех показателях Core Web Vitals: LCP, FID и CLS. Если URL-адрес не содержит минимального количества отчетных данных для этих показателей, он не включается в отчет. Ознакомьтесь с новым отчетом, чтобы получить целостное представление о производительности вашего источника.

Как только вы определите тип страницы, на которой есть проблемы, связанные с Core Web Vitals, можно использовать PageSpeed Insights, чтобы узнать о конкретных предложениях по оптимизации для репрезентативных страниц.

#### web.dev

[web.dev/measure](/measure/) позволяет измерять производительность страницы с течением времени, предоставляя приоритетный список руководств об улучшении. Измерения web.dev основаны на PageSpeed Insights. Инструмент измерения теперь также поддерживает показатели Core Web Vitals, как показано ниже:

<figure>
  {% Img src="image/admin/ryoV1T1PhxUmo9zdCsDe.png", alt="Измеряйте показатели Core Web Vitals с течением времени и получайте приоритетные рекомендации с помощью инструмента измерения web.dev", width="800", height="459" %}
</figure>

### Расширение Web Vitals

Расширение Web Vitals измеряет три показателя Core Web Vitals в режиме реального времени для (настольного) Google Chrome. Это полезно для выявления проблем на ранних этапах рабочего процесса разработки и в качестве диагностического инструмента для оценки производительности Core Web Vitals при просмотре веб-страниц.

Расширение теперь можно установить из [Интернет-магазина Chrome](https://chrome.google.com/webstore/detail/web-vitals/ahfhijdlegdabablpippeagghigmibma?hl=en)! Надеемся, вы сочтете это полезным. Мы приветствуем любой вклад в улучшение расширения, а также отзывы в репозитории проекта на [GitHub](https://github.com/GoogleChrome/web-vitals-extension/).

<figure>{% Img src="image/admin/woROdEmNV4jlHDPryjBQ.png", alt="Core Web Vitals отображаются в режиме реального времени с помощью расширения Web Vitals для Chrome", width="800", height="459" %}</figure>

#### Краткие итоги

Вот и всё! Следующие шаги:

- Используйте **Lighthouse** в DevTools, чтобы оптимизировать взаимодействие с пользователем и убедиться, что у вас отличные показатели Core Web Vitals в полевых условиях.
- Используйте **PageSpeed Insights** для сравнения производительности Core Web Vitals в лабораторных и полевых условиях.
- Попробуйте новый **Chrome User Experience Report API**, чтобы узнать, какие Core Web Vitals были у вашего источника и URL-адрес за последние 28 дней.
- Используйте раздел **Experience** и нижний колонтитул на панели **Performance** в DevTools, чтобы копнуть глубже и отладить определенные показатели Core Web Vitals.
- Используйте **отчет Core Web Vitals report в Search Console**, чтобы получить сводку о том, как ваши источники работают в полевых условиях.
- Используйте **расширение Web Vitals**, чтобы отслеживать производительность страницы по Core Web Vitals в режиме реального времени.

Мы расскажем больше о наших инструментах Core Web Vitals на [web.dev Live](/live/) в июне. Зарегистрируйтесь, чтобы получать новости о мероприятии!

~ Элизабет и Эдди, WebPerf Janitors
