---
title: Как начать измерять Web Vitals
authors:
  - katiehempenius
date: 2020-05-27
updated: 2022-07-18
hero: image/admin/QxMJKZcue9RS5u05XxTE.png
alt: Месячный график с наложением секундомеров с ярлыками LCP, FID и CLS.
description: Узнайте, как измерить Web Vitals вашего сайта в полевых и лабораторных условиях.
tags:
  - blog
  - performance
  - web-vitals
---

Сбор данных по метрикам Web Vitals вашего сайтапервый шаг к их улучшению. Хорошо продуманный анализ позволит собрать данные о производительности как в полевых, так и в лабораторных условиях. Измерение Web Vitals требует минимальных изменений кода и может быть выполнено с помощью бесплатных инструментов.

## Измерение Web Vitals с использованием данных RUM

[Данные мониторинга реальных пользователей](https://en.wikipedia.org/wiki/Real_user_monitoring) (RUM), также известные как полевые данные, фиксируют производительность, с которой сталкиваются реальные пользователи сайта. Данные RUMэто то, что использует Google, чтобы определить, соответствует ли сайт [рекомендуемым пороговым значениям Core Web Vitals](/vitals/).

### С чего начать измерение

Если у вас нет настройки RUM, следующие инструменты быстро предоставят вам данные о реальной производительности вашего сайта. Все эти инструменты основаны на одном и том же базовом наборе данных ([Chrome User Experience Report (Отчет об удобстве пользования браузером Chrome)](https://developer.chrome.com/docs/crux/)), но имеют несколько разные варианты использования:

- **PageSpeed Insights (PSI)**: [PageSpeed Insights](https://pagespeed.web.dev/) сообщает о сводной производительности на уровне страницы и на уровне источника за последние 28 дней. Кроме того, он содержит предложения по улучшению производительности. Если вы ищете с чего начать измерение и оптимизацию Web Vitals вашего сайта, мы рекомендуем использовать PSI. PSI доступен в виде [веб-инструмента](https://pagespeed.web.dev/) и [API](https://developers.google.com/speed/docs/insights/v5/get-started).
- **Search Console**: [Search Console](https://search.google.com/search-console/welcome) предоставляет данные о производительности каждой страницы. Это позволяет выявить конкретные страницы, нуждающиеся в улучшении. В отличие от PageSpeed Insights, отчеты Search Console включают исторические данные о производительности. Search Console можно использовать для сайта, только если вы его владелец с подтверждённым правом собственности.
- **Панель управления CrUX**: [панель управления CrUX](https://developers.google.com/web/updates/2018/08/chrome-ux-report-dashboard)это предварительно созданная панель управления, на которой отображаются данные CrUX для источника по вашему выбору. Она построен на основе Data Studio, процесс установки занимает около минуты. По сравнению с PageSpeed Insights и Search Console, отчеты панели управления CrUX включают больше параметровнапример, данные можно разбить по типу устройства и соединения.

Стоит отметить, что перечисленные выше инструменты хорошо подходят не только для «начала» измерения Web Vitals, они могут быть полезны и в других контекстах. В частности, и CrUX, и PSI доступны как API и могут использоваться для [создания информационных панелей](https://dev.to/chromiumdev/a-step-by-step-guide-to-monitoring-the-competition-with-the-chrome-ux-report-4k1o) и других отчетов.

### Сбор данных RUM

Хотя инструменты на основе CrUX являются хорошей отправной точкой для исследования производительности Web Vitals, мы настоятельно рекомендуем дополнить их вашим собственным RUM. Данные RUM, которые вы собираете сами, могут предоставить более подробную и немедленную обратную связь о производительности вашего сайта. Это упрощает выявление проблем и тестирование возможных решений.

{% Aside %} Источники данных на основе CrUX предоставляют данные с детализацией примерно за один месяц, однако детализация отличается в зависимости от инструмента. Например, PSI и Search Console сообщают о производительности за последние 28 дней, тогда как набор данных и панель управления CrUX разбиты по календарным месяцам. {% endAside %}

Вы можете собирать свои данные RUM, используя специального поставщика RUM или настраивая собственные инструменты.

Поставщики RUM специализируются на сборе и представлении данных RUM. Чтобы использовать Core Web Vitals с этими службами, попросите своего поставщика RUM включить мониторинг Core Web Vitals для вашего сайта.

Если у вас нет поставщика RUM, вы можете расширить существующую настройку аналитики для сбора данных и составления отчетов по этим метрикам с помощью [библиотеки JavaScript `web-vitals`](https://github.com/GoogleChrome/web-vitals). Этот метод более подробно описан ниже.

### Библиотека JavaScript web-vitals

Если вы реализуете собственную настройку RUM для Web Vitals, самый простой способ собрать измерения Web Vitalsиспользовать библиотеку JavaScript [`web-vitals`](https://github.com/GoogleChrome/web-vitals). `web-vitals`это небольшая модульная библиотека (~ 1 КБ), которая предоставляет удобный API для сбора данных и создания отчетов по каждой [измеряемой в полевых условиях](/user-centric-performance-metrics/#in-the-field) метрике Web Vitals.

Некоторые метрики Web Vitals не отображаются напрямую встроенными API-интерфейсами производительности браузера, но их измерение построено на основе этих API. Например, [CLS (Совокупное смещение макета)](/cls/) реализуется с помощью [Layout Instability API](https://wicg.github.io/layout-instability/). При использовании `web-vitals` вам не нужно беспокоиться о самостоятельной реализации измерения этих метрик; библиотека также гарантирует, что собранные вами данные соответствуют методологии и лучшим практикам по измерению каждого показателя.

Для получения дополнительной информации о внедрении `web-vitals` см. [документацию библиотеки](https://github.com/GoogleChrome/web-vitals) и статью [«Лучшие практики для измерения показателей Web Vitals в полевых условиях»](/vitals-field-measurement-best-practices/).

### Агрегация данных

Очень важно, чтобы вы составляли отчеты об измерениях, собранных с помощью библиотеки `web-vitals`. Если эти данные измеряются, но не предоставляются в виде отчета, вы их никогда не увидите. Документация `web-vitals` включает примеры, показывающие, как отправлять данные в [общую конечную точку API](https://github.com/GoogleChrome/web-vitals#send-the-results-to-an-analytics-endpoint), [Google Analytics](https://github.com/GoogleChrome/web-vitals#send-the-results-to-google-analytics) или [Google Tag Manager](https://github.com/GoogleChrome/web-vitals#send-the-results-to-google-tag-manager).

Если у вас уже есть любимый инструмент отчетности, воспользуйтесь им. Если же нет, то Google Analyticsбесплатный инструмент, который можно использовать для этой цели.

При выборе инструмента подумайте о том, кто должен иметь доступ к данным. Как правило, компании добиваются наибольших успехов, когда в повышении производительности заинтересована вся компания, а не только один отдел. См. статью [«Исправление скорости веб-сайта совместными усилиями»](/fixing-website-speed-cross-functionally/), чтобы узнать, как получить поддержку от разных отделов.

### Интерпретация данных

При анализе данных о производительности важно обращать внимание на хвосты распределения. Данные RUM часто показывают, что производительность сильно различаетсяодни пользователи остались довольны взаимодействием с сайтом, а другиенет. Использование медианы для обобщения данных может привести к тому, что существующие проблемы будут скрыты.

Google, чтобы определить, соответствует ли сайт/страница рекомендуемым пороговым значениям Web Vitals, использует процент «хороших» впечатлений, а не медианы или средние значения. В частности, считается, что сайт/страница соответствует пороговым значениям Core Web Vitals, если 75% посещений страниц соответствуют «хорошему» порогу каждой метрики.

## Измерение Web Vitals с использованием лабораторных данных

[Лабораторные данные](/user-centric-performance-metrics/#in-the-lab), также известные как синтетические, получают от контролируемой среды, а не от реальных пользователей. В отличие от данных RUM, лабораторные данные могут собираться и в предпроизводственных средах, поэтому сбор лабораторных данных можно включить в рабочие процессы разработчика и процессы непрерывной интеграции. Примеры инструментов для сбора синтетических данныхLighthouse и WebPageTest.

### Рекомендации

Всегда будут расхождения между данными RUM и лабораторными данными, особенно если условия сети, тип устройства или расположение лабораторной среды значительно отличаются от пользовательских. Однако, когда речь идет о сборе лабораторных данных по показателям Web Vitals, важно обратить внимание на несколько специфических моментов:

- **Совокупное смещение макета (CLS):** [Совокупное смещение макета](/cls/), измеренное в лабораторных условиях, может быть искусственно ниже, чем наблюдаемое в данных RUM. CLS определяется как «сумма всех индивидуальных оценок смещений макета для каждого неожиданного смещения макета, который происходит *в течение всего времени жизни страницы*». Однако продолжительность жизни страницы обычно сильно различается в зависимости от того, загружается ли она реальным пользователем или синтетическим инструментом измерения производительности. Многие лабораторные инструменты только загружают страницуони не взаимодействуют с ней. В результате они фиксируют только те смещения макета, которые происходят во время начальной загрузки страницы. Напротив, CLS, измеряемый инструментами RUM, фиксирует [неожиданные смещения макета](/cls/#expected-vs-unexpected-layout-shifts), которые происходят на протяжении всего времени жизни страницы.
- **Время ожидания до первого взаимодействия с контентом (FID):** [FID](/fid/) невозможно измерить в лабораторных условиях, поскольку для этого требуется взаимодействие пользователя со страницей. В качестве косвенного лабораторного показателя для FID используется [TBT (Общее время блокировки)](/tbt/). TBT измеряет «общее количество времени между первой отрисовкой контента (FCP) и временем до интерактивности (TTI), в течение которого страница блокируется и не реагирует на ввод пользователя». Хотя метрики FID и TBT рассчитываются по-разному, они обе отражают блокировку основного потока во время процесса начальной загрузки. Когда основной поток заблокирован, браузер не отвечает на действия пользователя. FID измеряет задержку (при наличии таковой), которая возникает при первой попытке пользователя взаимодействовать со страницей.

### Инструменты

Эти инструменты можно использовать для сбора лабораторных измерений Web Vitals:

- **Расширение Web Vitals для Chrome:** [Расширение](https://github.com/GoogleChrome/web-vitals-extension) Web Vitals для Chrome измеряет и сообщает Core Web Vitals (LCP, FID и CLS) для данной страницы. Этот инструмент предназначен для предоставления разработчикам отзывов о производительности в режиме реального времени, когда они вносят изменения в код.
- **Lighthouse:** Lighthouse сообщает о LCP, CLS и TBT, а также указывает на возможные улучшения производительности. Lighthouse доступен в Chrome DevTools как расширение Chrome и как пакет npm. Lighthouse также можно включить в рабочие процессы непрерывной интеграции с помощью [Lighthouse CI](https://github.com/GoogleChrome/lighthouse-ci).
- **WebPageTest:** Web Vitals входят в стандартную отчетность [WebPageTest](https://webpagetest.org/). WebPageTest полезен для сбора информации о Web Vitals при использовании различных типов подключений и устройств.
