---
title: Лучшие практики для измерения показателей Web Vitals в полевых условиях
subhead: Как измерить Web Vitals с помощью текущего инструмента аналитики.
authors:
  - philipwalton
description: Как измерить Web Vitals с помощью текущего инструмента аналитики
date: 2020-05-27
updated: 2020-07-21
hero: image/admin/WNrgCVjmp8Gyc8EbZ9Jv.png
alt: Как измерить Web Vitals с помощью текущего инструмента аналитики
tags:
  - blog
  - performance
  - web-vitals
---

Возможность измерять реальную производительность ваших страниц и составлять отчеты по ней имеет решающее значение для диагностики проблем и повышения производительности с течением времени. Без [полевых данных](/user-centric-performance-metrics/#in-the-field) невозможно точно понять, действительно ли изменения, которые вы вносите в свой сайт, приносят желаемые результаты.

Многие популярные поставщики аналитики [мониторинга реальных пользователей (RUM)](https://en.wikipedia.org/wiki/Real_user_monitoring) уже поддерживают метрики [Core Web Vitals](/vitals/#core-web-vitals) в своих инструментах (а также многие [другие метрики Web Vitals](/vitals/#other-web-vitals)). Если вы сейчас используете один из этих инструментов аналитики RUM, то у вас есть возможность оценить, насколько страницы вашего сайта соответствуют [рекомендуемым пороговым значениям Core Web Vitals](/vitals/#core-web-vitals) и предотвратить регрессию в будущем.

Хотя мы и рекомендуем применять инструменты аналитики, поддерживающие показатели Core Web Vitals, если используемый вами инструмент аналитики не поддерживает их, вовсе не обязательно переходить на другой. Почти все аналитические инструменты предлагают способ определения и измерения [пользовательских метрик](https://support.google.com/analytics/answer/2709828) или [событий](https://support.google.com/analytics/answer/1033068), а это значит, что вы можете использовать своего текущего поставщика аналитики, чтобы измерять метрики Core Web Vitals и добавлять их в существующие аналитические отчеты и панели управления.

В этой статье обсуждаются лучшие практики измерения метрик Core Web Vitals (или любых пользовательских метрик) с помощью сторонних или собственных аналитических инструментов. Статья также может служить руководством для поставщиков аналитики, желающих добавить поддержку Core Web Vitals в свой сервис.

## Применяйте пользовательские метрики или события

Как упоминалось выше, большинство инструментов аналитики позволяют измерять пользовательские данные. Если ваш аналитический инструмент поддерживает такую возможность, вы сможете измерить каждую из метрик Core Web Vitals с помощью этого механизма.

Измерение пользовательских метрик или событий в инструменте аналитики обычно состоит из трех этапов:

1. [Определите или зарегистрируйте](https://support.google.com/analytics/answer/2709829?hl=en&ref_topic=2709827) пользовательскую метрику в админке вашего инструмента (при необходимости). *(Примечание: не все поставщики аналитики требуют, чтобы пользовательские метрики определялись заранее.)*
2. Вычислите значение метрики в своем внешнем JavaScript-коде.
3. Отправьте значение метрики в серверную аналитику, убедившись, что имя или идентификатор совпадают с тем, что было определено на шаге 1 *(если требуется)*.

Для шагов 1 и 3 вы можете обратиться к документации вашего инструмента аналитики за инструкциями. На шаге 2 для вычисления значения каждой из метрик Core Web Vitals вы можете использовать [JavaScript-библиотеку web-vitals](https://github.com/GoogleChrome/web-vitals).

В следующем примере кода показано, насколько легко можно отслеживать эти метрики в коде и отправлять их в службу аналитики.

```js
import {onCLS, onFID, onLCP} from 'web-vitals';

function sendToAnalytics({name, value, id}) {
  const body = JSON.stringify({name, value, id});
  // Use `navigator.sendBeacon()` if available, falling back to `fetch()`.
  (navigator.sendBeacon && navigator.sendBeacon('/analytics', body)) ||
      fetch('/analytics', {body, method: 'POST', keepalive: true});
}

onCLS(sendToAnalytics);
onFID(sendToAnalytics);
onLCP(sendToAnalytics);
```

## Убедитесь, что вы можете составить отчет о распределении

После того как вы вычислили значения для каждой из метрик Core Web Vitals и отправили их в свою аналитическую службу с помощью пользовательской метрики или события, следующий шагсоздание отчета или панели мониторинга, отображающих собранные значения.

Чтобы убедиться, что ваш сайт/страница соответствует [рекомендованным пороговым значениям Core Web Vitals](/vitals/#core-web-vitals), вам понадобится отчет, в котором значение каждой метрики будет отображаться на 75-м процентиле.

Если ваш инструмент аналитики не предлагает квантильные отчеты в качестве встроенной функции, вы, вероятно, всё равно можете получить эти данные вручную, создав отчет, в котором перечислены все значения метрики, отсортированные в порядке возрастания. После создания этого отчета результат, который составляет 75% от полного отсортированного списка всех значений в этом отчете, и будет 75-м процентилем для этого показателя. Причем не имеет значения, как вы сегментируете свои данные (по типу устройства, типу подключения, стране и т. д.).

Если ваш аналитический инструмент по умолчанию не обеспечивает детализацию отчетов на уровне метрик, но поддерживает [специальные параметры](https://support.google.com/analytics/answer/2709828), то вы, вероятно, сможете добиться нужного результата. Установив уникальное значение специального параметра для каждого отдельного экземпляра отслеживаемой метрики и включив специальные параметры в конфигурацию отчета, вы сможете создать отчет с разбивкой по отдельным экземплярам метрики. Поскольку каждый экземпляр будет иметь уникальное значение параметра, группировка не произойдет.

Отчет [Web Vitals Report](https://github.com/GoogleChromeLabs/web-vitals-report)пример этого метода с использованием Google Analytics. У этого отчета [открытый исходный код](https://github.com/GoogleChromeLabs/web-vitals-report), поэтому разработчики могут ссылаться на него как на пример методов, описанных в этом разделе.

![Скриншоты отчета Web Vitals](https://user-images.githubusercontent.com/326742/101584324-3f9a0900-3992-11eb-8f2d-182f302fb67b.png)

{% Aside %} Совет. Библиотека [`web-vitals`](https://github.com/GoogleChrome/web-vitals) предоставляет идентификатор для каждого зарегистрированного экземпляра метрики, что позволяет создавать дистрибутивы в большинстве аналитических инструментов. См. документацию по интерфейсу [`Metric`](https://github.com/GoogleChrome/web-vitals#metric) для более подробной информации. {% endAside %}

## Отправляйте свои данные в нужное время

Некоторые метрики производительности можно рассчитать после завершения загрузки страницы, в то время как другие (например, CLS) учитывают всё время жизни страницы и окончательно вычисляются только после того, как пользователь покидает страницу.

Однако это может быть проблематично, так как события `beforeunload` и `unload` ненадежны (особенно на мобильных устройствах), и мы [не рекомендуем](https://developer.chrome.com/blog/page-lifecycle-api/#legacy-lifecycle-apis-to-avoid) их использовать (поскольку они могут помешать странице попасть в механизм кеширования страниц [Back-Forward Cache](https://developer.chrome.com/blog/page-lifecycle-api/#what-is-the-back-forward-cache)).

Любые текущие значения метрик, которые отслеживаются на протяжении всего времени жизни страницы, лучше всего отправлять во время `visibilitychange`, когда состояние видимости страницы меняется на `hidden`. Это обусловлено тем,  что после изменения состояния видимости страницы на `hidden`, нет гарантии, что любой сценарий на этой странице сможет снова запуститься. Это особенно актуально для мобильных операционных систем, где само приложение браузера может быть закрыто без использования каких-либо обратных вызовов страницы.

Обратите внимание, что мобильные операционные системы обычно запускают  событие `visibilitychange` при переключении вкладок, переключении приложений, закрытии самого приложения браузера, а также при закрытии вкладки или переходе на новую страницу. Это делает событие `visibilitychange` гораздо более надежным, чем события `unload` или `beforeunload`.

{% Aside 'gotchas' %} Из-за [определённых ошибок браузера](https://github.com/w3c/page-visibility/issues/59#issue-554880545) в некоторых случаях `visibilitychange` не срабатывает. Если вы создаете собственную библиотеку аналитики, важно знать об этих ошибках. Обратите внимание, что в [JavaScript-библиотеке web-vitals](https://github.com/GoogleChrome/web-vitals) все эти ошибки браузеров учтены. {% endAside %}

## Отслеживайте производительность с течением времени

После того как вы обновите свою реализацию аналитики, чтобы отслеживать метрики Core Web Vitals и включать их в отчеты, следующий шаготслеживать, как изменения вашего сайта влияют на производительность в течение длительного периода времени.

### Версия ваших изменений

Наивный (и в конечном итоге ненадежный) подход к отслеживанию изменений заключается в развертывании изменений в производственной среде и последующем предположении, что все метрики, полученные после даты развертывания, соответствуют новому сайту, а все метрики, полученные до даты развертывания, соответствуют старому сайту. Однако любое количество факторов (включая кеширование на уровне HTTP, сервис-воркера или CDN) может помешать этому.

Гораздо лучший подход - создать уникальную версию для каждого развернутого изменения, а затем отслеживать эту версию в вашем инструменте аналитики. Большинство аналитических инструментов поддерживают установку версии. Если ваш инструмент этого не делает, вы можете создать специальный параметр и установить этот параметр на развернутую версию.

### Проведите эксперименты

Вы можете сделать еще один шаг вперед в управлении версиями, отслеживая несколько версий (или экспериментов) одновременно.

Если ваш аналитический инструмент позволяет определять группы экспериментов, используйте эту возможность, если же нетиспользуйте специальные параметры, чтобы связать каждое значение метрики с определенной группой экспериментов в ваших отчетах.

Проведя эксперименты в инструменте аналитики, вы можете развернуть экспериментальное изменение для подгруппы пользователей и сравнить производительность этого изменения с производительностью пользователей в контрольной группе. Как только вы убедитесь, что изменение действительно улучшает производительность, вы можете распространить его на всех пользователей.

{% Aside %} Группы экспериментов всегда должны создаваться на сервере. Избегайте использовать любые инструменты для экспериментов или A/B-тестирование на стороне клиента. Эти инструменты обычно блокируют рендеринг, пока не будет определена экспериментальная группа пользователей, что может негативно сказаться на времени LCP. {% endAside %}

## Убедитесь, что измерения не влияют на производительность

При измерении производительности реальных пользователей очень важно, чтобы используемый для измерения производительности код не оказывал негативного влияния на производительность страницы. Если это происходит, то любые полученные выводы о влиянии производительности на бизнес, будут ненадежными, так как вы не будете знать, оказывает ли негативное влияние присутствие самого кода аналитики.

Всегда следуйте этим принципам при развертывании кода аналитики RUM на рабочем сайте:

### Отложите загрузку своей аналитики

Код аналитики всегда должен загружаться асинхронно и не блокировать основной поток. Как правило, код аналитики загружается в последнюю очередь. Если загрузка кода аналитики блокирует основной поток, это может негативно повлиять на LCP.

Все API-интерфейсы, используемые для измерения показателей Core Web Vitals, были специально разработаны для поддержки асинхронной и отложенной загрузки скриптов (с помощью [`buffered`](https://www.chromestatus.com/feature/5118272741572608)), поэтому нет необходимости загружать скрипты заранее.

Если вы измеряете метрику, которую нельзя вычислить позже на временной шкале загрузки страницы, встройте в `<head>` вашего документа *только* тот код, который должен запускаться на ранней стадии (чтобы это не было [блокирующим рендеринг запросом](https://developer.chrome.com/docs/lighthouse/performance/render-blocking-resources/)), а остальное отложите. Не загружайте всю аналитику заранее только потому, что этого требует одна метрика.

### Не создавайте длительных задач

Код аналитики часто запускается в ответ на ввод пользователя, но если ваш аналитический код проводит много измерений DOM или применяет другие API-интерфейсы, интенсивно использующие процессор, сам аналитический код может стать причиной плохой отзывчивости на ввод. Кроме того, если JavaScript-файл с кодом аналитики имеет большой размер, выполнение этого файла может заблокировать основной поток и отрицательно повлиять на FID.

### Используйте неблокирующие API

API, такие как <code>[sendBeacon()](https://developer.mozilla.org/docs/Web/API/Navigator/sendBeacon)</code>
и
<code>[requestIdleCallback()](https://developer.mozilla.org/docs/Web/API/Window/requestIdleCallback)</code> специально разработаны для выполнения некритических задач таким образом, чтобы не блокировать важные для пользователя задачи.

Эти API-интерфейсыотличные инструменты для использования в аналитической библиотеке RUM.

Как правило, все маячки аналитики должны отправляться с помощью `sendBeacon()` (если доступно), а весь код пассивных аналитических измерений должен  запускаться в периоды простоя.

{% Aside %} Рекомендации о том, как максимально использовать время простоя, обеспечивая возможность экстренного запуска кода при необходимости (например, когда пользователь покидает страницу), см. в статье о шаблоне [idle-until-urgent](https://philipwalton.com/articles/idle-until-urgent/). {% endAside %}

### Не отслеживайте больше, чем вам нужно

Браузер предоставляет множество данных о производительности, но наличие этих данных не обязательно означает, что вы должны записывать их и отправлять на свои аналитические серверы.

Например, [Resource Timing API](https://w3c.github.io/resource-timing/) предоставляет подробные данные о времени загрузки каждого ресурса на вашей странице. Однако маловероятно, что все эти данные будут обязательными или полезными для улучшения производительности загрузки ресурсов.

Короче говоря, не отслеживайте данные просто потому, что они есть, убедитесь, что данные будут использоваться, прежде чем тратить ресурсы на их отслеживание.
