---
layout: post
title: Введение в вариативные шрифты
subhead: Новая спецификация шрифта, которая может значительно уменьшить размер файлов шрифтов.
description: |-
  Как работают вариативные шрифты, как типографы реализуют вариативные шрифты и
  как работать с вариативными шрифтами в CSS.
authors:
  - mustafakurtuldu
  - thomassteiner
  - dcrossland
  - roeln
date: 2018-02-19
updated: 2020-08-17
hero: image/admin/SHy7jOlEVPU1lsyfgvlG.jpg
tags:
  - blog
  - fonts
  - performance
  - ux
feedback:
  - api
---

В этой статье мы рассмотрим, что такое вариативные шрифты, какие преимущества они предлагают, и как мы можем использовать их в своей работе. Во-первых, давайте разберем, как типографика работает в Интернете и какие инновации привносят вариативные шрифты.

## Совместимость с браузером

По состоянию на май 2020 года вариативные шрифты поддерживаются в большинстве браузеров. См. [«Могу ли я использовать вариативные шрифты?»](https://caniuse.com/#feat=variable-fonts) и [«Резервные варианты»](#fallbacks).

## Вступление

Термины «шрифт» и «гарнитура» часто используются разработчиками как взаимозаменяемые. Однако между ними есть разница: гарнитура — это основной визуальный дизайн, который может существовать во многих различных технологиях набора, а шрифт — это одна из этих реализаций в формате цифрового файла. Проще говоря, гарнитура — это то, что вы *видите*, а шрифт — то, что *используете*.

Еще одно понятие, которое часто упускается из виду, — это различие между стилем и семейством. Стиль — это отдельный и конкретный шрифт, например, Bold Italic, а семейство — это полный набор стилей.

До появления вариативных шрифтов каждый стиль реализовывался как отдельный файл шрифта. В случае вариативных шрифтов все стили могут содержаться в одном файле.

<figure>{% Img src="image/admin/RbhgXwS81Y9PVRJnTjPX.png", alt="Образец композиции и список различных стилей семейства Roboto", width="800", height="600" %} <figcaption> Слева: образец гарнитур шрифтов Roboto. Справа: именованные стили внутри семейства. </figcaption></figure>

## Вызовы для дизайнера и разработчика

Когда дизайнер создает проект печати, он сталкивается с некоторыми ограничениями, такими как физический размер макета страницы, количество цветов, которые он может использовать (что определяется типом применяемой печатной машины) и так далее. Но он не ограничен в выборе количества применяемых стилей гарнитуры. Это означает, что типографика печатных изданий часто бывает богатой и сложной, так что процесс чтения действительно доставляет удовольствие. Вспомните, когда вы в последний раз листали отличный журнал.

У веб-дизайнеров и разработчиков другие ограничения, чем у дизайнеров полиграфии. Одним из основных ограничений, стоящих на пути более разнообразного типографского оформления, является стоимость полосы пропускания проектов. В случае традиционных веб-шрифтов каждый стиль, используемый в дизайне, требует от пользователей загрузки отдельного файла шрифта, что увеличивает задержку и время рендеринга страницы. Только стили Regular и Bold, а также их курсивные аналоги могут занимать 500 КБ или более данных шрифта. И это не считая способов рендеринга шрифтов, резервных шаблонов, нежелательных побочных эффектов, таких как [FOIT и FOUT](https://www.zachleat.com/web/fout-vs-foit/).

Многие семейства шрифтов предлагают гораздо более широкий спектр стилей: тонкие и жирные, узкие и широкие, разнообразные стилистические детали и даже дизайн с учетом конкретного размера (оптимизированный для больших или маленьких размеров текста). Поскольку для каждого стиля (или комбинации стилей) придется загружать новый файл шрифта, многие веб-разработчики предпочитают не использовать эти возможности, снижая удобство чтения для пользователей.

## Структура вариативного шрифта

Вариативные шрифты решают эти проблемы, упаковывая стили в один файл.

Вначале создается центральный стиль или стиль «по умолчанию», обычно это Regular — вертикальный римский стиль с наиболее типичным весом и шириной, который наиболее подходит для простого текста. Затем этот стиль соединяется с другими стилями в непрерывном диапазоне, называемом «осью». Самая распространенная ось — это **Weight (Вес)**. Двигая центральный стиль по оси веса, можно получать промежуточные состояния, например, стиль Bold для жирного шрифта. Любой отдельный стиль вдоль оси называется «экземпляром» вариативного шрифта. Некоторые экземпляры названы разработчиком шрифта, например, положение 600 по оси веса называется SemiBold.

Вариативный шрифт [Roboto Flex](https://github.com/TypeNetwork/Roboto-Flex) имеет три стиля для оси **веса.** В центре находится стиль Regular, а на противоположных концах оси расположены два стиля: более легкий и более тяжелый. Между ними существует 900 экземпляров:

<figure>{% Img src="image/tcFciHGuF3MxnTr1y5ue01OGLBn2/Ecr5godvTKunVXP7W8aU.png", alt="Буква «А» с разным весом", width="800", height="218" %} <figcaption> На рисунке выше: иллюстрированная структура оси веса для гарнитуры Roboto. </figcaption></figure>

Разработчик шрифта может предложить набор различных осей. Их можно комбинировать, потому что они используют одни и те же стили по умолчанию. Roboto имеет три стиля для оси Width (Ширина): Regular находится в центре оси, а два стиля, более узкий и более широкий, находятся на каждом ее конце. Сочетание осей ширины и веса предоставляют для стиля Regular огромный диапазон возможных вариантов.

<figure>
  <video controls autoplay loop muted>
    <source src="https://storage.googleapis.com/web-dev-assets/variable-fonts/roboto-dance.mp4" type="video/mp4">
  </source></video>
  <figcaption>Roboto Flex в случайных комбинациях ширины и веса</figcaption></figure>

То есть мы получаем тысячи возможных стилей! Это может показаться излишеством, но благодаря такому разнообразию шрифтов можно значительно улучшить процесс чтения. И, если это не приводит к снижению производительности, веб-разработчики могут использовать столько стилей, сколько потребуется для реализации дизайна страницы.

### Курсив

Интересен способ обработки курсива в вариативных шрифтах, поскольку существует два разных подхода. Гарнитуры, такие как Helvetica или Roboto, имеют совместимые с интерполяцией контуры, поэтому их стили Roman и Italic могут быть интерполированы между собой, а ось **Slant** (Наклон) может использоваться для перехода от Roman к Italic.

Другие гарнитуры (например, Garamond, Baskerville или Bodoni) имеют несовместимые с интерполяцией контуры глифов Roman и Italic. Например, контуры, которые обычно определяют строчную латинскую букву «n», не соответствуют контурам, используемым для определения курсивной строчной буквы «n». Вместо интерполяции одного контура в другой ось **Italic** переключается с контура Roman на Italic.

<figure>{% Img src="image/tcFciHGuF3MxnTr1y5ue01OGLBn2/EySl1LIfX1QIrGq654PO.png", alt="Пример осей веса для гарнитуры Amstelvar", width="800", height="520" %} <figcaption> Контуры «n», шрифт Amstelvar, курсив (Italic) (12 пт, обычный вес, нормальная ширина) и латиница (Roman). Изображение предоставлено Дэвидом Берлоу, шрифтовым дизайнером и типографом в Font Bureau. </figcaption></figure>

Оси, доступные пользователю после переключения на Italic, должны быть такими же, как и для латиницы, так же как и набор символов.

Для отдельных глифов существует возможность замены, которую можно использовать в дизайне вариативного шрифта. Например, дизайн знака доллара с двумя вертикальными полосками лучше всего подходит для больших кеглей, но для меньших кеглей лучше использовать дизайн только с одной полоской. Когда у нас меньше пикселей для отображения глифа, дизайн с двумя полосками может стать нечитаемым. Для борьбы с этим, как и в случае с осью Italic, вдоль оси **Optical Size** (Оптический размер) может происходить замена одного глифа на другой в точке, определяемой дизайнером шрифта.

Таким образом, если контуры позволяют, дизайнеры могут создавать шрифты, которые интерполируют между различными стилями в многомерном пространстве дизайна. Это дает вам полный контроль над своей типографикой и огромные возможности.

## Определение осей

Существует пять [зарегистрированных осей](https://docs.microsoft.com/en-us/typography/opentype/spec/dvaraxisreg#registered-axis-tags), которые управляют известными предсказуемыми характеристиками шрифта: весом, шириной, оптическим размером, наклоном и курсивом. Помимо этого, шрифт может содержать пользовательские оси, добавленные дизайнером для управления любым аспектом шрифта: размером засечек, длиной штрихов, высотой надстрочных элементов или размером точки над i.

Несмотря на то, что оси могут управлять одним и тем же элементом, они могут использовать разные значения. Например, в вариативных шрифтах Oswald и Hepta Slab доступна только одна ось — Weight (Вес), но диапазоны разные: у Oswald тот же диапазон, что и до модернизации, от 200 до 700, а у Hepta Slab — от супертонкого начертания в 1 до 900.

Для установки значений пяти зарегистрированных осей в CSS используются 4-символьные теги в нижнем регистре:

<table>
	<tbody>
		<tr>
			<th colspan="2">Названия осей и значения CSS</th>
		</tr>
		<tr>
			<td>Weight (Вес)</td>
			<td>
				<code>wght</code>
			</td>
		</tr>
		<tr>
			<td>Width (Ширина)</td>
			<td>
				<code>wdth</code>
			</td>
		</tr>
		<tr>
			<td>Slant (Наклон)</td>
			<td>
				<code>slnt</code>
			</td>
		</tr>
		<tr>
			<td> Optical Size (Оптический размер)</td>
			<td>
				<code>opsz</code>
			</td>
		</tr>
		<tr>
			<td>Italics (Курсив)</td>
			<td>
				<code>ital</code>
			</td>
		</tr>
	</tbody>
</table>

Поскольку разработчик шрифта определяет, какие оси доступны в вариативном шрифте, и какие значения они могут иметь, необходимо выяснить, что предлагает каждый шрифт. Как правило, такая информация содержится в документации к шрифту. Альтернативный вариант — проверить шрифт с помощью такого инструмента, как [Wakamai Fondue](https://wakamaifondue.com).

## Примеры использования и преимущества

Установка значений осей зависит от личного вкуса и применения передовых методов типографики. Опасность любой новой технологии заключается в возможном неправильном использовании, ведь чрезмерно художественные или экспериментальные настройки могут ухудшить читаемость текста. Применять различные оси целесообразно для создания великолепных художественных проектов для заголовков, но подобные эксперименты с основным текстом могут сделать его нечитаемым.

### Впечатляющий пример

<figure>{% Img src="image/tcFciHGuF3MxnTr1y5ue01OGLBn2/Rh7wLaBLauEF02D2dqMC.png", alt="Пример слова Grass от Мэнди Майкл", width="495", height="174" %}</figure>

Один из замечательных примеров художественного оформления показан выше — это исследование гарнитуры шрифта [Decovar](https://www.typenetwork.com/brochure/decovar-a-decorative-variable-font-by-david-berlow), выполненное Мэнди Майкл.

Действующий образец и исходный код для приведенного выше примера можно просмотреть [здесь](https://codepen.io/mandymichael/pen/YYaWop).

### Анимация

<figure>{% Video src="video/vgdbNJBYHma2o62ZqYmcnkq3j0o1/2Du2L0Ii5nUqz8n6S3Vz.mp4", controls=false, autoplay=true, loop=true, muted=true, playsinline=true %} <figcaption> Гарнитура Zycon, разработанная для анимации Дэвидом Берлоу, шрифтовым дизайнером и типографом в Font Bureau. </figcaption></figure>

Благодаря вариативным шрифтам также есть возможность анимировать символы. Выше приведен пример использования различных осей с гарнитурой Zycon. Посмотрите интерактивный [пример анимации на сайте Axis Praxis](https://www.axis-praxis.org/specimens/zycon).

[Anicons](https://typogram.github.io/Anicons) — это первый в мире шрифт с анимированными цветными иконками, основанный на Material Design Icons. Anicons — это эксперимент, в котором сочетаются две передовые технологии шрифтов: вариативные шрифты и цветные шрифты.

<figure>
  <video controls autoplay loop muted>
    <source src="https://storage.googleapis.com/web-dev-assets/variable-fonts/anicons-animation.mp4" type="video/mp4">
  </source></video>
  <figcaption>Несколько примеров анимации при наведении курсора на цветные иконки шрифта Anicon</figcaption></figure>

### Тонкая настройка

<figure>
  <video controls autoplay loop muted>
    <source src="https://storage.googleapis.com/web-dev-assets/variable-fonts/larger-widths.mp4" type="video/mp4">
  </source></video>
  <figcaption>Ширина слов в шрифте Amstelvar выравнивается путем небольшого смещения по оси XTRA в противоположных направлениях</figcaption></figure>

[Roboto Flex](https://github.com/TypeNetwork/Roboto-Flex) и [Amstelvar](https://github.com/TypeNetwork/Amstelvar) предлагают набор «Параметрических осей». На этих осях буквы разбиты на 4 основных аспекта формы: черные или положительные формы, белые или отрицательные формы, а также размеры x и y. Подобно тому, как основные цвета можно смешивать с любым другим цветом для получения оттенка, эти 4 аспекта можно использовать для тонкой настройки любой другой оси.

Ось XTRA в Amstelvar позволяет регулировать значение «белого» в тысячных долях кегля, как показано выше. Ширина слов выравнивается путем небольшого смещения по оси XTRA в противоположных направлениях.

## Вариативные шрифты в CSS

### Загрузка файлов с вариативными шрифтами

Вариативные шрифты загружаются с помощью того же механизма `@font-face`, что и традиционные статические веб-шрифты, но с двумя новыми доработками:

```css
@font-face {
	font-family: 'Roboto Flex';
	src: url('RobotoFlex-VF.woff2') format('woff2 supports variations'),
       url('RobotoFlex-VF.woff2') format('woff2-variations');
	font-weight: 100 1000;
	font-stretch: 25% 151%;
}
```

**1. Исходные форматы:** мы не хотим, чтобы браузер загружал вариативный шрифт, если он его не поддерживает, поэтому мы добавляем описание для функции `format`: единожды в [будущем формате](https://www.w3.org/TR/css-fonts-4/#font-face-src-requirement-types) (`woff2 supports variations`), единожды в текущем, но скоро устаревающем формате (`woff2-variations`). Если браузер поддерживает вариативные шрифты и будущий синтаксис, он будет использовать первое объявление. Если браузер поддерживает вариативные шрифты и текущий синтаксис, он будет использовать второе объявление. Они оба указывают на один и тот же файл шрифта.

<!-- TODO 2021 Q1 revisit this, based on progress in
     https://www.w3.org/TR/css-fonts-4/#font-face-src-requirement-types
     to allow removing the 2nd src -->

**2. Диапазоны стилей:** вы заметите, что мы предоставляем два значения для `font-weight` и `font-stretch`. Вместо того чтобы сообщать браузеру, какой конкретно вес предоставляет этот шрифт (например, `font-weight: 500;`), мы указываем **диапазон** значений веса, поддерживаемых шрифтом. Для Roboto Flex ось Weight находится в диапазоне от 100 до 1000; CSS напрямую сопоставляет диапазон оси со свойством стиля `font-weight`. Если указать диапазон в `@font-face`, любое значение за пределами этого диапазона будет «урезано» до ближайшего допустимого значения. Диапазон оси Width ​таким же образом сопоставляется со свойством `font-stretch`.

Если вы используете API Google Fonts, то вообще не о чем беспокоиться: CSS будет содержать правильные исходные форматы и диапазоны. Google Fonts также будет отправлять статические резервные шрифты в случае, если вариативные шрифты не поддерживаются.

### Использование веса и ширины

В настоящее время в CSS-коде гарантированно можно задать ось `wght` через свойство `font-weight` и ось `wdth` через свойство `font-stretch`.

Раньше для свойства `font-weight` нужно было задавать значение в виде ключевого слова (`light` или `bold`) или в виде числа от 100 до 900 с шагом в 100. При использовании вариативных шрифтов можно задавать любое значение в диапазоне ширины шрифта:

```css
.kinda-light {
  font-weight: 125;
}

.super-heavy {
  font-weight: 1000;
}
```

<figure>
  <video controls autoplay loop muted>
    <source src="https://storage.googleapis.com/web-dev-assets/variable-fonts/roboto-flex-weight.mp4" type="video/mp4">
  </source></video>
  <figcaption>Шрифт Roboto Flex меняется по оси Weight (Вес) от минимального до максимального значения.</figcaption></figure>

Аналогично можно задать свойство `font-stretch` с помощью ключевых слов (`condensed` или `ultra-expanded`) или с помощью процентных значений:

```css
.kinda-narrow {
  font-stretch: 33.3%;
}

.super-wide {
  font-stretch: 151%;
}
```

<figure>
  <video controls autoplay loop muted>
    <source src="https://storage.googleapis.com/web-dev-assets/variable-fonts/roboto-flex-width.mp4" type="video/mp4">
  </source></video>
  <figcaption>Шрифт Roboto Flex меняется по оси Width (Ширина) от минимального до максимального значения.</figcaption></figure>

### Использование курсива и наклона

Ось `ital` (Курсив) предназначена для шрифтов, которые содержат стили для нормального и курсивного начертания. Ось выступает в роли переключателя: значение `0` — «выключено», для шрифта применяется нормальный стиль начертания, значение `1` — «включено», применяется курсивный стиль начертания. В отличие от других осей, возможность плавного перехода отсутствует. Значение `0.5` не даст «полукурсива».

Ось `slnt` (Наклон) отличается от оси курсива тем, что это не новый *стиль*, а просто наклонное начертание нормального стиля. По умолчанию задано значение `0`, что соответствует нормальному начертанию букв. Максимальный наклон шрифта Roboto Flex составляет –10 градусов, то есть буквы наклоняются вправо при изменении угла от 0 до –10.

Проще было бы задавать эти оси через свойство `font-style`, но по состоянию на апрель 2020 года [эта возможность еще находится в разработке](https://github.com/w3c/csswg-drafts/issues/3125). Поэтому пока следует рассматривать эти оси как пользовательские и задавать их с помощью низкоуровневого синтаксиса `font-variation-settings`:

```css
i, em, .italic {
	/* Should be font-style: italic; */
	font-variation-settings: 'ital' 1;
}

.slanted {
	/* Should be font-style: oblique 10deg; */
	font-variation-settings: 'slnt' 10;
}
```

<figure>
  <video controls autoplay loop muted>
    <source src="https://storage.googleapis.com/web-dev-assets/variable-fonts/roboto-flex-slant.mp4" type="video/mp4">
  </source></video>
  <figcaption>Шрифт Roboto Flex меняется по оси Slant (Наклон) от минимального до максимального значения.</figcaption></figure>

### Использование оптических размеров

Гарнитура может быть очень маленькой (сноска размером 12 пикселей) или очень большой (заголовок размером 80 пикселей). Шрифт может реагировать на эти изменения размера, изменяя форму букв, чтобы лучше соответствовать размеру. При маленьком размере букв лучше обойтись без мелких деталей, в то время как при большом размере лучше использовать более детальные и тонкие штрихи.

<figure>{% Img src="image/tcFciHGuF3MxnTr1y5ue01OGLBn2/wrVCGSQNaGWhNp97BoRS.png", alt="Буква «a» в разных оптических размерах", width="800", height="147" %} <figcaption> Различия в дизайне показаны на примере буквы «а» из шрифта Roboto Flex. Буква взята в разных размерах пикселей и затем масштабирована до одинакового размера. <a href="https://codepen.io/RoelN/pen/PoPvdeV">Попробуйте сами на Codepen</a> </figcaption></figure>

Для этой оси было введено новое свойство CSS: `font-optical-sizing`. По умолчанию оно установлено на `auto`, и браузер устанавливает значение оси на основе `font-size`. То есть браузер будет автоматически выбирать лучший оптический размер. Если нужно отключить автоматический выбор, установите для `font-optical-sizing` значение `none`.

Вы также можете задать пользовательское значение для оси `opsz`, если намеренно хотите получить оптический размер, не соответствующий размеру шрифта. Следующий CSS-код приведет к тому, что текст будет отображаться в большом размере, но с оптическим размером для шрифта `8 пт`:

```css
.small-yet-large {
  font-size: 100px;
  font-variation-settings: 'opsz' 8;
}
```

### Использование пользовательских осей

В отличие от зарегистрированных осей, пользовательские оси не будут сопоставляться с существующими свойствами CSS, поэтому вам придется задавать оси через `font-variation-settings`. Теги для пользовательских осей всегда пишутся заглавными буквами, чтобы отличать их от тегов для зарегистрированных осей.

Шрифт Roboto Flex предлагает несколько пользовательских осей, самая важная из которых — Grade (`GRAD`). Ось Grade (Уклон) интересна тем, что она изменяет вес шрифта без изменения ширины, поэтому межбуквенные интервалы не меняются. Меняя шрифт по оси Grade, можно избежать необходимости возиться с изменениями оси Weight, затрагивающими общую ширину, а затем с изменениями оси Width, затрагивающими общий вес.

<figure>
  <video controls autoplay loop muted>
    <source src="https://storage.googleapis.com/web-dev-assets/variable-fonts/roboto-flex-grade.mp4" type="video/mp4">
  </source></video>
  <figcaption>Шрифт Roboto Flex меняется по оси Grade от минимального до максимального значения.</figcaption></figure>

Поскольку `GRAD` — это пользовательская ось с диапазоном от –200 до 150, нужно задавать ее через `font-variation-settings`:

```css
.grade-light {
	font-variation-settings: `GRAD` -200;
}

.grade-normal {
	font-variation-settings: `GRAD` 0;
}

.grade-heavy {
	font-variation-settings: `GRAD` 150;
}
```

### Вариативные шрифты в Google Fonts

В каталоге Google Fonts уже содержатся [вариативные шрифты](https://fonts.google.com/?vfonly=true) и регулярно добавляются новые. Интерфейс в настоящее время нацелен на выбор отдельных экземпляров шрифта: выбираете нужный вариант, нажимаете Select this style (Выбрать этот стиль), и стиль добавляется в элемент `<link>`, который получает CSS-код и шрифты из Google Fonts.

Чтобы использовать все доступные оси или диапазоны значений, вам придется [вручную составить](https://developers.google.com/fonts/docs/css2) URL-адрес к API Google Fonts. В [обзоре вариативных шрифтов](https://fonts.google.com/variablefonts) перечислены все оси и значения.

Инструмент [Google Variable Fonts Links](https://github.com/RoelN/google-variable-fonts-links) также может предоставить актуальные URL-адреса вариативных шрифтов.

## Наследование в font-variation-settings

Хотя все зарегистрированные оси скоро будут поддерживаться через существующие свойства CSS, пока что вам может понадобиться использовать `font-variation-settings` в качестве запасного варианта. Если ваш шрифт имеет пользовательские оси, вам также понадобится `font-variation-settings`.

Однако существует небольшая проблема с `font-variation-settings`. Каждое свойство, которое *не было задано явно*, будет автоматически сброшено на значение по умолчанию. Ранее установленные значения не наследуются! Это означает, что следующий код не будет работать должным образом:

```html
<span class="slanted grade-light">
	I should be slanted and have a light grade
</span>
```

Сначала браузер применит `font-variation-settings: 'slnt' 10` из класса `.slanted`. Затем он применит `font-variation-settings: 'GRAD' -200` из класса `.grade-light`. Но это вернет `slnt` к значению по умолчанию 0! В результате текст будет светлым, но не наклонным.

К счастью, это можно обойти, используя переменные CSS:

```css
/* Set the default values */
:root {
	--slnt: 0;
	--GRAD: 0;
}

/* Change value for these elements and their children */
.slanted {
	--slnt: 10;
}

.grade-light {
	--grad: -200;
}

.grade-normal {
	--grad: 0;
}

.grade-heavy {
	--grad: 150;
}

/* Apply whatever value is kept in the CSS variables */
.slanted,
.grade-light,
.grade-normal,
.grade-heavy {
	font-variation-settings: 'slnt' var(--slnt), 'GRAD' var(--GRAD);
}
```

Переменные CSS каскадируются, поэтому если в элементе (или в одном из его родителей) значение `slnt` установлено на `10`, это значение сохранится, даже если вы измените значение `GRAD`. Подробное объяснение этой техники см. в разделе [«Исправление наследования вариативных шрифтов»](https://pixelambacht.nl/2019/fixing-variable-font-inheritance/).

Обратите внимание, что CSS-анимация с помощью @keyframes не работает (по замыслу), поэтому примерно такой код не даст желаемого результата:

```css
@keyframes width-animation {
   from { --wdth: 25; }
   to   { --wdth: 151; }
}
```

Анимация должна задаваться непосредственно в `font-variation-settings`.

## Прирост производительности

Вариативные шрифты OpenType позволяют хранить несколько вариантов семейства шрифтов в одном файле шрифта. [Компания Monotype](https://medium.com/@monotype/part-2-from-truetype-gx-to-variable-fonts-4c28b16997c3) провела эксперимент, объединив 12 входных шрифтов для создания восьми начертаний с тремя вариантами ширины для стилей Italic и Roman. Хранение 48 отдельных шрифтов в одном файле с вариативными шрифтами позволило *уменьшить размер файла на 88%*.

Однако если вы используете один шрифт, например Roboto Regular, и ничего больше, вы можете не увидеть сокращения размера шрифта, если перейдете на вариативный шрифт с большим количеством осей. Как всегда, всё зависит от конкретного случая использования.

С другой стороны, анимация шрифта через настройки может вызвать проблемы с производительностью. Хотя ситуация улучшится, когда вариативные шрифты будут лучше поддерживаться браузерами, проблему можно несколько уменьшить, если анимировать только те шрифты, которые в данный момент находятся на экране. Этот фрагмент кода от [Dinamo](https://abcdinamo.com/news/using-variable-fonts-on-the-web) приостанавливает анимацию в элементах с классом `vf-animation`, когда их нет на экране:

```javascript
var observer = new IntersectionObserver(function(entries, observer) {
  entries.forEach(function(entry) {
    // Pause/Play the animation
    if (entry.isIntersecting) entry.target.style.animationPlayState = "running"
    else entry.target.style.animationPlayState = "paused"
  });
});

var variableTexts = document.querySelectorAll(".vf-animation");
variableTexts.forEach(function(el) { observer.observe(el); });
```

Если ваш шрифт реагирует на взаимодействие с пользователем, рекомендуется [ограничивать или отклонять](https://css-tricks.com/debouncing-throttling-explained-examples/) события ввода. Это предотвратит отображение браузером экземпляров вариативного шрифта, изменение которых по сравнению с предыдущим экземпляром неразличимо для человеческого глаза.

Если вы используете Google Fonts, рекомендуется [предварительно подключиться](/preconnect-and-dns-prefetch/) к домену `https://fonts.gstatic.com`, где размещены шрифты Google. Это гарантирует, что браузер заранее знает, где взять шрифты, когда он встретит их в CSS:

```html
<link rel="preconnect" href="https://fonts.gstatic.com" />
```

Этот совет работает и для других CDN: чем раньше вы разрешите браузеру установить сетевое соединение, тем скорее он сможет загрузить шрифты.

Дополнительные советы по повышению производительности при загрузке шрифтов Google приведены в статье [«Самые быстрые шрифты Google Fonts»](https://csswizardry.com/2020/05/the-fastest-google-fonts/).

## Резервные варианты и поддержка в браузерах {: #fallbacks}

Все современные браузеры [поддерживают вариативные шрифты](https://caniuse.com/#feat=variable-fonts). Если вам нужна поддержка в старых браузерах, вы можете создать сайт со статическими шрифтами и использовать вариативные шрифты в качестве прогрессивного улучшения:

```css
/* Set up Roboto for old browsers, only regular + bold */
@font-face {
  font-family: Roboto;
  src: url('Roboto-Regular.woff2');
  font-weight: normal;
}

@font-face {
  font-family: Roboto;
  src: url('Roboto-Bold.woff2');
  font-weight: bold;
}

body {
  font-family: Roboto;
}

.super-bold {
  font-weight: bold;
}

/* Set up Roboto for modern browsers, all weights */
@supports (font-variation-settings: normal) {
  @font-face {
    font-family: 'Roboto';
    src: url('RobotoFlex-VF.woff2') format('woff2 supports variations'),
         url('RobotoFlex-VF.woff2') format('woff2-variations');
    font-weight: 100 1000;
    font-stretch: 25% 151%;
  }

  .super-bold {
    font-weight: 1000;
  }
}
```

Для старых браузеров текст с классом `.super-bold` будет отображаться обычным полужирным шрифтом, поскольку это единственный доступный полужирный шрифт. Когда поддерживаются вариативные шрифты, мы можем использовать самый большой вес, равный 1000.

Если вы используете API Google Fonts, он позаботится о загрузке нужных шрифтов для браузеров ваших посетителей. Скажем, вы запрашиваете шрифт Oswald в диапазоне весов от 200 до 700, например:

```html
<link href="https://fonts.googleapis.com/css2?family=Oswald:wght@200..700&display=swap" rel="stylesheet">
```

Современные браузеры с поддержкой вариативных шрифтов будут обрабатывать вариативный шрифт, изменяющийся по шкале веса от 200 до 700. Старые браузеры будут обрабатывать отдельные статические шрифты для каждого отдельно взятого веса. В данном случае это означает, что они загрузят 6 файлов шрифтов: один для веса 200, другой для веса 300 и так далее.

## Благодарности

Приносим искреннюю благодарность следующим людям, чей вклад позволил этой статье появится на свет:

- [Мустафе Куртулду](https://twitter.com/mustafa_x), UX-дизайнеру и Design advocate в Google;
- [Роэлу Нискенсу](https://twitter.com/PixelAmbacht), UX-дизайнеру/разработчику и эксперту по типографике в [Kabisa](https://kabisa.nl);
- [Дэйву Кроссленду](https://twitter.com/davelab6), руководителю группы проектов в Google Fonts;
- [Дэвиду Берлоу](https://twitter.com/dberlow), дизайнеру шрифтов и типографу в [Font Bureau](https://fontbureau.typenetwork.com/);
- [Лоуренсу Пенни](https://twitter.com/lorp), разработчику [axis-praxis.org](https://axis-praxis.org);
- [Мэнди Майклу](https://twitter.com/Mandy_Kerr), разработчик [variablefonts.dev](https://variablefonts.dev).

Главное изображение взято у [Bruno Martins](https://unsplash.com/@brunus) на [Unsplash](https://unsplash.com/photos/OhJmwB4XWLE).
