---
title: Начало работы с Trust Tokens
subhead: Trust Tokens (Токены доверия) — это новый API, позволяющий веб-сайту передавать ограниченный объем информации из одного контекста просмотра в другой (например, между сайтами) для борьбы с мошенничеством без использования пассивного отслеживания.
authors:
  - samdutton
date: 2020-06-22
updated: 2021-12-10
hero: image/admin/okxi2ttRG3h1Z4F3cylI.jpg
thumbnail: image/admin/cTo0l2opcfNxg1TEjxSg.jpg
alt: Черно-белая фотография руки, держащей жетон
tags:
  - blog
  - privacy
  - security
feedback:
  - api
---

{% Aside  'caution' %} **⚠️ Предупреждение: вам может потребоваться обновить приложение!**

**TrustTokenV3** — это набор обратно несовместимых изменений в реализации Trust Tokens в Chromium. Изменения появились в Chrome 92, стабильная версия которого вышла в конце июля 2021 года.

Необходимо обновить существующие приложения, [тестирующие API](https://www.chromestatus.com/feature/5078049450098688), если вы еще этого не сделали.

Узнайте больше: [что такое TrustTokenV3?](https://bit.ly/what-is-trusttokenv3). {% endAside %}

<br><br>

{% YouTube id='bXB1Iwq6Eq4' %}

## Резюме

Токены доверия позволяют источнику выдавать криптографические токены пользователю, которому он доверяет. Токены хранятся в браузере пользователя. В дальнейшем браузер может использовать токены в других контекстах для оценки подлинности пользователя.

Trust Token API позволяет передавать доверие к подлинности пользователя из одного контекста в другой, не прибегая к идентификации пользователя или связыванию двух идентификаторов.

Вы можете опробовать API в нашей [демонстрации](https://trust-token-demo.glitch.me) и [проверить токены](https://developers.google.com/web/updates/2021/01/devtools#trust-token) на вкладках Chrome DevTools **Network** и **Application**.

<figure>{% Img src="image/tcFciHGuF3MxnTr1y5ue01OGLBn2/krrI292OLd6awb4dxkN0.jpg", alt="Скриншот, показывающий Trust Tokens на вкладке Network в Chrome DevTools.", width="800", height="584" %} <figcaption>Trust Tokens на вкладке <b>Network</b> в Chrome DevTools.</figcaption></figure>

<figure>{% Img src="image/tcFciHGuF3MxnTr1y5ue01OGLBn2/cwR9JdoVo1M4VDovP2oM.jpg", alt="Скриншот, показывающий Trust Tokens на вкладке Application в Chrome DevTools.", width="800", height="584" %} <figcaption>Trust Tokens на вкладке <b>Application</b> в Chrome DevTools.</figcaption></figure>

{% Aside %} Privacy Sandbox — это ряд предложений, позволяющих удовлетворить запросы сторонних разработчиков без использования сторонних файлов cookie и других механизмов отслеживания. См. статью [«Подробно о Privacy Sandbox»](/digging-into-the-privacy-sandbox), чтобы ознакомиться со всеми предложениями.

**Нам важны отзывы об этом предложении!** Если у вас есть комментарии, [создайте тему](https://github.com/WICG/trust-token-api/issues/new) в репозитории [объяснения токенов доверия](https://github.com/WICG/trust-token-api). {% endAside %}

## Зачем нужны токены доверия?

Интернет нуждается в способах установки и передачи сигналов доверия, показывающих, что пользователь действительно является тем, за кого себя выдает, а не ботом, маскирующимся под человека, или злоумышленником, пытающимся обмануть реального человека или сервис. Защита от мошенничества особенно важна для рекламодателей, поставщиков рекламы и сетей CDN.

К сожалению, многие существующие механизмы оценки и распространения доверия — например, используемые для подтверждения того, что с сайтом взаимодействует реальный человек, — используют технологии, которые также могут применяться для создания цифровых отпечатков.

{% Aside 'key-term' %} **Фингерпринтинг**, или создание цифрового отпечатка, позволяет сайтам идентифицировать и отслеживать отдельных пользователей, получая данные об их устройстве, операционной системе и настройках браузера (например, языковых настройках, строке [user-agent](https://developer.mozilla.org/docs/Web/API/NavigatorID/userAgent) и доступных шрифтах), а также изменениях в состоянии устройства. Это можно делать как на стороне сервера путем проверки заголовков запросов, так и на стороне клиента при помощи JavaScript.

Фингерпринтинг использует механизмы, о которых пользователи не знают и которые не могут контролировать. Такие сайты, как [Panopticlick](https://panopticlick.eff.org/) и [amiunique.org](https://amiunique.org/), показывают, как данные, полученные в результате фингерпринтинга, можно объединить, чтобы идентифицировать вашу личность. {% endAside %}

API должен сохранять конфиденциальность, позволяя распространять доверие между сайтами без отслеживания отдельных пользователей.

## Что содержится в предложении Trust Tokens?

Интернет полагается на построение сигналов доверия для обнаружения мошенничества и спама. Один из способов это реализовать — отслеживать просмотр с помощью глобальных межсайтовых идентификаторов пользователя. Для API, сохраняющего конфиденциальность, это неприемлемо.

Из [**объяснения**](https://github.com/WICG/trust-token-api#overview) предложения:

<blockquote>
<p>Этот API предлагает новую область хранения для каждого источника для криптографических токенов в стиле «Privacy Pass», которые доступны в сторонних контекстах. Эти токены не персонализированы и не могут использоваться для отслеживания пользователей, но имеют криптографическую подпись, поэтому их нельзя подделать.</p>
<p>Когда источник находится в контексте, в котором он доверяет пользователю, он может выдать браузеру пакет токенов, который может быть «потрачен» позже в контексте, в котором пользователь в противном случае был бы неизвестен или меньше заслуживал доверия. Важно отметить, что токены неотличимы друг от друга, что не позволяет веб-сайтам отслеживать пользователей через них.</p>
<p>Мы также предлагаем механизм расширения, позволяющий браузеру подписывать исходящие запросы ключами, привязанными к конкретной активации токена.</p>
</blockquote>

## Пример использования API

Следующее адаптировано из [примера кода в объяснении API](https://github.com/WICG/trust-token-api#sample-api-usage).

{% Aside %} Код в этой публикации использует обновленный синтаксис, доступный начиная с Chrome 88. {% endAside %}

Представьте, что пользователь посещает новостной веб-сайт (`publisher.example`), на котором размещена реклама из сторонней рекламной сети (`foo.example`). Пользователь ранее посещал сайт социальной сети, который выпускает токены доверия (`issuer.example`).

В приведенной ниже последовательности показано, как работают токены доверия.

**1.** Пользователь заходит на сайт `issuer.example` и выполняет действия, которыми подтверждает для сайта, что он реальный человек, например, проводит операции с учетной записью или проходит тест CAPTCHA.

**2.** `issuer.example` проверяет, является ли пользователь человеком, и запускает следующий код JavaScript для выдачи токена доверия браузеру пользователя:

```js
fetch('https://issuer.example/trust-token', {
  trustToken: {
    type: 'token-request',
    issuer: 'https://issuer.example'
  }
}).then(...)
```

**3.** Браузер пользователя сохраняет токен доверия, связывая его с `issuer.example`.

**4.** Через некоторое время пользователь заходит на сайт `publisher.example`.

**5.** `publisher.example` хочет знать, является ли пользователь реальным человеком. `publisher.example` доверяет сайту `issuer.example`, поэтому он проверяет, есть ли в браузере пользователя действительные токены из этого источника:

```js
document.hasTrustToken('https://issuer.example');
```

**6.** Если возвращается обещание, которое разрешается в `true`, это означает, что у пользователя есть токены от `issuer.example`, поэтому `publisher.example` может попытаться активировать токен:

```js
fetch('https://issuer.example/trust-token', {
trustToken: {
  type: 'token-redemption',
  issuer: 'https://issuer.example',
  refreshPolicy: {none, refresh}
}
}).then(...)
```

С помощью этого кода:

1. Сайт издателя `publisher.example` запрашивает активацию.
2. Если активация успешна, сайт-эмитент `issuer.example` возвращает запись об активации, которая указывает, что в какой-то момент эмитент выпустил действительный токен для этого браузера.

**7.** Как только обещание, возвращаемое `fetch()`, будет разрешено, запись об активации может быть использована в последующих запросах ресурсов:

```js
fetch('https://foo.example/get-content', {
  trustToken: {
    type: 'send-redemption-record',
    issuers: ['https://issuer.example', ...]
  }
});
```

С помощью этого кода:

1. Записи об активации включаются в заголовок запроса `Sec-Redemption-Record`.
2. `foo.example` получает запись об активации и может ее проанализировать, чтобы определить, считал ли `issuer.example` этого пользователя реальным человеком.
3. `foo.example` отвечает соответствующим образом.

{% Details %} {% DetailsSummary %} Как веб-сайт может решить, доверять ли вам? {% endDetailsSummary %} У вас может быть история покупок в Интернет-магазине, отметки на платформе определения местоположения или движение по счету в банке. Эмитенты также могут учитывать другие факторы, например, как долго у вас была учетная запись, или другие взаимодействия (например, CAPTCHA или отправка форм), которые повышают доверие эмитента к вероятности того, что вы релаьный человек. {% endDetails %}

### Выпуск токена доверия

Если эмитент токена доверия, такой как `issuer.example`, считает пользователя заслуживающим доверия, эмитент может получить токены доверия для пользователя, выполнив запрос `fetch()` с параметром `trustToken`:

```js
fetch('issuer.example/trust-token', {
  trustToken: {
    type: 'token-request'
  }
}).then(...)
```

Это вызывает расширение протокола выдачи [Privacy Pass](https://privacypass.github.io/) с использованием [нового криптографического примитива](https://eprint.iacr.org/2020/072.pdf):

1. Сгенерируйте набор псевдослучайных чисел, известных как *одноразовые номера*.

2. Замаскируйте одноразовые номера (закодируйте их, чтобы эмитент не мог просматривать их содержимое) и прикрепите их к запросу в заголовке `Sec-Trust-Token`.

3. Отправьте запрос POST к предоставленной конечной точке.

Конечная точка отвечает [маскированными токенами](https://en.wikipedia.org/wiki/Blind_signature) (подписями на маскированных одноразовых номерах), затем токены демаскируются и сохраняются внутри браузера вместе со связанными одноразовыми номерами как токены доверия.

### Активация токена доверия

Сайт издателя (в приведенном выше примере это `publisher.example`) может проверить, доступны ли пользователю токены доверия:

```js
const userHasTokens = await document.hasTrustToken('issuer.example/trust-token');
```

Если есть доступные токены, сайт издателя может активировать их, чтобы получить запись об активации:

```js
fetch('issuer.example/trust-token', {
  ...
  trustToken: {
    type: 'token-redemption',
    refreshPolicy: 'none'
  }
  ...
}).then(...)
```

Издатель может включать записи об активации в запросы, для которых требуется токен доверия — например, публикация комментария, оценка страницы или голосование в опросе — с помощью вызова `fetch()`, как показано ниже:

```js
fetch('https://foo.example/post-comment', {
  ...
  trustToken: {
    type: 'send-redemption-record',
    issuers: ['issuer.example/trust-token', ...]
  }
  ...
}).then(...);
```

Записи об активации включаются в заголовок запроса `Sec-Redemption-Record`.

{% Aside %} Токены доверия доступны только через параметры Fetch, XHR и HTML-элемента `<iframe>`:<br> получить к ним доступ напрямую нельзя. {% endAside%}

### Соображения конфиденциальности

Токены разработаны таким образом, чтобы их нельзя было связать. Эмитент может узнать совокупную информацию о том, какие сайты посещают его пользователи, но не может связать выдачу с активацией: когда пользователь активирует токен, эмитент не может отличить его от других токенов, которые он создал. Однако токены доверия в настоящее время не существуют в вакууме: есть и другие способы, которыми эмитент в настоящее время может — теоретически — связать идентификаторы пользователя на разных сайтах, например, сторонние файлы cookie и методы скрытого отслеживания. Для сайтов важно понимать такую перестройку экосистемы при планировании их поддержки. Это общий аспект перехода для многих API-интерфейсов Privacy Sandbox, поэтому здесь он не рассматривается.

### Соображения безопасности

**Исчерпание токена доверия:** вредоносный сайт может намеренно исчерпать запас токенов у определенного эмитента. Существует несколько способов предотвращения атак такого типа, например, предоставление эмитентам возможности выдавать множество токенов одновременно. Так у пользователей образуется достаточный их запас, гарантирующий, что браузеры всегда будут активировать только один токен при просмотре страницы верхнего уровня.

**Предотвращение двойного расходования:** вредоносное ПО может попытаться получить доступ ко всем токенам доверия пользователя. Однако токены со временем закончатся, поскольку каждая активация отправляется одному и тому же эмитенту токенов, который может проверить, что каждый токен используется только один раз. Чтобы снизить риск, эмитенты также могут подписывать меньше токенов.

### Механизмы запроса

Возможно разрешить отправку записей об активации вне `fetch()`, например, с помощью запросов навигации. Сайты также могут включать данные об эмитенте в заголовки HTTP-ответов, чтобы включить активацию токенов параллельно загрузке страницы.

**Повторюсь: нам важны отзывы об этом предложении!** Если у вас есть комментарии, [создайте тему](https://github.com/WICG/trust-token-api/issues/new) в [репозитории объяснения](https://github.com/WICG/trust-token-api) токенов доверия.

## Дополнительные сведения

- [Демонстрация Trust Tokens](https://trust-token-demo.glitch.me)
- [Начало работы с испытаниями Chrome Origin Trial](https://developer.chrome.com/blog/origin-trials/)
- [Подробно о Privacy Sandbox](/digging-into-the-privacy-sandbox/)
- [Объяснение Trust Token API](https://github.com/WICG/trust-token-api)
- [Проекты Chromium: Trust Token API](https://sites.google.com/a/chromium.org/dev/updates/trust-token)
- [Намерение реализовать: Trust Token API](https://groups.google.com/a/chromium.org/g/blink-dev/c/X9sF2uLe9rA/m/1xV5KEn2DgAJ)
- [Статус платформы Chrome](https://www.chromestatus.com/feature/5078049450098688)
- [Privacy Pass](https://privacypass.github.io/)
- [Расширения Privacy Pass](https://eprint.iacr.org/2020/072.pdf)

---

Спасибо всем, кто помогал писать и рецензировать эту публикацию.

Фото [ZSun Fu](https://unsplash.com/photos/b4D7FKAghoE) c [Unsplash](https://unsplash.com/?utm_source=unsplash&utm_medium=referral&utm_content=creditCopyText).
