---
title: Советы по использованию файлов cookie с атрибутом SameSite
subhead: Обновите файлы cookie своего сайта, чтобы подготовиться к предстоящим изменениям в поведении атрибута SameSite.
authors:
  - rowan_m
date: 2019-10-30
updated: 2020-05-28
hero: image/kheDArv5csY6rvQUJDbWRscckLr1/5f56hyvtMT6Dymo839tc.png
description: Теперь, благодаря введению нового значения атрибута SameSite=None, сайты могут явно помечать файлы cookie как предназначенные для межсайтового использования. В ближайшее время браузеры станут блокировать межсайтовое использование файлов cookie без атрибута SameSite, чтобы повысить уровень безопасности и конфиденциальности. Узнайте о том, как помечать файлы cookie, чтобы после вступления изменения в силу ваши внутренние и межсайтовые файлы cookie продолжили работать.
tags:
  - blog
  - security
  - cookies
  - chrome-80
  - test-post
feedback:
  - api
---

{% Aside %} Эта статься относится к циклу статей об изменениях в атрибуте `SameSite` файлов cookie:

- [Объяснение SameSite — атрибута файлов cookie](/samesite-cookies-explained/)
- [Советы по использованию файлов cookie с атрибутом SameSite](/samesite-cookie-recipes/)
- [Same-Site с учетом схемы](/schemeful-samesite) {% endAside %}

Поведение [Chrome](https://www.chromium.org/updates/same-site), [Firefox](https://groups.google.com/d/msg/mozilla.dev.platform/nx2uP0CzA9k/BNVPWDHsAQAJ), [Edge](https://groups.google.com/a/chromium.org/d/msg/blink-dev/AknSSyQTGYs/8lMmI5DwEAAJ) и других браузеров будет изменено в соответствии с предложением IETF [Incrementally Better Cookies](https://tools.ietf.org/html/draft-west-cookie-incrementalism-00):

- Файлы cookie без атрибута `SameSite` будут обрабатываться так, как будто имеют атрибут `SameSite=Lax`: по умолчанию они будут действовать **исключительно** в рамках собственного контекста.
- Файлы cookie, предназначенные для межсайтового использования, **должны** включать атрибут `SameSite=None; Secure`, разрешающий использование в сторонних контекстах.

Это поведение является [стандартным начиная со стабильной версии Chrome 84](https://blog.chromium.org/2020/05/resuming-samesite-cookie-changes-in-july.html). Если вы еще не обновили атрибуты своих межсайтовых файлов cookie, вам следует это сделать, чтобы избежать их блокировки в будущем.

## Поддержка в браузерах

См. раздел [Совместимость браузеров](https://developer.mozilla.org/docs/Web/HTTP/Headers/Set-Cookie#Browser_compatibility) на странице о [заголовке `Set-Cookie`](https://developer.mozilla.org/docs/Web/HTTP/Headers/Set-Cookie) в MDN.

## Примеры использования межсайтовых или сторонних файлов cookie

Существует ряд распространенных случаев и сценариев использования, когда файлы cookie необходимо пересылать в стороннем контексте. Если ваш сайт фигурирует в роли поставщика или потребителя таких файлов cookie, проследите, чтобы либо вы, либо поставщик файлов cookie обновили их для обеспечения правильной работы в будущем.

### Контент внутри элемента `<iframe>`

Контент с другого сайта, отображаемый внутри элемента `<iframe>`, считается находящимся в стороннем контексте. Ниже перечислены стандартные сценарии использования:

- Встраиваемый контент с других сайтов, например видео, карты, фрагменты кода и посты из социальных сетей.
- Виджеты сторонних сервисов: календари, формы оплаты, бронирования, резервирования столиков и т. д.
- Виджеты, при использовании которых факт наличия `<iframe>` менее очевиден, например кнопки соцсетей или сервисы защиты от мошенничества.

В таких сценариях файлы cookie могут использоваться, помимо прочего, для сохранения состояния сеанса, хранения настроек, сбора статистики или персонализации контента для пользователей с существующими аккаунтами.

<figure>{% Img src="image/tcFciHGuF3MxnTr1y5ue01OGLBn2/fTUQP4SffHHcexSipvlz.png", alt="Изображение окна браузера, в котором URL-адрес встроенного контента не совпадает с URL-адресом страницы.", width="468", height="383", style="max-width: 35vw;" %} <figcaption> Если встроенный контент загружается с сайта, отличного от основного контекста вкладки в браузере, он считается сторонним контентом. </figcaption></figure>

Кроме того, поскольку веб-страницы по своей природе являются встраиваемыми, элементы `<iframe>` используются для встраивания контента, который также может просматриваться в своем родном контексте. Любые файлы cookie, используемые сайтом внутри iframe, будут обрабатываться как сторонние. Если страницы вашего сайта рассчитаны на то, чтобы их можно было легко встраивать на сторонние сайты, и при этом их функциональность зависит от файлов cookie, вам следует пометить файлы cookie как предназначенные для межсайтового использования или обеспечить корректную работу сайта при их отсутствии.

### «Небезопасные» межсайтовые запросы

Не следует пугаться слова «небезопасные»: оно всего лишь обозначает запросы, которые могут приводить к изменению состояния. В контексте веб-страниц это относится главным образом к POST-запросам. При безопасных переходах в главном окне, например в результате нажатия ссылки, ведущей на другой сайт, файлы cookie, помеченные как `SameSite=Lax`, продолжают действовать. Однако небезопасные межсайтовые запросы, такие как отправка формы при помощи POST, не будут включать файлы cookie.

<figure>{% Img src="image/tcFciHGuF3MxnTr1y5ue01OGLBn2/vddDg7f9Gp93OgaqWwHu.png", alt="Изображение запроса при перемещении с одной страницы на другую.", width="719", height="382", style="max-width: 35vw;" %} <figcaption> Если входящий запрос выполняется с использованием «безопасного» метода, он будет включать файлы cookie. </figcaption></figure>

Это поведение используется на сайтах, которые временно перенаправляют пользователя на другой сайт с целью совершения операции (например, входа при помощи стороннего поставщика идентификации). Перед тем как пользователь покидает сайт, в его браузер устанавливается файл cookie с одноразовым токеном, а при возвращении пользователя этот токен проверяется, чтобы предотвратить атаки с [межсайтовой подделкой запросов (CSRF)](https://cheatsheetseries.owasp.org/cheatsheets/Cross-Site_Request_Forgery_Prevention_Cheat_Sheet.html). Если для возврата пользователя на сайт применяется POST-запрос, файлы cookie необходимо будет пометить как `SameSite=None; Secure`.

### Удаленные ресурсы

Когда страница загружает удаленные ресурсы (теги `<img>`, `<script>` и т. д.), ей может понадобиться передать в запросе файлы cookie. Такая потребность может возникать при использовании отслеживающих пикселей или персонализации контента.

То же самое касается запросов, инициируемых из JavaScript-кода при помощи `fetch` или `XMLHttpRequest`. Если `fetch()` вызывается с [параметром `credentials: 'include'`](https://developer.mozilla.org/docs/Web/API/Fetch_API/Using_Fetch#Sending_a_request_with_credentials_included), то высока вероятность, что в запросе будут фигурировать файлы cookie. Что касается `XMLHttpRequest`, то вам следует обратить внимание на [свойство `withCredentials`](https://developer.mozilla.org/docs/Web/API/XMLHttpRequest/withCredentials): если оно установлено в значение `true`, это также говорит о том, что в запросе, скорее всего, используются файлы cookie. Такие файлы cookie необходимо будет пометить как предназначенные для межсайтовых запросов.

### Контент внутри WebView

WebView в платформозависимых приложениях используют в качестве основы браузер; проверьте, распространяются ли на них те же проблемы и ограничения. В Android новое поведение Chrome (по состоянию на версию 84) пока **не распространяется** на WebView, но в будущем это изменится, так что вам по-прежнему следует подготовиться и проверить совместимость с ним. Кроме того, Android позволяет платформозависимым приложениям устанавливать файлы cookie напрямую, используя [CookieManager API](https://developer.android.com/reference/android/webkit/CookieManager). Как и в случае с файлами cookie, устанавливаемыми при помощи заголовков или JavaScript, используйте `SameSite=None; Secure`, если файл предназначен для межсайтового применения.

## Как реализовать `SameSite` уже сегодня

Файлы cookie, используемые только в собственном контексте, в идеале следует помечать как `SameSite=Lax` или `SameSite=Strict` в зависимости от потребностей. Вы также можете не указывать ничего, позволив браузеру использовать политику по умолчанию, однако это чревато риском несогласованного поведения между браузерами и потенциальным появлением в консоли предупреждений о каждом файле cookie.

```text
Set-Cookie: first_party_var=value; SameSite=Lax
```

Файлы cookie, используемые в сторонних контекстах, необходимо помечать как `SameSite=None; Secure`. Обратите внимание, что указывать нужно оба атрибута сразу. Если указать только `None` без `Secure`, файл cookie будет отклонен. Однако в реализациях браузеров присутствуют взаимно несовместимые различия, для обхода которых могут понадобиться способы, описанные в разделе [Работа с несовместимыми клиентами](#handling-incompatible-clients).

```text
Set-Cookie: third_party_var=value; SameSite=None; Secure
```

### Работа с несовместимыми клиентами

Поскольку решение добавить значение `None` и изменить стандартное поведение было принято относительно недавно, в различных браузерах это изменение реализовано по-разному. Со списком известных проблем можно ознакомиться на chromium.org на [странице об изменениях](https://www.chromium.org/updates/same-site/incompatible-clients), однако список может быть неполным. Хотя такая ситуация не является идеальной, в течение переходного периода можно прибегать к временным решениям. Общее правило заключается в том, чтобы обрабатывать несовместимые клиенты как особый случай, а на создавать исключения для браузеров, следующих новым правилам.

Одно из возможных решений — устанавливать файлы cookie как в новом, так и в старом формате:

```text
Set-cookie: 3pcookie=value; SameSite=None; Secure
Set-cookie: 3pcookie-legacy=value; Secure
```

Браузеры, в которых реализовано новое поведение, будут использовать файлы cookie с указанным `SameSite`. В других браузерах такие файлы могут игнорироваться или устанавливаться некорректно, но при этом будет использоваться файл cookie `3pcookie-legacy`. При обработке файлов cookie, указанных в запросе, сайт должен сначала проверить наличие файла cookie нового образца и только в случае неудачи использовать файл cookie старого формата.

Ниже показан пример реализации такого поведения на Node.js с использованием [фреймворка Express](https://expressjs.com) и его библиотеки [cookie-parser](https://www.npmjs.com/package/cookie-parser).

```javascript
const express = require('express');
const cp = require('cookie-parser');
const app = express();
app.use(cp());

app.get('/set', (req, res) => {
  // Set the new style cookie
  res.cookie('3pcookie', 'value', { sameSite: 'none', secure: true });
  // And set the same value in the legacy cookie
  res.cookie('3pcookie-legacy', 'value', { secure: true });
  res.end();
});

app.get('/', (req, res) => {
  let cookieVal = null;

  if (req.cookies['3pcookie']) {
    // check the new style cookie first
    cookieVal = req.cookies['3pcookie'];
  } else if (req.cookies['3pcookie-legacy']) {
    // otherwise fall back to the legacy cookie
    cookieVal = req.cookies['3pcookie-legacy'];
  }

  res.end();
});

app.listen(process.env.PORT);
```

Недостаток подхода заключается в том, что для обеспечения поддержки всех браузеров необходимо дублировать файлы cookie, а также вносить изменения в процесс их установки и считывания. Однако такой подход обеспечивает поддержку всех браузеров вне зависимости от их поведения, благодаря чему межсайтовые файлы cookie продолжают работать так же, как и раньше.

В качестве альтернативы можно определять версию клиента по строке User-Agent перед отправкой заголовка `Set-Cookie`. Ознакомьтесь со [списком несовместимых клиентов](https://www.chromium.org/updates/same-site/incompatible-clients), а затем воспользуйтесь подходящей для вашей платформы библиотекой, например [ua-parser-js](https://www.npmjs.com/package/ua-parser-js) для Node.js. Определение User-Agent при помощи сторонней библиотеки позволяет не тратить время на написание регулярных выражений для самостоятельного определения.

Преимущество такого подхода заключается в том, что вносить изменения требуется только в процесс установки файла cookie. Однако имейте в виду, что определение User-Agent по своей природе ненадежно и для части пользователей может давать неверный результат.

{% Aside %}

Независимо от выбранного вами решения позаботьтесь о том, чтобы у вас была возможность следить за уровнем трафика, который приходится на пользователей с файлами cookie старого образца. Установите себе напоминание, чтобы удалить из кода временное решение, как только уровень такого трафика упадет до несущественных для вашего сайта значений.

{% endAside %}

## Поддержка `SameSite=None` в различных языках, библиотеках и фреймворках

Большинство языков и библиотек поддерживают файлы cookie с атрибутом `SameSite`, однако параметр `SameSite=None` появился относительно недавно, поэтому вам потребуются временные решения для обхода стандартного поведения. Они приведены в <a href="https://github.com/GoogleChromeLabs/samesite-examples" data-md-type="link">репозитории с примерами использования `SameSite` на GitHub</a>.

## Как получить помощь

Файлы cookie применяются повсюду, и мало кто проводит на сайтах полный аудит всех мест, где они устанавливаются и используются, особенно если учитывать межсайтовые сценарии. Столкнувшись с проблемой, имейте в виду, что ваш случай может быть первым в своем роде, и не стесняйтесь обращаться за помощью:

- Сообщите о проблеме в [репозитории с примерами использования `SameSite` на GitHub](https://github.com/GoogleChromeLabs/samesite-examples).
- Задайте вопрос с [тегом «samesite» на StackOverflow](https://stackoverflow.com/questions/tagged/samesite).
- Если проблема связана с поведением Chromium, сообщите об ошибке, используя [шаблон [SameSite cookies]](https://bit.ly/2lJMd5c).
- Следите за ходом разработки Chrome на [странице обновлений `SameSite`](https://www.chromium.org/updates/same-site).

