---
title: Рекомендации по использованию форм оплаты и ввода адреса
subhead: Увеличьте количество конверсий, сделав заполнение форм оплаты и ввода адреса максимально быстрым и легким.
authors:
  - samdutton
scheduled: true
date: 2020-12-09
updated: 2021-11-30
description: Увеличьте количество конверсий, сделав заполнение форм оплаты и ввода адреса максимально быстрым и легким.
hero: image/admin/dbYeeV2PCRZNY6RRvQd2.jpg
thumbnail: image/admin/jy8z8lRuLmmnyytD5xwl.jpg
alt: Бизнесмен оплачивает покупку на ноутбуке при помощи банковской карты.
tags:
  - blog
  - forms
  - identity
  - layout
  - mobile
  - payments
  - security
  - ux
codelabs:
  - codelab-payment-form-best-practices
  - codelab-address-form-best-practices
---

{% YouTube 'xfGKmvvyhdM' %}

Продуманный дизайн онлайн-форм делает их удобнее и повышает коэффициент конверсии. Одно небольшое изменение может сыграть существенную роль.

{% Aside 'codelab' %} Если вы предпочитаете более практический подход к изучению, ознакомьтесь со следующими интерактивными уроками:

- [Рекомендации по реализации форм оплаты](/codelab-payment-form-best-practices)
- [Рекомендации по реализации форм ввода адреса](/codelab-address-form-best-practices) {% endAside %}

Вот пример простой формы оплаты, в дизайне которой реализованы все рекомендации:

{% Glitch { id: 'payment-form', path: 'index.html', height: 720 } %}

Вот пример простой формы ввода адреса, в дизайне которой реализованы все рекомендации:

{% Glitch { id: 'address-form', path: 'index.html', height: 980 } %}

## Контрольный список

- [Используйте содержательные элементы HTML](#meaningful-html): `<form>`, `<input>`, `<label>` и `<button>`.
- [Подписывайте каждое поле формы при помощи `элемента <label>`](#html-label).
- Используйте атрибуты HTML-элементов для [доступа к встроенным функциям браузера](#html-attributes), например [`type`](#type-attribute) и [`autocomplete`](#autocomplete-attribute) с соответствующими значениями.
- Избегайте использования `type="number"` для чисел, для которых не требуются стрелки увеличения и уменьшения, таких как номера банковских карт. Вместо этого используйте `type="text"` и [`inputmode="numeric"`](#inputmode-attribute).
- Если для элемента `input` , `select` или `textarea` доступно [подходящее значение autocomplete](#autocomplete-attribute), используйте это значение.
- Чтобы позволить браузерам автоматически заполнять формы, указывайте для атрибутов `name` и `id` [стабильные значения](#stable-name-id), которые будут оставаться неизменными с каждой новой загрузкой страницы или развертыванием сайта.
- [Отключайте кнопки отправки формы](#disable-submit), после того как пользователь коснется или нажмет на них.
- [Проверяйте](#validate) данные во время ввода, а не только при отправке формы.
- Используйте [гостевое оформление заказа](#guest-checkout) по умолчанию и упростите создание аккаунта после завершения оформления.
- Отображайте [ход оформления заказа](#checkout-progress) в виде четких шагов с понятными призывами к действию.
- [Ограничьте количество потенциальных точек выхода](#reduce-checkout-exits) из процесса оформления заказа, удалив лишний мусор и отвлекающие факторы.
- Перед завершением оформления заказа [отобразите полную информацию о нем](#checkout-details) и дайте пользователю возможность с легкостью ее исправить.
- [Не запрашивайте данные, которые вам не нужны](#unneeded-data).
- [Используйте единое поле ввода имени](#single-name-input), если у вас нет веских причин для его разделения.
- [Не запрещайте использование нелатинских символов](#unicode-matching) в именах и логинах.
- [Предусмотрите поддержку различных форматов адресов](#address-variety).
- Рассмотрите возможность использования [единого элемента `textarea` для ввода адреса](#address-textarea).
- Используйте [автозаполнение адреса выставления счета](#billing-address).
- При необходимости [выполняйте интернационализацию и локализацию](#internationalization-localization).
- Старайтесь избегать [поиска адреса по почтовому индексу](#postal-code-address-lookup).
- Используйте [соответствующие значения атрибута autocomplete для полей ввода данных банковской карты](#payment-form-autocomplete).
- Используйте [единое (не разделенное на части) поле ввода номера банковской карты](#single-number-input).
- [Избегайте использования нестандартных элементов](#avoid-custom-elements), если они мешают работе автозаполнения.
- [Выполняйте тестирование как в «полевых», так и в лабораторных условиях](#analytics-rum), используя средства аналитики страниц, аналитики взаимодействия и измерения производительности у реальных пользователей.
- [Выполняйте тестирование на различных браузерах, устройствах и платформах](#test-platforms).

{% Aside %} Эта статья содержит рекомендации по реализации форм оплаты и ввода адреса на стороне фронтенда. Она не затрагивает тему реализации на сайте транзакций. Подробнее о том, как добавить на сайт поддержку платежей, см. в разделе [Веб-платежи](/payments). {% endAside %}

## Используйте содержательный HTML-код {: #meanful-html}

Используйте специализированные элементы и атрибуты:

- `<form>`, `<input>`, `<label>` и `<button>`
- `type`, `autocomplete` и `inputmode`

Они позволяют использовать встроенную функциональность браузера, повышают доступность и делают разметку более осмысленной.

### Используйте HTML-элементы по назначению {: #html-elements}

#### Размещайте формы внутри элемента <form> {: #html-form}

При создании формы у вас может возникнуть желание не оборачивать элементы `<input>` в `<form>` и обрабатывать отправку данных исключительно с помощью JavaScript.

Не следует так делать.

HTML-элемент `<form>` предоставляет доступ к мощному набору встроенных функций во всех современных браузерах, а также может помочь сделать сайт доступным для программ чтения с экрана и других вспомогательных технологий. Кроме того, элемент `<form>` упрощает реализацию базовой функциональности для старых браузеров с ограниченной поддержкой JavaScript и позволяет отправлять форму даже тогда, когда в коде содержится ошибка или у пользователя отключен JavaScript.

Если у вас на странице больше одного компонента для пользовательского ввода, разместите каждый из них в отдельном элементе `<form>`. Например, если на странице есть формы поиска и регистрации, для каждой из них следует использовать отдельный элемент `<form>`.

#### Используйте `<label>` для отображения подписей к элементам {: #html-label}

Для указания подписей к элементам `<input>`, `<select>` и `<textarea>` используйте элемент [`<label>`](https://developer.mozilla.org/docs/Web/HTML/Element/label).

В атрибуте `for` элемента «label» следует указывать `id` соответствующего элемента ввода, чтобы связать их друг с другом.

```html
<label for="address-line1">Address line 1</label>
<input id="address-line1" …>
```

Каждой подписи должен соответствовать один элемент ввода; не используйте одну подпись для обозначения нескольких элементов. Таким образом вы сможете обеспечить лучшую совместимость с браузерами и программами чтения с экрана, поскольку нажатие или касание подписи перемещает фокус к соответствующему элементу ввода, а программы чтения с экрана зачитывают подпись, когда либо *элемент ввода*, либо сама *подпись* попадает в фокус.

{% Aside 'caution' %} Не используйте [заполнители вместо подписей](https://www.smashingmagazine.com/2018/06/placeholder-attribute/). Как только пользователь начинает вводить в поле ввода текст, заполнитель исчезает, поэтому можно легко забыть, для чего предназначено поле. По той же причине не следует использовать заполнители для отображения формата значений, таких как даты. Особенно неудобным это может быть для пользователей телефонов, в частности если они отвлечены или находятся в состоянии напряжения. {% endAside %}

#### Делайте кнопки удобными {: #html-button}

Используйте для кнопок специализированные элементы, такие как [`<button>`](https://developer.mozilla.org/docs/Web/HTML/Element/button) или `<input type="submit">`: они совместимы со вспомогательными технологиями, предоставляют встроенную функциональность отправки формы, а также поддерживают легкую стилизацию. Избегайте использования элементов, не предназначенных для кнопок, таких как `div`.

Кнопки отправки формы должны иметь подписи, отражающие их функцию. В ходе оформления заказа отображайте ясные призывы к действию, дающие пользователю понять, на каком этапе он находится и каким будет следующий этап. Например, для кнопки отправки формы, запрашивающей адрес доставки, используйте подпись **Перейти к оплате**, а не **Продолжить** или **Сохранить**.

{: #disable-submit}

Кнопки отправки формы рекомендуется деактивировать при нажатии или касании, особенно если форма предназначена для выполнения оплаты или размещения заказа. Многие пользователи нажимают на кнопки по несколько раз подряд, даже если кнопка работает нормально. Это может приводить к проблемам при оформлении заказа и увеличивать нагрузку на сервер.

В то же время не отключайте кнопки отправки формы, когда она ожидает верного ввода. Например, кнопку **Сохранить адрес** не следует делать неактивной, даже если некоторые поля не заполнены или заполнены неверно. Это лишь собьет пользователя с толку: после нескольких попыток нажать на кнопку он может прийти к выводу, что она сломана. Вместо этого пользователю, попытавшемуся отправить неверно заполненную форму, следует сообщать, где он ошибся и как это исправить. Это особенно важно на мобильных устройствах, где процесс ввода данных затруднен и к моменту отправки формы неверно заполненное поле уже может находиться за пределами экрана.

{% Aside 'caution' %} По умолчанию кнопки, размещенные внутри формы, имеют тип `submit`. Если нужно добавить кнопку другого типа (например, для команды **Показать пароль**), используйте `type="button"`. В противном случае нажатие на кнопку будет приводить к отправке формы.

Когда фокус находится на любом поле формы, нажатие клавиши `Enter` имитирует щелчок первой кнопки с типом `submit`, являющейся частью этой формы. Если перед **кнопкой отправки** разместить в пределах той же формы другую кнопку с неуказанным типом, то именно она при отправке формы будет получать событие клика, так как по умолчанию ей будет присвоен тип `submit`. Пример смотрите в нашей [демонстрации](https://enter-button.glitch.me/): заполните форму, а затем нажмите `Enter`. {% endAside %}

### Используйте HTML-атрибуты по максимуму {: #html-attributes}

#### Упрощайте ввод данных для пользователей

{: #type-attribute}

Указывайте для полей ввода подходящее значение [атрибута `type`](https://developer.mozilla.org/docs/Web/HTML/Element/input/email), чтобы предоставлять на мобильных устройствах нужный тип клавиатуры, а также активировать базовую функциональность валидации, встроенную в браузер.

Например, для адресов электронной почты используйте `type="email"`, а для номеров телефона — `type="tel"`.

<figure>{% Img src="image/tcFciHGuF3MxnTr1y5ue01OGLBn2/bi7J9Z1TLP4IsQLyhbQm.jpg", alt="Скриншоты двух типов клавиатур на Android-телефоне: для ввода электронного адреса (type=email) и для ввода номера телефона (type=tel).", width="800", height="683" %} <figcaption>Клавиатуры для ввода электронного адреса и для ввода телефона.</figcaption></figure>

{: #inputmode-attribute}

{% Aside 'warning' %} При использовании type="number" в поле отображаются стрелки для увеличения и уменьшения числа, которые при вводе таких данных, как номера телефонов, платежных карт или банковских счетов, не являются уместными.

Для ввода таких чисел следует использовать `type="text"` (или вообще не указывать этот атрибут, поскольку `text` используется по умолчанию). Для ввода телефонных номеров используйте `type="tel"`, чтобы на мобильных устройствах отображалась соответствующая клавиатура. Для других чисел используйте `inputmode="numeric"`, чтобы на мобильных устройствах отображалась цифровая клавиатура.

На некоторых сайтах для ввода номера банковской карты с цифровой клавиатуры по-прежнему используется `type="tel"`, но в связи с [широким распространением поддержки](https://caniuse.com/input-inputmode) `inputmode` в этом больше нет необходимости (однако не пренебрегайте проверкой браузера пользователя). {% endAside %}

{: #avoid-custom-elements}

Для ввода даты избегайте использования нестандартных элементов `select`: они нарушают работу автозаполнения, если реализованы неправильно, и кроме того не работают в устаревших браузерах. Для ввода чисел, таких как год рождения, рекомендуется использовать `input`, а не `select`, поскольку вводить цифры вручную зачастую проще и надежнее, чем выбирать из длинного списка (особенно на мобильных устройствах). Для отображения на мобильных устройствах подходящего типа клавиатуры используйте `inputmode="numeric"`, а для того, чтобы обеспечить соблюдение формата, используйте валидацию и отображайте подсказки в виде заполнителей или внешнего текста.

{% Aside %} Элемент [`datalist`](https://developer.mozilla.org/docs/Web/HTML/Element/datalist) позволяет пользователю выбирать варианты из списка и отображает подсказки по мере ввода текста. По адресу [simpl.info/datalist](https://simpl.info/datalist) доступна демонстрация `datalist` в сочетании с элементами `text`, `range` и `color`. По адресу [datalist-select.glitch.me](https://datalist-select.glitch.me) можно сравнить реализацию ввода даты рождения на основе `select` и на основе комбинации элементов `input` и `datalist`. {% endAside %}

#### Используйте автозаполнение, чтобы повысить доступность и сократить необходимость в повторном вводе данных {: #autocomplete-attribute}

Указывайте верные значения `autocomplete`, чтобы позволить браузеру безопасно сохранять данные и автоматически заполнять поля `input`, `select` и `textarea` в целях экономии усилий пользователя. Это особенно важно для пользователей мобильных устройств и играет первостепенную роль в снижении [коэффициента незаполненных форм](https://www.zuko.io/blog/8-surprising-insights-from-zukos-benchmarking-data), а также существенно [повышает доступность](https://www.w3.org/WAI/WCAG21/Understanding/identify-input-purpose.html).

Если для поля формы доступно подходящее значение «autocomplete», используйте это значение. В [веб-документации MDN](https://developer.mozilla.org/docs/Web/HTML/Attributes/autocomplete) перечислены все допустимые значения, а также приводятся пояснения об их использовании.

{: #stable-name-id}

{% Aside %} Чтобы автозаполнение форм в браузерах работало еще лучше, в дополнение к атрибуту «autocomplete» следует указывать для полей форм [стабильные значения](#stable-name-id) атрибутов `name` и `id`, остающиеся неизменными с каждой новой загрузкой страницы или развертыванием сайта. {% endAside %}

{: #billing-address}

По умолчанию в качестве адреса выставления счета следует использовать адрес доставки. Чтобы сократить визуальную зашумленность, не отображайте адрес выставления счета в самой форме, а укажите ссылку для его редактирования (или используйте [элементы `summary` и `details`](https://simpl.info/details/)).

<figure>{% Img src="image/tcFciHGuF3MxnTr1y5ue01OGLBn2/TIan7TU8goyoOXwLPYyd.png", alt="Пример страницы оформления заказа со ссылкой, позволяющей изменить адрес выставления счета.", width="800", height="250" %} <figcaption>Добавьте ссылку для редактирования платежной информации.</figcaption></figure>

Как и в случае с адресом доставки, для полей адреса выставления счета следует указывать соответствующие значения атрибута «autocomplete», чтобы пользователю не приходилось вводить данные повторно. Если поля ввода в разных разделах имеют одинаковое название, но разные значения, то для их разграничения добавьте в начало атрибута «autocomplete» дополнительное слово.

```html
<input autocomplete="shipping address-line-1" ...>
...
<input autocomplete="billing address-line-1" ...>
```

#### Помогайте пользователям указывать верные данные {: #validation}

Когда клиенты допускают ошибки, старайтесь не отталкивать их замечаниями. Вместо этого помогайте им исправлять ошибки по мере их появления, чтобы сделать процесс заполнения формы быстрым и легким. Оформляя заказ, клиент пытается приобрести у вашей компании продукт или услугу, и ваша задача — помочь ему, а не наказать его.

Элементы формы поддерживают [атрибуты валидации](https://developer.mozilla.org/docs/Web/Guide/HTML/HTML5/Constraint_validation#Intrinsic_and_basic_constraints), такие как `min`, `max` и `pattern`, при помощи которых можно указывать допустимые значения. [Состояние валидации](https://developer.mozilla.org/docs/Web/API/ValidityState) элемента устанавливается автоматически в зависимости от того, имеет ли он допустимое значение; то же касается и CSS-псевдоклассов `:valid` и `:invalid`, которые можно использовать для стилизации элементов в зависимости от состояния валидации.

Например, приведенный ниже HTML-код создает элемент ввода, позволяющий указать год рождения от 1900 до 2020. Атрибут `type="number"` разрешает ввод только числовых значений, а `min` и `max` ограничивают их диапазон. Если попытаться ввести число за пределами диапазона, элемент ввода будет помечен как имеющий недопустимое значение.

{% Glitch { id: 'constraints', path: 'index.html', height: 170 } %}

В следующем примере `pattern="[\d ]{10,30}"` используется для проверки правильности номера банковской карты с возможностью использования пробелов:

{% Glitch { id: 'payment-card-input', path: 'index.html', height: 170 } %}

Современные браузеры также выполняют базовую валидацию для элементов ввода с типом `email` или `url`.

{% Glitch { id: 'type-validation', path: 'index.html', height: 250 } %}

{% Aside %} Чтобы выполнять валидацию нескольких электронных адресов, введенных в одном поле через запятые, добавьте к элементу ввода `type="email"` атрибут `multiple`. {% endAside %}

При попытке отправить форму браузер автоматически выделяет поля с отсутствующими или неверно указанными значениями. Использование JavaScript не требуется.

<figure>{% Img src="image/tcFciHGuF3MxnTr1y5ue01OGLBn2/mPyN7THWJNRQIiBezq6l.png", alt="Скриншот формы входа в Chrome на ПК, отображающий предупреждение и выделение поля в связи с неверно указанным электронным адресом.", width="500", height="483" %} <figcaption>Базовая валидация при помощи встроенных средств браузера.</figcaption></figure>

Проверяйте данные и предоставляйте пользователю отклик непосредственно во время ввода, а не отображайте список ошибок после нажатия кнопки отправки. Если данные необходимо проверять на сервере после отправки формы, то после проверки перечисляйте все обнаруженные ошибки и четко выделяйте все неверно заполненные поля формы, а также отображайте рядом с каждым из них рекомендации по исправлению. Проверяйте журналы сервера и данные аналитики на предмет часто совершаемых ошибок: они могут указывать на необходимость изменения дизайна формы.

Рекомендуется также использовать JavaScript для обеспечения более надежной валидации как во время ввода, так и при отправке формы. Используйте [Constraint Validation API](https://html.spec.whatwg.org/multipage/forms.html#constraints) ([широко поддерживающийся](https://caniuse.com/#feat=constraint-validation) в браузерах) для реализации нестандартной валидации с выделением полей и отображением подсказок при помощи встроенных средств браузера.

Дополнительные сведения см. в статье [Использование JavaScript для более сложной проверки в реальном времени](https://developers.google.com/web/fundamentals/design-and-ux/input/forms#use_javascript_for_more_complex_real-time_validation).

{% Aside 'warning' %} Даже если вы применяете на стороне клиента валидацию и ограничения на ввод данных, необходимо позаботиться, чтобы обмен данными с пользователями был безопасно реализован на стороне бэкенда. Никогда не доверяйте данным, поступающим от пользователей, так как они могут быть вредоносными. Подробности см. в статье [OWASP Input Validation Cheat Sheet](https://cheatsheetseries.owasp.org/cheatsheets/Input_Validation_Cheat_Sheet.html). {% endAside %}

#### Помогайте пользователям указывать все необходимые данные {: #required}

Чтобы пометить поле ввода как обязательное для заполнения, используйте [атрибут `required`](https://developer.mozilla.org/docs/Web/HTML/Attributes/required).

При попытке отправки формы [современные браузеры](https://caniuse.com/mdn-api_htmlinputelement_required) автоматически устанавливают фокус на незаполненные поля с атрибутом `required` и показывают сообщения об ошибках. При помощи [псевдокласса `:required`](https://caniuse.com/?search=required) незаполненные поля можно подсвечивать без использования JavaScript.

Пометьте подписи обязательных полей звездочками и разместите пояснение в начале формы.

## Упростите оформление заказа {: #checkout-forms}

### Учитывайте разрыв в мобильной коммерции {: #m-commerce-gap}

Представьте, что у ваших пользователей есть *лимит утомления*. Как только он достигнут, пользователь уходит с сайта.

Старайтесь минимизировать помехи и поддерживать интерес пользователя, особенно на мобильных устройствах. Многие сайты получают больше *трафика* с мобильных устройств, но при этом имеют более высокий *процент конверсии* на ПК — это явление называется [разрывом в мобильной коммерции](https://www.comscore.com/Insights/Presentations-and-Whitepapers/2017/Mobiles-Hierarchy-of-Needs). Некоторые покупатели попросту предпочитают совершать покупки с компьютера, однако низкий процент конверсии с мобильных устройств может также быть обусловлен низким уровнем удобства. Ваша задача — *минимизировать* потерянные конверсии на мобильных устройствах и *максимизировать* конверсии на ПК. [Согласно исследованиям](https://www.comscore.com/Insights/Presentations-and-Whitepapers/2017/Mobiles-Hierarchy-of-Needs), удобство при заполнении мобильных форм можно значительно повысить.

В первую очередь имейте в виду, что пользователи чаще бросают заполнение форм, если они кажутся длинными, сложными или запутанными, — особенно когда пользователь торопится, отвлекается на что-то или использует устройство с маленьким экраном. Поэтому старайтесь запрашивать как можно меньше данных.

### Используйте гостевое оформление заказа по умолчанию {: #guest-checkout}

Самый простой способ минимизировать помехи при заполнении формы в интернет-магазине — это использовать гостевое оформление заказа по умолчанию. Не заставляйте пользователей создавать аккаунт перед покупкой. Отсутствие возможности оформить заказ от имени гостя считается одной из главных причин возникновения брошенных корзин.

<figure>{% Img src="image/tcFciHGuF3MxnTr1y5ue01OGLBn2/a7OQLnCRb0FZglj07N7z.png", alt="Причины возникновения брошенных корзин при оформлении заказа.", width="800", height="503" %} <figcaption>Источник: <a href="https://baymard.com/checkout-usability">baymard.com/checkout-usability</a></figcaption></figure>

Предложить пользователю зарегистрировать аккаунт можно после окончания оформления заказа. К этому моменту у вас уже есть большая часть данных, необходимых для создания аккаунта, так что процесс регистрации можно сделать быстрым и легким.

{% Aside 'gotchas' %} Если вы предлагаете пользователю зарегистрироваться после оформления заказа, не забудьте связать с новым аккаунтом только что сделанную покупку. {% endAside %}

### Отображайте ход оформления заказа {: #checkout-progress}

Процесс оформления заказа можно сделать субъективно менее сложным, если отображать ход его оформления и помогать пользователю четкими инструкциями. На видео ниже показано, как это реализовала британская розничная сеть [johnlewis.com](https://www.johnlewis.com).

<figure> {% Video src="video/tcFciHGuF3MxnTr1y5ue01OGLBn2/6gIb1yWrIMZFiv775B2y.mp4", controls=true, autoplay=true, muted=true, poster="image/tcFciHGuF3MxnTr1y5ue01OGLBn2/ViftAUUUHr4TDXNec0Ch.png", playsinline=true %} <figcaption>Отображайте ход оформления заказа.</figcaption></figure>

Старайтесь поддерживать интерес пользователя. На каждом этапе, приближающем пользователя к оплате, используйте четкие заголовки страниц и названия кнопок, дающие понять, что требуется от пользователя и каким будет следующий этап оформления заказа.

<figure>
   <video controls autoplay loop muted>
     <source src="https://samdutton.com/address-form-save.mp4" type="video/mp4">
   </source></video>
  <figcaption>Давайте кнопкам формы осмысленные подписи, которые четко обозначают следующий шаг.</figcaption></figure>

Указывайте для элементов ввода атрибут `enterkeyhint`, позволяющий задавать подпись клавиши Enter на мобильной клавиатуре. Например, можно использовать `enterkeyhint="previous"` и `enterkeyhint="next"` в многостраничных формах, `enterkeyhint="done"` — для последнего поля ввода в форме, а `enterkeyhint="search"` — для поля ввода поиска.

<figure> {% Img src="image/tcFciHGuF3MxnTr1y5ue01OGLBn2/QoY8Oynpw0CqjPACtCdG.png", alt="Два скриншота формы ввода адреса на Android, иллюстрирующие изменение значка кнопки Enter под влиянием атрибута enterkeyhint.", width="800", height="684" %} <figcaption>Кнопки Enter на Android: «next» и «done».</figcaption></figure>

Атрибут `enterkeyhint` [поддерживается на Android и iOS](https://caniuse.com/mdn-html_global_attributes_enterkeyhint). Подробности см. в [описании enterkeyhint](https://github.com/dtapuska/enterkeyhint).

{: #checkout-details}

Позвольте пользователям с легкостью перемещаться между этапами оформления заказа и изменять его параметры, даже находясь на заключительном этапе оплаты. Отображайте полную информацию о заказе, а не только краткое описание. Дайте пользователям возможность легко изменять со страницы оплаты количество товаров. Ваша задача — сделать так, чтобы во время оформления заказа ничто не помешало достижению конверсии.

### Избавьтесь от отвлекающих факторов {: #reduce-checkout-exits}

Ограничьте потенциальные точки выхода, избавившись от визуального мусора и отвлекающих факторов, таких как реклама продуктов. Многие успешные магазины не отображают при оформлении заказа даже поле поиска и элементы навигации.

<figure>{% Img src="image/tcFciHGuF3MxnTr1y5ue01OGLBn2/UR97R2LqJ5MRkL5H4V0U.png", alt="Два скриншота, отображающие ход оформления заказа в мобильной версии johnlewis.com. Поиск, навигация и другие отвлекающие факторы не показываются.", width="800", height="683" %} <figcaption>Поиск, навигация и другие отвлекающие факторы скрыты со страницы оформления заказа.</figcaption></figure>

Не давайте пользователю отклониться от курса. В момент оформления заказа не следует предлагать пользователю что-либо еще.

<figure>{% Img src="image/tcFciHGuF3MxnTr1y5ue01OGLBn2/lKJwd5e2smBfDjNxV22N.jpg", alt="Скриншот мобильной страницы оформления заказа, на которой отображается навязчивая реклама с текстом «FREE STICKERS».", width="350", height="735" %} <figcaption>Не отвлекайте клиентов от завершения покупки.</figcaption></figure>

Для пользователей, заходящих повторно, вы можете еще сильнее упростить процесс оформления заказа, сократив объем лишних данных. Например, отображайте адрес доставки в виде обычного текста (а не формы) и укажите ссылку для его изменения.

<figure>{% Img src="image/tcFciHGuF3MxnTr1y5ue01OGLBn2/xEAYOeEFYhOZLaB2aeCY.png", alt="Скриншот раздела подтверждения данных на странице оформления заказа. Данные отображаются в виде обычного текста; рядом видны ссылки для изменения адреса доставки, способа оплаты и адреса выставления счета, которые не отображаются на странице.", width="450", height="219" %} <figcaption>Скрывайте данные, которые не требуется отображать клиентам.</figcaption></figure>

## Упростите ввод имени и адреса {: #address-forms}

### Запрашивайте только те данные, которые вам нужны {: #unneeded-data}

Прежде чем приступить к созданию форм ввода имени и адреса, определитесь с тем, какие данные вам нужны. Не запрашивайте ничего лишнего! Самый простой способ сделать форму менее сложной — это избавиться от ненужных полей. Это также повышает конфиденциальность пользователей, снижает расходы на хранение данных на серверах и сокращает объем обязательств.

### Используйте для ввода имени единое поле {: #single-name-input}

Позвольте пользователям указывать имя при помощи единого поля, если у вас нет весомой причины хранить имена, фамилии, отчества и другие части имени по отдельности. Использование единого поля для ввода имени делает форму проще, позволяет вставлять имя из буфера обмена и облегчает автозаполнение.

В особенности избегайте использования отдельного поля для указания приставки к имени, такой как «господин» или «доктор», если у вас нет для этого веской причины. При необходимости пользователи смогут указать приставку вместе с именем. Кроме того, параметр автозаполнения `honorific-prefix` в настоящее время не работает в большинстве браузеров, поэтому для большинства пользователей наличие такого поля приведет к проблемам при автозаполнении формы ввода адреса.

### Используйте автозаполнение имени

Для автозаполнения полного имени используйте `name`:

```html
<input autocomplete="name" ...>
```

Если у вас есть весомая причина запрашивать разные части имени по отдельности, используйте соответствующие значения autocomplete:

- `honorific-prefix`
- `given-name`
- `nickname`
- `additional-name-initial`
- `additional-name`
- `family-name`
- `honorific-suffix`

### Разрешите ввод имен на любых языках {: #unicode-matching}

При вводе имен есть смысл выполнять их валидацию или ограничивать допустимые символы, однако старайтесь обеспечить поддержку как можно более широкого набора систем письменности. Пользователю будет неприятно услышать, что его имя «неправильное».

При валидации избегайте использования регулярных выражений, рассчитанных только на латиницу, поскольку имя или адрес пользователя может содержать нелатинские символы. Вместо этого используйте определение букв Unicode — и обеспечьте на стороне бэкенда безопасную поддержку как ввода, так и вывода Unicode-строк. Регулярные выражения с Unicode поддерживаются всеми современными браузерами.

{% Compare 'worse' %}

```html
<!-- Имена с нелатинскими символами (например, «Françoise» или «Jörg») не пройдут валидацию. -->
<input pattern="[\w \-]+" ...>
```

{% endCompare %}

{% Compare 'better' %}

```html
<!-- Поле принимает буквы Unicode. -->
<input pattern="[\p{L} \-]+" ...>
```

{% endCompare %}

<figure>
   <video controls autoplay loop muted>
     <source src="https://samdutton.com/unicode-letter-matching.mp4" type="video/mp4">
   </source></video>
  <figcaption>Сравнение распознавания букв Unicode с распознаванием только латинских букв.</figcaption></figure>

{% Aside %} Подробнее об [интернационализации и локализации](#internationalization-localization) рассказывается ниже, однако старайтесь проектировать формы ввода с учетом имен, распространенных в регионах проживания всех ваших пользователей. Например, для японских имен есть смысл добавить поле, позволяющее указать фонетическую формы имени. Это поможет сотрудникам службы поддержки правильно произносить имя клиента при разговоре по телефону. {% endAside %}

### Предусмотрите поддержку различных форматов адресов {: #address-variety}

При проектировании формы ввода адреса помните, что форматы адресов могут сильно различаться даже в пределах одной страны. Не делайте предположений о том, как должен выглядеть «обычный» адрес. (Взгляните на статью о [странных адресах в Великобритании](http://www.paulplowman.com/stuff/uk-address-oddities/), если не верите!)

#### Делайте формы ввода адреса гибкими {:flexible-address}

Не заставляйте пользователей пытаться втиснуть адрес в поля формы, которые для него не подходят.

Например, не требуйте указания номера дома и названия улицы в отдельных полях, поскольку многие адреса не используют такой формат и автозаполнение в браузере может не сработать из-за отсутствия нужных данных.

Будьте особенно осторожны при использовании атрибута `required` для полей ввода адреса. Например, в Великобритании крупные города не являются частью графства, однако многие сайты несмотря на это заставляют пользователей его указывать.

Использование двух полей, позволяющих указать адрес в произвольном формате, подойдет для различных видов адресов.

```html
<input autocomplete="address-line-1" id="address-line1" ...>
<input autocomplete="address-line-2" id="address-line2" ...>
```

Добавьте соответствующие ярлыки:

```html/0-2,5-7
<label for="address-line-1">
Address line 1 (or company name)
</label>
<input autocomplete="address-line-1" id="address-line1" ...>

<label for="address-line-2">
Address line 2 (optional)
</label>
<input autocomplete="address-line-2" id="address-line2" ...>
```

Вы можете попробовать такую форму в действии, создав копию демонстрации, приведенной ниже, и отредактировав ее.

{% Aside 'caution' %} Согласно исследованиям, [использование **двух полей для ввода адреса** может сбивать пользователей с толку](https://baymard.com/blog/address-line-2). Помните об этом при проектировании формы ввода адреса — возможно, есть смысл использовать альтернативные варианты, такие как единое поле `textarea` (см. ниже) или иные способы ввода. {% endAside %}

#### Рассмотрите возможность использования единого элемента textarea для ввода адреса {: #address-textarea}

Самый гибкий способ ввода адреса — это единое поле `textarea`.

Поле `textarea` подходит для адресов любого формата и позволяет с легкостью вставлять адрес из буфера обмена — однако имейте в виду, что оно может не подходить под ваши требования к вводимым данным; кроме того, у пользователей может не сработать автозаполнение, если раньше они использовали только формы с полями `address-line1` и `address-line2`.

В качестве значения autocomplete для поля textarea используйте `street-address`.

Вот пример формы, демонстрирующей использование единого поля `textarea` для ввода адреса:

{% Glitch { id: 'address-form', path: 'index.html', height: 980 } %}

#### Проектируйте формы ввода адреса с учетом интернационализации и локализации {: #internationalization-localization}

В зависимости от того, в каких странах находятся ваши пользователи, при реализации форм ввода адреса особенно важно учитывать [интернационализацию и локализацию](https://www.smashingmagazine.com/2020/11/internationalization-localization-static-sites/).

Имейте в виду, что даже в рамках одного и того же языка могут использоваться не только различные форматы адреса, но и различные названия одних и тех же элементов.

```text
    ZIP code: США
 Postal code: Канада
    Postcode: Великобритания
     Eircode: Ирландия
         PIN: Индия
```

Пользователь может испытывать раздражение или недоумение, сталкиваясь с формой, которая не подходит для его адреса или использует не те слова, к которым он привык.

Формы ввода адреса на сайте могут потребовать адаптации [для различных локализаций](https://www.smashingmagazine.com/2020/11/internationalization-localization-static-sites#determining-user-s-language-and-region), но в некоторых случаях достаточно просто сделать форму как можно более гибкой (как описано выше). Если вы решили обойтись без локализации форм ввода адреса, примите во внимание следующие ключевые принципы, которые позволят обеспечить поддержку различных видов адресов:

- Избегайте излишней конкретики в отношении частей адреса. Например, не следует запрашивать название улицы или номер дома.
- По возможности старайтесь не помечать поля как `required`. Во многих странах адреса не имеют почтового индекса, а адреса в сельской местности могут не иметь названий улиц.
- Используйте именование, охватывающее как можно более широкий круг пользователей: «Страна/регион», а не «Страна»; «ZIP-код/почтовый индекс», а не «ZIP-код».

Стремитесь к высокому уровню гибкости. Приведенный выше [пример простой формы ввода адреса](#address-textarea) может быть адаптирован для пользователей из различных регионов.

#### Учитывайте недостатки поиска адреса по почтовому индексу {: #postal-code-address-lookup}

Некоторые сайты используют сервисы поиска адресов по почтовому индексу или ZIP-коду. В некоторых случаях это уместно, однако вам нужно учитывать потенциальные недостатки.

Поиск адреса по индексу работает не во всех странах, а в некоторых регионах к одному почтовому индексу может принадлежать большое количество адресов.

<figure>
   <video controls autoplay loop muted>
     <source src="https://samdutton.com/long-list-of-addresses.mp4" type="video/mp4">
   </source></video>
  <figcaption>Одному почтовому индексу может соответствовать множество адресов.</figcaption></figure>

Пользователям трудно выбирать адреса из длинного списка, особенно если они просматривают страницу с мобильного устройства, находясь в спешке или в напряженном состоянии. В такой ситуации будет проще и надежнее воспользоваться автозаполнением, чтобы в одно касание или нажатие вставить адрес в форму.

<figure>
   <video controls autoplay loop muted>
     <source src="https://samdutton.com/full-name-autofill.mp4" type="video/mp4">
   </source></video>
  <figcaption>Единое поле ввода позволяет заполнять адрес в одно касание (или нажатие).</figcaption></figure>

## Упрощайте формы оплаты {: #general-guidelines}

Форма оплаты — это наиболее важная часть процесса оформления заказа. Плохой дизайн формы оплаты — [одна из распространенных причин возникновения брошенных корзин](https://www.comscore.com/Insights/Presentations-and-Whitepapers/2017/Mobiles-Hierarchy-of-Needs). Необходимо [внимание к мелочам](https://en.wikipedia.org/wiki/The_devil_is_in_the_detail#cite_note-Titelman-1): даже мелкие неполадки могут отбить у пользователя желание совершать покупку, особенно на мобильных устройствах. Ваша задача — проектировать формы таким образом, чтобы процесс ввода данных был максимально легким.

### Не заставляйте пользователей вводить платежную информацию вручную {: #payment-form-autocomplete}

Поля для ввода данных банковской карты, таких как номер, имя держателя и срок действия, должны использовать соответствующие значения атрибута `autocomplete`:

- `cc-number`
- `cc-name`
- `cc-exp-month`
- `cc-exp-year`

Это позволяет браузерам безопасно сохранять данные банковских карт и автоматически вставлять их при заполнении форм. Отсутствие автозаполнения может приводить к тому, что пользователи будут хранить данные карты в физическом виде или в виде небезопасной копии на устройстве.

{% Aside 'caution' %} Не заставляйте пользователя выбирать тип банковской карты, так как его всегда можно определить по ее номеру. {% endAside %}

### Избегайте использования нестандартных элементов для ввода срока действия карты

Неправильно спроектированные [нестандартные элементы](https://developer.mozilla.org/docs/Web/Web_Components/Using_custom_elements) могут нарушать работу автозаполнения и тем самым создавать помехи при оплате, а также не поддерживаются устаревшими браузерами. Если автоматическое заполнение данных банковской карты срабатывает для всех полей, но не для поля срока действия, использующего нестандартный элемент, пользователю придется смотреть его на самой карте, что с большой вероятностью отобьет у него желание совершать покупку. Поэтому предпочтительнее использовать стандартные HTML-элементы с соответствующим стилем.

<figure> {% Img src="image/tcFciHGuF3MxnTr1y5ue01OGLBn2/1LIQm2Jt5PHxN0I7tni3.jpg", alt="Скриншот формы оплаты с нестандартными элементами ввода срока действия, мешающими работе автозаполнения.", width="800", height="916" %} <figcaption>Автозаполнение сработало для всех полей — за исключением срока действия карты.</figcaption></figure>

### Используйте единое поле для ввода номеров телефона и банковских карт {: #single-number-input}

Для ввода номеров телефона и банковских карт используйте единое поле; не разбивайте номер на части. Это упрощает процесс ввода данных и их валидацию, а также позволяет использовать автозаполнение в браузере. Это же справедливо и для других числовых данных, таких как PIN-коды и защитные коды карт.

<figure> {% Img src="image/tcFciHGuF3MxnTr1y5ue01OGLBn2/7cUwamPstwSQTlbmQ4CT.jpg", alt="Скриншот формы оплаты. Поле номера банковской карты разбито на четыре элемента ввода.", width="800", height="833" %} <figcaption>Не используйте раздельные поля для ввода номера банковской карты.</figcaption></figure>

### Будьте аккуратны при валидации ввода {: #validate}

Валидацию вводимых данных необходимо выполнять как в реальном времени, так и перед отправкой формы. Один из способов заключается в том, чтобы указать для поля ввода номера карты атрибут `pattern`. Если пользователь попытается отправить форму оплаты с неверно указанным значением, браузер покажет предупреждение и установит фокус на поле ввода. Использование JavaScript не требуется.

{% Glitch { id: 'payment-card-input', path: 'index.html', height: 170 } %}

Однако регулярное выражение, указанное в атрибуте `pattern`, должно быть достаточно гибким, чтобы обрабатывать [номера банковских карт различной длины](https://github.com/jaemok/credit-card-input/blob/master/creditcard.js#L35): от 14 (или менее) до 20 (или более) цифр. Подробнее о структуре номеров банковских карт можно узнать в [LDAPwiki](https://ldapwiki.com/wiki/Bank%20Card%20Number).

Разрешите пользователям вводить номера карт через пробелы, поскольку именно в таком виде они указываются на физической карте. Это снизит вероятность оттолкнуть пользователя (вам не придется сообщать ему, что он допустил ошибку) и уменьшает число помех в процессе конверсии; кроме того, удаление пробелов при обработке номера является тривиальной задачей.

{% Aside %} Для подтверждения оплаты или личности пользователя целесообразно использовать одноразовые коды, однако ручной ввод кода из электронного письма или SMS-сообщения — это трудоемкий и ненадежный процесс. О том, как правильно запрашивать одноразовые коды, можно узнать в статье [Рекомендации по использованию форм с SMS OTP](/sms-otp-form). {% endAside %}

## Тестируйте форму на различных версиях устройств, платформ и браузеров {: #test-platform}

Формы оплаты и ввода адреса особенно важно тестировать на платформах, которые чаще всего встречаются у ваших пользователей, поскольку функциональность и внешний вид элементов форм могут различаться, а отличия в размерах области просмотра могут приводить к проблемам с позиционированием. Сервис BrowserStack [бесплатное тестирование на различных устройствах и браузерах](https://www.browserstack.com/open-source) для проектов с открытым исходным кодом.

<figure>{% Img src="image/tcFciHGuF3MxnTr1y5ue01OGLBn2/Uk7WhpDMuHtvjmWlFnJE.jpg", alt="Скриншоты формы оплаты с сайта payment-form.glitch.me на iPhone 7 и 11. Кнопка «Завершить оплату» видна на iPhone 11, но не 7", width="800", height="707" %} <figcaption>Отображение одной и той же страницы на iPhone 7 и iPhone 11.<br>Чтобы кнопка <strong>Завершить оплату</strong> оставалась видимой, необходимо уменьшить поля на небольших экранах мобильных устройств.</figcaption></figure>

## Внедрите аналитику и RUM {: #analytics-rum}

Локальное тестирование удобства использования и производительности может быть полезным, но достоверно оценить удобство форм оплаты и ввода адреса можно только в условиях реальной эксплуатации.

Для этого вам понадобится аналитика и Real User Monitoring («мониторинг реальных пользователей») — этот термин обозначает данные об опыте реальных пользователей, такие как время загрузки страниц оформления заказа или время заполнения формы оплаты:

- **Аналитика страниц**: число просмотров, показатели отказов, а также показатели выходов для каждой страницы с формой.
- **Аналитика взаимодействия**: [последовательности переходов к цели](https://support.google.com/analytics/answer/6180923?hl=en) и [события](https://developers.google.com/analytics/devguides/collection/gtagjs/events) позволяют понять, на каких этапах пользователи прекращают оформление заказа и какие действия они предпринимают при взаимодействии с формами.
- **Производительность сайта**: [метрики, ориентированные на пользователей](/user-centric-performance-metrics), помогут вам узнать скорость загрузки страниц оформления заказа, а также выявить причины медленной загрузки.

Аналитика страниц, аналитика взаимодействия и измерение производительности на реальных пользователях становятся особенно ценными инструментами, если использовать их в комбинации с журналами сервера, данными о конверсиях и A/B-тестированием. С их помощью можно выяснить, помогают ли скидочные коды повысить доход, повышаются ли конверсии при использовании нового дизайна формы и многое другое.

Это, в свою очередь, дает прочную основу для расстановки приоритетов, внесения изменений и вознаграждения успеха.

## Обучающие ресурсы {: #resources}

- [Рекомендации по формам входа в систему](/sign-in-form-best-practices)
- [Рекомендации по формам регистрации](/sign-up-form-best-practices)
- [Подтвердите номера телефонов в Интернете с помощью API WebOTP](/web-otp)
- [Как создавать потрясающие формы](/learn/forms/)
- Рекомендации по разработке форм для мобильных устройств
- Функциональные элементы управления в формах
- [Создание доступных форм](https://webaim.org/techniques/forms/)
- [Оптимизация процесса регистрации с помощью API управления учетными данными](https://developer.chrome.com/blog/credential-management-api/)
- [Руководство Фрэнка по почтовым адресам](http://www.columbia.edu/~fdc/postal/) содержит полезные ссылки и подробные инструкции по форматам адресов в более чем 200 странах.
- На [Countries Lists](http://www.countries-list.info/Download-List) есть инструмент для скачивания кодов и названий стран на различных языках и в различных форматах.

Автор фото: [@rupixen](https://unsplash.com/@rupixen) с [Unsplash](https://unsplash.com/photos/Q59HmzK38eQ).
