---
title: Оптимизация скорости загрузки основного контента
subhead: Как ускорить рендеринг основного контента.
authors:
  - houssein
date: 2020-05-05
updated: 2020-08-20
hero: image/admin/qqTKhxUFqdLXnST2OFWN.jpg
alt: Оптимизировать баннер LCP
description: Метрика LCP (Скорость загрузки основного контента) может использоваться, чтобы определить момент завершения рендеринга основного содержимого страницы. Узнайте, как оптимизировать LCP, улучшив медленный отклик сервера, время загрузки ресурсов и рендеринг на стороне клиента.
tags:
  - blog
  - performance
  - web-vitals
---

{% YouTube id = 'AQqFZ5t8uNc', startTime = '1073'%}

<blockquote>
  <p>Я не вижу полезного контента! Почему так долго загружается? 😖</p>
</blockquote>

Одним из факторов, ухудшающих пользовательский опыт, является длительное время рендеринга контента. Метрика [FCP (Первая отрисовка контента)](/fcp) измеряет, сколько времени требуется для визуализации исходного содержимого DOM, но не фиксирует, сколько времени потребовалось для визуализации самого большого (обычно более значимого) содержимого на странице.

[LCP (Скорость загрузки основного контента)](/lcp)это метрика [Core Web Vitals](/vitals/), измеряющая время, за которое  становится видимым самый большой элемент контента в области просмотра. Ее можно использовать, чтобы определить, когда основное содержимое страницы завершило рендеринг на экране.

  <picture>
    <source srcset="{{ "image/tcFciHGuF3MxnTr1y5ue01OGLBn2/elqsdYqQEefWJbUM2qMO.svg" | imgix }}" media="(min-width: 640px)">
    {% Img src="image/tcFciHGuF3MxnTr1y5ue01OGLBn2/9trpfS9wruEPGekHqBdn.svg", alt="Хорошие значения LCP - 2,5 секунды, низкие значения больше 4,0 секунд, и все, что находится между ними, требует улучшения", width="384", height="96" %}
  </picture>

Наиболее частые причины плохого показателя LCP:

- [медленное время ответа сервера;](#slow-servers)
- [блокирующие рендеринг JavaScript и CSS;](#render-blocking-resources)
- [медленное время загрузки ресурсов;](#slow-resource-load-times)
- [клиентский рендеринг.](#client-side-rendering)

## Медленное время ответа сервера {: #slow-servers}

Чем дольше браузер получает контент с сервера, тем больше времени требуется для отображения чего-либо на экране. Более быстрое время отклика сервера напрямую улучшает каждую метрику загрузки страницы, включая LCP.

Прежде всего, улучшите то, как и где ваш сервер обрабатывает контент. Используйте метрику [TTFB (Время до первого байта)](/ttfb/), чтобы измерить время ответа сервера. Есть несколько способов улучшить TTFB:

- оптимизировать  сервер;
- направлять пользователей в ближайшую CDN (географически распределённую сетевую инфраструктуру);
- кешировать активы;
- применять для HTML-страниц политику выборки cache-first;
- устанавливать сторонние подключения на раннем этапе;
- использовать подписанные обмены.

### Оптимизация сервера

Вы запускаете ресурсоёмкие запросы, на выполнение которых у вашего сервера уходит много времени? Или на стороне сервера происходят другие сложные операции, которые задерживают процесс возврата содержимого страницы? Анализ и повышение эффективности вашего серверного кода напрямую улучшит время, необходимое браузеру для получения данных.

Вместо того чтобы сразу же обслуживать статическую страницу по запросу браузера, многим серверным веб-фреймворкам необходимо создавать веб-страницу динамически. Другими словами, вместо отправки готового HTML-файла по запросу браузера, фреймворкам необходимо запускать логику для создания страницы. Это может быть связано с ожиданием результатов запроса к базе данных или даже с тем, что компоненты должны быть сгенерированы с разметкой с помощью платформы пользовательского интерфейса (например, [React](https://reactjs.org/docs/react-dom-server.html)). Многие веб-платформы, работающие на сервере, содержат рекомендации по производительности, которые можно использовать для ускорения этого процесса.

{% Aside %} Дополнительные советы см. в статье [«Исправление перегруженного сервера»](/overloaded-server/). {% endAside %}

### Направление пользователей в ближайшую CDN

Сеть доставки контента (CDN)это географически распределенная сетевая инфраструктура. Если контент на вашей веб-странице размещается на одном сервере, то веб-сайт будет загружаться медленнее для географически удаленных пользователей,  потому что запросы их браузера должны буквально путешествовать по всему миру. Рассмотрите возможность использования CDN, чтобы вашим пользователям никогда не приходилось ждать выполнения сетевых запросов к удаленным серверам.

### Кеширование активов

Если ваш HTML статичен и его не нужно изменять при каждом запросе, кеширование может предотвратить его ненужное воссоздание. Сохраняя копию сгенерированного HTML на диске, кеширование на стороне сервера может уменьшить TTFB и минимизировать использование ресурсов.

В зависимости от вашего пакета инструментальных средств существует множество различных способов применения кеширования на сервере:

- настройте обратные прокси-серверы ([Varnish](https://varnish-cache.org/), [nginx](https://www.nginx.com/)) для обслуживания кешированного содержимого или работы в качестве кеш-сервера при установке перед сервером приложений;
- настройте режим кеширования на облачном провайдере ([Firebase](https://firebase.google.com/docs/hosting/manage-cache), [AWS](https://aws.amazon.com/caching/), [Azure)](https://docs.microsoft.com/en-us/azure/architecture/best-practices/caching);
- используйте CDN, которая переадресует запросы пользователя к географически ближайшему кеширующему серверу сети.

### Применение для HTML-страниц политики выборки cache-first

После установки [сервис-воркер](https://developer.mozilla.org/docs/Web/API/Service_Worker_API) работает в фоновом режиме браузера и может перехватывать запросы с сервера. Этот уровень программного управления кешем позволяет кешировать часть или всё содержимое HTML-страницы и обновлять кеш только при изменении контента.

На следующей диаграмме показано, как с помощью этого шаблона было сокращено распределение LCP на сайте:

<figure>
  {% Img
    src="image/admin/uB0Sm56R88MRF16voQ1k.png",
    alt="Распределения LCP до и после кэширования HTML",
    width="800",
    height="495"
  %}
  <figcaption>
    Распределение LCP для страниц, загруженных с сервис-воркером и без него<a href="https://philipwalton.com/articles/smaller-html-payloads-with-service-workers/">philipwalton.com</a>
  </figcaption>
</figure>

На диаграмме показано распределение LCP с одного сайта за последние 28 дней, сегментированное по состоянию сервис-воркера. Обратите внимание, насколько больше загрузок страниц имеют более быстрое значение LCP после того, как в сервис-воркере для HTML-страниц была введена политика выборки cache-first (синяя часть столбцов диаграммы).

{% Aside %} Чтобы узнать больше о методах кеширования страниц HTML целиком или в виде отдельных блоков, ознакомьтесь с разделом «Сокращение времени загрузки [HTML с помощью сервис-воркеров»](https://philipwalton.com/articles/smaller-html-payloads-with-service-workers/) {% endAside %}

### Установление сторонних подключений на раннем этапе

Запросы сервера к сторонним источникам также могут повлиять на LCP, особенно если они необходимы для отображения важного содержимого на странице. Используйте `rel="preconnect"`, чтобы сообщить браузеру, что ваша страница намеревается установить соединение как можно скорее.

```html
<link rel="preconnect" href="https://example.com" />
```

Кроме того, можно использовать `dns-prefetch` для более быстрого поиска DNS.

```html
<link rel="dns-prefetch" href="https://example.com" />
```

Хотя обе подсказки работают по-разному, рассмотрите возможность использования `dns-prefetch` в качестве запасного варианта для браузеров, которые не поддерживают `preconnect`.

```html
<head>
  …
  <link rel="preconnect" href="https://example.com" />
  <link rel="dns-prefetch" href="https://example.com" />
</head>
```

{% Aside %} Подробнее см. в статье [«Установление сетевых подключений на раннем этапе для улучшения воспринимаемой скорости страницы»](/preconnect-and-dns-prefetch/) {% endAside %}

### Использование подписанных обменов (SXG)

[Подписанные обмены (SXG)](/signed-exchanges)это механизм доставки, который позволяет ускорить взаимодействие с пользователем, предоставляя контент в легко кешируемом формате. В частности, [Google Поиск](https://developers.google.com/search/docs/advanced/experience/signed-exchange) будет кешировать, а иногда и предварительно загружать файлы SXG. Для сайтов, которые получают большую часть своего трафика от Поиска Google, SXG могут стать важным инструментом улучшения LCP. Более подробно см. в статье [«Подписанные обмены»](/signed-exchanges).

## Блокирующие рендеринг JavaScript и CSS {: #render-blocking-resources}

Прежде чем браузер сможет отобразить какой-либо контент, ему необходимо преобразовать разметку HTML в дерево DOM. Анализатор HTML приостановит работу, если обнаружит какие-либо внешние таблицы стилей (`<link rel="stylesheet">`) или синхронные теги JavaScript (`<script src="main.js">`).

Сценарии и таблицы стилейэто блокирующие рендеринг ресурсы, которые задерживают FCP и, следовательно, LCP. Отложите любой некритический JavaScript и CSS, чтобы ускорить загрузку основного контента веб-страницы.

### Уменьшение времени блокировки CSS

С помощью следующих шагов сведите блокирующий рендеринг CSS к минимально необходимому:

- выполните минификацию CSS-кода;
- отложите некритический CSS-код;
- встройте критический CSS-код в HTML.

### Минификация CSS

Для удобочитаемости CSS-файлы могут содержать интервалы, отступы или комментарии. Все эти символы не нужны браузеру, и путём удаления их из исходного кода можно уменьшить его размер. В конечном итоге уменьшение количества блокирующего CSS-кода всегда сокращает время, необходимое для полной отрисовки основного контента страницы (LCP).

Если вы используете сборщик модулей или систему сборки пакетов, включите соответствующий плагин для минификации CSS-кода при каждой сборке:

- для webpack: [optimize-css-assets-webpack-plugin](https://github.com/NMFR/optimize-css-assets-webpack-plugin);
- для Gulp: [gulp-clean-css](https://www.npmjs.com/package/gulp-clean-css);
- для Rollup: [rollup-plugin-css-porter](https://www.npmjs.com/package/rollup-plugin-css-porter).

<figure>
  {% Img
    src="image/admin/vQXSKrY1Eq3CKkNbu9Td.png",
    alt="Пример улучшения LCP: до и после минификации CSS",
    width="800",
    height="139"
  %}
  <figcaption>
    Пример улучшения LCP: до и после минификации CSS
  </figcaption>
</figure>

{% Aside %} Более подробную информацию см. в статье [«Минификация CSS»](/minify-css/). {% endAside %}

### Отложенная загрузка некритичного CSS-кода

Используйте вкладку [Coverage](https://developer.chrome.com/docs/devtools/coverage/) в Chrome DevTools, чтобы найти неиспользуемый CSS-код на своей веб-странице.

{% Img
  src="image/admin/wjS4NrU5EsJeCuvK0zhn.png",
  alt="Вкладка Coverage в Chrome DevTools",
  width="800",
  height="559"
%}

Для оптимизации:

- Полностью удалите неиспользуемый CSS или переместите его в другую таблицу стилей, если он используется на отдельной странице вашего сайта.
- Остальной CSS-код, который не требуется для начального рендеринга страницы, загружайте асинхронно с помощью библиотеки [loadCSS](https://github.com/filamentgroup/loadCSS/blob/master/README.md), использующей `rel="preload"` и `onload`.

```html
<link rel="preload" href="stylesheet.css" as="style" onload="this.rel='stylesheet'">
```

<figure>
  {% Img
    src="image/admin/2fcwrkXQRQrM8w1qyy3P.png",
    alt="Пример улучшения LCP: до и после отсрочки загрузки некритичного CSS",
    width="800",
    height="139"
  %}
  <figcaption>
    Пример улучшения LCP: до и после отсрочки загрузки некритичного CSS
  </figcaption>
</figure>

{% Aside %} Более подробную информацию см. в статье [«Отложенная загрузка некритичного CSS-кода](/defer-non-critical-css/). {% endAside %}

### Встраивание критического CSS-код в HTML

Встройте любой критический CSS-код, используемый для содержимого верхней части страницы, включив его непосредственно в `<head>.`

<figure>
  {% Img
    src="image/admin/m0n0JsLpH9JsNnXywSwz.png",
    alt="Встроенный критический CSS",
    width="800", height="325"
  %}
  <figcaption>Встроенный критический CSS</figcaption>
</figure>


Встраивание важных стилей избавляет от необходимости делать двусторонний запрос для получения критически важного CSS. Отсрочка остального сводит к минимуму время блокировки CSS.

Если вы не можете вручную добавить встроенные стили на свой сайт, используйте библиотеку для автоматизации процесса. Несколько примеров:

- [Critical](https://github.com/addyosmani/critical), [CriticalCSS](https://github.com/filamentgroup/criticalCSS) и [Penthouse](https://github.com/pocketjoso/penthouse)всё это пакеты, которые извлекают и встраивают верхнюю часть CSS.
- [Critters](https://github.com/GoogleChromeLabs/critters)это плагин для веб-пакетов, который встраивает критический CSS и отлаживает загрузку прочего CSS.

<figure>
  {% Img
    src="image/admin/L8sc51bd3ckxwnUfczC4.png",
    alt="Пример улучшения LCP: до и после встраивания критического CSS",
    width="800",
    height="175"
  %}
  <figcaption>
    Пример улучшения LCP: до и после встраивания критического CSS
  </figcaption>
</figure>

{% Aside %} Более подробную информацию см. в статье [«Извлечение критического CSS-кода»](/extract-critical-css/). {% endAside %}

### Уменьшение времени блокировки JavaScript

Загрузите и предоставьте пользователям минимальное количество необходимого JavaScript. Уменьшение количества блокирующих рендеринг JavaScript приводит к более быстрой отрисовке и, как следствие, лучшему значению LCP.

Этого можно добиться, оптимизируя скрипты несколькими различными способами:

- [выполняйте минификацию и сжатие файлов JavaScript](/reduce-network-payloads-using-text-compression/);
- [отложите загрузку неиспользуемого JavaScript](/reduce-javascript-payloads-with-code-splitting/);
- [минимизируйте неиспользуемые полифиллы](/serve-modern-code-to-modern-browsers/).

{% Aside %} В статье [«Оптимизация времени ожидания до первого взаимодействия с контентом»](/optimize-fid/) более подробно описаны все методы, необходимые для уменьшения времени блокировки JavaScript. {% endAside %}

## Медленное время загрузки ресурсов {: #slow-resource-load-times}

Хотя увеличение времени блокировки CSS или JavaScript напрямую приведет к снижению производительности, время, необходимое для загрузки многих других типов ресурсов, также может повлиять на время отрисовки. Типы элементов, которые влияют на LCP:

- элементы `<img>`;
- элементы `<image>` внутри элемента `<svg>`;
- элементы `<video>` (момент отрисовки изображения [poster](https://developer.mozilla.org/docs/Web/HTML/Element/video#attr-poster) используется для измерения LCP);
- элементы с фоновым изображением, загруженным с помощью функции [`url()`](https://developer.mozilla.org/docs/Web/CSS/url()) (в отличие от <a>CSS-градиента</a>);
- [блочные элементы](https://developer.mozilla.org/docs/Web/HTML/Block-level_elements), содержащие текстовые узлы или другие дочерние строковые элементы.

Время, необходимое для загрузки этих элементов при рендеринге в верхней части страницы, будет иметь прямое влияние на LCP. Есть несколько способов обеспечить максимально быструю загрузку этих файлов:

- оптимизировать и сжимать изображения;
- предварительно загружать важные ресурсы;
- сжимать текстовые файлы;
- доставлять различные ресурсы на основании сетевого подключения (адаптивное обслуживание);
- кешировать активы с помощью сервис-воркера.

### Оптимизация и сжатие изображений

Для многих сайтов изображения—самые крупные элементы, видимые после завершения загрузки страницы. Главные изображения, большие карусели или изображения баннеров—типичные примеры крупных элементов.

<figure>
  {% Img
    src="image/tcFciHGuF3MxnTr1y5ue01OGLBn2/unWra6cq0hPJJJT7Y3ye.png",
    alt="",
    width="459",
    height="925"
  %}
  <figcaption>Изображение как самый большой элемент страницы: <a href="https://design.google/">design.google</a></figcaption>
</figure>

Улучшение времени загрузки и рендеринга этих типов изображений, напрямую ускорит LCP. Для этого:

- Подумайте о том, чтобы не использовать изображения в первую очередь. Если они не важны для контента, удалите их.
- Сжимайте изображения (например, с помощью  [Imagemin](/use-imagemin-to-compress-images)).
- Преобразуйте изображений в новые форматы (JPEG 2000, JPEG XR или WebP).
- Используйте адаптивные изображения.
- Рассмотрите возможность использования CDN для обработки изображений.

{% Aside %} Ознакомьтесь со статьей [«Оптимизация изображений»](/fast/#optimize-your-images), где подробно объясняются упомянутые выше методы. {% endAside %}

### Предварительная загрузка важных ресурсов

Иногда важные ресурсы, которые объявлены или используются в определенном файле CSS или JavaScript, могут извлекаться позже, чем требуется (например, шрифт, спрятанный глубоко в одном из многих CSS-файлов приложения).

Если вы знаете, что приоритет должен быть отдан определенному ресурсу, используйте `<link rel="preload">`, чтобы получить его раньше. Можно предварительно загрузить [многие типы ресурсов](https://developer.mozilla.org/docs/Web/HTML/Preloading_content#What_types_of_content_can_be_preloaded), но сначала следует сосредоточиться на [предварительной загрузке критически важных ресурсов](/preload-critical-assets/), таких как шрифты, изображения или видео в верхней части страницы, а также CSS или JavaScript для критических этапов рендеринга.

```html
<link rel="preload" as="script" href="script.js" />
<link rel="preload" as="style" href="style.css" />
<link rel="preload" as="image" href="img.png" />
<link rel="preload" as="video" href="vid.webm" type="video/webm" />
<link rel="preload" href="font.woff2" as="font" type="font/woff2" crossorigin />
```

Начиная с Chrome 73, предварительную загрузку можно использовать вместе с [адаптивными изображениями](/preload-responsive-images/), чтобы объединить оба шаблона для более быстрой загрузки изображений.

```html
<link
  rel="preload"
  as="image"
  href="wolf.jpg"
  imagesrcset="wolf_400px.jpg 400w, wolf_800px.jpg 800w, wolf_1600px.jpg 1600w"
  imagesizes="50vw"
/>
```

### Сжатие текстовых файлов

Алгоритмы сжатия, такие как [Gzip](https://www.youtube.com/watch?v=whGwm0Lky2s&feature=youtu.be&t=14m11s) и [Brotli](https://opensource.googleblog.com/2015/09/introducing-brotli-new-compression.html), могут значительно уменьшить размер текстовых файлов (HTML, CSS, JavaScript) при их передаче между сервером и браузером. Gzip эффективно поддерживается во всех браузерах, а Brotli, обеспечивающий еще лучшие результаты сжатия, и [поддерживается почти всеми новыми браузерами](https://caniuse.com/#feat=brotli).

Сжатие ресурсов минимизирует размер их доставки, сокращая время загрузки и, следовательно, LCP.

1. Сначала проверьте, использует ли уже ваш сервер автоматическое сжатие файлов. Большинство хостинговых платформ, CDN и обратных прокси-серверов либо кодируют ресурсы со сжатием по умолчанию, либо позволяют легко настроить сжатие.
2. Если вам нужно внедрить сжатие файлов на сервере, рассмотрите возможность использования Brotli вместо Gzip, поскольку Brotli обеспечивает лучшую степень сжатия.
3. После того как вы выберите алгоритм сжатия, сжимайте ресурсы заранее в процессе сборки, а не на лету, когда они запрашиваются браузером. Это минимизирует потребление ресурсов сервера и предотвратит задержки при выполнении запросов, особенно при использовании высоких степеней сжатия.

<figure>
  {% Img
    src="image/admin/Ckh2Jjkoh7ojLj5Wxeqc.png",
    alt="Пример улучшения LCP: до и после сжатия с Brotli",
    width="800",
    height="139"
  %}
  <figcaption>
    Пример улучшения LCP: до и после сжатия с Brotli
  </figcaption>
</figure>


{% Aside %}Более подробную информацию см. в статье [«Минификация и сжатие полезных сетевых нагрузок»](/reduce-network-payloads-using-text-compression/). {% endAside %}

### Адаптивное обслуживание

При загрузке ресурсов, составляющих основной контент страницы, эффективным может быть условная выборка различных ресурсов в зависимости от типа устройства или условий сети пользователя. Это можно сделать с помощью API-интерфейсов [Network Information](https://wicg.github.io/netinfo/), [Device Memory](https://www.w3.org/TR/device-memory/) и [HardwareConcurrency.](https://html.spec.whatwg.org/multipage/workers.html#navigator.hardwareconcurrency)

Если у вас есть большие ресурсы, критически важные для первоначального рендеринга, вы можете использовать разные варианты одного и того же ресурса в зависимости от скорости подключения или от устройства пользователя. Например, вы можете отображать изображение вместо видео для любых скоростей подключения ниже 4G:

```js
if (navigator.connection && navigator.connection.effectiveType) {
  if (navigator.connection.effectiveType === '4g') {
    // Load video
  } else {
    // Load image
  }
}
```

Список полезных свойств, которые вы можете использовать:

- `navigator.connection.effectiveType` : эффективный тип подключения;
- `navigator.connection.saveData` : экономия данных включена/отключена;
- `navigator.hardwareConcurrency` : количество ядер ЦП;
- `navigator.deviceMemory` : память устройства.

{% Aside %} Более подробную информацию см. в статье [«Адаптивное обслуживание на основании качества сетевого подключения»](/adaptive-serving-based-on-network-quality/). {% endAside %}

### Кэширование активов с помощью сервис-воркера

Сервис-воркеры могут использоваться для множества полезных задач, в том числе для сокращения ответов на запросы контента HTML, как упоминалось ранее в этой статье. Их также можно использовать для кеширования любого статического ресурса, чтобы затем выдать его браузеру, а не загружать из сети при повторных запросах.

Предварительное кеширование критических ресурсов с помощью сервис-воркера может значительно сократить время их загрузки, особенно для пользователей, которые перезагружают веб-страницу, используя более слабое подключение (или даже получают к ней доступ в автономном режиме). Иногда, чтобы упростить процесс обновления предварительно кешированных ресурсов, проще использовать библиотеку наподобие [Workbox](https://developer.chrome.com/docs/workbox/), чем писать пользовательский сервис-воркер.

{% Aside %} Ознакомьтесь со статьей [«Надежность сети»](/reliable/), чтобы узнать больше о сервис-воркерах и Workbox. {% endAside %}

## Рендеринг на стороне клиента {: #client-side-rendering}

Многие сайты используют клиентскую логику JavaScript для отображения страниц непосредственно в браузере. Фреймворки и библиотеки, такие как [React](https://reactjs.org/) , [Angular](https://angular.io/) и [Vue](https://vuejs.org/), упростили создание одностраничных приложений, которые обрабатывают различные аспекты веб-страницы полностью на стороне клиента, а не на сервере.

Если вы создаете сайт, который в основном отображается на стороне клиента, вам следует опасаться влияния больших пакетов JavaScript на LCP. Если не предусмотреть оптимизацию для предотвращения этого влияния, пользователи могут не видеть контент или не иметь возможности взаимодействовать с ним на странице до тех пор, пока не завершится загрузка и выполнение всего критического JavaScript-кода.

При создании сайта, отображаемого на стороне клиента, подумайте о проведении следующих оптимизаций:

- минимизируйте критический JavaScript;
- используйте рендеринг на стороне сервера;
- используйте предварительный рендеринг.

### Минимизация критического JavaScript

Если контент на вашем сайте становится видимым или с ним можно взаимодействовать только после загрузки определенного количества JavaScript, то первоочередной задачей стаёт максимальное уменьшение размера пакета. Для этого:

- выполните минификацию JavaScript;
- <a>отложите загрузку неиспользуемого JavaScript</a>;
- <a>минимизируйте неиспользуемые полифиллы</a>.

Вернитесь в раздел [«Уменьшение времени блокировки JavaScript»](#reduce-javascript-blocking-time), чтобы подробнее прочитать об этих оптимизациях.

### Использование рендеринга на стороне сервера

Минимизация количества JavaScriptпервоочередная задача для сайтов, которые в основном отрисовываются на стороне клиента. Кроме того, для максимального улучшения LCP следует рассмотреть возможность сочетания клиентского и серверного рендеринга.

Эта концепция работает с использованием сервера для рендеринга приложения в HTML, где клиент затем [«впитывает»](https://www.gatsbyjs.org/docs/react-hydration/) весь JavaScript и необходимые данные в одно и то же содержимое DOM. Это может улучшить LCP, гарантируя, что основное содержимое страницы сначала отрисовывается на сервере, а не только на клиенте, но есть несколько недостатков:

- сохранение одного и того же приложения, отрисованного с помощью JavaScript, на сервере и на клиенте может увеличить сложность;
- выполнение JavaScript для рендеринга HTML-файла на сервере всегда увеличивает время ответа сервера (TTFB) по сравнению с простым обслуживанием статических страниц с сервера;
- страница, отображаемая на сервере, может выглядеть так, как будто с ней можно взаимодействовать, но она не может реагировать на действия пользователя, пока не будет выполнен весь клиентский JavaScript. Проще говоря, это может ухудшить метрику [**TTI (Время до интерактивности)**](/tti/).

### Использование предварительного рендеринга

Предварительный рендерингэто отдельный метод, который менее сложен, чем рендеринг на стороне сервера, но также позволяет улучшить LCP в вашем приложении. Браузер без графического интерфейса используется для создания статических файлов HTML для каждого маршрута во время сборки. Затем эти файлы могут быть отправлены вместе с пакетами JavaScript, необходимыми для приложения.

При предварительном рендеринге TTI по-прежнему подвергается негативному воздействию, но время отклика сервера не так сильно ухудшается, как при рендеринге на стороне сервера, которое динамически отображает каждую страницу только после ее запроса.

<figure>
  {% Img
    src="image/admin/sm9s16UHfh8a5MDEWjxa.png",
    alt="Пример улучшения LCP: до и после предварительного рендеринга",
    width="800",
    height="139"
  %}
  <figcaption>
    Пример улучшения LCP: до и после предварительного рендеринга
  </figcaption>
</figure>

{% Aside %} Чтобы глубже погрузиться в различные архитектуры серверного рендеринга, ознакомьтесь со статьей [«Рендеринг в Интернете»](/rendering-on-the-web/). {% endAside %}

## Инструменты разработчика

Для измерения и отладки LCP доступен ряд инструментов:

- [Lighthouse 6.0](https://developer.chrome.com/docs/lighthouse/overview/) включает поддержку измерения LCP в лабораторных условиях.

{% Img
  src="image/admin/Sar3Pa7TDe9ibny6sfq4.jpg",
  alt="Lighthouse 6.0",
  width="800",
  height="309"
%}

- Раздел **Timings** панели [Performance](https://developer.chrome.com/docs/devtools/evaluate-performance/) в Chrome Devtools включает маркер LCP и показывает, какой элемент связан с LCP при наведении мыши на поле **Related Node**.

{% Img
  src="image/admin/sxczQPKH0cvMBsNCx5uH.png",
  alt="LCP в Chrome DevTools",
  width="800",
  height="509"
%}

- Отчет [Chrome User Experience Report](https://developer.chrome.com/docs/crux/) предоставляет реальные значения LCP, агрегированные на уровне источника.

*Выражаем благодарность Филиппу Уолтону, Кэти Хемпениус, Кейси Баскесу и Илье Григорику за их обзоры.*
