---
title: Поддержка адаптивных иконок в PWA благодаря маскируемым иконкам
subhead: Новый формат для использования адаптивных иконок на платформах, где есть их поддержка.
description: Маскируемые иконки — это новый формат, который обеспечивает большую степень контроля, позволяя вашему прогрессивному веб-приложению использовать адаптивные иконки. С маскируемой иконкой ваше приложение будет замечательно смотреться на любых Android-устройствах.
authors:
  - tigeroakes
  - thomassteiner
date: 2019-12-19
updated: 2021-05-19
hero: image/admin/lzLo9JCh6bcehH2nSH0n.png
alt: Иконки внутри белых кругов в сравнении с иконками, покрывающими весь круг
tags:
  - blog
  - capabilities
  - progressive-web-apps
feedback:
  - api
---

## Что такое маскируемые иконки? {: #what }

Установив прогрессивное веб-приложение на свежую модель Android, вы сможете заметить, что его иконка отображается на белом фоне. В Android Oreo были представлены адаптивные иконки приложений, принимающие различные формы на разных моделях устройств. Иконки, не соответствующие этому новому формату, имеют белый фон.

<figure>{% Img src="image/admin/jzjx6dGkXN9EdqnUzAeg.png", alt="Иконки PWA в белых кругах на Android", width="400", height="100" %} <figcaption>Прозрачные иконки PWA отображаются на Android внутри белых кругов</figcaption></figure>

Маскируемые иконки — это новый формат, который обеспечивает большую степень контроля, позволяя вашему прогрессивному веб-приложению использовать адаптивные иконки. Добавленная маскируемая иконка сможет заполнить форму целиком, благодаря чему ваше приложение будет замечательно смотреться на любых Android-устройствах. Firefox и Chrome недавно добавили поддержку этого нового формата, и вы можете использовать его в своих приложениях.

<figure>{% Img src="image/admin/J7gkg9ylP2ANlFawblze.png", alt="Иконки PWA, покрывающие весь круг на Android", width="400", height="100" %} <figcaption>Маскируемые иконки покрывают круг целиком</figcaption></figure>

## Подходят ли мои нынешние иконки?

Поскольку маскируемые иконки рассчитаны на поддержку различных форм, вам нужно предоставить непрозрачное изображение с некоторым отступом, которое браузер сможет позже обрезать до нужной формы и размера. Лучше не полагаться на какую-то конкретную форму, поскольку окончательный вариант может различаться в зависимости от браузера и платформы.

<figure data-float="right">{% Video src=["video/tcFciHGuF3MxnTr1y5ue01OGLBn2/mx1PEstODUy6b5TXjo4S.webm", "video/tcFciHGuF3MxnTr1y5ue01OGLBn2/tw7QbXq9SBjGL3UYW0Fq.mp4"], autoplay=true, loop=true, muted=true, playsinline=true %} <figcaption> Различные формы иконок в зависимости от платформ </figcaption></figure>

К счастью, существует четко определенная и [стандартизированная](https://w3c.github.io/manifest/#icon-masks) «минимальная безопасная зона», соблюдаемая всеми платформами. Важные части вашей иконки, такие как логотип, должны находиться в пределах окружности в центре иконки с радиусом, равным 40% ее ширины. 10% внешнего края можно обрезать.

Вы можете проверить, какие части ваших иконок попадают в безопасную зону, с помощью Chrome DevTools. Открыв прогрессивное веб-приложение, запустите DevTools и перейдите на панель «**Приложение**». В разделе «**Иконки**» вы можете выбрать «**Показывать только минимальную безопасную область для маскируемых иконок**». Ваши иконки будут обрезаны так, чтобы была видна только безопасная область. Если ваш логотип виден в этой безопасной зоне, все готово.

<figure>{% Img src="image/admin/UeKTJM2SE0SQhgnnyaQG.png", alt="Панель приложений в DevTools, отображающая иконки PWA с обрезанными краями", width="762", height="423" %} <figcaption>Панель приложений</figcaption></figure>

Чтобы протестировать маскируемую иконку на различными формах Android, используйте созданный мной инструмент [Maskable.app](https://maskable.app/). Откройте иконку, затем Maskable.app позволит вам опробовать различные формы и размеры, и вы сможете поделиться предварительным просмотром с другими членами своей команды.

## Как начать пользоваться маскируемыми иконками?

Если вы хотите создать маскируемую иконку на основе существующей иконки, вы можете использовать [редактор Maskable.app](https://maskable.app/editor). Загрузите свою иконку, настройте цвет и размер, затем экспортируйте изображение.

<figure>{% Img src="image/admin/MDXDwH3RWyj4po6daeXw.png", alt="Снимок экрана редактора Maskable.app", width="670", height="569" %} <figcaption>Создание иконок в редакторе Maskable.app</figcaption></figure>

После того, как вы создали маскируемое изображение иконки и протестировали его в DevTools, необходимо обновить [манифест веб-приложения](/add-manifest/), чтобы он указывал на новые ресурсы. Манифест веб-приложения предоставляет информацию о вашем веб-приложении в файле JSON и включает [массив `icons`](/add-manifest/#icons).

С включением маскируемых иконок было добавлено новое значение свойства для ресурсов изображений, перечисленных в манифесте веб-приложения. Поле `purpose` сообщает браузеру, как следует использовать вашу иконку. По умолчанию для иконок значение этого поля равно `"any"`. На Android такие иконки будут подогнаны под нужный размер и размещены поверх белого фона.

Маскируемые значки должны использовать другое назначение: `"maskable"`. Это значение указывает, что изображение предназначено для использования с масками иконок, что позволяет вам регулировать результат. Таким образом, у ваших иконок не будет белого фона. Вы также можете указать несколько назначений, разделенных пробелами (например, `"any maskable"`), если хотите, чтобы маскируемая иконка использовалась без маски на других устройствах.

{% Aside %} Хотя вы *можете* указать несколько назначений, разделенных пробелами, например `"any maskable"`, на практике так *делать не следует*. Использование `"maskable"`-иконок в качестве `"any"` неоптимально, поскольку иконка будет использоваться как есть, что приведет к избыточным отступам и уменьшению основного содержимого иконки. В идеале у иконок для назначения `"any"` должны быть прозрачные области и не должно быть лишних отступов, как у иконок сайта, поскольку браузер не будет проделывать для иконок эту работу. {% endAside %}

```json
{
  …
  "icons": [
    …
    {
      "src": "path/to/regular_icon.png",
      "sizes": "196x196",
      "type": "image/png",
      "purpose": "any"
    },
    {
      "src": "path/to/maskable_icon.png",
      "sizes": "196x196",
      "type": "image/png",
      "purpose": "maskable" // <-- Новое значение свойства `"maskable"`
    },
    …
  ],
  …
}
```

Теперь вы можете приступить к делу и создать собственные маскируемые иконки, обеспечив своему приложению отличный вид по всем краям (и если уж на то пошло, по всей окружности или по всему овалу 😄).

## Благодарности

Статью рецензировал [Джо Медли](https://github.com/jpmedley).
