---
title: Что такое FLoC?
subhead: FLoC позволяет выбирать рекламу, не передавая информацию об истории просмотра отдельных пользователей.
authors:
  - samdutton
date: 2021-03-30
updated: 2021-10-29
hero: image/80mq7dk16vVEg8BBhsVe42n6zn82/GA543wiVTwpbwp6Zmw0H.jpg
thumbnail: image/80mq7dk16vVEg8BBhsVe42n6zn82/OuORgPSvN06ntXT5xOii.jpg
alt: Стая скворцов над пирсом Брайтона
tags:
  - blog
  - privacy
  - security
feedback:
  - api
---

{% Aside %} В этой статье описывается дизайн API, реализованный в Chrome для первоначального испытания FLoC по схеме Origin Trial.

В настоящее время разрабатываются будущие итерации API для включения рекламы на основе интересов без сторонних файлов cookie или других механизмов межсайтового отслеживания. {% endAside %}

FLoC предоставляет механизм подбора рекламы по интересам без ущерба для конфиденциальности.

По мере того как пользователь перемещается по веб-страницам, браузер с помощью алгоритма FLoC вычисляет подходящую «когорту интересов», которая будет одинаковой для тысяч различных браузеров с похожей недавней историей просмотра. Время от времени браузер вычисляет принадлежность к когорте заново; это происходит на устройстве пользователя, и индивидуальные данные о просмотре страниц не передаются разработчику браузера или кому-либо еще.

{% Aside %} Во время первоначального испытания FLoC по схеме Origin Trial посещение страницы включалось в расчет FLoC браузера только по одной из двух причин:

- на странице использовался API FLoC (`document.interestCohort()`);
- Chrome обнаруживал, что страница [загружает рекламу или связанные с ней ресурсы](https://github.com/WICG/floc/issues/82).

Испытание Origin Trial может экспериментировать с другими критериями включения для других алгоритмов кластеризации: это часть процесса первоначального испытания.

Испытание Origin Trial исходной версии FLoC, которая работала в версиях Chrome с 89 по 91, [теперь закрыто](https://developer.chrome.com/origintrials/#/view_trial/213920982300098561). {% endAside %}

Рекламодатели (сайты, которые платят за рекламу) могут устанавливать у себя на сайтах код, собирающий данные о когортах интересов и передающий его рекламным платформам (компаниям, предоставляющим ПО и инструменты для показа рекламы). Например, интернет-магазин обуви может сообщить рекламной платформе, что посетители из когорт 1101 и 1354 интересовались туристическим снаряжением. От других рекламодателей рекламная платформа узнает о других интересах пользователей из этих когорт.

В дальнейшем рекламная платформа может использовать эти данные для подбора релевантной рекламы (например, рекламы туристических ботинок из обувного магазина), когда браузер, принадлежащий к одной из этих когорт, заходит на сайт, показывающий рекламу, например, на новостной портал.

Privacy Sandbox — это серия предложений для обеспечения межсайтового взаимодействия без использования сторонних файлов cookie и других механизмов отслеживания. См. статью [«Углубление в тему Privacy Sandbox»](/digging-into-the-privacy-sandbox), чтобы ознакомиться со всеми предложениями.

**Примите участие в развитии инициативы: поделитесь отзывами или комментариями.** [Откройте вопрос](https://github.com/WICG/floc/issues/new) в репозитории [FLoC Explainer](https://github.com/WICG/floc) или оставьте отзыв об эксперименте с этой инициативой Chrome в обсуждении [Intent to Experiment](https://groups.google.com/a/chromium.org/g/blink-dev/c/MmijXrmwrJs).

## Зачем нужен FLoC?

Многие компании полагаются на рекламу для привлечения трафика на свои сайты, и многие сайты издателей финансируют контент, продавая рекламные ресурсы. Люди обычно предпочитают видеть релевантную и полезную для себя рекламу. Кроме того, релевантные объявления приносят [больше прибыли рекламодателям и больший доход сайтам, на которых они размещены](https://services.google.com/fh/files/misc/disabling_third-party_cookies_publisher_revenue.pdf). Другими словами, рекламное место более ценно, когда на нем отображается релевантная реклама. Таким образом, выбор релевантных объявлений увеличивает доход сайтов, показывающих рекламу.  Это, в свою очередь, означает, что релевантные объявления помогают финансировать создание полезного для пользователей контента.

Многие люди обеспокоены влиянием персонализированной рекламы на конфиденциальность, поскольку на данный момент она использует следящие файлы cookie, фингерпринтинг устройств и другие технологии, которые могут раскрывать рекламодателям и рекламным платформам историю перемещения пользователей между сайтами. Предложение FLoC преследует цель обеспечить более высокий уровень конфиденциальности при подборе рекламы.

## Для чего можно использовать FLoC?

- Чтобы показывать рекламу пользователям из когорт, представители которых, согласно наблюдениям, часто заходят на сайт рекламодателя или проявляют интерес к релевантным темам.
- Чтобы с помощью моделей машинного обучения предсказывать вероятность конверсии со стороны пользователя, принадлежащего к определенной когорте, и на основе этой вероятности определять ставку при участии в рекламных аукционах.
- Чтобы рекомендовать пользователям контент. Например, предположим, что посетители новостного сайта из когорт 1234 и 14159 начинают проявлять повышенный интерес к странице спортивных подкастов. Сайт может порекомендовать этот контент другим посетителям из этих когорт.

## Как работает FLoC?

На диаграмме ниже изображены участники процесса выбора и отображения релевантной рекламы с помощью FLoC.

- **Рекламодатель** (компания, оплачивающая рекламу) в этом примере — это интернет-магазин обуви:<br> **<u>shoestore.example</u>**.

- **Издатель** (сайт, который продает рекламное место). В примере это новостной сайт:<br> **<u>dailynews.example</u>**.

- **Рекламная платформа** (предоставляет программное обеспечение и инструменты для показа рекламы):<br> **<u>adnetwork.example</u>**.

{% Img src="image/80mq7dk16vVEg8BBhsVe42n6zn82/wnJ1fSECf5STngywgE7V.png", alt="Диаграмма с пошаговым объяснением различных ролей  участников процесса выбора и отображения релевантной рекламы с помощью FLoC: служба FLoC, браузер, рекламодатели, издатель (наблюдение за когортами), рекламная платформа, издатель (показ рекламы)", width="800", height="359" %}

Для этого примера возьмем двух гипотетических пользователей **Йоши** и **Алекса**. Изначально их браузеры принадлежали к одной когорте — 1354.

{% Aside %} Имена «Йоши» и «Алекс» выбраны исключительно для примера. Имена и личные данные пользователей не раскрываются рекламодателю, издателю или рекламной платформе с FLoC.

Не воспринимайте когорту как совокупность людей. Вместо этого думайте о когорте как о группе просмотров. {% endAside %}

### 1. Служба FLoC

1. Служба FLoC, используемая браузером, создает математическую модель с тысячами «когорт», каждая из которых будет соответствовать тысячам веб-браузеров с похожей недавней историей просмотра. Подробнее о том, как это работает, [ниже](#floc-server).
2. Каждой когорте присваивается номер.

### 2. Браузер

1. Из службы FLoC браузер Йоши получает данные, описывающие модель FLoC.
2. Браузер Йоши [формирует свою когорту, используя алгоритм модели FLoC](#floc-algorithm), чтобы вычислить, какая когорта наиболее точно соответствует истории просмотров. В этом примере это будет когорта 1354. Обратите внимание, что браузер Йоши не передает никаких данных службе FLoC.
3. Таким же образом браузер Алекса вычисляет идентификатор его когорты. История просмотров Алекса отличается от истории Йоши, но достаточно похожа, чтобы их браузеры были отнесены к когорте 1354.

### 3. Рекламодатель: <span style="font-weight:normal">shoestore.example</span>

1. Йоши заходит на сайт <u>shoestore.example</u>.
2. Сайт запрашивает у браузера Йоши его когорту: 1354.
3. Йоши смотрит туристические ботинки.
4. На сайте отмечается, что браузер из когорты 1354 проявил интерес к туристическим ботинкам.
5. Позже сайт регистрирует дополнительный интерес к своей продукции со стороны когорты 1354, а также со стороны других когорт.
6. Сайт периодически собирает и передает информацию о когортах и потребительских интересах рекламной платформе <u>adnetwork.example</u>.

Теперь очередь Алекса.

### 4. Издатель: <span style="font-weight:normal">dailynews.example</span>

1. Алекс заходит на новостной сайт <u>dailynews.example</u>.
2. Сайт запрашивает у браузера Алекса его когорту.
3. Затем сайт отправляет запрос на показ объявления в рекламную платформу <u>adnetwork.example</u> и передает номер когорты Алекса: 1354.

### 5. Рекламная платформа <span style="font-weight:normal">adnetwork.example</span>

1. Платформа <u>adnetwork.example</u> может выбрать подходящую для Алекса рекламу, объединив данные, полученные от издателя <u>dailynews.example</u> и от рекламодателя <u>shoestore.example</u>:

- Когорта браузера Алекса (1354) предоставляется новостным сайтом <u>dailynews.example</u>.
- Данные о когортах и потребительских интересах от сайта <u>shoestore.example</u>: «Пользователи браузеров из когорты 1354 могут заинтересоваться туристическими ботинками».

1. Платформа <u>adnetwork.example</u> выбирает подходящее для Алекса объявление: рекламу туристических ботинок от сайта <u>shoestore.example</u>.
2. Сайт <u>dailynews.example</u> показывает рекламу 🥾.

{% Aside %} Текущие подходы к выбору рекламы основаны на отслеживании файлов cookie и <br>фингерпринтинге устройств, и используются третьими сторонами (например, рекламодателями) для отслеживания индивидуального поведения пользователей при просмотре веб-страниц.

При использовании FLoC браузер **не передает** историю просмотров службе FLoC или кому-либо еще. Браузер на устройстве пользователя сам определяет когорту. История просмотров пользователя никогда не покидает устройство. {% endAside %}

## Кто управляет серверной службой, которая создает модель FLoC?

Производители браузеров должны будут самостоятельно выбрать способ группировки браузеров в когорты. Chrome использует собственную службу FLoC. Другие браузеры могут выбрать для реализации FLoC другой подход к кластеризации и запустить свою службу.

## Как служба FLoC дает браузеру возможность определять свою когорту? {: #floc-server}

1. Служба FLoC, используемая браузером, создает многомерное математическое представление всех потенциальных историй просмотра веб-страниц. Назовем эту модель «когортным пространством».
2. Служба делит это пространство на тысячи сегментов. Каждый сегмент представляет собой кластер из тысяч похожих историй просмотра. Эти группировки не основаны на знании реальных историй просмотров; они просто основаны на выборе случайных центров в «пространстве когорты» или на разрезании пространства случайными линиями.
3. Каждому сегменту присваивается номер когорты.
4. Веб-браузер получает эти данные, описывающие «пространство когорты», из своей службы FLoC.
5. Когда пользователь просматривает веб-страницы в сети, его браузер [использует алгоритм](#floc-algorithm) для периодического вычисления области в «пространстве когорты», которая наиболее точно соответствует истории просмотра.

<figure style="text-align: center">{% Img src="image/80mq7dk16vVEg8BBhsVe42n6zn82/32k5jByqLrgwSMwb9mqo.png", alt="Диаграмма «пространства истории просмотров», созданная сервером FLoC, со множеством сегментов, каждый из которых имеет номер когорты.", width="400", height="359" %} <figcaption>Служба FLoC делит «когортное пространство» на тысячи сегментов (здесь показана лишь малая часть).</figcaption></figure>

{% Aside %} Ни на каком этапе этого процесса история просмотров пользователя не передается службе FLoC или какой-либо третьей стороне. Когорта браузера рассчитывается браузером на устройстве пользователя. Служба FLoC не собирает и не хранит пользовательские данные. {% endAside %}

## Может ли когорта браузера измениться?

*Да*! Когорта браузера определенно может измениться! Вероятно, вы не посещаете одни и те же веб-сайты каждую неделю, и когорта вашего браузера будет это отражать.

Когорта представляет собой группу просмотров, а не группу людей. Характеристики активности когорты, как правило, неизменны во времени, и когорты полезны для выбора объявлений, поскольку они группируют похожие недавние просмотры. Браузеры отдельных людей будут появляться и исчезать из когорты по мере изменения их поведения при просмотре. Первоначально мы ожидаем, что браузер будет пересчитывать свою когорту каждые семь дней.

В приведенном выше примере у браузеров Йоши и Алекса 1354-я когорта. В будущем браузеры Йоши и Алекса могут перейти в другие когорты, если их интересы изменятся. В приведенном ниже примере браузер Йоши переходит в когорту 1101, а браузер Алекса — в когорту 1378. Браузеры других людей будут переходить в когорты и выходить из них по мере изменения интересов просмотра.

<figure style="text-align: center">{% Img src="image/80mq7dk16vVEg8BBhsVe42n6zn82/LMkb62V3iJTqkOrFACnM.png", alt="Диаграмма «пространства истории просмотров», созданная сервером FLoC, показывает несколько сегментов с номерами когорт. На диаграмме показано, как браузеры пользователей Йоши и Алекса переходят из одной когорты в другую по мере изменения их интересов просмотра с течением времени.", width="800", height="533" %} <figcaption> Когорта браузеров Йоши и Алекса может меняться, если меняются их интересы.</figcaption></figure>

{% Aside %} Когорта определяет группу посещаемых страниц, а не группу людей. Браузеры будут входить в группу и выходить из нее по мере изменения истории просмотра. {% endAside %}

## Как браузер вычисляет свою когорту? {: #floc-algorithm}

Как описано выше, браузер пользователя получает от службы FLoC данные, описывающие математическую модель для когорт. Эта модель представляет собой многомерное пространство, состоящее из интересов просмотра всех пользователей. Затем браузер с помощью алгоритма определяет, какая область этого «когортного пространства» (то есть, какая когорта) наиболее точно соответствует недавнему поведению пользователя в браузере.

## Как FLoC определяет правильный размер когорты?

В каждой когорте будут тысячи браузеров.

Меньший размер когорты может быть более полезен для персонализации рекламы, но с меньшей вероятностью остановит слежку за пользователем, и наоборот. Механизм распределения браузеров по когортам должен обеспечивать компромисс между конфиденциальностью и полезностью. Privacy Sandbox использует [k-анонимность](https://en.wikipedia.org/wiki/K-anonymity), чтобы «спрятать пользователя в толпе». Когорта является k-анонимной, если ее разделяют не менее k пользователей. Чем больше число k, тем лучше сохраняется конфиденциальность когорты.

## Можно ли использовать FLoC для группировки людей на основе деликатных категорий?

Алгоритм кластеризации когортной модели FLoC предназначен для оценки того, возможно ли соотнести когорту с деликатными категориями без выяснения причин, по которым категория является деликатной. Когорты, которые могут раскрывать деликатные категории, такие как раса, сексуальная ориентация или история болезни, будут блокироваться. Другими словами, при определении своей когорты браузер будет выбирать только между когортами, которые не раскрывают конфиденциальные данные.

## Является ли FLoC еще одним способом классификации людей в сети?

Служба FLoC распределит браузер пользователя к одной из тысяч когорт, наряду с тысячами браузеров других пользователей. В отличие от сторонних файлов cookie и других механизмов таргетинга, FLoC показывает только когорту, в которой находится браузер пользователя, а не индивидуальный идентификатор пользователя. Это не позволяет сторонним сервисам выделить отдельного человека в когорте. Кроме того, информация о просмотренных сайтах, которая используется для определения когорты браузера, хранится локально в браузере или устройстве и не загружается куда-либо еще. Браузер может дополнительно использовать другие методы анонимизации, такие как [дифференциальная приватность](https://en.wikipedia.org/wiki/Differential_privacy).

## Должны ли веб-сайты участвовать в инициативе и делиться информацией?

У сайтов будет возможность отказаться от участия в инициативе FLoC. Сайты, посвященные деликатным темам, смогут предотвратить включение их посещений в расчет FLoC. В качестве дополнительной защиты анализ, выполняемый службой FLoC, будет оценивать, может ли когорта раскрывать деликатную информацию о пользователях без выяснения причин, по которым эта когорта является деликатной. Если когорта может представлять большее, чем обычно, число людей, посещающих сайты из деликатной категории, вся когорта удаляется. Тяжелое финансовое положение и психическое здоровье относятся этим анализом к деликатным категориям.

Веб-сайты [могут исключить страницу из расчета FLoC](https://github.com/WICG/floc#opting-out-of-computation), установив для этой страницы заголовок [Permissions-Policy](https://developer.chrome.com/docs/privacy-sandbox/permissions-policy/) `interest-cohort=()`. Посещения остальных страниц будет включено в расчет FLoC браузера при условии, что на странице используется `document.interestCohort()`. В текущем испытании [FLoC Origin Trial](https://developer.chrome.com/origintrials/#/view_trial/213920982300098561) страница также будет включена в расчет, если Chrome обнаружит, что страница [загружает рекламу или ресурсы, связанные с рекламой](https://github.com/WICG/floc/issues/82). (В статье [«Тегирование рекламы в Chromium»](https://chromium.googlesource.com/chromium/src/+/master/docs/ad_tagging.md) объясняется, как работает механизм обнаружения рекламы в Chrome.)

Страницы, обслуживаемые с частных IP-адресов (например, страницы внутренней сети), не будут участвовать в вычислениях FLoC.

## Как работает API FLoC JavaScript?

{% Aside %} Испытание Origin Trial исходной версии FLoC, которая работала в версиях Chrome с 89 по 91, [теперь закрыто](https://developer.chrome.com/origintrials/#/view_trial/213920982300098561). {% endAside %}

API FLoC очень прост: всего лишь один метод, возвращающий обещание, которое разрешается в объект, предоставляющий `id` и `version` когорты:

```javascript
const { id, version } = await document.interestCohort();
console.log('FLoC ID:', id);
console.log('FLoC version:', version);
```

Предоставленные данные по когорте выглядят следующим образом:

```js
{
  id: "14159",
  version: "chrome.2.1"
}
```

Значение `version` позволяет сайтам, использующим FLoC, узнать, к какому браузеру и к какой модели FLoC относится идентификатор когорты. Как описано ниже, обещание, возвращаемое `document.interestCohort()`, будет отклонено для любого фрейма, для которого не предоставлено разрешение `interest-cohort`.

## Могут ли веб-сайты отказаться от включения в расчет FLoC?

Политика разрешений `interest-cohort` позволяет сайту заявить, что он не хочет быть включенным в список сайтов пользователя для расчета когорты. По умолчанию установлена политика `allow`. Обещание, возвращаемое `document.interestCohort()`, будет отклонено для любого фрейма, которому не предоставлено разрешение `interest-cohort`. Если у главного фрейма нет разрешения `interest-cohort`, то посещение страницы не будет включено в расчет когорты интересов.

Например, сайт может отказаться от всех расчетов когорты FLoC, отправив следующий HTTP-заголовок ответа:

```text
  Permissions-Policy: interest-cohort=()
```

## Может ли пользователь запретить сайтам получать когорту FLoC его браузера?

Если пользователь отключит Privacy Sandbox в `chrome://settings/privacySandbox`, браузер не предоставит когорту пользователей при запросе через JavaScript: обещание, возвращаемое `document.interestCohort()`, будет отклонено.

## Как я могу внести предложения или оставить отзыв?

Если у вас есть комментарии к API, [откройте вопрос](https://github.com/WICG/floc/issues/new) в репозитории [FLoC Explainer](https://github.com/WICG/floc).

## Дополнительные сведения

- [Подробно о Privacy Sandbox](/digging-into-the-privacy-sandbox/).
- [FLoC Explainer](https://github.com/WICG/floc).
- [Испытание FLoC по схеме Origin Trial и кластеризация](https://sites.google.com/a/chromium.org/dev/Home/chromium-privacy/privacy-sandbox/floc).
- [Оценка когортных алгоритмов для API FLoC](https://github.com/google/ads-privacy/blob/master/proposals/FLoC/README.md).

---

Фото [Риса Кентиша](https://unsplash.com/@rhyskentish)(Rhys Kentish) с [Unsplash](https://unsplash.com/photos/I5AYxsxSuVA).
