---
title: Развитие метрики CLS
subhead: Планы по улучшению метрики CLS (совокупное смещение макета) таким образом, чтобы она была более справедливой для «долгоживущих» страниц
description: Планы по улучшению метрики CLS (совокупное смещение макета) таким образом, чтобы она была более справедливой для «долгоживущих» страниц
authors:
  - anniesullie
  - hbsong
date: 2021-04-07
hero: image/admin/JSBg0yF1fatrTDQSKiTW.webp
alt: Пример оконного подхода для измерения смещения макета
tags:
  - blog
  - performance
  - web-vitals
---

{% Aside %} **2 июня 2021 г.:** изменение в CLS, описанное в этой статье, уже есть на платформах веб-инструментов Chrome. См. [Развитие метрики CLS (совокупного смещения макета) в веб-инструментах](/cls-web-tooling/). {% endAside %}

Мы (разработчики метрик скорости в Chrome) недавно в общих чертах изложили свое исходное исследование различных [вариантов сделать метрику CLS более справедливой для страниц, которые открыты долгое время](/better-layout-shift-metric/). Мы получили много очень полезной обратной связи, и после крупномасштабного анализа пришли к решению о том, какое изменение мы планируем внести в метрику, а именно: **максимальное окно сеанса, промежуток 1 секунда, ограничение 5 секунд**.

Подробности — ниже!

## Как мы оценивали варианты решения этой задачи?

Мы просмотрели все отзывы, полученные от разработчиков, и приняли их к сведению.

Мы также реализовали [основные варианты](/better-layout-shift-metric/#best-strategies) в браузере Chrome и провели крупномасштабный анализ метрик по миллионам веб-страниц. Мы проверили, какие типы сайтов получили улучшение по каждому варианту и какая разница была между вариантами. Особенно мы обращали внимание на сайты, которые получали разную оценку. В целом мы обнаружили следующее:

- **Все** варианты снизили корреляцию между временем, проведенным на странице, и оценкой смещения макета.
- **Ни один** из вариантов не ухудшил результат ни одной страницы. Так что беспокоиться о том, что это изменение ухудшит оценку конкретного сайта, не нужно.

## Принятие решения

### Почему мы выбрали окно сеанса

В одной из [предыдущих статей](/better-layout-shift-metric/) мы рассмотрели [несколько различных стратегий обработки методом окна](/better-layout-shift-metric/#windowing-strategies) для группировки смещений макета, при которых оценка не растет неограниченно. Разработчики в своих отзывах в подавляющем большинстве склонялись к стратегии окна сеанса, поскольку она группирует смещение макета наиболее интуитивно понятным образом.

В качестве напоминания об окнах сеанса — пример:

<figure>
  <video controls autoplay loop muted>
    <source src="https://storage.googleapis.com/web-dev-assets/better-layout-shift-metric/session-window.webm" type="video/webm">
    <source src="https://storage.googleapis.com/web-dev-assets/better-layout-shift-metric/session-window.mp4" type="video/mp4">
  </source></source></video>
  <figcaption>     Пример окна сеанса</figcaption></figure>

В примере выше, пока пользователь просматривает страницу, происходит много смещений макета. Каждое из них представлено синей полосой. Как можно заметить, у синих полос разная высота: она представляет собой [оценку](/cls/#layout-shift-score) каждого отдельного смещения макета. Окно сеанса начинается с первым смещением макета и продолжает расширяться, пока не появится промежуток без смещений. При следующем смещении макета открывается новое окно сеанса. В примере есть три промежутка без смещений — они соответствуют трем окнам сеанса. Как и в случае с текущим определением CLS, оценки за каждое смещение суммируются, поэтому оценка окна — это сумма по отдельным смещениям макета.

Основываясь на [исходном исследовании](/better-layout-shift-metric/#best-strategies), мы выбрали промежуток в 1 секунду между окнами сеанса, и он хорошо себя показал в крупномасштабном анализе. Таким образом, «промежуток сеанса» (Session Gap) в примере выше равен 1 секунде.

### Почему мы выбрали максимальное окно сеанса

В исходном исследовании мы сузили выбор [стратегий обобщения](/better-layout-shift-metric/#summarization) до двух вариантов:

- **Средняя** оценка всех окон сеанса в случае, если они очень длительные (неограниченные, с 5-секундными промежутками).
- **Максимальная** оценка всех окон сеанса для коротких окон сеанса (ограниченные до 5 секунд, с промежутками в 1 секунду).

После исходного исследования мы добавили каждую метрику в Chrome, чтобы провести анализ по миллионам URL-адресов. В результате анализа мы обнаружили много URL-адресов с таким смещением макета:

{% Img src="image/MZfwZ8oVW8U6tzo5CXffcER0jR83/bW3lHZmss3cqGayZsq4P.png", alt="Пример: небольшое смещение макета понижает среднюю оценку", width="800", height="550" %}

Справа внизу можно увидеть одно крошечное смещение макета в окне сеанса 2, дающее очень низкую оценку этому окну. В результате среднее значение также довольно мало. Но что произойдет, если разработчик исправит это небольшое смещение? Тогда оценка будет учитывать только окно сеанса 1, и значение для страницы *увеличится почти вдвое*. Разработчика это может сбить с толку и обескуражить: смещение макета было исправлено, но оценка ухудшилась. Причем устранение этого небольшого смещения макета, очевидно, сделает пользование страницей более удобным, а значит, оценка ухудшаться не должна.

Из-за этой проблемы со средним мы решили остановиться на максимальных окнах меньшего размера с ограничением. В приведенном выше примере окно сеанса 2 будет проигнорировано, и в итоговой оценке будет учитываться только сумма смещений макета в окне сеанса 1.

### Почему мы выбрали именно 5 секунд

Мы проверили различные размеры окон и обнаружили следующее:

- С одной стороны, для коротких окон медленная загрузка и медленный ответ на действия пользователя может разбить смещения макета на несколько окон и улучшить оценку. Мы же не хотели поощрять замедление — значит, размер окна должен быть достаточно большим.
- С другой стороны, есть страницы с постоянным потоком небольших смещений макета. Например, страница результатов матчей, которая немного меняется с появлением новых данных. Такие смещения неудобны, но раздражение от них не увеличивается с течением времени. Так что мы хотели сделать так, чтобы окно не учитывало смещения такого типа.

Учитывая оба пункта и сравнивая окна разных размеров на множестве реальных веб-страниц, мы пришли к выводу, что лучше всего подойдет ограничение в 5 секунд.

## Как изменение повлияет на CLS конкретной страницы

Это изменение ограничивает CLS страницы сверху, поэтому **результат не ухудшится** ни у одной страницы.

Согласно нашему анализу, **в 55 % случаев изменений в CLS в 75-м процентиле вообще не будет**: у соответствующих страниц сейчас либо нет смещений макета, либо имеющиеся смещения уже ограничены одним окном сеанса.

**В остальных случаях в 75-м процентиле будет улучшение:** на большинстве страниц оно будет небольшим, но около 3 % оценок улучшатся с уровня «требует улучшения» или «плохо» до уровня «хорошо». Обычно это страницы с бесконечной прокруткой или множеством медленных обновлений интерфейса — см. одну из [предыдущих статей](/better-layout-shift-metric/).

## Как опробовать новый метод измерения

Скоро мы встроим новое определение метрики в наши инструменты! А пока что обновленную версию CLS можно опробовать на любом сайте с помощью [примеров реализации на JavaScript](https://github.com/mmocny/web-vitals/wiki/Snippets-for-LSN-using-PerformanceObserver). Кроме того, можно [создать ответвление расширения Web Vitals](https://github.com/mmocny/web-vitals-extension/tree/experimental-ls).

Спасибо всем, кто нашел время на предыдущую статью и дал свои отзывы!
