---
layout: post
title: Определение пороговых значений показателей Core Web Vitals
subhead: Исследование и методология пороговых значений Core Web Vitals
authors:
  - bmcquade
description: Исследование и методология пороговых значений Core Web Vitals
date: 2020-05-21
updated: 2022-07-18
hero: image/admin/WNrgCVjmp8Gyc8EbZ9Jv.png
alt: Исследование и методология пороговых значений Core Web Vitals
tags:
  - blog
  - performance
  - web-vitals
---

[Core Web Vitals](/vitals/#core-web-vitals)это набор полевых показателей, которые измеряют важные аспекты взаимодействия с реальным пользователем в Интернете. Core Web Vitals включает метрики, а также целевые пороговые значения для каждой метрики, которые помогают разработчикам качественно оценить, какой у них сайт«хороший», «требующий улучшения» или «плохой». В этой статье будет объяснен подход, используемый для выбора пороговых значений показателей Core Web Vitals в целом, а также то, как были выбраны пороговые значения для каждой конкретной метрики Core Web Vitals.

## Напоминание: показатели и пороговые значения Core Web Vitals

В 2020 году в Core Web Vitals входило три метрики: LCP (Скорость загрузки основного контента), FID (Время ожидания до первого взаимодействия с контентом) и CLS (Совокупное смещение макета). Каждая метрика измеряет различные аспекты взаимодействия с пользователем: LCP измеряет воспринимаемую скорость загрузки и отмечает на временной шкале вероятный момент загрузки основного контента; FID измеряет скорость отклика и количественно оценивает впечатления пользователей от первого взаимодействия со страницей; а CLS измеряет визуальную стабильность и количественно определяет величину неожиданного смещения макета видимого содержимого страницы.

Каждая метрика Core Web Vitals имеет свои пороговые значения, которые определяют производительность страницы как «хорошую», «требующую улучшения» или «плохую»:

<style>
  .cluster > img {
    max-width: 30%;
  }
</style>
<div class="cluster">
  {% Img src="image/tcFciHGuF3MxnTr1y5ue01OGLBn2/ZZU8Z7TMKXmzZT2mCjJU.svg", alt="Рекомендации по пороговому значению скорости загрузки основного контента", width="400", height="350" %}
  {% Img src="image/tcFciHGuF3MxnTr1y5ue01OGLBn2/iHYrrXKe4QRcb2uu8eV8.svg", alt="Рекомендации по пороговому значению времени ожидания до первого взаимодействия с контентом", width="400", height="350" %}
  {% Img src="image/tcFciHGuF3MxnTr1y5ue01OGLBn2/dgpDFckbHwwOKdIGDa3N.svg", alt="Рекомендации по пороговому значению совокупного смещения макета", width="400", height="350" %}
</div>

<div>
  <table>
    <tr>
      <th> </th>
      <th>«Хорошо»</th>
      <th>«Плохо»</th>
      <th>Процентиль</th>
    </tr>
    <tr>
      <td>Cкорость загрузки основного контента (LCP)</td>
      <td>≤2500 мс</td>
      <td>&gt; 4000 мс</td>
      <td>75</td>
    </tr>
    <tr>
      <td>Время ожидания до первого взаимодействия с контентом (FID)</td>
      <td>≤100 мс</td>
      <td>&gt; 300 мс</td>
      <td>75</td>
    </tr>
    <tr>
      <td>Совокупное смещение макета (CLS)</td>
      <td>≤0,1</td>
      <td>&gt; 0,25</td>
      <td>75</td>
    </tr>
</table>
</div>
<p data-md-type="paragraph">Чтобы классифицировать общую производительность страницы или сайта, мы используем значение 75-го процентиля для всех просмотров этой страницы или сайта. Другими словами, если по крайней мере 75% просмотров страниц сайта соответствуют «хорошему» порогу, сайт классифицируется как имеющий «хорошую» производительность по этому показателю. И наоборот, если по крайней мере 25% просмотров страниц соответствуют «плохому» порогу производительности, сайт классифицируется как имеющий «плохую» производительность. Так, например, 75-й процентиль LCP в 2 секунды классифицируется как «хороший», а 75-й процентиль LCP в 5 секунд классифицируется как «плохой».</p>
<h2 data-md-type="header" data-md-header-level="2">Критерии для пороговых значений показателей Core Web Vitals</h2>
<p data-md-type="paragraph">При установлении пороговых значений для показателей Core Web Vitals мы сначала определили критерии, которым должен соответствовать каждый порог. Ниже я объясняю критерии, которые мы использовали в Google для оценки пороговых значений метрик Core Web Vitals 2020. В следующих разделах будет более подробно рассказано о том, как эти критерии применялись для выбора пороговых значений для каждой метрики в 2020 году. В будущие годы мы ожидаем внесения улучшений и дополнений в критерии и пороговые значения, чтобы еще больше улучшить нашу способность измерять впечатления пользователей от Интернета.</p>
<h3 data-md-type="header" data-md-header-level="3">Качественный пользовательский опыт</h3>
<p data-md-type="paragraph">Наша основная цельоптимизировать взаимодействие с пользователем. Поэтому мы стремимся к тому, чтобы страницы с «хорошими» значениям Core Web Vitals обеспечивали хорошие впечатления от взаимодействия.</p>
<p data-md-type="paragraph">Чтобы определить порог для качественного пользовательского опыта, мы обращаемся к человеческому восприятию и исследованиям человеко-машинного взаимодействия (ЧМВ). По данным исследования, рекомендуется использовать в качестве порога диапазон значений, а не единое фиксированное значение. Например, усредненное время ожидания пользователем загрузки страницы до потери фокуса1 секунда, при этом фактический диапазон времени ожидания начинается от сотен миллисекунд и заканчивается несколькими секундами. Пороги восприятия различаются в зависимости от пользователя и контекста, и это дополнительно подтверждается агрегированными и анонимными данными метрик Chrome, которые показывают, что не существует единого для всех пользователей правильного времени загрузки контента. Эти данные демонстрируют сглаженное и непрерывное распределение. Более подробную информацию о порогах человеческого восприятия и соответствующих исследованиях ЧМВ см. в статье <a href="https://blog.chromium.org/2020/05/the-science-behind-web-vitals.html" data-md-type="link">«Научные основы Web Vitals»</a>.</p>
<p data-md-type="paragraph">В случаях, когда для данной метрики доступно соответствующее исследование пользовательского опыта и существует разумный консенсус относительно диапазона значений в литературе, мы используем этот диапазон в качестве входных данных для выбора пороговых значений. Если же соответствующее исследование пользовательского опыта недоступно, например, для новой метрики, такой как совокупное смещение макета, мы оцениваем реальные страницы, соответствующие разным вероятным пороговым значениям этой метрики, чтобы определить диапазон, который приводит к хорошему пользовательскому опыту.</p>
<h3 data-md-type="header" data-md-header-level="3">Пороговые значения, достижимые для существующего веб-контента</h3>
<p data-md-type="paragraph">Чтобы владельцы могли успешно оптимизировать свои сайты и достичь «хороших» показателей, нужно, чтобы эти показатели были достижимы для существующего контента в Интернете. Например, ноль миллисекундидеальный «хороший» порог LCP, приводящий к мгновенной загрузке. Но пороговое значение в ноль миллисекунд в большинстве случаев практически недостижимо из-за задержек обработки сети и устройства. Таким образом, ноль миллисекунд не является разумно обоснованным «хорошим» порогом LCP для Core Web Vitals.</p>
<p data-md-type="paragraph">При оценке возможных «хороших» пороговых значений Core Web Vitals мы проверяем достижимость этих пороговых значений на основе данных из отчета<a href="https://developer.chrome.com/docs/crux/" data-md-type="link">Chrome User Experience Report</a> (CrUX). Чтобы подтвердить, что порог достижим, мы требуем, чтобы по крайней мере 10% <a href="/same-site-same-origin/#origin" data-md-type="link">источников</a> в настоящее время соответствовали «хорошему» порогу. Чтобы гарантировать, что хорошо оптимизированные сайты не будут неправильно классифицированы из-за изменчивости полевых данных, мы также проверяем, чтобы хорошо оптимизированный контент постоянно соответствовал «хорошему» порогу.</p>
<p data-md-type="paragraph">И наоборот, мы устанавливаем «плохой» порог, определяя уровень производительности, которому в настоящее время не соответствует лишь меньшинство источников. Если нет исследований о «плохом» пороге, то по умолчанию 10–30% источников с наихудшими результатами классифицируются как «плохие».</p>
<h3 data-md-type="header" data-md-header-level="3">Заключительные мысли о критериях</h3>
<p data-md-type="paragraph">При оценке вероятных пороговых значений мы обнаружили, что критерии иногда противоречили друг другу. Например, может возникнуть противоречие между стабильно достижимым пороговым значением и обеспечением стабильно хорошего взаимодействия с пользователем. Кроме того, учитывая, что исследование человеческого восприятия обычно предоставляет диапазон значений, а показатели поведения пользователей показывают постепенные изменения в поведении, мы обнаружили, что часто не существует единого «правильного» порога для показателя. Таким образом, наш подход к Core Web Vitals 2020 года заключался в выборе пороговых значений, которые наилучшим образом соответствуют указанным выше критериям, признавая при этом, что не существует единого идеального порогового значения и что иногда нам потребуется выбирать из нескольких приемлемых возможных пороговых значений. Вместо того чтобы задаваться вопросом об идеальном пороге, мы сосредоточились на том, чтобы узнать, какой вероятный порог лучше всего соответствует нашим критериям.</p>
<h2 data-md-type="header" data-md-header-level="2">Выбор процентиля</h2>
<p data-md-type="paragraph">Как отмечалось ранее, для классификации общей производительности страницы или сайта мы используем значение 75-го процентиля всех посещений этой страницы или сайта. 75-й процентиль был выбран на основе двух критериев. Во-первых, процентиль должен гарантировать, что большинство посещений страницы или сайта имели целевой уровень эффективности. Во-вторых, выпадающие значения не должны оказывать чрезмерного влияния на значение выбранного процентиля.</p>
<p data-md-type="paragraph">Эти цели несколько расходятся друг с другом. Для достижения первой цели, как правило, более высокий процентильлучший выбор. Однако с более высокими процентилями вероятность того, что на результирующее значение повлияют выпадающие показатели, также возрастает. Если несколько посещений сайта происходят при нестабильных сетевых подключениях, и это приводит к чрезмерно большим выборкам LCP, мы не хотим, чтобы наша классификация сайтов определялась этими исключениями. Например, если бы мы оценивали эффективность сайта с 100 посещениями, используя высокий процентиль, такой как 95-й, то значение 95-го процентиля подверглось бы влиянию исключений всего при 5 выпадающих значениях.</p>
<p data-md-type="paragraph">Учитывая, что эти цели немного расходятся, после анализа мы пришли к выводу, что 75-й процентиль обеспечивает разумный баланс. Используя 75-й процентиль, мы знаем, что большинство посещений сайта (3 из 4) имели целевой уровень эффективности или выше. Кроме того, значение 75-го процентиля с меньшей вероятностью будет подвержено влиянию выпадающих значений. Возвращаясь к нашему примеру, для сайта со 100 посещениями, чтобы на значение 75-го процентиля повлияли статистические выбросы, 25 из этих посещений должны были бы дать выпадающие значения. Хотя 25 из 100 выборок могут являться статистическими выбросами, вероятность этого гораздо меньше, чем в случае с 95-м процентилем.</p>
<h2 data-md-type="header" data-md-header-level="2">Скорость загрузки основного контента (LCP)</h2>
<h3 data-md-type="header" data-md-header-level="3">Качество опыта</h3>
<p data-md-type="paragraph">1 секунда часто упоминается как время, в течение которого пользователь будет ждать, прежде чем начнет терять фокус на задаче. При более тщательном изучении соответствующих исследований мы обнаружили, что 1 секундаэто приблизительное значение, описывающее диапазон значений, примерно от нескольких сотен миллисекунд до нескольких секунд.</p>
<p data-md-type="paragraph">Двумя наиболее часто цитируемыми источниками определения порога в 1 секунду являются <a href="https://dl.acm.org/doi/10.1145/108844.108874" data-md-type="link">Кард и другие</a> и <a href="https://dl.acm.org/doi/10.1145/1476589.1476628" data-md-type="link">Миллер</a>. Кард определяет порог «мгновенной реакции» в 1 секунду, ссылаясь на книгу Ньюэлла <a href="https://dl.acm.org/doi/book/10.5555/86564" data-md-type="link">«Объединенные теории познания»</a>. Ньюэлл объясняет мгновенные реакции как «реакции, которые должны быть даны на некоторый стимул в течение <em data-md-type="emphasis">очень приблизительной одной секунды</em> (то есть примерно от ~ 0,3 до ~ 3 секунд)». Это следует из дискуссии Ньюэлла об «ограничениях познания в реальном времени», где отмечается, что «взаимодействия с окружающей средой, вызывающие когнитивные размышления, происходят в течение нескольких секунд», которые варьируются примерно от 0,5 до 2–3 секунд. Миллер, еще один часто цитируемый источник порога в 1 секунду, отмечает, что «задачи, которые люди могут и будут выполнять с помощью машинной связи, серьезно изменят свой характер, если задержка ответа будет превышать две секунды, с возможным увеличением еще на секунду или около того».</p>
<p data-md-type="paragraph">В исследовании Миллера и Карда количество времени, в течение которого пользователь будет ждать, прежде чем потеряет фокус, описывается как диапазон от примерно 0,3 до 3 секунд, что позволяет предположить, что наш порог «хорошего» показателя LCP должен находиться в этом диапазоне. Кроме того, учитывая, что существующий «хороший» порог для FCP (Первой отрисовки контента) составляет 1 секунду, и что LCP (Скорость загрузки основного контента) обычно случается после FCP, мы дополнительно ограничиваем наш диапазон возможных пороговых значений LCP от 1 до 3 секунд. Чтобы выбрать порог в этом диапазоне, который лучше всего соответствует нашим критериям, мы посмотрим на достижимость этих возможных пороговых значений ниже.</p>
<h3 data-md-type="header" data-md-header-level="3">Достижимость</h3>
<p data-md-type="paragraph">Используя данные из CrUX, мы можем определить процент источников в Интернете, которые соответствуют «хорошим» вероятным пороговым значениям LCP.</p>
<p data-md-type="paragraph"><strong data-md-type="double_emphasis">% источников CrUX, классифицированных как «хорошие» (для возможных пороговых значений LCP)</strong></p>
<div data-md-type="block_html"><div>
  <table>
    <tr>
      <th> </th>
      <th>1 секунда</th>
      <th>1,5 секунды</th>
      <th>2 секунды</th>
      <th>2,5 секунды</th>
      <th>3 секунды</th>
    </tr>
    <tr>
      <td><strong>Мобильные устройства</strong></td>
      <td>3,5%</td>
      <td>13%</td>
      <td>27%</td>
      <td>42%</td>
      <td>55%</td>
    </tr>
    <tr>
      <td><strong>ПК</strong></td>
      <td>6,9%</td>
      <td>19%</td>
      <td>36%</td>
      <td>51%</td>
      <td>64%</td>
    </tr>
  </table>
</div></div>
<p data-md-type="paragraph">В то время как менее 10% источников соответствуют порогу в 1 секунду, все остальные пороговые значения от 1,5 до 3 секунд удовлетворяют нашему требованию о том, чтобы не менее 10% источников соответствовали «хорошему» порогу и, таким образом, выбор этого диапазон более обоснован в качестве вероятного порога.</p>
<p data-md-type="paragraph">Кроме того, чтобы гарантировать, что выбранный порог постоянно достигается для хорошо оптимизированных сайтов, мы анализируем производительность LCP для наиболее эффективных сайтов в Интернете, чтобы определить, какие пороговые значения стабильно достижимы для этих сайтов. В частности, мы стремимся определить порог, который постоянно достигается на 75-м процентиле для наиболее эффективных сайтов. Мы обнаружили, что пороговые значения 1,5 и 2 секунды не всегда достижимы, в то время как 2,5 секунды достижимы.</p>
<p data-md-type="paragraph">Для определения «плохого» порога LCP мы использовали данные CrUX, чтобы определить порог, которому соответствует большинство источников:</p>
<p data-md-type="paragraph"><strong data-md-type="double_emphasis">% источников CrUX, классифицированных как «плохие» (для возможных пороговых значений LCP)</strong></p>
<div data-md-type="block_html"><div>
  <table>
    <tr>
      <th> </th>
      <th>3 секунды</th>
      <th>3,5 секунды</th>
      <th>4 секунды</th>
      <th>4,5 секунды</th>
      <th>5 секунд</th>
    </tr>
    <tr>
      <td><strong>Мобильные устройства</strong></td>
      <td>45%</td>
      <td>35%</td>
      <td>26%</td>
      <td>20%</td>
      <td>15%</td>
    </tr>
    <tr>
      <td><strong>ПК</strong></td>
      <td>36%</td>
      <td>26%</td>
      <td>19%</td>
      <td>14%</td>
      <td>10%</td>
    </tr>
  </table>
</div></div>
<p data-md-type="paragraph">При 4-секундном пороге примерно 26% мобильных устройств и 21% компьютеров будут классифицироваться как «плохие». Это попадает в наш целевой диапазон 10–30%, поэтому мы заключаем, что 4 секундыприемлемый «плохой» порог.</p>
<p data-md-type="paragraph">Таким образом, мы заключаем, что 2,5 секундыэто разумно обоснованный «хороший» порог, а 4 секундыразумно обоснованный «плохой» порог для метрики LCP.</p>
<h2 data-md-type="header" data-md-header-level="2">Время ожидания до первого взаимодействия с контентом (FID)</h2>
<h3 data-md-type="header" data-md-header-level="3">Качество опыта</h3>
<p data-md-type="paragraph">Исследования достаточно последовательны в выводах о том, что задержки в визуальной обратной связи до 100 мс воспринимаются как вызванные связанным источником, таким как пользовательский ввод. Это говорит о том, что «хороший» порог задержки первого ввода в 100 мс, вероятно, подходит в качестве минимальной планки: если задержка обработки ввода превышает 100 мс, нет никаких шансов, что другие этапы обработки и рендеринга завершатся вовремя.</p>
<p data-md-type="paragraph">В часто цитируемой работе Якоба Нильсена <a href="https://www.nngroup.com/articles/response-times-3-important-limits/" data-md-type="link">«Время отклика: 3 важных предела»</a> 0,1 секунды определяется как предел, при котором пользователь чувствует, что система реагирует мгновенно. Нильсен ссылается на Миллера и Карда, которые цитируют работу Мишотта <a href="https://psycnet.apa.org/record/1964-05029-000" data-md-type="link">«Восприятие причинности»</a> (1962). В исследовании Мишотта участникам эксперимента показывали «два объекта на экране. Объект А начинал движение по направлению к объекту Б. Он останавливался, когда доходил до Б, затем объект Б начинал движение и удалялся от А». Мишотт изменял временной интервал между остановкой объекта А и началом движения объекта Б. Учёный обнаружил, что при задержках примерно до 100 мс у участников создавалось впечатление, что объект А вызывал движение объекта Б. При задержках примерно от 100 до 200 мс восприятие причинности было неоднозначно, а при задержках более 200 мс движение объекта Б уже не воспринималось как вызванное объектом А.</p>
<p data-md-type="paragraph">Аналогичным образом Миллер определяет порог срабатывания для «реакции на управляющее воздействие» как «указание на действие, обычно вызываемое движением клавиши, переключателя или другого элемента управления, которое сигнализирует о том, что он был физически активирован. Эта реакция должна... восприниматься как часть механического воздействия, вызванного оператором. Временная задержка: не более 0,1 секунды», и далее по тексту «задержка между нажатием клавиши и визуальной обратной связью должна быть не более 0,1–0,2 секунды».</p>
<p data-md-type="paragraph">Относительно недавно в работе Кааресоя и др. <a href="https://dl.acm.org/doi/10.1145/2611387" data-md-type="link">«На пути к идеальной виртуальной кнопке»</a> исследовалось восприятие одновременности между касанием виртуальной кнопки на сенсорном экране и последующим визуальным откликом, указывающем на то, что кнопка была нажата, при различных задержках. Когда задержка между нажатием кнопки и визуальным откликом составляла 85 мс или меньше, участники сообщали, что визуальный отклик появлялся одновременно с нажатием кнопки в 75% случаев. Кроме того, для задержек в 100 мс или меньше участники сообщали о неизменно высоком воспринимаемом качестве нажатия кнопки, при этом воспринимаемое качество снижалось при задержках от 100 до 150 мс и достигало очень низких уровней при задержке в 300 мс.</p>
<p data-md-type="paragraph">Учитывая вышеизложенное, мы заключаем, что исследования указывают на диапазон значений около 100 мс в качестве подходящего порога для метрики FID (Время ожидания до первого взаимодействия с контентом) из набора Web Vitals. Кроме того, учитывая, что пользователи сообщили о низком уровне качества для задержек 300 мс или более, 300 мс представляется разумно обоснованным «плохим» порогом.</p>
<h3 data-md-type="header" data-md-header-level="3">Достижимость</h3>
<p data-md-type="paragraph">Используя данные CrUX, мы определили, что большинство источников в Интернете соответствуют порогу «хорошего» FID в 100 мс на уровне 75-го процентиля:</p>
<p data-md-type="paragraph"><strong data-md-type="double_emphasis">% источников CrUX, классифицированных как «хорошие» для порога FID в 100 мс</strong></p>
<div data-md-type="block_html"><div>
  <table>
    <tr>
      <th></th>
      <th>100 мс</th>
    </tr>
    <tr>
      <td><strong>Мобильные устройства</strong></td>
      <td>78%</td>
    </tr>
    <tr>
      <td><strong>ПК</strong></td>
      <td>&gt; 99%</td>
    </tr>
  </table>
</div></div>
<p data-md-type="paragraph">Кроме того, мы наблюдаем, что ведущие сайты в Интернете могут постоянно соответствовать этому пороговому значению на 75-м процентиле (а часто и на 95-м процентиле).</p>
<p data-md-type="paragraph">Учитывая вышеизложенное, мы заключаем, что 100 мсразумно обоснованный «хороший» порог для FID.</p>
<h2 data-md-type="header" data-md-header-level="2">Совокупное смещение макета (CLS)</h2>
<h3 data-md-type="header" data-md-header-level="3">Качество опыта</h3>
<p data-md-type="paragraph">CLS (Совокупное смещение макета)это новая метрика, которая измеряет, насколько сильно смещается видимое содержимое страницы. Поскольку CLSновая метрика, мы не знаем об исследованиях, которые могли бы помочь напрямую определить пороговые значения для неё. Поэтому, чтобы определить порог, соответствующий ожиданиям пользователей, мы оценили реальные страницы с разной степенью смещения макета, чтобы определить максимальную величину смещения, которая ещё воспринимается как приемлемая, а не вызывающая значительные сбои при взаимодействии с содержимым страницы. В ходе внутреннего тестирования мы обнаружили, что уровни смещения от 0,15 и выше всегда воспринимались как деструктивные, в то время как смещения от 0,1 и ниже были заметными, но не вызывали чрезмерных сбоев. Таким образом, хотя нулевой сдвиг макетаидеальный вариант, мы пришли к выводу, что значения до 0,1 являются вероятным «хорошим» порогом для CLS.</p>
<h3 data-md-type="header" data-md-header-level="3">Достижимость</h3>
<p data-md-type="paragraph">Основываясь на данных CrUX, мы видим, что почти 50% источников имеют CLS 0,05 или ниже.</p>
<p data-md-type="paragraph"><strong data-md-type="double_emphasis">% источников CrUX, классифицированных как «хорошие» (для возможных пороговых значений CLS)</strong></p>
<div data-md-type="block_html"><div>
  <table>
    <tr>
      <th> </th>
      <th>0,05</th>
      <th>0,1</th>
      <th>0,15</th>
    </tr>
    <tr>
      <td><strong>Мобильные устройства</strong></td>
      <td>49%</td>
      <td>60%</td>
      <td>69%</td>
    </tr>
    <tr>
      <td><strong>ПК</strong></td>
      <td>42%</td>
      <td>59%</td>
      <td>69%</td>
    </tr>
  </table>
</div></div>
<p data-md-type="paragraph">Хотя данные CrUX свидетельствуют о том, что 0,05 может быть разумным «хорошим» порогом CLS, мы признаем, что есть некоторые варианты использования, где в настоящее время трудно избежать деструктивных смещений макета. Например, для стороннего встраиваемого контента, такого как встраиваемые объекты социальных сетей, высота встраиваемого контента иногда неизвестна до окончания загрузки, что может привести к смещению макета более чем на 0,05. Таким образом, мы пришли к выводу, что, хотя многие источники соответствуют порогу 0,05, чуть менее строгий порог CLS в 0,1 обеспечивает лучший баланс между качеством опыта и достижимостью. Мы надеемся, что в будущем экосистема веб-разработки найдет решения для устранения смещений макета, вызванных сторонними встраиваемыми объектами, что позволит использовать более строгий порог «хорошего» CLS в 0,05 или 0 в одной из будущих итераций Core Web Vitals.</p>
<p data-md-type="paragraph">Для определения «плохого» порога CLS мы использовали данные CrUX, чтобы определить порог, которому соответствует большинство источников:</p>
<p data-md-type="paragraph"><strong data-md-type="double_emphasis">% источников CrUX, классифицированных как «плохие» (для возможных пороговых значений CLS)</strong></p>
<div data-md-type="block_html"><div>
  <table>
    <tr>
      <th> </th>
      <th>0,15</th>
      <th>0,2</th>
      <th>0,25</th>
      <th>0,3</th>
    </tr>
    <tr>
      <td><strong>Мобильные устройства</strong></td>
      <td>31%</td>
      <td>25%</td>
      <td>20%</td>
      <td>18%</td>
    </tr>
    <tr>
      <td><strong>ПК</strong></td>
      <td>31%</td>
      <td>23%</td>
      <td>18%</td>
      <td>16%</td>
    </tr>
  </table>
</div></div>
<p data-md-type="paragraph">При пороговом значении 0,25 примерно 20% мобильных устройств и 18% компьютеров будут классифицироваться как «плохие». Это попадает в наш целевой диапазон 10–30%, поэтому мы пришли к выводу, что 0,25приемлемый порог для «плохих» значений.</p>
