---
layout: post
title: Управление фокусом при помощи tabindex
authors:
  - robdodson
date: 2018-11-18
description: Стандартные HTML-элементы, такие как <button> или <input>, доступны с клавиатуры по умолчанию. Если вы создаете собственные интерактивные компоненты, используйте tabindex, чтобы они также были доступны с клавиатуры.
---

Стандартные HTML-элементы, такие как `<button>` или `<input>`, доступны с клавиатуры по умолчанию. Если вы создаете *собственные* интерактивные компоненты, используйте атрибут `tabindex`, чтобы они также были доступны с клавиатуры.

{% Aside %} Когда есть возможность, используйте встроенные HTML-элементы, вместо того того чтобы создавать свою нестандартную версию. Например, элемент `<button>` с легкостью поддается стилизации и уже имеет полную поддержку клавиатуры. Это избавит вас от необходимости управлять атрибутом `tabindex` или добавлять семантическую информацию при помощи ARIA. {% endAside %}

## Проверьте, доступны ли элементы управления с клавиатуры

Некоторые проблемы с доступностью легко выявляются при помощи таких инструментов, как Lighthouse, однако существуют моменты, которые может проверить только человек.

Попробуйте использовать клавишу `Tab` для навигации по вашему сайту. Все ли интерактивные элементы управления удается выбрать? Если ответ отрицательный, возможно, необходимо сделать их фокусируемыми при помощи атрибута [`tabindex`](https://developer.mozilla.org/docs/Web/HTML/Global_attributes/tabindex).

{% Aside 'warning' %} Если вы вообще не видите индикатор фокуса, возможно, он скрыт при помощи CSS-кода. Проверьте все стили, в которых встречается `:focus { outline: none; }`. О том, как исправить эту проблему, вы можете узнать в нашем руководстве по [стилизации фокуса](/style-focus). {% endAside %}

## Включение элемента в последовательность перехода

Чтобы включить элемент в естественную последовательность перехода по Tab, используйте `tabindex="0"`. Например:

```html
<div tabindex="0">Focus me with the TAB key</div>
```

Установить фокус на элементе можно при помощи клавиши `Tab` или метода `focus()`.

{% Glitch { id: 'tabindex-zero', path: 'index.html', height: 346 } %}

## Исключение элемента из последовательности перехода

Исключить элемент можно при помощи `tabindex="-1"`. Например:

```html
<button tabindex="-1">Can't reach me with the TAB key!</button>
```

Это позволяет исключить элемент из естественной последовательности перехода по Tab, однако на элементе по-прежнему можно будет установить фокус при помощи метода `focus()`.

{% Glitch { id: 'tabindex-negative-one', path: 'index.html', height: 346 } %}

Обратите внимание, что атрибут `tabindex="-1"` не распространяется на потомки элемента: они продолжат быть частью последовательности перехода вне зависимости от того, находились ли они там изначально или были включены при помощи `tabindex`. Чтобы исключить элемент из последовательности перехода вместе со всеми его потомками, можно воспользоваться [polyfill-библиотекой `inert` из репозитория WICG](https://github.com/WICG/inert). Она имитирует поведение предлагаемого атрибута `inert`, который запрещает выбор элементов или их чтение при помощи вспомогательных технологий.

{% Aside 'caution' %} Polyfill-библиотека `inert` является экспериментальной, и в некоторых случаях ее поведение может отличаться от ожидаемого. Тщательно протестируйте ее, прежде чем использовать ее на реальных сайтах. {% endAside %}

## Избегайте `tabindex > 0`

Значения `tabindex` больше 0 позволяют переместить элемент в начало естественного порядка перехода. Если на странице несколько элементов с `tabindex` больше 0, то самый высокий приоритет имеют элементы с наименьшим значением.

Использование `tabindex` со значениями больше 0 считается **анти-паттерном**, поскольку программы чтения с экрана при перемещении по странице руководствуются порядком DOM, а не порядком перехода по Tab. Для того чтобы изменить порядок следования элементов при переходе по Tab, следует изменить их порядок в DOM.

Lighthouse позволяет с легкостью обнаруживать элементы с `tabindex` > 0. Запустите проверку доступности (Lighthouse > Options > Accessibility) и изучите результаты проверки «No element has a [tabindex] value greater than 0».

## Создавайте доступные компоненты, используя прием «блуждающий `tabindex`»

Если вы разрабатываете сложный компонент, вам может потребоваться дополнительная поддержка клавиатуры помимо фокусировки. Например, рассмотрим встроенный элемент `select`. Он поддерживает фокусировку, однако при помощи клавиш со стрелками можно получить доступ к дополнительным функциям (выбору вариантов).

Чтобы реализовать аналогичную функциональность в нестандартных компонентах, используйте метод под названием «блуждающий `tabindex`». Суть метода заключается в том, что для всех дочерних элементов, кроме активного в данный момент, устанавливается `tabindex` -1. Затем компонент использует слежение за событиями клавиатуры для определения нажатия клавиш.

Когда пользователь нажимает клавишу, компонент присваивает ранее сфокусированному дочернему элементу `tabindex` -1, а элементу, который должен получить фокус, — `tabindex` 0, после чего вызывает для него метод `focus()`.

**Было**

```html/2-3
<div role="toolbar">
  <button tabindex="-1">Undo</div>
  <button tabindex="0">Redo</div>
  <button tabindex="-1">Cut</div>
</div>
```

**Стало**

```html/2-3
<div role="toolbar">
  <button tabindex="-1">Undo</div>
  <button tabindex="-1">Redo</div>
  <button tabindex="0">Cut</div>
</div>
```

{% Glitch { id: 'roving-tabindex', path: 'index.html', height: 346 } %}

{% Aside %} Интересуетесь, зачем нужны атрибуты `role=""`? Они изменяют семантику элемента, для того чтобы он корректно озвучивался программами чтения с экрана. Узнать о них подробнее можно в нашем [базовом руководстве по программам чтения с экрана](/semantics-and-screen-readers). {% endAside %}

{% Assessment 'self-assessment' %}

## Советы по реализации поддержки клавиатуры

Если вы не уверены насчет того, какой уровень поддержки клавиатуры может потребоваться  для ваших нестандартных  компонентов, обратитесь к руководству [ARIA Authoring Practices 1.1](https://www.w3.org/TR/wai-aria-practices-1.1/). В нем приводятся распространенные паттерны пользовательских интерфейсов и рассказывается о том, какие клавиши должны поддерживаться в ваших компонентах.
