---
layout: post
title: Доступность по цвету и контрастности
authors:
  - dgash
  - megginkearney
  - rachelandrew
  - robdodson
date: 2020-03-31
updated: 2020-05-29
description: |
  Если у вас хорошее зрение, вы вряд ли задумываетесь, что другие могут воспринимать цвета иначе или видеть текст хуже, чем вы, — а ведь это именно так.
tags:
  - accessibility
---

Если у вас хорошее зрение, вы вряд ли задумываетесь, что другие могут
воспринимать цвета иначе или видеть текст хуже, чем вы, — а ведь это именно так.

Некоторые сочетания цветов
легко воспринимаются одними людьми, но другие их различают с трудом или не различают вообще.
Обычно проблема сводится к цветовому контрасту —
соотношению яркости цветов переднего и заднего плана.
Если цвета похожи, контрастность низкая;
если они различаются, контрастность высокая.

В [руководстве WebAIM](https://webaim.org/standards/wcag/) для текста рекомендуется минимальная контрастность уровня AA — 4,5:1.
Исключение — очень крупный текст (на 120–150 % больше основного текста по умолчанию):
здесь контрастность может составлять 3:1. Обратите внимание на разницу в контрасте ниже.

<figure>
  {% Img src="image/admin/DcYclKelVqhQ2CWlIG97.jpg", alt="Изображение, показывающее различную контрастность", width="800", height="328" %}
</figure>

Контрастность 4,5:1 выбрана для уровня AA, чтобы
компенсировать потерю контрастной чувствительности,
которая обычно наблюдается при ухудшении зрения до уровня примерно 0,5,
который считается типичной остротой зрения для людей в возрасте около 80 лет.
Для пользователей с ослабленным зрением и недостатком цветового
зрения контрастность основного текста можно увеличить до 7:1.

Для проверки цветового контраста можно использовать аудит «Специальные возможности» (Accessibility Audit) в Lighthouse.
Откройте DevTools, щелкните «Аудиты» (Audits или Lighthouse), выберите «Специальные возможности» (Accessibility)
и создайте отчет.

<figure>
  {% Img src="image/admin/vSFzNOurQO6z2xV6qWuW.png", alt="Скриншот вывода от аудита по цветовому контрасту.", width="800", height="218" %}
</figure>

В браузере Chrome также есть экспериментальная функция, которая поможет [обнаружить низкоконтрастный
текст на странице](https://developers.google.com/web/updates/2020/10/devtools#css-overview). А исправить низкий контраст можно с помощью [подсказки по доступности цветов](https://developers.google.com/web/updates/2020/08/devtools#accessible-color).

<figure>
  {% Img src="image/admin/VYZeK2l2vs6pIoWhH2hO.png", alt="Скриншот вывода экспериментальной функции Chrome по поиску низкоконтрастного текста.", width="800", height="521" %}
</figure>

Более подробный отчет можно получить, установив [расширение Accessibility Insights](https://accessibilityinsights.io/).
Одна из проверок в отчете Fastpass — цветовой контраст.
Вы получите подробные сведения обо всех элементах, не соответствующих требованиям.

<figure>
  {% Img src="image/admin/CR21TFMZw8gWsSTWOGIF.jpg", alt="Отчет в Accessibility Insights", width="800", height="473" %}
</figure>

## Расширенный алгоритм восприятия контраста (APCA)

[Расширенный алгоритм восприятия контраста (Advanced Perceptual Contrast Algorithm, APCA)](https://w3c.github.io/silver/guidelines/methods/Method-font-characteristic-contrast.html) — это новый способ вычисления контраста, основанный на современных исследованиях цветового восприятия.

В сравнении с указаниями по уровням [AA](https://www.w3.org/WAI/WCAG21/quickref/#contrast-minimum)и [AAA](https://www.w3.org/WAI/WCAG21/quickref/#contrast-enhanced) этот алгоритм больше зависит от контекста.

Контраст рассчитывается на основе следующих характеристик:

- Пространственные свойства (вес шрифта и размер текста).
- Цвет текста (воспринимаемая разница в яркости между текстом и фоном).
- Контекст (окружающий свет, среда и предназначение текста).

В браузере Chrome есть [экспериментальная функция, которая заменяет рекомендации AA/AAA на APCA](https://developers.google.com/web/updates/2021/01/devtools#apca).

<figure>
  {% Img src="image/admin/YhGKRLYvt37j3ldlwiXE.png", alt="Скриншот с выводом функции APCA в Chrome.", width="800", height="543" %}
</figure>

## При передаче информации не полагайтесь только на цвет

В мире около 320 миллионов человек страдают недостатком цветового зрения.
Примерно 1 из 12 мужчин и 1 из 200 женщин страдают той или иной формой «цветовой слепоты» —
то есть, около 1/20, или 5 %, ваших пользователей будут видеть ваш сайт не так, как вы задумали.
Полагаясь на цвет для передачи информации, мы доводим это число до неприемлемого уровня.

{% Aside %}
Примечание. Термин «цветовая слепота» часто используется для описания недостатка зрения, при котором различение цветов затруднено,
однако полная цветовая слепота встречается очень редко.
Большинство людей с недостатком цветового зрения видят цветовой спектр частично или почти полностью,
но им трудно различать определенные цвета — например, красный и зеленый (наиболее частый случай),
коричневый и оранжевый, синий и фиолетовый.
{% endAside %}

Например, недействительный номер телефона в форме ввода
может подчеркиваться красным.
Но при недостатке цветового зрения или использовании программы чтения с экрана эта информация будет передана плохо или вообще потеряется.
Поэтому всегда нужно стараться предоставить несколько способов получения важной информации.

<figure style="width: 200px">
  {% Img src="image/admin/MKmlhejyjNpk7XE9R2KV.png", alt="Изображение формы ввода с неверным номером телефона, который выделен только красным цветом.", width="293", height="323" %}
</figure>

В [разделе 1.4.1 контрольного списка WebAIM](https://webaim.org/standards/wcag/checklist#sc1.4.1) сказано
не использовать цвет как единственный способ передачи контента или различения визуальных элементов,
Также там говорится не выделять ссылки на тексте исключительно цветом, если он
не отвечает определенным требованиям к контрастности.
При этом для указания на активную ссылку рекомендуется использовать дополнительный индикатор,
например подчеркивание (с помощью CSS-свойства `text-decoration`).

В предыдущем примере можно просто добавить в поле сообщение, говорящее о том, что
значение недействительно (и в чем проблема).

<figure style="width: 200px">
  {% Img src="image/admin/FLQPcG16akNRoElx3pnz.png", alt="Форма ввода из предыдущего примера — на этот раз с текстовой меткой, указывающей на проблему с полем.", width="292", height="343" %}
</figure>

При создании приложения нужно помнить обо всем этом и следить за тем,
чтобы не полагаться слишком сильно на цвет для передачи важной информации.

Если вам интересно, как сайт выглядит для людей с нарушениями зрения,
или если вы сильно полагаетесь на цвет в интерфейсе,
то можете с помощью DevTools имитировать зрительные нарушения,
включая цветовую слепоту различных видов.
В браузере Chrome есть [функция «Эмулировать дефекты зрения»](https://developers.google.com/web/updates/2020/03/devtools#vision-deficiencies) (Emulate Vision Deficiencies):
откройте DevTools и перейдите на вкладку **Отрисовка** (Rendering) в нижней панели.
Здесь можно имитировать следующие недостатки цветового зрения:

- Протанопия — неспособность воспринимать красный цвет.
- Дейтеранопия — неспособность воспринимать зеленый цвет.
- Тританопия— неспособность воспринимать синий цвет.
- Ахроматопсия: неспособность воспринимать цвета вообще, за исключение оттенков серого (встречается крайне редко).

<figure>
  {% Img src="image/admin/VAnFxYhzFcpovdTCToPl.jpg", alt="Имитация зрения человека с ахроматопсией: наша страница отображается в оттенках серого.", width="800", height="393" %}
</figure>

## Режим высокой контрастности

Режим высокой контрастности позволяет инвертировать цвета переднего и заднего плана,
что часто помогает лучше выделить текст.
Для людей с нарушениями зрения такой режим
может значительно упростить навигацию по контенту на странице.
У себя на компьютере настроить высокую контрастность можно несколькими способами.

В операционных системах (например, Mac OSX и Windows) есть режимы высокой контрастности,
которые включаются на уровне системы для всего интерфейса.

Полезно иногда включать высокую контрастность и проверять,
как отображается интерфейс приложения и насколько он остается удобным.

Например, в панели навигации для указания на активную страницу может
использоваться неконтрастный фоновый оттенок.
Если включить режим высокой контрастности, этот цвет становится незаметным
и становится непонятно, какая страница активна.

<figure style="width: 500px">
  {% Img src="image/admin/dgmA4W1Qu8JmcgsH80HD.png", alt="Скриншот панели навигации в режиме высокой контрастности: непонятно, какая вкладка активна", width="640", height="57" %}
</figure>

А в примере выше красное подчеркивание в поле недействительного
номера телефона может отображаться трудно различимым
сине-зеленым цветом.

<figure>
  {% Img src="image/admin/HtlXwmHQHBcAO4LYSfAA.jpg", alt="Скриншот использованной ранее адресной формы в режиме высокой контрастности. Изменение цвета недействительного элемента трудно читается.", width="700", height="328" %}
</figure>

Если обеспечить соответствие упомянутым выше требованиям
к контрасту, то в режиме высокой контрастности всё будет хорошо.
Но спокойствия ради можно установить
[расширение High Contrast для Chrome](https://chrome.google.com/webstore/detail/high-contrast/djcfdncoelnlbldjfhinnjlhdjlikmph)
и проверить страницу на предмет того, правильно ли всё работает и выглядит.