---
layout: post
title: Por que a velocidade é importante?
authors:
  - bojanpavic
  - ansteychris
  - jlwagner
description: Quando se fala em experiência do usuário, a velocidade importa. E atrasos causados pela velocidade em dispositivos móveis não apenas são frustrantes, mas também podem ter um impacto negativo nos resultados dos negócios.
web_lighthouse: N/D
date: 2019-05-01
updated: 2020-07-23
tags:
  - performance
---

Os consumidores dependem cada vez mais do celular para acessar conteúdos e serviços digitais, e se você olhar a análise do seu site, provavelmente verá essa história se confirmando com seus próprios dados. Os consumidores também estão mais exigentes do que nunca e, ao avaliar a experiência em seu site, não estão apenas comparando você com seus concorrentes, mas também estão classificando você em relação aos melhores serviços da classe que usam todos os dias.

Esta postagem resume algumas das pesquisas feitas sobre a relação entre desempenho e o sucesso nos negócios.

## Desempenho envolve reter usuários

<figure data-float="right">
  <blockquote>
    <p>O desempenho impactou diretamente os resultados financeiros da empresa.</p>
    <cite>
      <p data-md-type="paragraph"><a href="https://www.youtube.com/watch?v=Xryhxi45Q5M&amp;feature=youtu.be&amp;t=1366">Pinterest</a></p>
    </cite>
  </blockquote></figure>

O desempenho representa um papel importante no sucesso de qualquer empreendimento online. Sites de alto desempenho envolvem e retêm os usuários melhor do que os de baixo desempenho.

O Pinterest reduziu os tempos de espera percebidos em 40% e isso [aumentou o tráfego do mecanismo de pesquisa e as inscrições em 15%](https://medium.com/@Pinterest_Engineering/driving-user-growth-with-performance-improvements-cfc50dafadd7) .

O COOK reduziu o tempo médio de carregamento da página em 850 milissegundos, o que [aumentou as conversões em 7%, diminuiu as taxas de rejeição em 7% e aumentou as páginas por sessão em 10%](https://www.nccgroup.trust/globalassets/resources/uk/case-studies/web-performance/cook-case-study.pdf) .

Os estudos também mostraram o impacto negativo que o baixo desempenho pode ter nas metas de negócios. Por exemplo, [a BBC](https://www.creativebloq.com/features/how-the-bbc-builds-websites-that-scale) descobriu que perdia mais 10% de usuários para cada segundo adicional que o site deles levava para carregar.

## Desempenho envolve melhorar as conversões

Reter usuários é crucial para melhorar as conversões. Os sites lentos têm um impacto negativo na receita e os sites rápidos aumentam as taxas de conversão.

Para o [Mobify](http://resources.mobify.com/2016-Q2-mobile-insights-benchmark-report.html), cada redução de 100 ms na velocidade de carregamento da página inicial resultou em um aumento de 1,11% na conversão baseada em sessão, gerando um aumento médio de receita anual de quase US$ 380.000. Além disso, uma redução de 100 ms na velocidade de carregamento da página de checkout totalizou um aumento de 1,55% na conversão baseada em sessão, que por sua vez gerou um aumento médio de receita anual de quase US$ 530.000.

Quando o [AutoAnything reduziu o tempo de carregamento da página pela metade](https://www.digitalcommerce360.com/2010/08/19/web-accelerator-revs-conversion-and-sales-autoanything/), observou um aumento de 12% a 13% nas vendas.

O varejista [Furniture Village](https://www.thinkwithgoogle.com/intl/en-gb/success-stories/uk-success-stories/furniture-village-and-greenlight-slash-page-load-times-boosting-user-experience/) auditou a velocidade do site e desenvolveu um plano para resolver os problemas encontrados, resultando em uma redução de 20% no tempo de carregamento da página e um aumento de 10% na taxa de conversão.

## Desempenho envolve experiência do usuário

Quando se trata de experiência do usuário, a velocidade é importante. Um [estudo com consumidores](https://www.ericsson.com/en/press-releases/2016/2/streaming-delays-mentally-taxing-for-smartphone-users-ericsson-mobility-report) mostra que a resposta ao estresse aos atrasos na velocidade dos celulares é semelhante à de assistir a um filme de terror ou resolver um problema matemático, e maior do que esperar na fila do caixa em uma loja varejista.

Conforme um site começa a carregar, há um período de tempo em que os usuários esperam que o conteúdo apareça. Até que isso aconteça, sequer há experiência do usuário para se falar. Essa falta de experiência é passageira em conexões rápidas. Em conexões mais lentas, no entanto, os usuários são forçados a esperar. Os usuários podem ter mais problemas à medida que os recursos da página lentamente chegam.

<figure>{% Img src="image/admin/W0ctiX3cMOfWnNF6AQMg.png", alt="Uma comparação de dois rolos de película de uma página carregando. O primeiro mostra uma página carregando em uma conexão lenta, enquanto o segundo mostra a mesma página carregando em um conexão rápida.", width="800", height="264" %}<figcaption>Uma comparação entre o carregamento da página em uma conexão muito lenta (parte superior) e uma conexão mais rápida (parte inferior).</figcaption></figure>

O desempenho é um aspecto fundamental das boas experiências do usuário. Quando os sites enviam muitos códigos, os navegadores devem usar megabytes do plano de dados do usuário para fazer o download do código. Os dispositivos móveis têm capacidade de CPU e memória limitadas. Frequentemente, esses aparelhos ficam sobrecarregados com o que podemos considerar uma pequena quantidade de código não otimizado. Isso cria um desempenho ruim que leva à falta de resposta. Sabendo o que sabemos sobre o comportamento humano, os usuários só irão tolerar aplicativos de baixo desempenho por um certo tempo até abandoná-los.

## Desempenho envolve pessoas

Sites e aplicativos com baixo desempenho também podem representar custos reais para as pessoas que os utilizam.

[Como os usuários móveis continuam a representar uma parcela maior dos usuários da Internet em todo o mundo](http://gs.statcounter.com/platform-market-share/desktop-mobile-tablet), é importante ter em mente que muitos desses usuários acessam a web por meio de redes móveis LTE, 4G, 3G e até 2G. Como aponta Ben Schwarz da Caliber [neste estudo de desempenho no mundo real](https://calibreapp.com/blog/beyond-the-bubble), o custo dos planos de dados pré-pagos está diminuindo, o que por sua vez está tornando o acesso à internet mais acessível em lugares onde antes não era. Dispositivos móveis e acesso à Internet não são mais itens de luxo. Eles são ferramentas comuns necessárias para navegar e funcionar em um mundo cada vez mais interconectado.

[O tamanho total da página tem aumentado constantemente desde pelo menos 2011](http://beta.httparchive.org/reports/state-of-the-web#bytesTotal), e a tendência parece continuar. Como a página típica envia mais dados, os usuários precisam fazer recargas em seus planos de dados com limites de dados com mais frequência, o que lhes custa dinheiro.

Além de economizar o dinheiro dos usuários, experiências de usuário rápidas e leves também podem ser cruciais para usuários em crise. Recursos públicos, como hospitais, clínicas e centros de crise têm recursos online que disponibilizam aos usuários informações importantes e específicas de que precisam durante uma crise. [Embora o design seja fundamental para apresentar informações importantes de maneira eficiente em momentos estressantes](https://aneventapart.com/news/post/eric-meyer-designing-for-crisis), a importância de fornecer essas informações rapidamente não pode ser subestimada. Faz parte do nosso trabalho.

## Comece a melhorar a velocidade do seu site {: #get-started }

Leia o [Core Web Vitals](/vitals/#core-web-vitals) para saber mais sobre as métricas nas quais o Google acredita que todos os sites devem se concentrar.

<blockquote>
  <p>Hoje, estamos desenvolvendo esse trabalho e fornecendo uma visão antecipada de uma futura mudança na classificação da Pesquisa que incorpora essas métricas de experiência da página. Apresentaremos um novo sinal que combina Core Web Vitals com nossos sinais existentes para a experiência da página para fornecer uma imagem holística da qualidade da experiência do usuário em uma página da web.</p>
  <cite><a href="https://webmasters.googleblog.com/2020/05/evaluating-page-experience.html">Avaliando a experiência da página para uma web melhor</a> , Blog oficial Google Webmaster Central</cite>
</blockquote>

Em seguida, verifique os [tempos de carregamento rápido](/fast/) para ver muitas dicas e truques relacionados a ficar rápido e permanecer rápido.
