---
layout: post
title: HTTPS가 중요한 이유
authors:
  - kaycebasques
date: 2015-11-23
updated: 2020-04-07
description: |2-

  HTTPS는 웹사이트의 무결성을 보호하고, 사용자의 개인 정보 및 보안을 보호합니다. HTTPS는 새롭고 강력한 웹 플랫폼 API의 전제 조건입니다.
tags:
  - security
---

민감한 통신을 처리하지 않더라도 항상 HTTPS로 모든 웹사이트를 보호해야 합니다. HTTPS는 웹사이트와 사용자 개인 정보 모두에 중요한 보안 및 데이터 무결성을 제공하지만, 그 외의 많은 새로운 브라우저 기능에도 필수적이며, 특히 [프로그레시브 웹 앱](/progressive-web-apps)에 필요한 기능에도 필수적입니다.

{% YouTube 'iP75a1Y9saY' %}

## 요약 {: #summary }

- 악성 및 무해한 침입자 모두는 웹사이트와 사용자 간의 보호되지 않은 모든 리소스를 부당하게 이용합니다.
- 많은 침입자가 사용자를 식별하기 위해 종합적인 동작을 확인합니다.
- HTTPS는 단순히 웹사이트의 오용만 막지 않습니다. HTTPS는 많은 첨단 기능과 서비스 작업자와 같은 앱과 유사한 기능을 구현하는 기술의 요구 사항이기도 합니다.

## HTTPS는 웹사이트의 무결성을 보호합니다. {: #integrity }

HTTPS는 침입자가 웹사이트와 사용자 브라우저 간의 통신을 변조하는 것을 방지하는 데 도움이 됩니다. 침입자로는 의도적이며 악의적인 공격자와 페이지에 광고를 삽입하는 ISP 또는 호텔과 같이 합법적이지만 침입적인 회사 등이 있습니다.

침입자는 보호되지 않은 통신을 이용하여 사용자가 민감한 정보를 포기하거나 맬웨어를 설치하도록 속이거나, 리소스에 자신의 광고를 삽입하도록 합니다. 예를 들어, 일부 제3자는 잠재적으로 사용자 경험을 손상하고 보안 취약성을 생성하는 광고를 웹사이트에 삽입합니다.

침입자는 웹사이트와 사용자 간에 이동하는 모든 보호되지 않은 리소스를 악용합니다. 이미지, 쿠키, 스크립트, HTML 등이 모두 악용될 수 있습니다. 침입은 사용자의 컴퓨터, Wi-Fi 핫스팟 또는 손상된 ISP 등 네트워크의 어느 지점에서나 발생할 수 있습니다.

## HTTPS는 사용자의 개인 정보와 보안을 보호합니다. {: #privacy }

HTTPS는 침입자가 웹사이트와 사용자 간의 통신을 소극적으로 들을 수 없도록 합니다.

HTTPS에 대한 일반적인 오해 중 하나는 민감한 통신을 처리하는 웹사이트만 HTTPS가 필요하다는 것입니다. 보호되지 않은 모든 HTTP 요청은 잠재적으로 사용자의 동작 및 ID 정보를 공개할 수 있습니다. 보호되지 않는 웹사이트 중 하나를 한 번만 방문하는 행동은 문제가 없어 보일 수 있지만, 일부 침입자는 사용자의 행동과 의도를 추론하고 이들의 신원을 [반익명화](https://en.wikipedia.org/wiki/De-anonymization)하기 위해 사용자의 종합적인 브라우징 활동을 살펴봅니다. 예를 들어, 직원은 보호되지 않은 의료 기사를 읽는 것만으로도 민감한 건강 상태를 고용주에게 무심코 공개할 수 있습니다.

## HTTPS는 웹의 미래입니다 {: #capabilities }

`getUserMedia()`를 사용한 사진 촬영 또는 오디오 녹음, [서비스 작업자](/service-workers-cache-storage/)를 사용한 오프라인 앱 경험 활성화, [프로그레시브 웹 앱](/progressive-web-apps)의 구축과 같은 강력하고 새로운 웹 플랫폼 기능은 사용자의 명시적인 허가가 있어야 실행할 수 있습니다. [Geolocation API](https://developer.mozilla.org/docs/Web/API/Geolocation/Using_geolocation)와 같은 이전의 많은 API도 실행 권한을 요구하도록 업데이트되고 있습니다. HTTPS는 이러한 새로운 기능과 업데이트된 API 모두에 대한 권한 워크플로의 핵심 구성 요소입니다.
