---
layout: post
title: 혼합 콘텐츠란 무엇입니까?
authors:
  - johyphenel
  - rachelandrew
date: 2019-09-07
updated: 2020-09-24
description: |2

  보안 HTTPS 연결을 통해 초기 HTML이 로드될 때 혼합 콘텐츠가 발생합니다.
  그러나 다른 리소스는 안전하지 않은 HTTP 연결을 통해 로드됩니다.
tags:
  - security
  - network
  - privacy
  - html
  - css
  - javascript
  - images
  - media
---

**혼합 콘텐츠**는 초기 HTML이 보안 [HTTPS](/why-https-matters/) 연결을 통해 로드되지만 다른 리소스(예: 이미지, 비디오, 스타일시트, 스크립트)는 비보안 HTTP 연결을 통해 로드될 때 발생합니다. HTTP 및 HTTPS 콘텐츠가 모두 동일한 페이지를 표시하기 위해 로드되고 초기 요청이 HTTPS를 통해 안전했기 때문에 이를 혼합 콘텐츠라고 합니다.

안전하지 않은 HTTP 프로토콜을 사용하여 하위 리소스를 요청하면 전체 페이지의 보안이 약화됩니다. 이러한 요청은 공격자가 네트워크 연결을 도청하고 두 당사자 간의 통신을 보거나 수정하는 [**경로 내 공격**](https://www.ietf.org/rfc/rfc7835.html#section-2.1.1)에 취약하기 때문입니다. 이러한 리소스를 사용하여 공격자는 웹 사이트의 사용자를 추적하고 콘텐츠를 교체할 수 있으며 활성 혼합 콘텐츠의 경우 안전하지 않은 리소스뿐만 아니라 페이지를 완전히 제어할 수 있습니다.

많은 브라우저가 사용자에게 혼합 콘텐츠 경고를 보고하지만 이러한 일이 발생했을 때는 너무 늦었습니다. 안전하지 않은 요청이 이미 수행되었고 페이지의 보안이 손상되었습니다.

이것이 브라우저가 혼합 콘텐츠를 점점 더 차단하는 이유입니다. 사이트에 혼합 콘텐츠가 있는 경우 이를 수정하면 브라우저가 더욱 엄격해짐에 따라 콘텐츠가 계속 로드됩니다.

## 두 가지 유형의 혼합 콘텐츠

혼합 콘텐츠에는 능동 및 수동의 두 가지 유형이 있습니다.

**수동 혼합 콘텐츠**는 페이지의 나머지 부분과 상호 작용하지 않는 콘텐츠를 말하므로 메시지 가로채기 공격은 해당 콘텐츠를 가로채거나 변경할 경우 수행할 수 있는 작업으로 제한됩니다. 수동 혼합 콘텐츠는 이미지, 비디오 및 오디오 콘텐츠로 정의됩니다.

**활성 혼합 콘텐츠**는 페이지 전체와 상호 작용하며 공격자가 페이지에서 거의 모든 작업을 수행할 수 있도록 합니다. 활성 혼합 콘텐츠에는 브라우저에서 다운로드하고 실행할 수 있는 스크립트, 스타일시트, iframe 및 기타 코드가 포함됩니다.

### 수동 혼합 콘텐츠

수동 혼합 콘텐츠는 덜 문제가 있는 것으로 보이지만 여전히 사이트와 사용자에게 보안 위협이 됩니다. 예를 들어, 공격자는 사이트의 이미지에 대한 HTTP 요청을 가로채 이러한 이미지를 교환하거나 교체할 수 있습니다. 공격자는 *저장* 및 *삭제* 버튼 이미지를 교환하여 사용자가 의도하지 않은 콘텐츠를 삭제하도록 할 수 있습니다. 제품 다이어그램을 외설적이거나 음란한 콘텐츠로 교체하여 사이트를 손상시킵니다. 또는 제품 사진을 다른 사이트 또는 제품에 대한 광고로 교체하십시오.

공격자가 사이트의 콘텐츠를 변경하지 않더라도 공격자는 혼합 콘텐츠 요청을 통해 사용자를 추적할 수 있습니다. 공격자는 브라우저가 로드하는 이미지 또는 기타 리소스를 기반으로 사용자가 방문하는 페이지와 사용자가 보는 제품을 알 수 있습니다.

수동 혼합 콘텐츠가 있는 경우 페이지 자체가 HTTPS를 통해 로드된 경우에도 대부분의 브라우저는 URL 표시줄에 페이지가 안전하지 않다고 표시합니다. 수동 혼합 콘텐츠의 예가 포함된 이 [데모](https://passive-mixed-content.glitch.me/)에서 이 동작을 관찰할 수 있습니다.

최근까지 수동적인 혼합 콘텐츠가 모든 브라우저에 로드되어 차단하면 많은 웹사이트가 손상되었을 것입니다. 이것은 이제 변경되기 시작하므로 사이트의 혼합 콘텐츠 인스턴스를 업데이트하는 것이 중요합니다.

[Chrome은 현재](https://blog.chromium.org/2019/10/no-more-mixed-messages-about-https.html) 가능한 경우 수동 혼합 콘텐츠의 자동 업그레이드를 출시하고 있습니다. 자동 업그레이드는 자산이 HTTPS를 통해 사용 가능하지만 HTTP로 하드코딩된 경우 브라우저가 HTTPS 버전을 로드함을 의미합니다. 보안 버전을 찾을 수 없으면 자산이 로드되지 않습니다.

혼합 콘텐츠를 감지하거나 수동 혼합 콘텐츠를 자동 업그레이드할 때마다 Chrome은 DevTools의 **문제** 탭에 자세한 메시지를 기록하여 특정 문제를 해결하는 방법을 안내합니다.

<figure>{% Img src="image/tcFciHGuF3MxnTr1y5ue01OGLBn2/HNxoomaHi2ksvYHGuNiE.jpg", alt="Chrome DevTools의 문제 탭은 특정 혼합 콘텐츠 문제 및 해결 방법에 대한 자세한 정보를 보여줍니다.", width="800", height="310 " %}</figure>

### 활성 혼합 콘텐츠

능동 혼합 콘텐츠는 수동 혼합 콘텐츠보다 더 큰 위협이 됩니다. 공격자는 활성 콘텐츠를 가로채서 다시 작성하여 페이지 또는 전체 웹 사이트를 완전히 제어할 수 있습니다. 이를 통해 공격자는 완전히 다른 콘텐츠 표시, 사용자 암호 또는 기타 로그인 자격 증명 도용, 사용자 세션 쿠키 도용 또는 사용자를 완전히 다른 사이트로 리디렉션하는 등 페이지에 대한 모든 것을 변경할 수 있습니다.

이 위협의 심각성으로 인해 대부분의 브라우저는 기본적으로 이러한 유형의 콘텐츠를 차단하여 사용자를 보호하지만 기능은 브라우저 공급업체와 버전에 따라 다릅니다.

이 다른 [데모](https://active-mixed-content.glitch.me/)에는 활성 혼합 콘텐츠의 예가 포함되어 있습니다. [HTTPS를 통해 예제를 로드](https://active-mixed-content.glitch.me/)할 때 차단되는 콘텐츠를 보려면 [HTTP를 통해 예제를 로드](http://active-mixed-content.glitch.me/)하십시오. 차단된 콘텐츠는 **문제** 탭에서도 자세히 설명됩니다.

<figure>{% Img src="image/tcFciHGuF3MxnTr1y5ue01OGLBn2/xRG5zpKLr0Z3OwfYpn2H.jpg", alt="Chrome DevTools의 Issues 탭은 특정 혼합 콘텐츠 문제와 해결 방법에 대한 자세한 정보를 보여줍니다.", width="800", height="361 " %}</figure>

{% Aside %} 브라우저는 DevTools에서 차단된 콘텐츠도 강조표시합니다. 차단된 콘텐츠 문제는 Chromium 기반 브라우저의 **문제** 탭에 자세히 설명되어 있습니다. Firefox 및 Safari는 콘솔에 메시지를 기록합니다. {% endAside %}

## 혼합 콘텐츠 사양

브라우저는 [**선택적으로 차단할 수 있는 콘텐츠**](https://w3c.github.io/webappsec-mixed-content/#category-blockable)와 [**차단할 수 있는 콘텐츠**](https://w3c.github.io/webappsec-mixed-content/#optionally-blockable-mixed-content) 범주를 정의하는 [혼합 콘텐츠 사양](https://w3c.github.io/webappsec-mixed-content/#category-blockable)을 따릅니다.

사양에서 리소스는 "혼합 콘텐츠로 사용을 허용할 위험이 웹의 상당 부분을 손상시킬 위험보다 클 때" 선택적으로 차단 가능한 콘텐츠로 간주됩니다. 이것은 위에서 설명한 수동 혼합 콘텐츠 범주의 하위 집합입니다.

**선택적으로 차단 가능하지** 않습니다 모든 콘텐츠 **차단 가능** 간주되며, 브라우저에 의해 차단되어야한다.

{% Aside %} [혼합 콘텐츠 사양의 레벨 2](https://w3c.github.io/webappsec-mixed-content/level2.html)가 진행 중이며 사양에 자동 업그레이드가 추가됩니다. {% endAside %}

최근 몇 년 동안 [HTTPS 사용이 급격히 증가](https://transparencyreport.google.com/https/overview)했으며 웹에서 명백한 기본값이 되었습니다. 이를 통해 브라우저는 [혼합 콘텐츠 사양](https://w3c.github.io/webappsec/specs/mixedcontent/)에서 **선택적으로 차단 가능**으로 정의된 하위 리소스 유형을 포함하여 모든 혼합 콘텐츠 차단을 고려할 수 있습니다. 이것이 바로 Chrome이 이러한 하위 리소스에 대해 더 엄격한 접근 방식을 취하는 이유입니다.

### 이전 브라우저

귀하의 웹사이트를 방문하는 모든 방문자가 최신 브라우저를 사용하는 것은 아니라는 점을 기억하는 것이 중요합니다. 다른 브라우저 공급업체의 다른 버전은 각각 혼합 콘텐츠를 다르게 취급합니다. 최악의 경우 이전 브라우저와 버전은 혼합 콘텐츠를 전혀 차단하지 않으므로 사용자에게 매우 안전하지 않습니다.

혼합 콘텐츠 문제를 수정하면 콘텐츠가 새 브라우저에서 표시되도록 할 수 있습니다. 또한 이전 브라우저에서 차단하지 않는 위험한 콘텐츠로부터 사용자를 보호할 수 있습니다.
