---
layout: post
title: 속도가 왜 중요합니까?
authors:
  - bojanpavic
  - ansteychris
  - jlwagner
description: 사용자 경험에서 속도는 중요한 역할을 합니다. 모바일 속도로 인한 지연은 실망스러울 뿐만 아니라 비즈니스 결과에도 부정적인 영향을 미칠 수 있습니다.
web_lighthouse: 해당 없음
date: 2019-05-01
updated: 2020-07-23
tags:
  - performance
---

소비자는 디지털 콘텐츠 및 서비스에 액세스하기 위해 모바일에 점점 더 의존하고 있으며 사이트 분석을 보면 이 이야기가 여러분의 데이터밖에서 전개되는 것을 확인할 수 있습니다. 또한, 소비자는 그 어느 때보다 요구 사항이 많으며, 여러분의 사이트 경험을 평가할 때 여러분을 경쟁업체와 비교할 뿐만 아니라 매일 사용하는 동급 최고의 서비스와 비교하며 여러분을 평가합니다.

이 게시물은 성과와 비즈니스 성공 간의 관계에 대해 수행된 일부 연구를 정리합니다.

## 성능은 사용자 유지를 좌우합니다

<figure data-float="right">
  <blockquote>
    <p>실적은 회사의 수익에 직접적인 영향을 미쳐왔습니다.</p>
    <cite>
      <p data-md-type="paragraph"><a href="https://www.youtube.com/watch?v=Xryhxi45Q5M&amp;feature=youtu.be&amp;t=1366">핀터레스트</a></p>
    </cite>
  </blockquote></figure>

성능은 모든 온라인 벤처의 성공에 중요한 역할을 합니다. 성능이 좋은 사이트는 성능이 낮은 사이트보다 더 많은 사용자의 참여를 유도하고 유지합니다.

핀터레스트는 인지된 대기 시간을 40% 줄였으며 [검색 엔진 트래픽과 가입 수를 15% 늘렸습니다](https://medium.com/@Pinterest_Engineering/driving-user-growth-with-performance-improvements-cfc50dafadd7).

COOK은 평균 페이지 로드 시간을 850밀리초로 줄여 [전환율을 7% 늘리고, 이탈률을 7% 낮추고, 세션당 페이지 수를 10% 늘렸습니다](https://www.nccgroup.trust/globalassets/resources/uk/case-studies/web-performance/cook-case-study.pdf).

연구에 따르면 낮은 성능은 비즈니스 목표에 부정적인 영향을 미칠 수 있습니다. 예를 들어 [BBC](https://www.creativebloq.com/features/how-the-bbc-builds-websites-that-scale)는 사이트를 로드하는 시간이 1초 추가될 때마다 사용자 수가 추가로 10% 줄어든다는 사실을 발견했습니다.

## 성능은 전환율 향상을 좌우합니다

사용자를 유지하는 것은 전환을 개선하는 데 중요합니다. 느린 사이트는 수익에 부정적인 영향을 미치고 빠른 사이트는 전환율을 높이는 것으로 나타났습니다.

[Mobify](http://resources.mobify.com/2016-Q2-mobile-insights-benchmark-report.html)의 경우 홈페이지 로드 속도가 100ms 감소할 때마다 세션 기반 전환이 1.11% 증가하여 평균 연간 수익이 거의 $380,000 증가했습니다. 또한, 체크아웃 페이지 로드 속도가 100ms 감소하면 세션 기반 전환이 1.55% 증가하여 연간 평균 수익이 거의 $530,000 증가했습니다.

[AutoAnything은 페이지 로드 시간을 절반으로  줄였을 때](https://www.digitalcommerce360.com/2010/08/19/web-accelerator-revs-conversion-and-sales-autoanything/) 매출이 12%에서 13% 증가했습니다.

소매업체 [Furniture Village](https://www.thinkwithgoogle.com/intl/en-gb/success-stories/uk-success-stories/furniture-village-and-greenlight-slash-page-load-times-boosting-user-experience/)는 사이트 속도를 감사한 후 발견한 문제를 해결하기 위한 계획을 수립하여 페이지 로드 시간을 20% 줄이고 전환율을 10% 증가시켰습니다.

## 성능은 사용자 경험을 좌우합니다

사용자 경험에서 속도는 중요한 역할을 합니다. [소비자 연구](https://www.ericsson.com/en/press-releases/2016/2/streaming-delays-mentally-taxing-for-smartphone-users-ericsson-mobility-report)에 따르면 모바일 속도 지연에 대한 스트레스 반응은 공포 영화를 보거나 수학 문제를 푸는 것과 유사하며, 소매점 계산대에서 기다리는 것보다 더 큽니다.

사이트가 로드되기 시작하면 사용자가 콘텐츠가 표시되기를 기다리는 시간이 있습니다. 이 작업이 완료되기까지는 사용자 경험이 없는 것입니다. 이러한 경험의 부재는 빠른 연결에서 일시적인 현상입니다. 그러나 느린 연결에서는 사용자가 강제로 기다려야 합니다. 페이지 리소스가 서서히 유입되면 사용자는 더 많은 문제를 경험할 수 있습니다.

<figure>{% Img src="image/admin/W0ctiX3cMOfWnNF6AQMg.png", alt="페이지 로드의 두 필름 릴의 비교. 첫 번째는 느린 연결에서의 페이지 로드를 보여주고 두 번째는 빠른 연결에서의 동일한 페이지 로드를 보여줍니다.", width="800", height="264" %} <figcaption>매우 느린 연결(위)과 빠른 연결(아래)의 페이지 로드 비교.</figcaption></figure>

성능은 우수한 사용자 경험에서 기본적인 측면입니다. 사이트에서 많은 양의 코드를 제공하는 경우 브라우저는 코드를 다운로드하기 위해 사용자 데이터 요금제를 메가바이트 단위로 사용해야 합니다. 모바일 장치는 CPU 성능과 메모리가 제한되어 있습니다. 이러한 장치들은 종종 우리가 약간 최적화되지 않았다고 생각하는 코드에 압도되곤 합니다. 이로 인해 성능이 저하되어 응답하지 않는 모습도 보입니다. 인간의 행동 양식에 대해서 우리가 알다시피 사용자는 해당 응용 프로그램을 포기하기 전까지만 성능이 낮은 응용 프로그램을 용인할 것입니다.

## 성능은 사람을 좌우합니다

성능이 좋지 않은 사이트와 응용 프로그램은 이를 사용하는 사람들에게 실질적인 비용을 초래할 수도 있습니다.

[모바일 사용자가 계속해서 전 세계 인터넷 사용자의 더 많은 부분을 차지함에 따라](http://gs.statcounter.com/platform-market-share/desktop-mobile-tablet) 이러한 사용자 중 상당수가 모바일 LTE, 4G, 3G, 2G 네트워크를 통해 웹에 액세스한다는 점을 기억하는 것이 중요합니다. Calibre의 Ben Schwarz가 [실제 성능에 대한 이 연구](https://calibreapp.com/blog/beyond-the-bubble)에서 지적했듯이, 선불 데이터 요금제의 비용이 감소하고 있으며, 결과적으로 이전에는 인터넷 이용이 없었던 곳에서 더 저렴하게 액세스할 수 있게 되었습니다. 모바일 기기와 인터넷 접속은 더 이상 사치품이 아닙니다. 그것들은 점점 더 상호 연결되는 세계에서 탐색하고 기능하는 데 필요한 일반 도구입니다.

[총 페이지 크기는 최소 2011년 이후부터 꾸준히 증가해 왔으며](http://beta.httparchive.org/reports/state-of-the-web#bytesTotal) 이러한 추세는 계속될 것으로 보입니다. 일반적인 페이지에서 더 많은 데이터를 전송함에 따라 사용자는 데이터 요금제를 더 자주 충전해야 하므로 비용이 많이 듭니다.

사용자의 비용을 절약하는 것 외에도 빠르고 가벼운 사용자 경험은 응급 상황의 사용자에게 매우 중요합니다. 병원, 진료소 및 응급 센터와 같은 공공 자원에는 응급 상황의 사용자에게 필요한 중요하고 구체적인 정보를 제공하는 온라인 자원이 있습니다.[디자인은 스트레스가 많은 순간에 중요한 정보를 효율적으로 표시하기 위해 중요하지만](https://aneventapart.com/news/post/eric-meyer-designing-for-crisis) 이러한 정보를 빠르게 전달하는 것의 중요성은 아무리 강조해도 지나치지 않습니다. 그것이 우리의 임무 중 하나입니다.

## 웹사이트 속도 향상 시작하기 {: #get-started }

Google에서 모든 웹사이트가 집중해야 한다고 생각하는 메트릭에 대해 알아보려면 [코어 웹 바이탈](/vitals/#core-web-vitals)을 읽어보십시오.

<blockquote>
  <p>오늘 우리는 이 작업을 기반으로 이러한 페이지 경험 메트릭을 통합하는 향후 검색 순위 변경 사항을 미리 살펴보고자 합니다. 우리는 코어 웹 바이탈을 페이지 경험에 대한 기존 신호와 결합하여 웹 페이지에서의 사용자 경험 품질에 대한 전체적인 그림을 제공하는 새로운 신호를 도입할 것입니다.</p>
  <cite><a href="https://webmasters.googleblog.com/2020/05/evaluating-page-experience.html">더 나은 웹을 위한 페이지 경험 평가</a> , 공식 Google 검색 센터 블로그</cite>
</blockquote>

그런 다음 [빠른 로드 시간](/fast/)에서 속도 향상 및 속도 유지와 관련된 다양한 팁과 요령을 확인하십시오.
