---
layout: post
title: 이미지 CDN을 사용하여 이미지 최적화
authors:
  - katiehempenius
description: |2

  이미지 CDN은 이미지 최적화에 탁월합니다.

  이미지 CDN으로 전환하면 이미지 바이트를 40–80% 절약할 수 있습니다.
date: 2019-08-14
codelabs:
  - install-thumbor
tags:
  - performance
---

## 이미지 CDN을 사용하는 이유는 무엇입니까?

이미지 콘텐츠 전송 네트워크(CDN)는 이미지 최적화에 탁월합니다. 이미지 CDN으로 전환하면 이미지 파일 크기를 [40~80% 줄일 수 있습니다.](https://www.youtube.com/watch?v=YJGCZCaIZkQ&t=1010s) 이론상으로는 빌드 스크립트만 사용하여 동일한 결과를 얻을 수 있지만 실제로는 드뭅니다.

## 이미지 CDN이란 무엇입니까?

이미지 CDN은 이미지 변환, 최적화 및 전달을 전문으로 합니다. 사이트에서 사용되는 이미지에 액세스하고 조작하기 위한 API로 간주할 수도 있습니다. 이미지 CDN에서 로드된 이미지의 경우 이미지 URL은 로드할 이미지뿐만 아니라 크기, 형식 및 품질과 같은 매개변수도 나타냅니다. 이를 통해 다양한 사용 사례에 대한 이미지 변형을 쉽게 만들 수 있습니다.

<figure>{% Img src="image/admin/OIF2VcXp8P6O7tQvw53B.jpg", alt="이미지 CDN과 클라이언트 간의 요청/응답 흐름을 표시합니다. 크기 및 형식과 같은 매개변수는 동일한 이미지의 변형을 요청하는 데 사용됩니다.", width="800", height="408" %}<figcaption> 변환의 예 이미지 CDN은 이미지 URL의 매개변수를 기반으로 수행할 수 있습니다.</figcaption></figure>

이미지 CDN은 필요에 따라 새 버전의 이미지를 생성한다는 점에서 빌드 시 이미지 최적화 스크립트와 다릅니다. 결과적으로 CDN은 일반적으로 빌드 스크립트보다 각 개별 클라이언트에 대해 크게 사용자 지정된 이미지를 만드는 데 더 적합합니다.

## 이미지 CDN이 URL을 사용하여 최적화 옵션을 나타내는 방법

이미지 CDN에서 사용하는 이미지 URL은 이미지와 이미지에 적용해야 하는 변환 및 최적화에 대한 중요한 정보를 전달합니다. URL 형식은 이미지 CDN에 따라 다르지만 대략적으로는 모두 유사한 기능을 가지고 있습니다. 가장 일반적인 몇 가지 기능을 살펴보겠습니다.

<figure>{% Img src="image/admin/GA4udXeYUEjHSY4N0Qew.jpg", alt="이미지 URL은 일반적으로 원본, 이미지, 보안 키 및 변환 구성요소로 구성됩니다.", width="800", height="127" %}</figure>

### 기원

이미지 CDN은 자체 도메인 또는 이미지 CDN의 도메인에 있을 수 있습니다. 타사 이미지 CDN은 일반적으로 사용자 지정 도메인을 유료로 사용할 수 있는 옵션을 제공합니다. 자체 도메인을 사용하면 URL을 변경할 필요가 없기 때문에 나중에 이미지 CDN을 쉽게 전환할 수 있습니다.

위의 예는 사용자 지정 도메인이 아닌 개인별로 맞춤 설정된 하위 도메인과 함께 이미지 CDN의 도메인("example-cdn.com")을 사용합니다.

### 이미지

이미지 CDN은 일반적으로 필요할 때 기존 위치에서 이미지를 자동으로 검색하도록 구성할 수 있습니다. 이 기능은 이미지 CDN에 의해 생성된 이미지에 대한 URL 내에 *기존 이미지*의 전체 URL을 포함함으로써 달성되는 경우가 많습니다. 예를 들어, `https://my-site.example-cdn.com/https://flowers.com/daisy.jpg/quality=auto`와 같은 URL을 볼 수 있습니다. 이 URL은 `https://flowers.com/daisy.jpg`에 있는 이미지를 검색하고 최적화합니다.

이미지 CDN에 이미지를 업로드하는 널리 지원되는 또 다른 방법은 HTTP POST 요청을 통해 이미지 CDN의 API에 이미지를 보내는 것입니다.

### 보안 키

보안 키는 다른 사람이 새 버전의 이미지를 만드는 것을 방지합니다. 이 기능을 사용하는 경우 이미지의 새 버전마다 고유한 보안 키가 필요합니다. 누군가 이미지 URL의 매개변수를 변경하려고 하지만 유효한 보안 키를 제공하지 않으면 새 버전을 만들 수 없습니다. 이미지 CDN은 보안 키 생성 및 추적에 대한 세부 정보를 처리합니다.

### 변환

이미지 CDN은 수십 가지, 경우에 따라 수백 가지의 다양한 이미지 변환을 제공합니다. 이러한 변환은 URL 문자열을 통해 지정되며 동시에 여러 변환을 사용하는 데 제한이 없습니다. 웹 성능의 맥락에서 가장 중요한 이미지 변환은 크기, 픽셀 밀도, 형식 및 압축입니다. 이러한 변환은 이미지 CDN으로 전환하면 일반적으로 이미지 크기가 크게 감소하는 이유입니다.

성능 변환에 대해 객관적으로 최상의 설정이 있는 경향이 있으므로 일부 이미지 CDN은 이러한 변환에 대해 "자동" 모드를 지원합니다. 예를 들어, 이미지가 WebP 형식으로 변환되도록 지정하는 대신 CDN이 자동으로 최적의 형식을 선택하고 제공하도록 할 수 있습니다. 이미지 CDN이 이미지를 변환하는 가장 좋은 방법을 결정하는 데 사용할 수 있는 신호는 다음과 같습니다.

- [클라이언트 힌트](https://developer.chrome.com/blog/automating-resource-selection-with-client-hints/)(예: 뷰포트 너비, DPR 및 이미지 너비)
- [`Save-Data`](https://developer.mozilla.org/docs/Web/HTTP/Headers/Save-Data) 헤더
- [사용자 에이전트](https://developer.mozilla.org/docs/Web/HTTP/Headers/User-Agent) 요청 헤더
- [네트워크 정보 API](https://developer.mozilla.org/docs/Web/API/Network_Information_API)

예를 들어 이미지 CDN은 Edge 브라우저에 JPEG XR, Chrome 브라우저에 WebP, 아주 구형인 브라우저에 JPEG를 제공할 수 있습니다. 자동 설정은 이미지 CDN에서 지원되면 새로운 기술을 채택하기 위해 코드를 변경할 필요 없이 이미지를 최적화하는 데 있어 이미지 CDN의 상당한 전문성을 활용할 수 있기 때문에 널리 사용됩니다.

## 이미지 CDN의 유형

이미지 CDN은 자체 관리 및 타사 관리의 두 가지 범주로 나눌 수 있습니다.

### 자체 관리 이미지 CDN

자체 관리형 CDN은 자신의 인프라를 편안하게 유지 관리할 수 있는 엔지니어링 직원이 있는 사이트에 적합합니다.

[Thumbor](https://github.com/thumbor/thumbor)는 현재 사용할 수 있는 유일한 자체 관리 이미지 CDN입니다. 오픈 소스이며 무료로 사용할 수 있지만 일반적으로 대부분의 상용 CDN보다 기능이 적고 설명서가 다소 제한적입니다. [Wikipedia](https://wikitech.wikimedia.org/wiki/Thumbor), [Square](https://medium.com/square-corner-blog/dynamic-images-with-thumbor-a430a1cfcd87) 및 [99designs](https://99designs.com/tech-blog/blog/2013/07/01/thumbnailing-with-thumbor/)는 Thumbor를 사용하는 3가지 사이트입니다. 설정 지침은 [Thumbor 이미지 CDN 설치 방법](/install-thumbor) 게시물을 참조하십시오.

### 타사 이미지 CDN

타사 이미지 CDN은 이미지 CDN을 서비스로 제공합니다. 클라우드 공급자가 서버 및 기타 인프라를 유료로 제공하는 것처럼; 이미지 CDN은 이미지 최적화 및 전송을 유료로 제공합니다. 타사 이미지 CDN은 기본 기술을 유지하므로 시작하는 것이 상당히 간단하고 일반적으로 10-15분 내에 완료할 수 있지만 대규모 사이트의 경우 전체 마이그레이션은 훨씬 더 오래 걸릴 수 있습니다. 타사 이미지 CDN은 일반적으로 사용 계층에 따라 가격이 책정되며 대부분의 이미지 CDN은 무료 계층 또는 무료 평가판을 제공하여 제품을 사용해 볼 수 있는 기회를 제공합니다.

## 이미지 CDN 선택

이미지 CDN에는 좋은 옵션이 많이 있습니다. 일부는 다른 것보다 더 많은 기능을 가지고 있지만 모두 이미지의 바이트를 절약하여 페이지를 더 빨리 로드하는 데 도움이 될 것입니다. 기능 세트 외에도 이미지 CDN을 선택할 때 고려해야 할 다른 요소로는 비용, 지원, 문서, 설정 또는 마이그레이션 용이성 등이 있습니다.

결정을 내리기 전에 직접 시도해 보는 것도 도움이 될 수 있습니다. 아래에서 여러 이미지 CDN을 빠르게 시작하는 방법에 대한 지침이 포함된 코드랩을 찾을 수 있습니다.
