---
layout: post
title: 쿠키 알림에 대한 모범 사례
subhead: |2

  성능 및 사용성을 위해 쿠키 알림을 최적화합니다.
authors:
  - katiehempenius
date: 2021-03-30
hero: image/j2RDdG43oidUy6AL6LovThjeX9c2/V8rNgYUkkAWET3EkBL6H.png
alt: 쿠키 공지 그림.
description: |2

  쿠키 알림이 성능, 성능 측정 및 UX에 미치는 영향에 대해 알아보세요.
tags:
  - blog
  - performance
  - web-vitals
---

이 문서는 쿠키 알림이 성능, 성능 측정 및 사용자 경험에 미치는 영향에 대해 설명합니다.

## 성능

쿠키 알림은 일반적으로 페이지 로드 프로세스 초기에 로드되고 모든 사용자에게 표시되며 광고 및 기타 페이지 콘텐츠 로드에 잠재적으로 영향을 미칠 수 있기 때문에 페이지 성능에 상당한 영향을 미칠 수 있습니다.

쿠키 알림이 Web Vitals 측정항목에 영향을 미칠 수 있는 방법은 다음과 같습니다.

- **가장 큰 콘텐츠가 포함된 페인트(LCP):** 대부분의 쿠키 동의 알림은 상당히 작기 때문에 일반적으로 페이지의 LCP 요소를 포함하지 않습니다. 그러나 이것은 특히 모바일 장치에서 발생할 수 있습니다. 모바일 장치에서 쿠키 알림은 일반적으로 화면의 더 많은 부분을 차지합니다. 이것은 일반적으로 쿠키 알림에 큰 텍스트 블록이 포함될 때 발생합니다(텍스트 블록도 LCP 요소일 수 있음).

- **FID(First Input Delay):** 일반적으로 쿠키 동의 솔루션 자체는 FID에 최소한의 영향을 미쳐야 합니다. 쿠키 동의에는 JavaScript 실행이 거의 필요하지 않습니다. 그러나 이러한 쿠키가 활성화하는 기술, 즉 광고 및 추적 스크립트는 페이지 상호 작용에 상당한 영향을 미칠 수 있습니다. 쿠키가 승인될 때까지 이러한 스크립트를 지연시키면 FID(First Input Delay)를 줄이는 기술로 작용할 수 있습니다.

- **CLS(누적 레이아웃 이동):** 쿠키 동의 알림은 레이아웃 이동의 매우 일반적인 소스입니다.

일반적으로 제3자 제공업체의 쿠키 알림은 귀하가 직접 구축한 쿠키 알림보다 성능에 더 큰 영향을 미칠 것으로 예상할 수 있습니다. 이것은 쿠키 알림 고유의 문제가 아니라 일반적인 타사 스크립트의 특성입니다.

### 모범 사례

이 섹션의 모범 사례는 타사 쿠키 알림에 중점을 둡니다. 이러한 모범 사례의 전부는 아니지만 일부는 자사 쿠키 알림에도 적용됩니다.

#### 쿠키 알림 스크립트를 비동기식으로 로드

쿠키 알림 스크립트는 비동기식으로 로드해야 합니다. 이렇게 하려면 스크립트 태그에[`async`](https://developer.mozilla.org/docs/Web/HTML/Element/script#attr-async) 속성을 스크립트 태그에 추가하세요.

```html
<script src="https://cookie-notice.com/script.js" async>
```

비동기가 아닌 스크립트는 브라우저 파서를 차단합니다. 이것은 페이지 로드와 LCP를 지연시킵니다. 자세한 내용은 [효율적으로 타사 JavaScript 로드](/efficiently-load-third-party-javascript/)를 참조하십시오.

{% Aside %} 동기 스크립트를 사용해야 하는 경우(예: 일부 쿠키 알림은 동기 스크립트를 사용하여 쿠키 차단을 구현함) 이 요청이 최대한 빨리 로드되도록 해야 합니다. 이를 수행하는 한 가지 방법은 [리소스 힌트](/preconnect-and-dns-prefetch/)를 사용하는 것 입니다. {% endAside %}

#### 쿠키 알림 스크립트 직접 로드

쿠키 알림 스크립트는 태그 관리자나 다른 스크립트에 의해 로드되지 않고 기본 문서의 HTML에 스크립트 태그를 배치하여 "직접" 로드해야 합니다. 태그 관리자 또는 보조 스크립트를 사용하여 쿠키 알림 스크립트를 삽입하면 쿠키 알림 스크립트의 로드가 지연됩니다. 이러한 경우 브라우저의 lookahead 파서로부터 스크립트를 가리고 JavaScript 실행 전에 스크립트가 로드되지 않습니다.

#### 쿠키 알림 출처와 조기 연결 설정

타사 위치에서 쿠키 알림 스크립트를 로드하는 모든 사이트는 `dns-prefetch` 또는 `preconnect` 리소스 힌트를 사용하여 쿠키 알림 리소스를 호스팅하는 원본과의 조기 연결을 설정해야 합니다. 자세한 내용은 [인지되는 페이지 속도를 개선하기 위해 조기에 네트워크 연결 설정](/preconnect-and-dns-prefetch/)을 참조하십시오.

```html
<link rel="preconnect" href="https://cdn.cookie-notice.com/">
```

{% Aside %} 쿠키 알림은 여러 출처에서 리소스를 로드하는 것이 일반적입니다(예: `www.cookie-notice.com` 및 `cdn.cookie-notice.com` 모두에서 리소스 로드). 별도의 출처에는 별도의 연결이 필요하므로 별도의 리소스 힌트가 필요합니다. {% endAside %}

#### 쿠키 알림을 적절하게 미리 로드

일부 사이트는 [`preload`](https://developer.mozilla.org/docs/Web/HTML/Preloading_content) 리소스 힌트를 사용하여 쿠키 알림 스크립트를 로드하는 것이 좋습니다. `preload` 리소스 힌트는 지정된 리소스에 대한 조기 요청을 시작하도록 브라우저에 알립니다.

```html
<link rel="preload" href="https://www.cookie-notice.com/cookie-script.js">
```

`preload`는 사용량이 페이지당 몇 개의 핵심 리소스를 가져오는 것으로 제한될 때 가장 강력합니다. 따라서 쿠키 알림 스크립트를 미리 로드하는 것의 유용성은 상황에 따라 달라집니다.

#### 쿠키 알림 스타일 지정 시 성능 절충 사항에 유의

타사 쿠키 알림의 모양과 느낌을 사용자 지정하면 추가 성능 하락이 발생할 수 있습니다. 예를 들어, 타사 쿠키 알림은 페이지의 다른 곳에서 사용되는 동일한 리소스(예: 웹 글꼴)를 항상 재사용할 수 있는 것은 아닙니다. 또한 타사 쿠키 알림은 긴 요청 체인의 끝에 스타일을 로드하는 경향이 있습니다. 예상치 못한 상황을 피하려면 쿠키 알림이 스타일 및 관련 리소스를 로드하고 적용하는 방법을 알고 있어야 합니다.

#### 레이아웃 변경 피하기

다음은 쿠키 알림과 관련된 가장 일반적인 레이아웃 변경 문제입니다.

- **화면 상단 쿠키 알림**: 화면 상단 쿠키 알림은 레이아웃 이동의 매우 일반적인 소스입니다. 주변 페이지가 이미 렌더링된 후 쿠키 알림이 DOM에 삽입되면 그 아래에 있는 페이지 요소를 페이지 아래로 더 밀어 넣습니다. 이러한 유형의 레이아웃 이동은 동의 알림을 위해 DOM의 공간을 예약하여 제거할 수 있습니다. 이것이 실현 가능한 솔루션이 아닌 경우(예: 쿠키 알림의 크기가 지역에 따라 다른 경우) 고정 바닥글 또는 모달을 사용하여 쿠키 알림을 표시하는 것이 좋습니다. 이 두 가지 대체 접근 방식 모두 쿠키 알림을 페이지의 나머지 부분 위에 "오버레이"로 표시하므로 쿠키 알림이 로드될 때 콘텐츠 이동을 일으키지 않아야 합니다.
- **애니메이션** : 많은 쿠키 알림은 애니메이션을 사용합니다. 예를 들어 쿠키 알림을 "슬라이딩 인"하는 것은 일반적인 디자인 패턴입니다. 이러한 효과가 구현되는 방식에 따라 레이아웃 이동이 발생할 수 있습니다. 자세한 내용은 [레이아웃 전환 디버깅](/debugging-layout-shifts/)을 참조하십시오.
- **글꼴** : 늦게 로드하는 글꼴은 렌더링을 차단하거나 레이아웃 이동을 유발할 수 있습니다. 이 현상은 느린 연결에서 더 분명합니다.

#### 고급 로딩 최적화

이러한 기술은 구현하는 데 더 많은 작업이 필요하지만 쿠키 알림 스크립트의 로드를 더욱 최적화할 수 있습니다.

- 자체 서버에서 타사 쿠키 알림 스크립트를 캐싱하고 제공하면 이러한 리소스의 전달 속도를 향상시킬 수 있습니다.
- [서비스 워커](https://developer.mozilla.org/docs/Web/API/Service_Worker_API/Using_Service_Workers)를 사용하면 쿠키 알림 스크립트와 같은 [타사 스크립트의 가져오기 및 캐싱](https://developer.chrome.com/docs/workbox/caching-resources-during-runtime/#cross-origin-considerations)을 더 잘 제어할 수 있습니다.

## 성능 측정

쿠키 알림은 성능 측정에 영향을 줄 수 있습니다. 이 섹션에서는 이러한 영향과 이를 완화하기 위한 기술에 대해 설명합니다.

### 실제 사용자 모니터링(RUM)

일부 분석 및 RUM 도구는 쿠키를 사용하여 성능 데이터를 수집합니다. 사용자가 쿠키 사용을 거부하는 경우 이러한 도구는 성능 데이터를 캡처할 수 없습니다.

사이트는 이러한 현상을 인지하고 있어야 합니다. RUM 도구가 데이터를 수집하는 데 사용하는 메커니즘을 이해하는 것도 가치가 있습니다. 그러나 일반적인 사이트의 경우 이러한 불일치는 데이터 왜곡의 방향과 크기를 고려할 때 경보의 원인이 아닐 수 있습니다. 쿠키 사용은 성능 측정을 위한 기술적 요구 사항이 아닙니다. [web-vitals](https://github.com/GoogleChrome/web-vitals) JavaScript 라이브러리는 쿠키를 사용하지 않는 라이브러리의 예입니다.

귀하의 사이트가 쿠키를 사용하여 성능 데이터를 수집하는 방식(즉, 쿠키에 개인 정보가 포함되어 있는지 여부)과 해당 법률에 따라 성능 측정을 위한 쿠키는 다른 목적을 위해 귀하의 사이트에서 사용되는 일부 쿠키(예: 광고 쿠키)와 동일한 법적 요구 사항의 적용을 받지 않을 수 있습니다. 일부 사이트는 사용자 동의를 요청할 때 성능 쿠키를 별도의 쿠키 범주로 분류합니다.

### 합성 모니터링

사용자 지정 구성이 없으면 대부분의 합성 도구(예: Lighthouse 및 WebPageTest)는 쿠키 동의 알림에 응답하지 않은 최초 사용자의 경험만 측정합니다. 그러나 성능 데이터를 수집할 때 캐시 상태의 변화(예: 초기 방문 대 반복 방문)뿐만 아니라 쿠키 수락 상태의 변화(수락, 거부 또는 응답 없음)도 고려해야 합니다.

다음 섹션에서는 쿠키 알림을 성능 측정 워크플로에 통합하는 데 도움이 될 수 있는 WebPageTest 및 Lighthouse 설정에 대해 설명합니다. 그러나 쿠키 및 쿠키 알림은 실험실 환경에서 완벽하게 시뮬레이션하기 어려울 수 있는 많은 요소 중 하나일 뿐입니다. 이러한 이유로 합성 도구가 아닌 [RUM 데이터](/user-centric-performance-metrics/#how-metrics-are-measured)를 성능 벤치마킹의 초석으로 만드는 것이 중요합니다.

### WebPageTest로 쿠키 알림 테스트

#### 스크립팅

추적을 수집하는 동안 [WebPageTest](https://webpagetest.org/)가 쿠키 동의 배너를 "클릭"하도록 스크립팅을 사용할 수 있습니다.

**스크립트** 탭으로 이동하여 스크립트를 추가합니다. 아래 스크립트는 테스트할 URL로 이동한 다음 id가 `cookieButton`인 DOM 요소를 클릭합니다.

{% Aside 'caution' %} WebPageTest 스크립트는 [탭으로 구분](https://github.com/WPO-Foundation/webpagetest-docs/blob/main/src/scripting.md#scripting) 됩니다. {% endAside %}

```shell
combineSteps
navigate    %URL%
clickAndWait    id=cookieButton
```

이 스크립트를 사용할 때 다음 사항에 유의하십시오.

- `combineSteps`는 추적 및 측정의 단일 세트로 이어지는 스크립팅 단계의 결과를 "결합"하도록  WebPageTest에 지시합니다. `combineSteps` 없이 이 스크립트를 실행하는 것도 유용할 수 있습니다. 별도의 추적을 통해 리소스가 쿠키를 수락하기 전이나 후에 로드되었는지 쉽게 확인할 수 있습니다.
- `%URL%`은 테스트 중인 URL을 참조하는 WebPageTest 규칙입니다.
- `clickAndWait`는 WebPageTest에 `attribute=value`로 표시된 요소를 클릭하고 후속 브라우저 활동이 완료될 때까지 기다리라고 지시합니다. `clickAndWait attribute=Value` 형식을 따릅니다.

이 스크립트를 올바르게 구성했다면 WebPageTest에서 찍은 스크린샷에 쿠키 알림이 표시되지 않아야 합니다(쿠키 알림이 수락됨).

WebPageTest 스크립팅에 대한 자세한 내용은 [WebPageTest 문서](https://docs.webpagetest.org/scripting/)를 확인하십시오.

#### 쿠키 설정

쿠키 세트로 WebPageTest를 실행하려면 **고급** 탭으로 이동하여 쿠키 헤더를 **사용자 정의 헤더** 필드에 추가하십시오.

{% Img src="image/j2RDdG43oidUy6AL6LovThjeX9c2/qSccrAxF0H4yoSzYRYdh.png", alt="WebPageTest의 '사용자 정의 헤더' 필드를 보여주는 스크린샷", width="800", height="181" %}

#### 테스트 위치 변경

WebPageTest에서 사용하는 테스트 위치를 변경하려면 **고급 테스트** 탭 **에 있는 테스트 위치** 드롭다운을 클릭합니다.

{% Img src="image/j2RDdG43oidUy6AL6LovThjeX9c2/J27NcDQ5LTtXYloaA1DN.png", alt="WebPageTest의 '테스트 위치' 드롭다운 스크린샷", width="800", height="267" %}

### Lighthouse로 쿠키 알림 테스트

Lighthouse 실행 시 쿠키를 설정하면 Lighthouse에서 테스트하기 위해 페이지를 특정 상태로 전환하는 메커니즘 역할을 할 수 있습니다. Lighthouse의 쿠키 동작은 컨텍스트(DevTools, CLI 또는 PageSpeed Insights)에 따라 약간 다릅니다.

#### 개발자 도구

Lighthouse가 DevTools에서 실행될 때 쿠키가 지워지지 않습니다. 그러나 다른 유형의 저장소는 기본적으로 지워집니다. 이 동작은 **Lighthouse** 설정 패널에서 **저장소 비우기** 옵션을 사용하여 변경할 수 있습니다.

{% Img src="image/j2RDdG43oidUy6AL6LovThjeX9c2/nmNDeSoGEQUVKeTP7q7R.png", alt="Lighthouse '저장소 비우기' 옵션을 강조한 스크린샷", width="800", height="304" %}

#### CLI

CLI에서 Lighthouse를 실행하면 새로운 Chrome 인스턴스가 사용되므로 기본적으로 쿠키가 설정되지 않습니다. 특정 쿠키 세트를 사용하여 CLI에서 Lighthouse를 실행하려면 다음 [명령](https://github.com/GoogleChrome/lighthouse#cli-options)을 사용하십시오.

```shell
lighthouse <url> --extra-headers "{\"Cookie\":\"cookie1=abc; cookie2=def; \_id=foo\"}"
```

Lighthouse CLI에서 사용자 지정 요청 헤더를 설정하는 방법에 대한 자세한 내용은 [인증된 페이지에서 Lighthouse 실행](https://github.com/GoogleChrome/lighthouse/blob/master/docs/authenticated-pages.md)을 참조하십시오.

#### PageSpeed 인사이트

PageSpeed Insights에서 Lighthouse를 실행하면 새로운 Chrome 인스턴스가 사용되며 쿠키가 설정되지 않습니다. 특정 쿠키를 설정하도록 PageSeed Insights를 구성할 수 없습니다.

## 사용자 경험

다양한 쿠키 동의 알림의 사용자 경험(UX)은 주로 페이지 내 쿠키 알림의 위치와 사용자가 사이트의 쿠키 사용을 사용자 지정할 수 있는 범위라는 두 가지 결정의 결과입니다. 이 섹션에서는 이러한 두 가지 결정에 대한 잠재적인 접근 방식에 대해 설명합니다.

{% Aside 'caution' %} 쿠키 알림 UX는 지역에 따라 크게 다를 수 있는 법률의 영향을 크게 받습니다. 따라서 이 섹션에서 논의된 일부 디자인 패턴은 특정 상황과 관련이 없을 수 있습니다. 이 문서는 법적 조언을 대신할 수 없습니다. {% endAside %}

쿠키 알림에 대한 잠재적인 디자인을 고려할 때 고려해야 할 몇 가지 사항은 다음과 같습니다.

- UX: 좋은 사용자 경험입니까? 이 특정 디자인이 기존 페이지 요소와 사용자 흐름에 어떤 영향을 미칩니까?
- 비즈니스: 사이트의 쿠키 전략은 무엇입니까? 쿠키 알림에 대한 귀하의 목표는 무엇입니까?
- 법적 요건: 법적 요구 사항을 준수합니까?
- 엔지니어링: 구현하고 유지 관리하는 데 얼마나 많은 작업이 필요합니까? 얼마나 변경하기 어려울까요?

### 배치

쿠키 알림은 머리글, 인라인 요소 또는 바닥글로 표시될 수 있습니다. 모달을 사용하여 페이지 콘텐츠 상단에 표시하거나 [전면 광고](https://en.wikipedia.org/wiki/Interstitial_webpage) 로 사용할 수도 있습니다.

{% Img src="image/j2RDdG43oidUy6AL6LovThjeX9c2/LLqHAhp7W6x4E3rZh0Oc.png", alt="쿠키 알림에 대한 다양한 배치 옵션의 예를 보여주는 다이어그램", width="800", height="345" %}

#### 머리글, 바닥글 및 인라인 쿠키 알림

쿠키 알림은 일반적으로 머리글이나 바닥글에 배치됩니다. 이 두 가지 옵션 중에서 바닥글 배치는 눈에 거슬리지 않고 배너 광고 또는 알림과 관심을 끌기 위해 경쟁하지 않으며 일반적으로 CLS를 유발하지 않기 때문에 일반적으로 선호됩니다. 또한 개인정보취급방침 및 이용약관을 게시하는 곳이기도 합니다.

인라인 쿠키 알림도 옵션이지만 기존 사용자 인터페이스에 통합하기 어려울 수 있으므로 일반적이지 않습니다.

#### 모달

모달은 페이지 콘텐츠 상단에 표시되는 쿠키 동의 알림입니다. 모달은 크기에 따라 모양과 성능이 상당히 다를 수 있습니다.

더 작고 화면의 일부만 차지하는 모달은 [레이아웃 변경](/cls/)을 일으키지 않는 방식으로 쿠키 알림을 구현하는 데 어려움을 겪고 있는 사이트에 좋은 대안이 될 수 있습니다.

반면에 페이지 콘텐츠의 대부분을 가리는 큰 모달은 주의해서 사용해야 합니다. 특히 소규모 사이트에서는 사용자가 콘텐츠가 가려진 익숙하지 않은 사이트의 쿠키 알림을 수락하지 않고 사이트를 떠날 수 있습니다. 반드시 동의어인 것은 아니지만 전체 화면 쿠키 동의 모달 사용을 고려하고 있다면 [쿠키 벽](https://techcrunch.com/2020/05/06/no-cookie-consent-walls-and-no-scrolling-isnt-consent-says-eu-data-protection-body/)에 관한 법률을 알고 있어야 합니다.

{% Aside %} 큰 모달은 일종의 전면 광고로 간주될 수 있습니다. Google 검색은 전면 광고가 쿠키 배너의 경우와 같이 법적 규정을 준수하는 데 사용되는 경우 이를 [처벌하지 않습니다.](https://developers.google.com/search/blog/2016/08/helping-users-easily-access-content-on) 그러나 다른 상황에서 전면 광고를 사용하는 경우(특히 방해가 되거나 사용자 환경이 좋지 않은 경우) 불이익을 받을 수 있습니다. {% endAside %}

### 구성 가능성

쿠키 알림 인터페이스는 사용자에게 허용하는 쿠키에 대한 다양한 제어 수준을 제공합니다.

#### 구성 불가능

이러한 알림 스타일의 쿠키 배너는 사용자에게 쿠키를 선택 해제하기 위한 직접적인 UX 제어를 제공하지 않습니다. 대신 일반적으로 웹 브라우저를 사용하여 쿠키를 관리하는 방법에 대한 정보를 사용자에게 제공할 수 있는 사이트의 쿠키 정책에 대한 링크를 포함합니다. 이러한 통지에는 일반적으로 "해제" 및/또는 "수락" 버튼이 포함됩니다.

{% Img src="image/j2RDdG43oidUy6AL6LovThjeX9c2/RlAg8DCjBC0bX7Ki5MuE.png", alt="쿠키 구성 가능성이 없는 쿠키 알림의 예를 보여주는 다이어그램", width="800", height="518" %}

#### 일부 구성 가능성

이러한 쿠키 알림은 사용자에게 쿠키를 거부할 수 있는 옵션을 제공하지만 더 세분화된 제어를 지원하지 않습니다. 쿠키 통지에 대한 이러한 접근 방식은 덜 일반적입니다.

{% Img src="image/j2RDdG43oidUy6AL6LovThjeX9c2/MOl8u9NcnyjCWogxzjdz.png", alt="일부 쿠키 구성 가능성이 있는 쿠키 알림의 예를 보여주는 다이어그램", width="800", height="508" %}

#### 전체 구성 가능성

이러한 쿠키 알림은 사용자가 수락하는 쿠키 사용을 구성하기 위한 보다 세분화된 제어 기능을 제공합니다.

{% Img src="image/j2RDdG43oidUy6AL6LovThjeX9c2/QfFoqkkmdKHAYlftIH0n.png", alt="전체 쿠키 구성 가능성이 있는 쿠키 알림의 예를 보여주는 다이어그램", width="800", height="467" %}

- **UX:** 쿠키 사용 구성을 위한 컨트롤은 사용자가 초기 쿠키 동의 알림에 응답할 때 실행되는 별도의 모달을 사용하여 가장 일반적으로 표시됩니다. 그러나 공간이 충분한 경우 일부 사이트는 초기 쿠키 동의 알림 내에 이러한 제어를 인라인으로 표시합니다.

- **세분성:** 쿠키 구성 가능성에 대한 가장 일반적인 접근 방식은 사용자가 쿠키 "범주"별로 쿠키를 선택하도록 허용하는 것입니다. 일반적인 쿠키 범주의 예로는 기능, 타겟팅 및 소셜 미디어 쿠키가 있습니다.

    그러나 일부 사이트는 한 단계 더 나아가 사용자가 쿠키별로 선택하도록 허용합니다. 또는 사용자에게 보다 구체적인 제어 기능을 제공하는 또 다른 방법은 "광고"와 같은 쿠키 카테고리를 특정 사용 사례로 분류하는 것입니다. 예를 들어 사용자가 "기본 광고"와 "개인 맞춤 광고"를 별도로 선택할 수 있습니다.

{% Img src="image/j2RDdG43oidUy6AL6LovThjeX9c2/z7zFPtCkFi8GEpkfubek.png", alt="전체 쿠키 구성이 가능한 쿠키 알림의 예를 보여주는 다이어그램", width="800", height="372" %}
