---
layout: post
title: 올바른 이미지 형식 선택
authors:
  - ilyagrigorik
description: |2

  올바른 이미지 형식을 선택하는 것은 웹사이트에 최적화된 이미지를 제공하는 첫 번째 단계입니다. 이 게시물은 올바른 선택을 하는 데 도움이 됩니다.
date: 2018-08-30
updated: 2020-06-18
tags:
  - performance
  - images
---

가장 먼저 자문해야 할 질문은 이미지가 실제로 원하는 효과를 얻기 위해 필요한지 여부입니다. 좋은 디자인은 단순하고 항상 최고의 성능을 제공합니다. 페이지의 HTML, CSS, JavaScript 및 기타 자산에 비해 많은 바이트를 필요로 하는 이미지 리소스를 제거할 수 있다면 이것이 항상 최상의 최적화 전략입니다. 즉, 잘 배치된 이미지는 천 마디 말보다 더 많은 정보를 전달할 수 있으므로 균형을 찾는 것은 사용자에게 달려 있습니다.

다음으로 원하는 결과를 제공할 수 있지만 보다 효율적인 방식으로 대체 기술이 있는지 고려해야 합니다.

- **CSS 효과** (예: 그림자 또는 그라디언트) 및 CSS 애니메이션을 사용하여 모든 해상도 및 확대/축소 수준에서 종종 이미지 파일에 필요한 바이트의 일부만 사용하더라도 항상 선명하게 보이는 해상도 독립적인 자산을 생성할 수 있습니다.
- **웹 글꼴을** 사용하면 텍스트를 선택, 검색 및 크기 조정하는 기능을 유지하면서 아름다운 서체를 사용할 수 있으므로 사용성이 크게 향상됩니다.

이미지 자산에서 텍스트를 인코딩하는 자신을 발견했다면 중지하고 재고하십시오. 훌륭한 타이포그래피는 좋은 디자인, 브랜딩 및 가독성에 매우 중요하지만 이미지 내 텍스트는 좋지 않은 사용자 경험을 제공합니다. 웹 글꼴을 사용하려면 [자체 최적화 세트](https://www.igvita.com/2014/01/31/optimizing-web-font-rendering-performance/)가 필요하지만 이러한 모든 문제를 해결하고 항상 텍스트를 표시하는 데 더 나은 선택입니다.

## 올바른 이미지 형식 선택

이미지가 올바른 옵션이라고 확신하는 경우 작업에 적합한 이미지 종류를 신중하게 선택해야 합니다.

<figure>{% Img src="image/admin/dJuB2DQcbhtwD5VdPVlR.png", alt="확대된 벡터 및 래스터 이미지", width="585", height="313" %} <figcaption>확대된 벡터 이미지(L) 래스터 이미지(R)</figcaption></figure>

- [벡터 그래픽](https://en.wikipedia.org/wiki/Vector_graphics)은 선, 점 및 다각형을 사용하여 이미지를 나타냅니다.
- [래스터 그래픽](https://en.wikipedia.org/wiki/Raster_graphics)은 직사각형 격자 내에서 각 픽셀의 개별 값을 인코딩하여 이미지를 나타냅니다.

각 형식에는 고유한 장단점이 있습니다. 벡터 형식은 로고, 텍스트 또는 아이콘과 같은 단순한 기하학적 모양으로 구성된 이미지에 이상적입니다. 모든 해상도와 확대/축소 설정에서 선명한 결과를 제공하므로 다양한 크기로 표시해야 하는 자산 및 고해상도 화면에 이상적인 형식입니다.

그러나 장면이 복잡한 경우(예: 사진) 벡터 형식이 부족합니다. 모든 모양을 설명하기 위한 SVG 마크업의 양이 엄청나게 많을 수 있고 출력이 여전히 "사실적"으로 보이지 않을 수 있습니다. 이 경우 PNG, JPEG 또는 WebP와 같은 래스터 이미지 형식을 사용해야 합니다.

래스터 이미지는 해상도나 확대/축소에 독립적이라는 좋은 속성을 갖고 있지 않습니다. 래스터 이미지를 확대하면 들쭉날쭉하고 흐릿한 그래픽이 표시됩니다. 결과적으로 사용자에게 최적의 경험을 제공하기 위해 여러 버전의 래스터 이미지를 다양한 해상도로 저장해야 할 수 있습니다.

## 고해상도 화면의 의미

픽셀에는 CSS 픽셀과 장치 픽셀의 두 가지 종류가 있습니다. 단일 CSS 픽셀은 단일 장치 픽셀에 직접 대응하거나 여러 장치 픽셀로 뒷받침될 수 있습니다. 점은 무엇인가? 장치 픽셀이 많을수록 화면에 표시되는 콘텐츠의 세부 사항이 더 미세해집니다.

<figure>{% Img src="image/admin/oQV7qJ9fUMkYsKlUMrL4.png", alt="CSS 픽셀과 기기 픽셀의 차이를 보여주는 세 개의 이미지.", width="470", height="205" %}<figcaption> CSS 픽셀과 장치 픽셀의 차이입니다.</figcaption></figure>

높은 DPI(HiDPI) 화면은 아름다운 결과를 제공하지만 한 가지 분명한 절충안이 있습니다. 이미지 자산은 더 많은 장치 픽셀 수를 활용하기 위해 더 많은 세부 정보가 필요합니다. 좋은 소식은 벡터 이미지가 이 작업에 이상적으로 적합하다는 것입니다. 어떤 해상도에서도 선명한 결과로 렌더링할 수 있기 때문입니다. 더 미세한 디테일을 렌더링하려면 더 높은 처리 비용이 발생할 수 있지만 기본 자산은 동일하고 해상도에 독립적입니다. .

반면에 래스터 이미지는 픽셀 단위로 이미지 데이터를 인코딩하기 때문에 훨씬 더 큰 문제를 야기합니다. 따라서 픽셀 수가 많을수록 래스터 이미지의 파일 크기가 커집니다. 예를 들어 100x100(CSS) 픽셀로 표시되는 사진 자산의 차이점을 살펴보겠습니다.

<div class="table-wrapper scrollbar"><table>
<thead>
  <tr>
    <th>화면 해상도</th>
    <th>총 픽셀</th>
    <th>압축되지 않은 파일 크기(픽셀당 4바이트)</th>
  </tr>
</thead>
<tbody>
<tr>
  <td data-th="resolution">1배</td>
  <td data-th="total pixels">100 x 100 = 10,000</td>
  <td data-th="filesize">40,000바이트</td>
</tr>
<tr>
  <td data-th="resolution">2배</td>
  <td data-th="total pixels">100 x 100 x 4 = 40,000</td>
  <td data-th="filesize">160,000바이트</td>
</tr>
<tr>
  <td data-th="resolution">3배</td>
  <td data-th="total pixels">100 x 100 x 9 = 90,000</td>
  <td data-th="filesize">360,000바이트</td>
</tr>
</tbody>
</table></div>

실제 화면의 해상도를 두 배로 늘리면 총 픽셀 수가 4배 증가합니다. 가로 픽셀 수는 두 배, 세로 픽셀 수는 두 배입니다. 따라서 "2x" 화면은 필요한 픽셀 수를 두 배로 늘릴 뿐만 아니라 네 배로 늘립니다!

그렇다면 이것이 실제로 의미하는 바는 무엇입니까? 고해상도 화면을 통해 아름다운 이미지를 전달할 수 있으며 이는 훌륭한 제품 기능이 될 수 있습니다. 그러나 고해상도 화면에는 고해상도 이미지도 필요하므로 다음을 수행합니다.

- 벡터 이미지는 해상도와 무관하고 항상 선명한 결과를 제공하므로 가능한 한 선호합니다.
- 래스터 이미지가 필요한 경우 [반응형 이미지](/serve-responsive-images/)를 제공합니다.

## 다양한 래스터 이미지 형식의 기능

다양한 손실 및 무손실 압축 알고리즘 외에도 다양한 이미지 형식은 애니메이션 및 투명도(알파) 채널과 같은 다양한 기능을 지원합니다. 결과적으로 특정 이미지에 대한 "올바른 형식"의 선택은 원하는 시각적 결과와 기능적 요구 사항의 조합입니다.

<div class="table-wrapper scrollbar"><table>
<thead>
  <tr>
    <th>체재</th>
    <th>투명도</th>
    <th>생기</th>
    <th>브라우저</th>
  </tr>
</thead>
<tbody>
<tr>
  <td data-th="format"><a href="http://en.wikipedia.org/wiki/Portable_Network_Graphics">PNG</a></td>
  <td data-th="transparency">예</td>
  <td data-th="animation">아니요</td>
  <td data-th="browser">모두</td>
</tr>
<tr>
  <td data-th="format"><a href="http://en.wikipedia.org/wiki/JPEG">JPEG</a></td>
  <td data-th="transparency">아니요</td>
  <td data-th="animation">아니요</td>
  <td data-th="browser">모두</td>
</tr>
<tr>
  <td data-th="format"><a href="http://en.wikipedia.org/wiki/WebP">웹피</a></td>
  <td data-th="transparency">예</td>
  <td data-th="animation">예</td>
  <td data-th="browser">모든 최신 브라우저. <a href="https://caniuse.com/#feat=webp">사용할 수 있습니까?</a>를 참조하십시오.</td>
</tr>
</tbody>
</table></div>

보편적으로 지원되는 두 가지 래스터 이미지 형식(PNG 및 JPEG)이 있습니다. 이러한 형식 외에도 최신 브라우저는 더 나은 전체 압축과 더 많은 기능을 제공하는 최신 형식의 WebP를 지원합니다. 그렇다면 어떤 형식을 사용해야 할까요?

WebP 형식은 일반적으로 이전 형식보다 더 나은 압축을 제공하며 가능한 경우 사용해야 합니다. WebP를 다른 이미지 형식과 함께 폴백으로 사용할 수 있습니다. 자세한 내용은 [WebP 이미지 사용](/serve-images-webp/)을 참조하십시오.

이전 이미지 형식과 관련하여 다음을 고려하십시오.

1. **애니메이션이 필요하십니까? `<video>` 요소를 사용하세요.**
    - GIF는 어떻습니까? GIF는 색상표를 최대 256색으로 제한하고 `<video>` 요소보다 훨씬 더 큰 파일 크기를 만듭니다. [애니메이션 GIF를 비디오로 교체](/replace-gifs-with-videos/)를 참조하십시오.
2. **최고의 해상도로 미세한 디테일을 보존해야 합니까? PNG를 사용하십시오.**
    - PNG는 색상 팔레트 크기 선택 외에 손실 압축 알고리즘을 적용하지 않습니다. 결과적으로 최고 품질의 이미지를 생성하지만 다른 형식보다 파일 크기가 훨씬 더 커집니다. 신중하게 사용하세요.
    - 이미지 자산에 기하학적 모양으로 구성된 이미지가 포함된 경우 벡터(SVG) 형식으로 변환하는 것이 좋습니다!
    - 이미지 자산에 텍스트가 포함된 경우 중지하고 재고하십시오. 이미지의 텍스트는 선택, 검색 또는 "확대/축소"가 불가능합니다. 브랜딩 또는 기타 이유로 사용자 정의 모양을 전달해야 하는 경우 웹 글꼴을 대신 사용하십시오.
3. **사진, 스크린샷 또는 유사한 이미지 자산을 최적화하고 있습니까? JPEG를 사용하십시오.**
    - JPEG는 손실 및 무손실 최적화의 조합을 사용하여 이미지 자산의 파일 크기를 줄입니다. 자산에 대한 최상의 품질 대 파일 크기 절충점을 찾기 위해 여러 JPEG 품질 수준을 시도합니다.

마지막으로 WebView를 사용하여 플랫폼별 애플리케이션에서 콘텐츠를 렌더링하는 경우 클라이언트를 완전히 제어할 수 있고 WebP를 독점적으로 사용할 수 있습니다. Facebook을 비롯한 많은 기업은 WebP를 사용하여 애플리케이션 내에서 모든 이미지를 제공합니다. 절약할 가치는 분명히 있습니다.
