---
title: CLS 메트릭의 진화
subhead: 수명이 긴 페이지에 더 공정하도록 CLS 메트릭을 개선하기 위한 계획.
description: 수명이 긴 페이지에 더 공정하도록 CLS 메트릭을 개선하기 위한 계획.
authors:
  - anniesullie
  - hbsong
date: 2021-04-07
hero: image/admin/JSBg0yF1fatrTDQSKiTW.webp
alt: 레이아웃 이동을 측정하기 위한 예제 윈도잉 접근 방식.
tags:
  - blog
  - performance
  - web-vitals
---

{% Aside %} **2021년 6월 2일:** 이 게시물에 설명된 CLS 업데이트는 현재 Chrome의 웹 도구 영역 전체에서 사용할 수 있습니다. 자세한 내용은 [웹 도구에서 진화하는 누적 레이아웃 이동](/cls-web-tooling/)을 참조하세요. {% endAside %}

우리(Chrome Speed Metrics Team)는 최근 [오랫동안 열려 있는 페이지에 대해 CLS 메트릭을 보다 공정하게 만들기 위한 옵션](/better-layout-shift-metric/)의 초기 연구를 개괄적으로 설명했습니다. 매우 유익한 피드백을 많이 받았고 대규모 분석을 완료한 후 메트릭에 적용할 계획인 다음의 변경 사항을 확정했습니다: **1초 간격이고 최대 5초로 제한된 최대 세션 윈도우**.

계속해서 자세한 내용을 읽어보세요!

## 옵션을 어떻게 평가했을까요?

개발자 커뮤니티로부터 받은 모든 피드백을 검토하고 고려했습니다.

또한 Chrome에서 [상위 옵션](/better-layout-shift-metric/#best-strategies)을 구현하고 수백만 개의 웹페이지에 대해 대규모 메트릭 분석을 수행했습니다. 각 옵션이 개선시킨 사이트 유형과 옵션을 비교한 방식을 점검했으며 특히 옵션에 따라 다른 점수가 매겨진 사이트를 면밀히 조사했습니다. 전반적으로 다음과 같은 점을 발견했습니다.

- **모든** 옵션은 페이지에서 보낸 시간과 레이아웃 이동 점수 간의 상관 관계를 줄였습니다.
- **어떤** 옵션도 페이지에 대해 더 낮은 점수로 이어지지 않았습니다. 따라서 이 변경으로 인해 사이트의 점수가 악화될 것이라는 걱정은 할 필요가 없습니다.

## 결정 포인트

### 왜 세션 창인가?

[이전 게시물](/better-layout-shift-metric/)에서 점수가 무한대로 증가하지 않도록 하는 동시에 레이아웃 이동을 그룹화하기 위한[몇 가지 다른 윈도잉 전략](/better-layout-shift-metric/#windowing-strategies)을 다루었습니다. 개발자들로부터 받은 피드백은 레이아웃 이동을 가장 직관적으로 그룹화한다는 점에서 세션 창 전략에 압도적으로 많은 손을 들어주었습니다.

세션 창을 검토하기 위한 예는 다음과 같습니다.

<figure>
  <video controls autoplay loop muted>
    <source src="https://storage.googleapis.com/web-dev-assets/better-layout-shift-metric/session-window.webm" type="video/webm">
    <source src="https://storage.googleapis.com/web-dev-assets/better-layout-shift-metric/session-window.mp4" type="video/mp4">
  </source></source></video>
  <figcaption>세션 창의 예.</figcaption></figure>

위의 예에서 사용자가 페이지를 볼 때 시간이 지남에 따라 많은 레이아웃 이동이 발생합니다. 각각은 파란색 막대로 표시됩니다. 위에서 파란색 막대의 높이가 다른 것을 알 수 있습니다. 이것들은 각 개별 레이아웃 이동의 [점수](/cls/#layout-shift-score)를 나타냅니다. 세션 창은 첫 번째 레이아웃 이동으로 시작하여 레이아웃 이동이 없는 간격이 있을 때까지 계속 확장됩니다. 다음 레이아웃 이동이 발생하면 새 세션 창이 시작됩니다. 레이아웃 이동이 없는 세 개의 간격이 있으므로 이 예제에는 세 개의 세션 창이 있습니다. CLS의 현재 정의와 유사하게 각 이동의 점수가 합산되어 각 창의 점수는 개별 레이아웃 이동의 합계가 됩니다.

[초기 연구](/better-layout-shift-metric/#best-strategies)를 기반으로, 세션 창 사이에 1초 간격을 선택했으며 이 간격은 대규모 분석에서 잘 작동했습니다. 따라서 위의 예에 표시된 "세션 간격"은 1초입니다.

### 최대 세션 창이 필요한 이유는 무엇인가요?

초기 연구에서 [요약 전략](/better-layout-shift-metric/#summarization)을 두 가지 옵션으로 좁혔습니다.

- 매우 큰 세션 창에 대해 모든 세션 창의 **평균** 점수(5초 간격의 제한이 없는 창).
- 더 작은 세션 창에 대해 모든 세션 창의 **최대** 점수(최대 5초, 그 사이에 1초 간격).

초기 조사 후 수백만 개의 URL에 대한 대규모 분석을 수행할 수 있도록 각 메트릭을 Chrome에 추가했습니다. 대규모 분석에서 우리는 다음과 같은 레이아웃 이동 패턴을 가진 많은 URL을 발견했습니다.

{% Img src="image/MZfwZ8oVW8U6tzo5CXffcER0jR83/bW3lHZmss3cqGayZsq4P.png", alt="평균을 낮추는 작은 레이아웃 이동의 예", width="800", height="550" %}

오른쪽 하단에서 세션 창 2에 아주 낮은 점수를 주는 단 하나의 작은 레이아웃 이동만 있음을 알 수 있습니다. 즉, 평균 점수가 매우 낮습니다. 그러나 개발자가 이 작은 레이아웃 이동을 수정한다면 어떨까요? 그러면 점수가 세션 창 1에서만 계산됩니다. 즉, 페이지 점수가 *거의 두 배*가 됩니다. 개발자가 레이아웃 이동을 개선했지만 점수가 오히려 더 나빠졌다는 사실을 알게 된다면 정말 혼란스럽고 낙담할 것입니다. 그리고 이 작은 레이아웃 이동을 제거하면 분명히 사용자 경험이 약간 더 개선되므로 점수를 악화시키지 않을 것입니다.

평균과 관련된 이 문제 때문에 우리는 더 작고 제한이 있는 최대 창으로 진행하기로 결정했습니다. 따라서 위의 예에서 세션 창 2는 무시되고 세션 창 1의 레이아웃 이동 합계만 보고됩니다.

### 왜 5초일까요?

여러 창 크기를 평가하고 두 가지를 발견했습니다.

- 짧은 창의 경우 느린 페이지 로드와 사용자 상호 작용에 대한 느린 응답으로 인해 레이아웃 이동이 여러 창으로 분할되고 점수가 향상될 수 있습니다. 속도 저하를 보상하지 않도록 창을 충분히 크게 유지하려고 했습니다!
- 작은 레이아웃 이동이 계속되는 일부 페이지가 있습니다. 예를 들어, 각 점수 업데이트와 함께 약간씩 이동하는 스포츠 점수 페이지가 있습니다. 이러한 이동은 성가시지만 시간이 지남에 따라 더 성가시게 되지는 않습니다. 그래서 우리는 이러한 유형의 레이아웃 이동에 대해 창이 제한되도록 하고 싶었습니다.

이 두 가지를 염두에 두고 많은 실제 웹 페이지에서 다양한 창 크기를 비교한 결과, 5초가 창 크기의 적절한 제한이라는 결론을 내렸습니다.

## 이것이 내 페이지의 CLS 점수에 어떤 영향을 주나요?

이 업데이트는 페이지의 CLS를 제한하므로 이 변경으로 인해 **어떤 페이지에서도 점수가 다 나빠지지 않습니다.**

그리고 우리의 분석에 따르면 **원본의 55%는 75번째 백분위수에서 CLS의 변화를 전혀 보지 못할 것입니다**. 이는 해당 페이지에 현재 레이아웃 이동이 없거나 이동이 있더라도 이미 단일 세션 창으로 제한되어 있기 때문입니다.

**원본의 나머지는 이 변경으로 75번째 백분위수에서 점수 향상을 보게 될 것입니다.** 대부분은 개선 수준이 미미하겠지만 약 3%는 점수가 "개선 필요" 또는 "나쁨" 등급에서 "좋음" 등급으로 향상되는 결과를 보게 될 것입니다. 이러한 페이지는 [이전 게시물](/better-layout-shift-metric/)에서 설명한 대로 무한 스크롤러를 사용하거나 UI 업데이트가 느린 경향이 있습니다.

## 어떻게 시도해 볼 수 있나요?

곧 새로운 메트릭 정의를 사용하도록 도구를 업데이트할 예정입니다! 그때까지는 [예제 JavaScript 구현](https://github.com/mmocny/web-vitals/wiki/Snippets-for-LSN-using-PerformanceObserver) 또는 [Web Vitals 확장의 포크](https://github.com/mmocny/web-vitals-extension/tree/experimental-ls)를 사용하여 모든 사이트에서 업데이트된 버전의 CLS를 사용해 볼 수 있습니다.

시간을 내어 이전 게시물을 읽고 피드백을 주신 모든 분들께 감사드립니다!
