---
layout: post
title: 캐러셀 권장사항
subhead: 성능과 사용성을 위해 캐러셀을 최적화합니다.
authors:
  - katiehempenius
description: 성능과 사용성을 위해 캐러셀을 최적화하는 방법을 알아보세요.
date: 2021-01-26
hero: image/admin/i7tjE04MYo7xJOZKkyQI.jpg
tags:
  - blog
  - performance
  - web-vitals
---

캐러셀은 슬라이드쇼와 같은 방식으로 콘텐츠를 표시하는 UX 구성 요소입니다. 캐러셀은 '자동 재생'하거나 사용자가 수동으로 탐색할 수 있습니다. 캐러셀은 다른 곳에서도 사용할 수 있지만 홈페이지에 이미지, 제품 및 프로모션을 표시하는 데 가장 자주 사용됩니다.

이 문서에서는 캐러셀의 성능 및 UX 모범 사례에 대해 설명합니다.

<figure>{% Img src="image/admin/u2FlXalClwBeDOBBiwxu.png", alt="캐러셀을 보여주는 이미지", width="629", height="420" %}</figure>

## 성능

잘 구현된 캐러셀은 그 자체로 성능에 미치는 영향이 매우 적거나 전혀 없습니다. 그러나 캐러셀에는 종종 큰 미디어 자산이 포함됩니다. 큰 자산은 캐러셀에 표시되는지 여부에 관계없이 성능에 영향을 줄 수 있습니다.

- **LCP(Largest Contentful Paint: 최대 콘텐트풀 페인트)**

    스크롤 없이 볼 수 있는 큰 캐러셀에는 종종 페이지의 LCP 요소가 포함되어 LCP에 상당한 영향을 줄 수 있습니다. 이러한 상황에서 캐러셀을 최적화하면 LCP가 크게 향상될 수 있습니다. 캐러셀이 포함된 페이지에서 LCP 측정이 작동하는 방식에 대한 자세한 설명은 [캐러셀에 대한 LCP 측정](#lcp-measurement-for-carousels) 섹션을 참조하세요.

- **FID(First Input Delay: 최초 입력 지연)**

    캐러셀에는 최소한의 JavaScript 요구 사항이 있어 페이지 상호 작용에 영향을 주지 않습니다. 사이트의 캐러셀에 오래 실행되는 스크립트가 있다면 캐러셀 도구 교체를 고려해야 합니다.

- **CLS(Cumulative Layout Shift: 누적 레이아웃 이동)**

    놀랍도록 많은 캐러셀에서 CLS의 원인이 될 수 있는 낮은 품질의 비합성 애니메이션을 사용합니다. 자동 재생 캐러셀이 있는 페이지에서 이는 무한 CLS를 유발할 가능성이 있습니다. 이러한 유형의 CLS는 일반적으로 사람의 눈으로는 분명히 보이지 않아 문제를 간과하기 쉽습니다. 이 문제를 방지하려면 캐러셀에서 [비합성 애니메이션의 사용을 피하십시오](https://developer.chrome.com/docs/lighthouse/performance/non-composited-animations/).(예: 슬라이드 전환 중)

## 성능 모범 사례

### HTML을 사용하여 캐러셀 콘텐츠 불러오기

캐러셀 콘텐츠는 페이지 로드 과정 초기에 브라우저에서 검색할 수 있도록 페이지의 HTML 마크업을 통해 로드되어야 합니다. JavaScript를 사용하여 캐러셀 콘텐츠의 로딩을 시작하는 것은 캐러셀을 사용할 때 피해야 할 가장 큰 수행 중 실수일 것입니다. 이는 이미지 로딩을 지연시키고 LCP에 부정적인 영향을 줄 수 있습니다.

{% Compare 'better' %}

```html
<div class="slides">
  <img src="https://example.com/cat1.jpg">
  <img src="https://example.com/cat2.jpg">
  <img src="https://example.com/cat3.jpg">
</div>
```

{% endCompare %}

{% Compare 'worse' %}

```javascript
const slides = document.querySelector(".slides");
const newSlide = document.createElement("img");
newSlide.src = "htttp://example.com/cat1.jpg";
slides.appendChild(newSlide);
```

{% endCompare %}

고급 캐러셀 최적화를 첫 번째 슬라이드를 정지 상태로 로딩한 다음, 탐색 컨트롤 및 추가 콘텐츠를 포함하도록 점진적으로 향상시키는 것을 고려하십시오. 이 기술은 사용자의 관심이 길어지는 환경에 가장 적당하며, 그러면 추가 콘텐츠를 로드할 수 있는 시간이 생깁니다. 사용자가 1, 2초 정도만 머무는 홈페이지와 같은 환경에서는 단일 이미지만 로드하는 것으로 유사한 효과를 낼 수 있습니다.

### 레이아웃 이동 피하기

{% Aside %}

Chrome 88-90은 레이아웃 이동이 계산되는 방식과 관련된 다양한 [버그 수정](https://chromium.googlesource.com/chromium/src/+/master/docs/speed/metrics_changelog/cls.md)을 출시했습니다. 이 버그 수정의 많은 부분이 캐러셀과 관련되어 있습니다. 이러한 수정의 결과로 사이트는 이후 버전의 Chrome에서 캐러셀 관련 레이아웃 이동 지수가 낮아질 것으로 예상하고 있습니다.

{% endAside %}

슬라이드 전환 및 탐색 컨트롤은 캐러셀에서 레이아웃 이동의 가장 일반적인 두 가지 소스입니다.

- **슬라이드 전환:** 슬라이드 전환 중에 발생하는 레이아웃 이동은 일반적으로 DOM 요소의 레이아웃 유도 속성을 업데이트하여 발생합니다. 이러한 속성 중 일부의 예로는 `left`, `top`, `width` 및 `marginTop`가 있습니다. 레이아웃 이동을 피하려면 대신 CSS [`transform`](https://developer.mozilla.org/docs/Web/CSS/transform) 속성을 사용하여 이러한 요소를 전환합니다. 이 [데모](https://glitch.com/~basic-carousel)는 `transform`을 사용하여 기본적인 캐러셀을 만드는 방법을 보여줍니다.

- **탐색 컨트롤:** DOM에서 캐러셀 탐색 컨트롤을 이동하거나 추가/제거하면 이러한 변경 사항이 구현되는 방식에 따라 레이아웃 이동이 일어날 수 있습니다. 이 동작이 나타내는 캐러셀은 일반적으로 사용자 호버에 반응하여 그렇게 작동합니다.

다음은 캐러셀에 대한 CLS 측정과 관련하여 흔히 혼동할 수 있는 몇 가지 사항입니다.

- **자동 재생 캐러셀:** 슬라이드 전환은 캐러셀 관련 레이아웃 이동의 가장 일반적인 원인입니다. 자동재생이 아닌 캐러셀에서 이러한 레이아웃 이동은 일반적으로 사용자 상호작용으로부터 500ms 이내에 발생하므로 [CLS(Cumulative Layout Shift)에 포함되지 않습니다](/cls/#expected-vs-unexpected-layout-shifts). 그러나 자동 재생 캐러셀의 경우 이러한 레이아웃 이동이 잠재적으로 CLS에 포함될 수 있을 뿐만 아니라 무기한 반복될 수도 있습니다. 따라서 자동 재생 캐러셀이 레이아웃 이동의 원인이 아님을 확인하는 것이 특히 중요합니다.

- **스크롤:** 일부 캐러셀에서는 스크롤을 사용하여 캐러셀 슬라이드를 탐색할 수 있습니다. 만약 요소의 시작 위치가 변경되지만 그 스크롤 오프셋(즉, [`scrollLeft`](https://developer.mozilla.org/docs/Web/API/Element/scrollLeft) 또는 [`scrollTop`](https://developer.mozilla.org/docs/Web/API/Element/scrollTop) )이 동일한 양만큼(그러나 반대 방향으로) 변경되는 경우에는 동일한 프레임에서 발생하는 한 레이아웃 이동으로 간주되지 않습니다.

레이아웃 변환에 대한 자세한 내용은 [디버그 레이아웃 변환](/debug-layout-shifts/#identifying-the-cause-of-a-layout-shift)을 참조하세요.

### 현대 기술의 사용

많은 사이트에서 캐러셀을 구현하기 위해 [타사 JavaScript](/third-party-javascript) 라이브러리를 사용합니다. 현재 이전 캐러셀 도구를 사용하는 경우 최신 도구로 전환하여 성능을 향상시킬 수 있습니다. 최신 도구는 더 효율적인 API를 사용하는 경향이 있으며 jQuery와 같은 추가 종속성을 요구할 가능성이 적습니다.

그러나 구축하는 캐러셀 유형에 따라 JavaScript가 전혀 필요하지 않을 수도 있습니다. 새로운 [Scroll Snap](https://developer.mozilla.org/docs/Web/CSS/CSS_Scroll_Snap) API를 사용하면 HTML과 CSS만 사용하여 캐러셀 같은 전환을 구현할 수 있습니다.

다음은 도움이 될 수 있는 `scroll-snap` 사용에 대한 몇 가지 리소스입니다.

- [스토리 구성 요소(web.dev) 빌드](/building-a-stories-component/)
- [차세대 웹 스타일링: 스크롤 스냅(web.dev)](/next-gen-css-2019/#scroll-snap)
- [CSS 전용 캐러셀(CSS 트릭)](https://css-tricks.com/css-only-carousel/)
- [CSS 전용 캐러셀을 만드는 방법(CSS 트릭)](https://css-tricks.com/how-to-make-a-css-only-carousel/)

### 캐러셀 콘텐츠 최적화

캐러셀에는 사이트의 가장 큰 이미지가 포함되는 경우가 많으므로 이러한 이미지가 완전히 최적화되었는지 확인하는 데 시간을 할애할 가치가 있습니다. 올바른 이미지 형식과 압축 수준을 선택하고, [이미지 CDN을 사용하고](/image-cdns), [srcset을 사용하여 여러 이미지 버전을 제공하는 것](https://developer.mozilla.org/docs/Web/CSS/CSS_Scroll_Snap)은 모두 이미지의 전송 크기를 줄일 수 있는 기술입니다.

## 성능 측정

이 섹션에서는 캐러셀과 관련된 LCP 측정에 대해 설명합니다. 캐러셀은 LCP 계산 중에 다른 UX 요소와 다르지 않게 취급되지만 캐러셀을 자동 재생하기 위한 LCP 계산 방식은 흔히 혼동할 수 있는 지점입니다.

### 캐러셀에 대한 LCP 측정

캐러셀에 대한  LCP 계산이 작동하는 방식을 이해하기 위한 핵심 내용은 다음과 같습니다.

- LCP는 페이지 요소를 프레임에 그려진 것으로  간주합니다. 사용자가 페이지와 상호 작용(탭, 스크롤 또는 키 누르기)하면 LCP 요소의 새 후보는 더 이상 고려되지 않습니다. 따라서 자동 재생 캐러셀의 모든 슬라이드는 최종 LCP 요소가 될 가능성이 있는 반면, 고정 캐러셀에서는 첫 번째 슬라이드만 잠재적 LCP 후보가 됩니다.
- 동일한 크기의 두 이미지가 렌더링되면 첫 번째 이미지가 LCP 요소로 간주됩니다. LCP 요소는 LCP 후보가 현재 LCP 요소보다 클 때만 업데이트됩니다. 따라서 모든 캐러셀 요소의 크기가 동일하면 LCP 요소가 첫 번째로 표시되는 이미지가 될 것입니다.
- LCP 후보를 평가할 때 LCP는 "[눈에 보이는 크기 또는 고유 크기 중 더 작은 것](/lcp)"을 고려합니다. 따라서 자동 재생 캐러셀이 일관된 크기로 이미지를 표시하고 있지만, 표시되는 크기보다 작은 다양한 [고유 크기](https://developer.mozilla.org/docs/Glossary/Intrinsic_Size)의 이미지를 포함하는 경우, LCP 요소는 새 슬라이드가 표시될 때 변경될 수 있습니다. 이 경우 모든 이미지가 동일한 크기로 표시되면 고유 크기가 가장 큰 이미지가 LCP 요소로 간주됩니다. LCP를 낮게 유지하려면 자동 재생 캐러셀의 모든 항목이 동일한 고유 크기를 가지도록 해야 합니다.

### Chrome 88의 캐러셀에 대한 LCP 계산 변경사항

[Chrome 88](https://chromium.googlesource.com/chromium/src/+/master/docs/speed/metrics_changelog/2020_11_lcp.md)부터는 DOM에서 늦게 제거되는 이미지가 잠재적인 최대 콘텐트풀 페인트로 간주됩니다. Chrome 88 이전에는 이러한 이미지는 고려 대상에서 제외되었습니다. 자동 재생 캐러셀을 사용하는 사이트의 경우 이러한 정의의 변경이 LCP 지수에 중립적이거나 긍정적인 영향을 미치게 될 것입니다.

이 변경은 많은 사이트에서 이전에 표시된 이미지를 DOM 트리에서 제거하여 캐러셀 전환을 구현한다는 [관찰](https://github.com/anniesullie/LCP_Examples/tree/master/removed_from_dom)에 대한 응답으로 이루어졌습니다. Chrome 88 이전에는 새 슬라이드가 표시될 때마다, 이전 요소의 제거가 LCP 업데이트를 촉발하였습니다. 이 변경 사항은 자동 재생 캐러셀에만 영향을 미칩니다. 정의에 따라 잠재적인 최대 콘텐트풀 페인트는 사용자가 페이지와 처음 상호작용하기 전에만 발생할 수 있습니다.

## 기타 고려 사항

이 섹션에서는 캐러셀을 구현할 때 염두에 두어야 할 UX 및 제품 모범 사례에 대해 설명합니다. 캐러셀은 비즈니스 목표를 향상시키고 탐색하고 읽기 쉬운 방식으로 콘텐츠를 제시해야 합니다.

### 탐색 모범 사례

#### 눈에 띄는 탐색 컨트롤 제공

캐러셀 탐색 컨트롤은 클릭하기 쉽고 눈에 잘 띄어야 합니다. 이는 거의 잘 이뤄지지 않고 있는 사항으로, 대부분의 캐러셀은 작고 보기 힘든 탐색 컨트롤을 가지고 있습니다. 단일 색상 또는 스타일의 탐색 컨트롤이 모든 상황에서 잘 작동하는 경우는 거의 없습니다. 예를 들어, 어두운 배경에서 또렷하게 보이는 화살표는 밝은 배경에서는 잘 보이지 않을 수도 있습니다.

#### 탐색 진행률 표시

캐러셀 탐색 컨트롤은 총 슬라이드 수와 슬라이드를 통한 사용자의 진행 상황에 대한 배경 정보를 제공해야 합니다. 이 정보를 통해 사용자는 쉽게 특정 슬라이드를 탐색하고 이미 본 콘텐츠가 어떤 것인지를 알 수 있게 됩니다. 다음 슬라이드에서 발췌한 내용이든 썸네일 목록이든 관계 없이 예정된 콘텐츠에 대한 미리보기를 제공하는 것도 도움이 되고 참여도를 높일 수 있습니다.

#### 모바일 제스처 지원

모바일에서 스와이프 제스처는 기존 탐색 컨트롤(예: 화면 버튼)과 함께 지원되어야 합니다.

#### 대체 탐색 경로 제공

대부분의 사용자가 모든 캐러셀 콘텐츠에 참여할 가능성은 낮기 때문에 캐러셀 슬라이드가 링크하는 콘텐츠는 다른 탐색 경로에서 액세스할 수 있어야 합니다.

### 가독성 모범 사례

#### 자동 재생 사용하지 않기

자동 재생을 사용하면 역설에 가까운 두 가지 문제가 발생합니다. 화면의 애니메이션은 사용자의 주의를 흩트리고 더 중요한 정보 콘텐츠에서 시선을 빼앗습니다. 동시에 사용자는 종종 애니메이션을 광고와 연관시켜 자동 재생되는 캐러셀을 무시합니다.

따라서 자동 재생이 좋은 선택인 경우는 드뭅니다. 콘텐츠가 중요한 경우 자동 재생을 사용하지 않으면 노출이 최대화됩니다. 캐러셀 콘텐츠가 중요하지 않은 경우 자동 재생을 사용하면 더 중요한 콘텐츠에서 주의를 돌리게 됩니다. 또한 자동 재생 캐러셀은 읽기 어려울 수 있습니다(귀찮기도 하고요). 사람들은 서로 다른 속도로 읽기 때문에 캐러셀이 다양한 사용자에게 '적절한' 시간에 일관되게 전환되는 경우는 드뭅니다.

이상적으로는 슬라이드 탐색은 탐색 컨트롤을 통해 사용자가 지시해야 합니다. 자동 재생을 사용해야만 한다면, 자동재생은 사용자 호버에서 비활성화되어야 합니다. 또한 슬라이드 전환 속도는 슬라이드 콘텐츠를 고려해야 합니다. 슬라이드에 포함된 텍스트가 많을수록 화면에 더 오래 표시되어야 합니다.

#### 텍스트와 이미지를 별도로 유지

캐러셀 텍스트 콘텐츠는 종종 HTML 마크업을 사용하여 별도로 표시되지 않고 해당 이미지 파일에 '통합'됩니다. 이 접근 방식은 접근성, 현지화 및 압축률에 좋지 않습니다. 또한 자산 생성에 대한 획일적인 접근 방식을 권장합니다. 그러나 동일한 이미지 및 텍스트 형식이 데스크톱 및 모바일에서 동일하게 읽기 쉬운 경우는 거의 없습니다.

#### 간결하게 만들기

사용자의 관심을 끌 수 있는 시간은 1초도 되지 않습니다. 짧고 핵심을 찌르는 카피가 메시지가 전달될 확률을 높여줄 것입니다.

### 제품 모범 사례

캐러셀은 추가 콘텐츠를 표시하기 위해 추가적인 수직 공간을 사용할 수 없는 상황에서 잘 작동합니다. 제품 페이지의 캐러셀은 종종 이러한 사용의 좋은 예시입니다.

그러나 캐러셀이 항상 효과적으로 사용되는 것은 아닙니다.

- 캐러셀은 특히 프로모션이 포함되거나 자동으로 진행되는 경우 쉽게 사용자에게 광고로 [오인](https://www.nngroup.com/articles/auto-forwarding/)됩니다. 사용자는 광고를 무시하는 경향이 있는데, 이것은 [배너 광고 회피](https://www.nngroup.com/articles/banner-blindness-old-and-new-findings/) 현상으로 알려져 있습니다.
- 캐러셀은 여러 부서를 달래고 비즈니스 우선 순위에 대한 결정을 회피하기 위해 자주 사용됩니다. 결과적으로 캐러셀은 비효율적인 콘텐츠의 쓰레기장으로 쉽게 변질될 수 있습니다.

#### 추정 사항의 점검

캐러셀, 특히 홈페이지에 대한 캐러셀의 비즈니스 효과는 평가와 테스트를 받아야 합니다. 캐러셀 클릭률은 캐러셀과 캐러셀의 콘텐츠가 효과적인지 판단하는 데 도움이 됩니다.

#### 관련성

캐러셀은 명확한 맥락과 함께 흥미롭고 관련성 높은 콘텐츠를 포함할 때 가장 잘 작동합니다. 콘텐츠가 캐러셀 외부에 있는 사용자의 주의를 끌지 못한다면, 캐러셀에 콘텐츠를 배치해도 성능은 향상되지 않습니다. 캐러셀을 꼭 사용해야 한다면, 콘텐츠의 우선 순위를 지정하고 사용자가 클릭하여 다음 슬라이드로 가고 싶어할 만큼 각 슬라이드가 관련성을 가지도록 하십시오.
