---
layout: post
title: HTTPSが重要な理由
authors:
  - kaycebasques
date: 2015-11-23
updated: 2020-04-07
description: |2-

  HTTPSはウェブサイトの整合性、プライバシー、セキュリティを保護するほか、新しくパワフルなウェブプラットフォーム API の必須要素です。
tags:
  - security
---

ウェブサイトは、機密性の高い通信データを処理しない場合でも、常にHTTPSを使って保護する必要があります。HTTPSは、ウェブサイトとユーザーの個人情報の両方に重大なセキュリティとデータの整合性を提供するだけでなく、多くの新しいブラウザー機能、特に[プログレッシブウェブプリ](/progressive-web-apps)で必須とされています。

{% YouTube 'iP75a1Y9saY' %}

## 要約 {: #summary}

- 侵入者は、悪意を持つ者も、そうでない者も、ウェブサイトとユーザーの間に存在するありとあらゆる無保護のリソースを悪用します。
- 多くの侵入者は、集約されたユーザー動作を見てユーザーを特定します。
- HTTPSは、ウェブサイトの誤用を防ぐだけでなく、多くの最先端機能やサービスワーカーといったアプリに似た機能を実現するテクノロジーの要件でもあります。

## HTTPSはウェブサイトの整合性を保護する {: #integrity}

HTTPSは、ウェブサイトとユーザーのブラウザ間で行われる通信データが侵入者によって改ざんされるのを防ぐのに役立ちます。侵入者には、意図的に悪意を持つ攻撃者や、ページに広告を挿入するISPやホテルといった、合法ではあるが迷惑な企業などが含まれます。

侵入者は、保護されていない通信を悪用することにより、ユーザーをだまし、個人情報を提供させたり、マルウェアをインストールしたり、独自の広告をリソースに挿入したりします。たとえば、一部のサードパーティは、ユーザーエクスペリエンスを害しい、セキュリティの脆弱性を生み出す可能性のある広告をウェブサイトに挿入します。

侵入者は、ウェブサイトとユーザーの間でやりとりされる無保護のリソースを悪用します。画像、Cookie、スクリプト、HTMLはすべて悪用可能です。侵入は、ユーザーのマシンやWi-Fiホットスポット、侵害されたISPなど、ネットワーク上のありとあらゆる場所で行われる可能性があります。

## HTTPSはユーザーのプライバシーとセキュリティを保護する {: #privacy}

HTTPSは、ウェブサイトとユーザーの間で行われる通信を侵入者によって受動的にリッスンされるのを防ぎます。

HTTPSに関する一般的な誤解の1つに、HTTPSを必要とするウェブサイトは機密性の高い通信を処理するウェブサイトだけであるというものがあります。保護されていないHTTPリクエストは、ユーザーの行動やアイデンティティに関する情報を明らかにしてしまう可能性があります。保護されていないウェブサイトに1回アクセスするだけなら無害に思えるかもしれませんが、一部の侵入者は、ユーザーの総合的な閲覧履歴を見ることにより、そのユーザーの行動や意図を推測し、アイデンティティを[特定](https://en.wikipedia.org/wiki/De-anonymization)することがあります。たとえば、従業員は、無保護の医療記事を読むだけで、誤ってプライベートな健康状態を雇用主に開示してしまう可能性があります。

## HTTPSがウェブの未来を握る {: #capabilities}

`getUserMedia()`を使用した写真の撮影や音声の録音[、サービスワーカーを使った](/service-workers-cache-storage/)オフラインアプリエクスペリエンスの有効化、[プログレッシブウェブアプリ](/progressive-web-apps)の構築など、パワフルで新しいウェブプラットフォーム機能を実行するには、ユーザーからの明示的な許可が必要です。 [Geolocation API](https://developer.mozilla.org/docs/Web/API/Geolocation/Using_geolocation)など、多くの古いAPIも実行するには許可が必要となるかたちで更新されつつあります。HTTPSは、こうした新機能と最新のAPIの両方において、権限ワークフローの重要なコンポーネントとして機能します。
