---
layout: post
title: 混合コンテンツとは何ですか？
authors:
  - johyphenel
  - rachelandrew
date: 2019-09-07
updated: 2020-09-24
description: 混合コンテンツは、最初の HTML がセキュリティで保護されている HTTPS 接続を介して読み込まれていても、他のリソースがセキュリティで保護されていない HTTP 接続を介して読み込まれる場合に起こります。
tags:
  - security
  - network
  - privacy
  - html
  - css
  - javascript
  - images
  - media
---

**混合コンテンツ**は、最初の HTML がセキュリティで保護されている [HTTPS](/why-https-matters/) 接続を介して読み込まれていても、他のリソース（画像、動画、スタイルシート、スクリプトなど）がセキュリティで保護されていない HTTP 接続を介して読み込まれる場合に起こります。HTTP と HTTPS の両コンテンツが同じページに読み込まれて表示されており、最初のリクエストが HTTPS 経由でセキュリティで保護されていたため、混合コンテンツと呼ばれます。

セキュリティで保護されていない HTTP プロトコルを使用してサブリソースをリクエストすると、ページ全体のセキュリティが弱まります。これらのリクエストは、攻撃者がネットワーク接続を盗聴し、2 者間の通信を閲覧または変更する、[**パス上攻撃**](https://www.ietf.org/rfc/rfc7835.html#section-2.1.1)に対して脆弱であるためです。攻撃者はこれらのリソースを使用して、ユーザーを追跡し、Web サイト上のコンテンツを置き換えることができます。そしてアクティブな混合コンテンツの場合であれば、セキュリティで保護されていないリソースだけでなく、ページを完全に制御できます。

多くのブラウザはユーザーに混合コンテンツの警告を報告しますが、これが発生すれば手遅れです。セキュリティで保護されていないリクエストはすでに実行されており、ページのセキュリティが危険にさらされてしまっています。

これが、ブラウザが混合コンテンツをますますブロックしている理由です。サイトに混合コンテンツが存在する場合は、それを修正することで、ブラウザがより厳密になってもコンテンツが引き続き読み込まれるようすることができます。

## 2 種類の混合コンテンツ

混合コンテンツには、アクティブとパッシブの 2 種類があります。

**パッシブ混合コンテンツ**とは、ページの他の部分と対話しないコンテンツを指します。したがって、中間者攻撃は、そのコンテンツを傍受または変更した場合に実行できることに制限されます。パッシブ混合コンテンツは、画像、動画、およびオーディオコンテンツとして定義されます。

**アクティブ混合コンテンツ**とは、ページ全体と対話し、攻撃者がページに対してほぼすべてのことを実行できるコンテンツを指します。アクティブ混合コンテンツには、スクリプト、スタイルシート、iframe、およびブラウザがダウンロードして実行できるその他のコードが含まれます。

### パッシブ混合コンテンツ

パッシブ混合コンテンツは問題が少ないと見なされていますが、それでもサイトとユーザーにセキュリティ上の脅威をもたらします。たとえば、攻撃者はサイト上の画像に対する HTTP リクエストを傍受し、これらの画像を交換または置換する可能性があります。攻撃者が*保存*ボタンと*削除*ボタンの画像を入れ替えれば、ユーザーが意図せずにコンテンツを削除する可能性があり、製品のダイアグラムをわいせつなコンテンツに置き換えれば、サイトの信用を傷つけてしまいます。または、商品の写真を他のサイトや商品の広告に置き換える可能性もあります。

攻撃者がサイトのコンテンツを変更しなくても、攻撃者は混合コンテンツのリクエストを介してユーザーを追跡できます。攻撃者は、ブラウザが読み込む画像やその他のリソースに基づいて、ユーザーがどのページにアクセスし、どの製品を閲覧しているかを知ることができます。

パッシブ混合コンテンツが存在する場合、ページ自体は HTTPS 経由で読み込まれた場合であっても、ほとんどのブラウザはページがセキュリティで保護されていないことを URL バーに示します。この動作は、パッシブ混合コンテンツの例を含むこちらの[デモ](https://passive-mixed-content.glitch.me/)で観察できます。

最近まで、パッシブ混合コンテンツがすべてのブラウザに読み込まれていました。これらのコンテンツをブロックすると、多くの Web サイトが機能しなくなっていたでしょう。そのような状態は現在変化し始めており、サイト上の混合コンテンツのインスタンスを更新することが重要となっています。

Chrome は現在、可能な限り、パッシブ混合コンテンツの自動アップグレードを[展開しています](https://blog.chromium.org/2019/10/no-more-mixed-messages-about-https.html)。自動アップグレードとは、アセットが HTTPS 経由で利用可能であっても HTTP としてハードコーディングされている場合、ブラウザは HTTPS バージョンを読み込むことを意味します。セキュリティで保護されたバージョンが見つからない場合、アセットは読み込まれません。

混合コンテンツを検出するか、パッシブ混合コンテンツを自動アップグレードするたびに、Chrome は詳細メッセージを DevToolsの [**Issues**] タブに記録して、特定の問題を修正する方法を案内します。

<figure>{% Img src="image/tcFciHGuF3MxnTr1y5ue01OGLBn2/HNxoomaHi2ksvYHGuNiE.jpg", alt="Chrome DevTools の [Issues] タブには、特定の混合コンテンツの問題とその修正方法に関する詳細情報が表示されます。", width="800", height="310" %}</figure>

### アクティブな混合コンテンツ

アクティブな混合コンテンツは、パッシブな混合コンテンツよりも大きな脅威をもたらします。攻撃者はアクティブなコンテンツを傍受して書き換えることができるため、ページ、さらには Web サイト全体までも、完全に制御できます。これにより、攻撃者は、まったく異なるコンテンツの表示、ユーザーパスワードやその他のログイン資格情報の盗用、ユーザーセッション cookie の盗用、別のサイトへのユーザーのリダイレクトなど、ページに関するあらゆる情報を変更できます。

この脅威の深刻さにより、ほとんどのブラウザはユーザーを保護するためにこの種のコンテンツをデフォルトですでにブロックしていますが、機能はブラウザのベンダーとバージョンによって異なります。

このもう 1 つの[デモ](https://active-mixed-content.glitch.me/)には、アクティブな混合コンテンツの例が含まれています。[例を HTTP 経由で読み込んで](http://active-mixed-content.glitch.me/)、 [HTTPS 経由で例を読み込む際にブロックされるコンテンツを確認します。ブロックされたコンテンツは、[**Issues**] タブでも詳しく説明されます。](https://active-mixed-content.glitch.me/)

<figure>{% Img src="image/tcFciHGuF3MxnTr1y5ue01OGLBn2/xRG5zpKLr0Z3OwfYpn2H.jpg", alt="Chrome DevToolsの [Issues] タブには、特定の混合コンテンツの問題とその修正方法に関する詳細情報が表示されます。", width="800", height="361" %}</figure>

{% Aside %} ブラウザは、DevTools でブロックされたコンテンツもハイライト表示します。ブロックされたコンテンツの問題については、Chromium ベースのブラウザの [**Issues**] タブで詳しく説明されます。Firefox と Safari はコンソールにメッセージを記録します。 {% endAside %}

## 混合コンテンツ仕様

ブラウザは、 [**オプションでブロック可能なコンテンツ**](https://w3c.github.io/webappsec-mixed-content/#optionally-blockable-mixed-content)と[**ブロック可能なコンテンツの**](https://w3c.github.io/webappsec-mixed-content/#category-blockable)[カテゴリを定義する混合コンテンツ仕様に](https://w3c.github.io/webappsec-mixed-content/)従っています。

仕様から、リソースは「混合コンテンツとしての使用を許可するリスクが Web の大部分を破壊するリスクよりも重要である場合」、オプションでブロック可能なコンテンツとして適格です。これは、上記のパッシブ混合コンテンツカテゴリのサブセットです。

**オプションでブロック可能**でないすべてのコンテンツは**ブロック可能**と見なされ、ブラウザでブロックする必要があります。

{% Aside %}[混合コンテンツ仕様のレベル 2](https://w3c.github.io/webappsec-mixed-content/level2.html) が制作中であり、仕様への自動アップグレードが追加される予定です。 {% endAside %}

近年、[HTTPS の使用は劇的に増加](https://transparencyreport.google.com/https/overview)し、Web の明確なデフォルトになっています。このため、ブラウザは、[混合コンテンツ仕様](https://w3c.github.io/webappsec/specs/mixedcontent/)で**オプションでブロック可能**として定義されているサブリソースタイプであっても、すべての混合コンテンツをブロックすることを検討できるようになりました。これが、Chrome がこれらのサブリソースに対してより厳格なアプローチを取っている理由です。

### 古いブラウザ

Web サイトへのすべての訪問者が最新のブラウザを使用しているわけではないことを覚えておくことが重要です。ブラウザベンダーとバージョンごとに、混合コンテンツの処理方法は異なります。最悪の場合、古いブラウザやバージョンでは混合コンテンツがまったくブロックされないため、ユーザーにとって非常に危険です。

混合コンテンツの問題を修正すると、コンテンツが新しいブラウザに表示されるようになります。また、古いブラウザでブロックされていない危険なコンテンツからユーザーを保護するのにも役立ちます。
