---
layout: post
title: 優れたプログレッシブ Web アプリとは？
authors:
  - samrichard
  - petelepage
date: 2020-01-06
updated: 2022-07-18
description: 優れたまたは素晴らしいプログレッシブ Web アプリとは？
tags:
  - progressive-web-apps
---

<!-- Disable heading-increment because it mucks with the Details widget -->

<!--lint disable heading-increment-->

プログレッシ Web アプリ（PWA）は、最新の API で構築と拡張されており、単一のコードベースで、*場所やデバイスを問わず、誰にでも*到達しながら、拡張された機能、信頼性、およびインストール可能性を提供します。可能な限り最高のエクスペリエンスを作り出すために、[基本的](#core)かつ[最適な](#optimal)チェックリストと推奨事項をガイドとして使用してください。

## 基本的なプログレッシブ Web アプリのチェックリスト {: #core }

プログレッシブ Web アプリのチェックリストは、サイズや入力の種類に関係なく、すべてのユーザーがアプリをインストールして使用できるようにする理由について説明しています。

{% Details %} {% DetailsSummary 'h3' %}

高速に開始して速度を維持する

オンラインエクスペリエンスの成功には、パフォーマンスが大きく関わっています。パフォーマンスの高いサイトは、パフォーマンスの低いサイトよりもユーザーの関心を引き付け、維持するためです。サイトは、ユーザー中心のパフォーマンスメトリクスの最適化に重点を置く必要があります。

{% endDetailsSummary %}

オンラインエクスペリエンスの成功には、パフォーマンスが大きく関わっています。パフォーマンスの高いサイトは、パフォーマンスの低いサイトよりもユーザーの関心を引き付け、維持するためです。サイトは、ユーザー中心のパフォーマンスメトリクスの最適化に重点を置く必要があります。

#### 理由

ユーザーにアプリを*使用*させるには、速度が重要です。実際、ページの読み込み時間が 1 秒から 10 秒になると、ユーザーがバウンスする確率は 123％ 増加します。パフォーマンスは `load` イベントに限られたことではありません。ユーザーが、ボタンのクリックなどの操作が届いているかどうかを考えるようなことがあってはいけません。スクロールとアニメーションはスムーズに感じられなければなりません。パフォーマンスは、アプリケーションに対するユーザーの認識から実際の実行まで、エクスペリエンス全体に影響を及ぼします。

アプリケーションごとにニーズは異なりますが、Lighthouse のパフォーマンス監査は、[RAIL ユーザー中心のパフォーマンスモデル](/rail/)に基づいており、これらの監査で高いスコアを得られれば、ユーザーが楽しい体験を得る可能性が高くなります。また、[PageSpeed Insights](https://pagespeed.web.dev/) や [Chrome ユーザーエクスペリエンスレポート](https://developer.chrome.com/docs/crux/)を使用して、Web アプリの実際のパフォーマンスデータを取得することもできます。

#### 方法

PWA を高速で開始し、その速度を維持する方法については、[高速読み込み時間に関するガイド](/fast/)に従ってください。

{% endDetails %}

{% Details %} {% DetailsSummary 'h3' %}

どのブラウザでも動作する

ユーザーは、Web アプリをインストールする前に、ユーザーが好むブラウザを使用して Web アプリにアクセスできます。

{% endDetailsSummary%}

ユーザーは、Web アプリをインストールする前に、ユーザーが好むブラウザを使用して Web アプリにアクセスできます。

#### 理由

プログレッシブ Web アプリは元々 Web アプリです。つまり、1 つのブラウザだけでなく、さまざまなブラウザで動作する必要があります。

これを効果的に実現するには、『[Resilient Web Design](https://resilientwebdesign.com/)』の中で Jeremy Keith が述べた言葉を借りれば、コア機能を特定し、可能な限り単純なテクノロジーを使用してその機能を利用できるようにし、可能な場合はエクスペリエンスを強化することが方法として挙げられます。多くの場合、これは、まず HTML だけで始めてコア機能を作成し、より魅力的なエクスペリエンスを生み出すために、CSS と JavaScript を使用してユーザーエクスペリエンスを強化するということです。

フォームの送信を例にとってみましょう。これを実装する最も簡単な方法は、 `POST` リクエストを送信する HTML フォームです。それを構築した後で、フォームの検証と AJAX による送信を実現する JavaScript でエクスペリエンスを強化することができます。それをサポートできるユーザーのエクスペリエンスを向上させることができるのです。

ユーザーがさまざまなデバイスやブラウザでサイトを体験することを考慮してください。ただスペクトルの上限をターゲットにするわけにはいきません。機能の検出を行えば、現時点では存在していないブラウザやデバイスを使用するユーザーを含む、幅広い潜在的なユーザーに、使いものになるエクスペリエンスを提供できるでしょう。

#### 方法

Jeremy Keith の『[Resilient Web Design](https://resilientwebdesign.com/)』は、このクロスブラウザのプログレッシブ手法で Web デザインを考える方法を説明している優れたリソースです。

#### その他の読み物

- A List Apart の「[Understanding Progressive Enhancement](https://alistapart.com/article/understandingprogressiveenhancement/)」は、このトピックの導入に最適な記事です。
- Smashing Magazine の「[Progressive Enhancement: What It Is, And How To Use It?](https://www.smashingmagazine.com/2009/04/progressive-enhancement-what-it-is-and-how-to-use-it/)」には、実用的な紹介とより高度なトピックへのリンクが掲載されています。
- MDN の「[Implementing feature detection](https://developer.mozilla.org/docs/Learn/Tools_and_testing/Cross_browser_testing/Feature_detection)」というタイトルの記事では、機能を直接クエリして検出する方法について説明されています。

{% endDetails %}

{% Details %} {% DetailsSummary 'h3' %}

あらゆる画面サイズに対応

ユーザーは任意の画面サイズで PWA を使用でき、すべてのコンテンツは任意のビューポートサイズで利用できます。

{% endDetailsSummary %}

ユーザーは任意の画面サイズで PWA を使用でき、すべてのコンテンツは任意のビューポートサイズで利用できます。

#### 理由

デバイスにはさまざまなサイズがあり、ユーザーは同じデバイス上でもさまざまなサイズでアプリケーションを使用できます。したがって、コンテンツがビューポート内に収まるだけでなく、サイトのすべての機能とコンテンツがすべてのビューポートサイズで使用できるようにすることが重要です。

ユーザーが実行したいタスクとアクセスしたいコンテンツは、ビューポートのサイズによって変化しません。コンテンツはさまざまなビューポートサイズで再配置されるため、どのような形態であってもすべてがそこに収まります。実際、Luke Wroblewski が著書『Mobile First』で述べているように、大きい物から小さい物へではなく、小さい物から大きい物へ向かって取り組むことで、サイトのデザインを実際に改善できます。

> モバイルデバイスでは、ソフトウェア開発チームがアプリケーション内の最も重要なデータとアクションのみに専念することが必要です。320 x 480 ピクセルの画面には、無関係で不要な要素を配置する余地がないわけですから、どれを優先するのかを決定する必要があります。

#### 方法

レスポンシブデザインに関するリソースは、[Ethan Marcotte のオリジナルの記事](https://alistapart.com/article/responsive-web-design/)、それに関連する[重要な概念のコレクション](https://snugug.com/musings/principles-responsive-web-design/)、そして豊富な本や講演などたくさんあります。この議論をレスポンシブデザインのコンテンツの側面に絞り込むには、[コンテンツファーストデザイン](https://uxdesign.cc/why-you-should-design-the-content-first-for-better-experiences-374f4ba1fe3c)と[コンテンツアウトレスポンシブレイアウト](https://alistapart.com/article/content-out-layout/)を掘り下げていくことができます。最後に、モバイルに焦点を当てていますが、Josh Clark の「[Seven Deadly Mobile Myths](https://www.forbes.com/sites/anthonykosner/2012/05/03/seven-deadly-mobile-myths-josh-clark-debunks-the-desktop-paradigm-and-more/#21ecac977bca)」に含まれるレッスンは、モバイルと同様にレスポンシブサイトの小規模なビューにも関連しています。

{% endDetails %}

{% Details %} {% DetailsSummary 'h3' %}

カスタムオフラインページを提供

ユーザーがオフラインの場合、ユーザーを PWA に保持すると、デフォルトのブラウザのオフラインページに戻るよりもシームレスなエクスペリエンスを提供できます。

{% endDetailsSummary %}

ユーザーがオフラインの場合、ユーザーを PWA に保持すると、デフォルトのブラウザのオフラインページに戻るよりもシームレスなエクスペリエンスを提供できます。

#### 理由

ユーザーは、接続ステータスに関係なく、インストールされたアプリが機能することを期待しています。プラットフォーム固有のアプリがオフラインのときに空白のページを表示することはありません。また、プログレッシブ Web アプリがブラウザのデフォルトのオフラインページを表示することもありません。ユーザーがキャッシュされていない URL に移動したときと、接続が必要な機能を使用しようとしたときの両方でカスタムオフラインエクスペリエンスを提供することで、Web エクスペリエンスが実行中のデバイスの一部であるかのように感じることができます。

#### 方法

Service Worker の `install` イベント中に、後で使用するためのカスタムオフラインページを事前にキャッシュしておくことができます。ユーザーがオフラインになった場合は、事前にキャッシュされたカスタムオフラインページで応答できます。カスタム[オフラインページのサンプル](https://googlechrome.github.io/samples/service-worker/custom-offline-page/)に従うと、この例の動作を確認し、自分で実装する方法を学ぶことができます。

{% endDetails %}

{% Details %} {% DetailsSummary 'h3' %}

インストール可能である

デバイスにアプリをインストールまたは追加するユーザーは、それらのアプリをより多く利用する傾向があります。

{% endDetailsSummary %}

デバイスにアプリをインストールまたは追加するユーザーは、それらのアプリをより多く利用する傾向があります。

#### 理由

プログレッシブ Web アプリをインストールすると、他のインストール済みのアプリと同じような外観、操作感、動作が得られ、他のアプリと同じ場所から起動します。ブラウザとは別の独自のアプリウィンドウで実行し、他のアプリと同じようにタスクリストに表示されます。

なぜユーザーに PWA をインストールしてもらいたいのでしょうか？ユーザーにアプリストアからアプリをインストールしてもらいたいのと同じ理由です。アプリをインストールするユーザーはエンゲージ度の最も高いオーディエンスです。通常の訪問者よりもエンゲージメントメトリクスが優れており、多くの場合、モバイルデバイスのアプリユーザーと同等です。これらのメトリクスには、より多くのリピート訪問、より長いサイト滞在時間、より高いコンバージョン率が含まれます。

#### 方法

[インストール可能なガイド](/customize-install/)に従って、PWAをインストール可能にする方法とインストール可能であることをテストする方法を学び、自分で試してみることができます。

{% endDetails %}

## 最適なプログレッシブ Web アプリのチェックリスト {: #optimal }

クラス最高のアプリのように感じられる、真に優れたプログレッシブ Web アプリを作成するには、基本チェックリスト以上のものが必要です。プログレッシブ Web アプリの最適なチェックリストは、Web を強力にするものを活用しながら、PWA を実行中のデバイスの一部であるかのように感じさせることに関連しています。

{% Details %} {% DetailsSummary 'h3' %}

オフラインエクスペリエンスを提供する

接続が厳密に必要とされない場合、アプリはオフラインでもオンラインと同じように動作します。

{% endDetailsSummary %}

接続が厳密に必要とされない場合、アプリはオフラインでもオンラインと同じように動作します。

#### 理由

カスタムオフラインページを提供することに加えて、ユーザーはプログレッシブ Web アプリがオフラインで使用できることを期待しています。たとえば、旅行アプリや航空会社のアプリでは、オフライン時に旅程と搭乗券に簡単にアクセスできる必要があります。音楽、ビデオ、ポッドキャストアプリでは、オフラインで再生できる必要があります。ソーシャルアプリやニュースアプリは、オフラインでも閲覧できるように、最近のコンテンツをキャッシュする必要があります。また、ユーザーはオフライン時に認証状態が維持されることを期待しているため、オフライン認証の設計が求められます。オフライン PWA は、ユーザーに真のアプリのようなエクスペリエンスを提供します。

#### 方法

ユーザーがオフラインで作業できることを期待している機能を決定したら、コンテンツを利用可能にしてオフラインのコンテキストに適応できるようにする必要があります。さらに、ブラウザ内の NoSQL ストレージシステムである [IndexedDB](https://developers.google.com/web/ilt/pwa/working-with-indexeddb) を使用してデータを保存および取得し、[バックグラウンド同期](https://developer.chrome.com/blog/background-sync/)を使用して、ユーザーがオフライン中にアクションを実行し、ユーザーが再び安定した接続を確立するまでサーバー通信を延期できるようにすることができます。また、Service Worker を使用して、オフラインで使用する画像、動画ファイル、音声ファイルなどの他の種類のコンテンツを保存したり、それらを使用して[安全で長期間有効なセッション](https://developer.chrome.com/blog/2-cookie-handoff/)を実装し、ユーザーの認証を維持したりすることもできます。ユーザーエクスペリエンスの観点から、読み込み中に速度とコンテンツをユーザーに認識させる[スケルトン画面](https://uxdesign.cc/what-you-should-know-about-skeleton-screens-a820c45a571a)を使用して、必要に応じてキャッシュされたコンテンツまたはオフラインインジケーターにフォールバックできます。

{% endDetails %}

{% Details %} {% DetailsSummary 'h3' %}

完全にアクセス可能である

すべてのユーザー操作は、[WCAG 2.0](https://www.w3.org/TR/WCAG20/) アクセシビリティ要件に合格しています。

{% endDetailsSummary %}

すべてのユーザー操作は、[WCAG 2.0](https://www.w3.org/TR/WCAG20/) アクセシビリティ要件に合格しています。

#### 理由

ほとんどの人は、人生のある時点で、[WCA G2.0](https://www.w3.org/TR/WCAG20/) アクセシビリティ要件でカバーされている方法で PWA を利用したいと思うことがあるでしょう。PWA を操作し、理解する人間の能力はスペクトル上に存在し、ニーズは一時的でも永続的でもある可能性があります。PWA をアクセシブルにすることで、誰もが使用できることを保証できます。

#### 方法

W3C の『[Introduction to Web Accessibility](https://www.w3.org/WAI/fundamentals/accessibility-intro/)』は最適な出発点です。アクセシビリティテストの大部分は手動で行う必要があります。Lighthouse の[アクセシビリティ](https://github.com/dequelabs/axe-core)監査、[axe](https://accessibilityinsights.io/)、[Accessibility Insights](https://developer.chrome.com/docs/lighthouse/accessibility/) などのツールは、アクセシビリティテストを自動化するのに役立ちます。また、`a` や `button` 要素のように、意味的に正しい要素を独自に再作成せずに使用することも重要です。そうすることで、より高度な機能を構築する必要がある場合に、アクセシビリティへの期待を確実に満たすことができます（矢印とタブのどちらをいつ使用するかなど）。[A11Y Nutrition Cards](https://accessibilityinsights.io/) には、いくつかの一般的なコンポーネントについて、これに関する優れたアドバイスをていきょうしています。

{% endDetails %}

{% Details %} {% DetailsSummary 'h3' %}

検索で検出可能

PWA は、簡単に[検索で検出](/discoverable/)可能です。

{% endDetailsSummary %}

PWA は、簡単に[検索で検出](/discoverable/)可能です。

#### 理由

Web の最大の利点の1つは、検索を通じてサイトやアプリを発見できることです。実際、すべての Web サイトトラフィックの [半分以上](https://www.brightedge.com/resources/research-reports/channel_share)はオーガニック検索によるものです。コンテンツの正規 URL が存在し、検索エンジンがサイトをインデックス化できることを確認することは、ユーザーが PWA を見つけられるようにする上で重要なことです。これは、特にクライアント側レンダリングを採用する場合に当てはまります。

#### 方法

まず、各 URL に一意の説明的なタイトルとメタ説明があることを確認します。次に、Lighthouse の [Google 検索コンソール](https://search.google.com/search-console/about)と[検索エンジン最適化監査](https://developer.chrome.com/docs/lighthouse/seo/)を使用して、PWA の検出可能性の問題をデバッグして修正することができます。[Bing](https://www.bing.com/toolbox/webmaster) や [Yandex](https://webmaster.yandex.com/welcome/) の Web マスターツールを使用して、[Schema.org](https://goo.gle/search-gallery) のスキーマを介して[構造化データ](https://schema.org/)をPWAに含めることを検討することもできます。

{% endDetails %}

{% Details %} {% DetailsSummary 'h3' %}

任意の入力タイプを使用できる

PWA は、マウス、キーボード、スタイラス、またはタッチでも同様に使用できます。

{% endDetailsSummary %}

PWA は、マウス、キーボード、スタイラス、またはタッチでも同様に使用できます。

#### 理由

デバイスにはさまざまな入力方法が用意されており、ユーザーはアプリケーションを使用中に入力方法をシームレスに切り替えることができなければなりません。同様に重要なこととして、入力方法は画面サイズに依存しないようにする必要があります。つまり、大きなビューポートはタッチをサポートする必要があり、小さなビューポートはキーボードとマウスをサポートする必要があります。最大限の能力を発揮して、アプリケーションとそのすべての機能が、ユーザーが選択できる入力方法をサポートしていることを確認してください。必要に応じて、エクスペリエンスを強化して、入力固有のコントロール（プルして再読み込みなど）も可能にする必要があります。

#### 方法

[Pointer Events API](https://developer.chrome.com/blog/pointer-events/) は、さまざまな入力オプションを操作するための統一されたインターフェイスを提供し、スタイラスサポートを追加するのに特に適しています。タッチとキーボードの両方をサポートするには、正しいセマンティック要素（アンカー、ボタン、フォームコントロールなど）を使用し、非セマンティック HTML（アクセシビリティに適している）でこれらを再構築しないようにしてください。ホバー時にアクティブになる操作を含める場合は、クリックまたはタップでもアクティブにできることを確認してください。

{% endDetails %}

{% Details %} {% DetailsSummary 'h3' %}

許可要求のコンテキストを提供する

強力な API を使用するための許可を求めるときは、コンテキストを提供し、API が必要な場合にのみ求めます。

{% endDetailsSummary %}

強力な API を使用するための許可を求めるときは、コンテキストを提供し、API が必要な場合にのみ求めます。

#### 理由

通知、ジオロケーション、資格情報などの権限プロンプトをトリガーする API は、オプトインを必要とする強力な機能に関連する傾向があるため、ユーザーを混乱させるように意図的に設計されています。ページ読み込み時など、追加のコンテキストなしでこれらのプロンプトをトリガーすると、ユーザーはこれらのアクセス許可に同意する可能性が低くなり、将来的にそれらを信用しなくなる可能性が高くなります。代わりに、そのアクセス許可が必要な理由について、コンテキスト内の理由をユーザーに提供した後でのみ、これらのプロンプトをトリガーするようにします。

#### 方法

[Permission UX](https://developers.google.com/web/fundamentals/push-notifications/permission-ux) の記事と UX Planet の「[The Right Ways to Ask Users for Permissions](https://uxplanet.org/mobile-ux-design-the-right-ways-to-ask-users-for-permissions-6cdd9ab25c27)」は、モバイルに焦点を当てながらもすべての PWA に適用される許可プロンプトを設計する方法を理解できる優れたリソースです。

{% endDetails %}

{% Details %} {% DetailsSummary 'h3' %}

健全なコードのベストプラクティスに従う

コードベースを健全に維持することで、目標の達成と新機能の提供が容易になります。

{% endDetailsSummary %}

コードベースを健全に維持することで、目標の達成と新機能の提供が容易になります。

#### 理由

最新の Web アプリケーションの構築には多くのことが関わっています。アプリケーションを最新の状態に保ち、コードベースを正常に保つことで、このチェックリストに記載されている他の目標を満たす新機能を簡単に提供できるようになります。

#### 方法

健全なコードベースを確保するための優先度の高いチェックはたくさんあります。既知の脆弱性を持つライブラリの使用を回避する、非推奨の API を使用していないことを確認する、コードベースから Web アンチパターンを除去する（ `document.write()` の使用や非パッシブスクロールイベントリスナーの使用など）、さらには、分析やその他のサードパーティライブラリが読み込みに失敗した場合に PWA がエラーにならないように防御的にコーディングするなどが挙げられます。複数のブラウザとリリースチャンネルで、リンティングなどの静的コード分析と自動テストを要求することを検討してください。これらの手法は、本番環境に移行する前にエラーを検出するのに役立ちます。

{% endDetails %}
