---
layout: post
title: プログレッシブWebアプリでビジネスの成功を推進する
authors:
  - sfourault
date: 2020-05-20
updated: 2020-05-20
description: PWAの信頼できるビジネスケースを構築します。投資するタイミングと、投資の成功を測定する方法について説明します。
tags:
  - progressive-web-apps
---

プログレッシブWebアプリは、Webサイトを最新化し、ユーザーの新しい期待に適応するために、多くの企業のロードマップに取り入れられています。そして、すべての新しい概念や技術的能力と同様に、顧客が望んでいるものなのか、ビジネスをどれだけ成長させるのか、技術的に実現可能かという疑問も生じます。

{% Img src="image/admin/o70RxMcAQVPrjxH34a8r.jpg", alt="ステークホルダーを特定する", width="800", height="254" %}

デジタル戦略を形作るために、多くのステークホルダーが関与します。プロダクトマネージャーとCMOは各機能のビジネスへの影響を共同で所有し、CTOは技術の実現可能性と信頼性を評価します。また、UX研究者は機能が実際の顧客の問題に対応できることを検証します。

この記事の目的は、このような3つの疑問に答え、PWAプロジェクトを形成できるように支援することです。顧客のニーズから始めて、これをPWA機能に変換し、各機能がもたらすビジネスへの影響の測定について重点的に扱います。

## PWAは顧客のニーズを解決する {: #solve-customer-needs }

Googleで製品を開発するときには、「[ユーザーに焦点を合わせれば、あとはうまくいく](https://www.google.com/about/philosophy.html)」というルールに従っています。*ユーザーファーストを*考えてください。顧客のニーズは何か、PWAでどのようにそれらを提供するのかを考えれば良いのです。

{% Img src="image/admin/TcmXmWb5mSUqal98NIAH.jpg", alt="顧客のニーズを特定する", width="800", height="262" %}

ユーザーを研究すると、次のような興味深いパターンがいくつか見つかります。

- ユーザーはモバイルでの遅延や信頼性の欠如を嫌います。モバイルの遅延によって引き起こされるストレスのレベルは、[ホラー映画を見るのに匹敵](https://blog.hubspot.com/marketing/mobile-website-load-faster)します。
- スマートフォンユーザーの50%は、[アプリをダウンロードしたくない](https://www.thinkwithgoogle.com/data/smartphone-user-mobile-shopping-preferences/)ため、閲覧や買い物の際に会社のモバイルサイトを使用する可能性が高くなっています。
- アプリをアンインストールする主な理由の1つは、[ストレージが限られている](https://www.thinkwithgoogle.com/data/why-users-uninstall-travel-apps/)ことです (通常、インストールされたPWAはたったの1MB未満しか占有しません)。
- スマートフォンユーザーは、製品に[関連する推奨事項](https://www.thinkwithgoogle.com/data/smartphone-mobile-app-and-site-purchase-data/)を提供するモバイルサイトから購入する可能性が高く、スマートフォンユーザーの85%は[モバイル通知が役立つ](https://www.thinkwithgoogle.com/data/smartphone-user-notification-preferences/)と述べています。

このような観察から、顧客は、高速で、インストール可能で、信頼性が高く、魅力的な (F.I.R.E.) エクスペリエンスを好むことがわかりました。

## PWAは最新のWeb機能を活用する {: #modern-capabilities }

PWAは、高速でインストール可能、信頼性が高く、魅力的なサイトにすることで、顧客のニーズを満たすことを目的とした一連のベストプラクティスと最新のWeb APIを提供します。

たとえば、サービスワーカーを使用して[リソースをキャッシュに保存](/service-workers-cache-storage/)し、[予測プリフェッチ](/precache-with-workbox/)を実行すると、サイトの速度と信頼性が向上します。サイトをインストール可能にすると、顧客がホーム画面またはアプリランチャーから直接サイトにアクセスできるようになります。また、[Webプッシュ通知](https://developer.mozilla.org/docs/Web/API/Push_API/Best_Practices)などの新しいAPIを使用すると、パーソナライズされたコンテンツを使用してユーザーを簡単にもう一度引き寄せ、ロイヤルティを生み出すことができます。

{% Img src="image/admin/rP0eNCflNYOhzjPi1Lq5.jpg", alt="新しい機能によるユーザーエクスペリエンスの向上", width="800", height="393" %}

## ビジネスへの影響を理解する{: #business-impact }

ビジネスの成功の定義は、活動内容によっては多岐にわたることがあります。

- サービスに長い時間を費やしているユーザー
- リードの直帰率の低下
- コンバージョン率の向上
- リピーターを増やす

ほとんどのPWAプロジェクトでは、モバイルコンバージョン率が高くなり、多数の[PWAケーススタディ](https://www.pwastats.com/)から詳細を学ぶことができます。目的によっては、ビジネスにとってより意味のあるPWAのいくつかの側面に優先順位を付けたい場合がありますが、それはまったく問題ありません。 PWAの機能は、個別に選択して起動できます。

では、これらの優れた各F.I.R.E機能のビジネスへの影響を測定します。

### 高速Webサイトのビジネスへの影響{: #impact-fast }

[Deloitte Digitalの最近の調査](https://www2.deloitte.com/ie/en/pages/consulting/articles/milliseconds-make-millions.html)によると、ページ速度はビジネスメトリクスに大きな影響を及ぼします。

さまざまな方法で、サイトの速度を最適化して、すべてのユーザーの重要なユーザージャーニーを最適化することができます。どこから始めればよいかわからない場合は、[Fast](/fast/)セクションを参照して、[Lighthouse](https://developer.chrome.com/docs/lighthouse/overview/)を使用し、最も重要な項目の修正を優先してください。

速度の最適化に取り組むときは、適切なツールとメトリックを使用してサイトの速度を頻繁に測定し、進捗状況を監視します。たとえば、[Lighthouse](https://developer.chrome.com/docs/lighthouse/overview/)を使用してメトリックを測定し、[「良好な」Core Web Vitals](/vitals/#core-web-vitals)といった明確な目標を修正し、[ビルドプロセスにパフォーマンスバジェット](/incorporate-performance-budgets-into-your-build-tools/)を組み込みます。毎日の測定と[「速度の価値」の方法論](/value-of-speed/)のおかげで、速度の増分的な変化の影響を分離し、作業によって生み出された収益の増加分を計算できます。

{% Img src="image/admin/yyRfQaDL3NcGhB0f79RN.jpg", alt="速度の値を測定し、それをコンバージョンと相関させます", width="800", height="306" %}

Ebayは、[速度を2019年の会社の目標](/shopping-for-speed-on-ebay/)にし、パフォーマンスバジェット、クリティカルパスの最適化、予測プリフェッチなどの手法を使用しました。また、検索ページの読み込み時間が100ミリ秒改善するごとに、カードへの追加数が0.5％増加すると結論付けました。

{% Img src="image/admin/Qq3wo5UOqzC1ugnTzdqT.jpg", alt="読み込み時間が100ミリ秒改善された結果、eBayのカート数が0.5%増加しました", width="800", height="184" %}

### インストール可能なWebサイトのビジネスへの影響{: #impact-installable }

なぜユーザーにPWAをインストールしてもらいたいのでしょうか。それは、簡単にサイトにアクセスできるようにするためです。Androidアプリのインストールで、少なくとも3つのステップ (Play Storeへのリダイレクト、ダウンロード、ファネル最上位でのAndroidアプリの再起動) が追加される場合、PWAのインストールはワンクリックでシームレスに実行され、ユーザーが現在のコンバージョンファネルから離れることはありません。

{% Img src="image/admin/u1jcKrBBOHEzSz3SqhEB.jpg", alt="インストールエクスペリエンスはシームレスであること", width="800", height="239" %}

インストールすると、ユーザーはホーム画面のアイコンからワンクリックで起動したり、アプリを切り替えるときにアプリトレイに表示したり、アプリの検索結果から見つけたりすることができます。このアプリは動的Discover-Launch-Switchと呼ばれ、自由にアクセスできるようにするには、PWAをインストール可能にすることが非常に重要です。

PWAは、デバイスの使い慣れた検出および起動画面からアクセスできるほか、プラットフォーム固有のアプリとまったく同じように起動します。スタンドアロンエクスペリエンスでは、ブラウザーとは別になります。さらに、アプリスイッチャーや設定などのOSレベルのデバイスサービスも利用できます。

PWAをインストールするユーザーは、最もエンゲージメントの高いユーザーである可能性が高く、リピート訪問の増加、長いサイト滞在時間、高いコンバージョン率など、一時的なアクセスユーザーよりもエンゲージメントのメトリックが高く、多くの場合、モバイルデバイスのプラットフォーム固有のアプリユーザーと同等と言えます。

PWAをインストール可能にするには、[基本条件](/install-criteria/)を満たす必要があります。これらの条件を満たすと、iOSを含むデスクトップとモバイルのユーザーエクスペリエンス内で[インストールをプロモーション](/promote-install/)できます。

{% Img src="image/admin/5sH5YX7kFrwv4f6duqVf.jpg", alt="PWAはどこにでもインストール可能", width="800", height="227" %}

PWAのインストールのプロモーションを開始したら、PWAをインストールしているユーザーの数と、ユーザーがどのようにPWAを使用しているのかを測定する必要があります。

サイトをインストールするユーザーの数を最大化するには、さまざまなプロモーションメッセージ (「1秒でインストール」、「ショートカットを追加して注文状況を追跡」など)、さまざまなプレイスメント (ヘッダーバナー、インフィード) を[テスト](https://pwa-book.awwwards.com/chapter-4)できます。ファネルのさまざまな段階 (2 番目にアクセスしたページ、予約後) でサイトを提案してみてください。

ユーザーがサイトを離れる場所とリテンションを改善する方法を理解するために、次の4つの方法でインストールファネルを[測定](https://pwa-book.awwwards.com/chapter-8)できます。

- インストール可能なユーザーの数
- UIインストールプロンプトをクリックしたユーザーの数
- インストールを承認および拒否したユーザーの数
- インストールに成功したユーザーの数

PWAインストールをすべてのユーザーにプロモーションしたり、少数のユーザーグループに限定して実験する慎重なアプローチを使用したりできます。

数日後または数週間後には、ビジネスへの影響を測定するためのデータが得られているはずです。インストールされたショートカットからアクセスするユーザーはどのような行動を取っているのでしょうか。エンゲージメントやコンバージョン率は高くなっているのでしょうか。

PWAをインストールしたユーザーをセグメント化するには、[`appinstalled`イベントを](/customize-install/#detect-install)追跡し、JavaScriptを使用して、[ユーザーがスタンドアロンモード (インストールされたPWAの使用状況を示す) であるかどうかを確認](/customize-install/#detect-launch-type)します。そして、これらの情報を分析追跡の変数またはディメンションとして使用します。

{% Img src="image/admin/H2U4jKTmATNzVJQ3WNCO.jpg", alt="インストールの値を測定", width="800", height="253" %}

[Weekendeskのケーススタディ](https://www.thinkwithgoogle.com/_qs/documents/8971/Weekendesk_PWA_-_EXTERNAL_CASE_STUDY.pdf)は興味深いものです。インストール率を最大化するために2番目にアクセスしたしたページでインストールを提案したところ、ホーム画面のアイコンをクリックして戻ってきた顧客が宿泊を予約する確率は2倍以上になることが観察されました。

{% Img src="image/admin/eR23C2o1adHq5tATNw34.jpg", alt="インストールしたユーザーのコンバージョン率は2.5倍高い", width="800", height="201" %}

インストールは、ユーザーをサイトに引き戻し、顧客ロイヤルティを向上させるための優れた方法です。これらのプレミアムユーザー向けにエクスペリエンスをパーソナライズすることも考えられます。

プラットフォーム固有のアプリがすでに導入されている場合でも、最初にアプリを提案してから、アプリのインストールバナーを拒否したり無視したりしたユーザーに対してPWAをプッシュするようにテストすることができます。 「セミエンゲージ」しているユーザーの中には、アプリストアベースのインストールのしきい値を満たしていない場合があります。このようなユーザーは、より軽量で摩擦が少ないと一般的に認識されているPWAのインストール可能性で対処できます。

{% Img src="image/admin/iNQalNPhjdBueuqPHiad.jpg", alt="PWAはセミエンゲージメントのユーザーにリーチできる", width="800", height="229" %}

### 信頼できるWebサイトのビジネスへの影響{: #impact-reliable }

ユーザーがオフラインのときに提供されるChrome Dinoゲームは、月に[2億7000万回](https://www.blog.google/products/chrome/chrome-dino/)以上プレイされます。この驚異的な数字は、特に、インド、ブラジル、メキシコ、インドネシアなどのモバイルデータの信頼性が低いか、モバイルデータが高額である市場では、ネットワークの信頼性が大きなチャンスであることを示しています。

アプリストアからインストールされたアプリを起動すると、ユーザーはインターネットに接続しているかどうかに関係なく、アプリが開くことを期待します。プログレッシブWebアプリも例外ではありません。

少なくとも、ネットワーク接続がないとアプリを利用できないことをユーザーに伝える簡単なオフラインページを用意する必要があります。次に、[オフラインで意味のある機能](https://pwa-book.awwwards.com/chapter-6)を提供することで、エクスペリエンスをさらに一歩進めることを検討してください。たとえば、チケットや搭乗券、オフラインのウィッシュリスト、コールセンターの連絡先情報、ユーザーが最近表示した記事やレシピなどへのアクセスを提供できます。

{% Img src="image/admin/ubglZLCoddAfB5cl8JSz.jpg", alt="オフラインのときでも役立つ", width="800", height="243" %}

[信頼できるユーザーエクスペリエンスを](https://pwa-book.awwwards.com/chapter-6)実装したら、それを測定できます。ネットワークがオフラインになり、再びネットワークに接続したときに、Webサイトに留まっているユーザーはどの地域で何人いるでしょうか。

オフラインの使用量は、ユーザーが[オフラインまたはオンライン](https://pwa-book.awwwards.com/chapter-8)になったときに分析pingを記録することで測定できます。ネットワークに接続した後、何人のユーザーがWebサイトを閲覧し続けているかが示されます。

{% Img src="image/admin/UfjYsWQWJjVIk2sp5bnE.jpg", alt="Trivagoでは、再びオンラインになったときにユーザーの67%が閲覧を続けている", width="800", height="272" %}

[Trivagoのケーススタディ](https://www.thinkwithgoogle.com/intl/en-154/insights-inspiration/case-studies/trivago-embrace-progressive-web-apps-as-the-future-of-mobile/)は、これがビジネス目標にどのように影響するかを示しています。オフライン期間によってセッションが中断されたユーザー (ユーザーの約3%) の場合、オンラインに戻ったときに、ユーザーの67%が引き続きサイトを閲覧しています。

### ユーザーを惹き付けるWebサイトのビジネスへの影響{: #impact-engaging }

Webプッシュ通知を使用すると、ユーザーはお気に入りのサイトからのタイムリーな更新をオプトインでき、カスタマイズされた関連コンテンツを効果的に再利用できます。

ただし、これには注意が必要です。ユーザーが最初にアクセスしたときに、利点を提示せずにWeb通知に登録するようにユーザーに求めると、迷惑広告と見なされ、エクスペリエンスに悪影響を与える可能性があります。通知を許可するように求めるときには[ベストプラクティス](https://developers.google.com/web/fundamentals/push-notifications/permission-ux)に従い、列車の遅延、価格の追跡、在庫切れの製品などの関連する使用方法を示すことで、通知を許可したくなる理由を提示します。

技術的には、サービスワーカーのおかげで、Web上の[プッシュ通知](https://developers.google.com/web/fundamentals/push-notifications/)はバックグラウンドで実行され、キャンペーンを管理するために構築されたシステム (Firebaseなど) によって送信されることがよくあります。この機能は、モバイル (Android) およびデスクトップユーザーに大きなビジネス価値をもたらします。これにより、繰り返しのアクセスが増加し、その結果、売上とコンバージョンが増加します。

プッシュキャンペーンの効果を測定するには、ファネル全体を測定する必要があります。

- プッシュ通知の対象となるユーザーの数
- カスタム通知UIプロンプトをクリックしたユーザーの数
- プッシュ通知許可を付与するユーザーの数
- プッシュ通知を受信するユーザーの数
- 通知を利用するユーザーの数
- 通知から来るユーザーのコンバージョンとエンゲージメント

{% Img src="image/admin/UpzfxBDi3e66cZ9gzkkS.jpg", alt="Webプッシュ通知の値を測定", width="800", height="255" %}

破棄されたカートでユーザーを再エンゲージすることで[コンバージョン率を4.5倍にしたCarrefour](https://useinsider.com/case-studies/carrefour/)のように、Webプッシュ通知に関する優れたケーススタディはたくさんあります。

## PWAのP: 機能ごとにプログレッシブに起動{: #feature-by-feature }

PWAは、Webの広範囲なリーチの利点を活用する最新のWebサイトであり、Android/iOS /デスクトップアプリでユーザーが好む使いやすい機能がすべて取り入れられています。これらは、ビジネスの特殊性と優先順位に応じて独立して実装できる一連のベストプラクティスと最新のWeb APIを活用しています。

{% Img src="image/admin/7g1j2z7h5m9QSHQhHceM.jpg", alt="PWAを段階的に起動", width="800", height="253" %}

Webサイトの最新化を加速し、それを真のPWAにするために、アジャイルであること、つまり機能ごとに起動することをお勧めします。まず、ユーザーと一緒にどの機能が最も価値をもたらすかを調査してから、設計者や開発者に提供します。最後に、PWAが生み出した金銭的利益を正確に測定することを忘れないでください。
