---
layout: post
title: ユーザーを中心としたパフォーマンス指標
authors:
  - philipwalton
date: 2019-11-08
description: ユーザーを中心としたパフォーマンス指標は、実際のユーザーにとって有益となる方法でサイトのエクスペリエンスを理解し、改善するための重要なツールです。
tags:
  - performance
  - metrics
---

パフォーマンスがいかに重要であるかは、既によく知られています。しかしながら、パフォーマンスや Web サイトの "高速" 化とは、具体的にどのようなことを指しているのでしょうか。

実際には、パフォーマンスとは相対的なものです。

- あるユーザー (高速なネットワーク上で高性能なデバイスを使用しているユーザー) にとってそのサイトは高速かもしれませんが、別のユーザー (低速なネットワーク上で性能の低いデバイスを使用しているユーザー) にとっては低速となる可能性があります。
- 2 つのサイトがまったく同じ時間で読み込みを完了しているにもかかわらず、一方のサイトの方が速く読み込みが完了しているように*見える*場合があります (コンテンツの読み込みを最後まで待たずに、徐々に読み込みながら表示をしている場合)。
- サイトの読み込みが早いように*見えても*、ユーザーの操作に対する応答が遅い (あるいは全く応答しない) 場合があります。

そのため、パフォーマンスについて語る場合には、正確で、定量的に測定が可能な客観的な基準に基づいて言及することが重要となります。この基準は、*指標*と呼ばれています。

しかしながら、客観的な基準に基づいていて定量的に測定が可能だからといって、その指標が有用であるとは限りません。

## 指標の定義

歴史的に、Web のパフォーマンスは <code>[load](https://developer.mozilla.org/docs/Web/API/Window/load_event)</code> イベントを使用して測定されてきました。しかしながら、<code>load</code> がページのライフサイクルにおいて明確に定義された瞬間であったとしても、その瞬間が必ずしもユーザーの関心に一致するわけではありません。

たとえばサーバーは、最小限のページで応答することもできます。このページはすぐに "読み込まれ" ますが、`load` イベントが発生してから数秒の間、コンテンツのフェッチやページ上でのコンテンツ表示を延期してしまいます。このようなページは、技術的には読み込み時間が速くなるかもしれませんが、その時間はページの読み込み時にユーザーが実際に体験する時間とは一致しません。

過去数年に渡り、Chrome チームのメンバーは [W3C Web Performance ワーキング グループ](https://www.w3.org/webperf/)と協力しながら、ユーザーが Web ページのパフォーマンスをどのように体験するかについてより正確な測定を行うための一連の新しい API および指標の標準化に取り組んできました。

指標がユーザーにとって適切であることを保証するために、以下のような重要な質問に当てはめることで評価を行っています。

<table id="questions">
  <tr>
    <td><strong>動作していますか？</strong></td>
    <td>ナビゲーションは正常に起動しましたか？サーバーからの応答はありましたか？</td>
  </tr>
  <tr>
    <td><strong>役に立っていますか？</strong></td>
    <td>ユーザーが利用できるだけのコンテンツがレンダリングされていますか？</td>
  </tr>
  <tr>
    <td><strong>使用が可能ですか？</strong></td>
    <td>ユーザーがページを操作できていますか？ビジー状態になっていませんか？</td>
  </tr>
  <tr>
    <td><strong>快適ですか？</strong></td>
    <td>遅延やエラーがなく、スムーズで自然な操作ができていますか？</td>
  </tr>
</table>

## 指標の測定方法

パフォーマンス指標は、一般的に次の 2 つの方法のいずれかによって測定されます。

- **ラボ環境での測定:** 一貫性のある管理された環境で、ページの読み込みをシミュレートするためのツールを使用します。
- **実際のユーザー環境での測定:** 実際にページを読み込み、操作しているユーザーについて測定します。

どちらかのオプションが、他方のオプションより優れているわけでも、劣っているわけでもありません。実際には、両方のオプションを併用しながらパフォーマンスを向上させていきます。

### ラボ環境での測定

新機能を開発する際には、ラボ環境でのパフォーマンスのテストが欠かせません。本番環境で機能がリリースされる前に、実際のユーザー環境でその機能のパフォーマンス特性を測定することは不可能です。そのため、機能がリリースされる前にラボ環境で機能をテストしておくことが、パフォーマンスの悪化を防ぐためには最善の方法となります。

### 実際のユーザー環境での測定

一方で、ラボ環境でのテストはパフォーマンス測定において妥当な代替策となるものの、それがすべてのユーザーによる実際のユーザー環境でのサイトの利用方法を反映しているとは限りません。

サイトのパフォーマンスは、ユーザーが使用するデバイスの性能やネットワークの状態に大きく左右されます。また、ユーザーがページを操作しているかどうか (またはその操作方法) によっても変わってきます。

さらには、ページの読み込みは決定論的なものではない可能性があります。たとえば、カスタマイズされたコンテンツや広告を読み込むサイトでは、ユーザーごとにパフォーマンス特性が大きく異なってくる可能性があります。ラボ環境でのテストでは、そういった違いを捕捉することはできません。

サイト パフォーマンスをユーザー目線で真に理解するための唯一の方法は、ユーザーがサイトを読み込み、操作を行っている環境でパフォーマンスを測定することです。このタイプの測定方法は、一般的にリアル ユーザー モニタリング (または RUM) と呼ばれています。

## 指標の種類

ユーザーがパフォーマンスをどのように認識しているかに関する指標は、他にもいくつかあります。

- **知覚される読み込み速度:** ページがすべての視覚要素を読み込み、画面にレンダリングする速度。
- **読み込みの応答性:** コンポーネントがユーザーの操作に対してすばやく応答するために、ページが必要な JavaScript コードを読み込んで実行する速度。
- **実行時の応答性:** ページの読み込みが完了した後、ページがユーザーの操作にどの程度すばやく応答できるかを示す指標。
- **視覚的な安定性:** ユーザーが予期しないような手法でページ上の要素が移動し、ユーザーの操作に支障をきたす可能性があるかどうかを示す指標。
- **滑らかさ:** トランジションやアニメーションが一定のフレーム レートでレンダリングされ、ある状態から別の状態へと流れるように移動しているかどうかを示す指標。

上記すべてのパフォーマンス指標を考慮に入れる場合、ページのパフォーマンス特性をすべて把握するには単一の指標では不十分であることがお分かりいただけるかと思います。

## 測定すべき重要な指標

- **[First Contentful Paint (視覚コンテンツの初期表示時間、FCP)](/fcp/):** この指標は、ページの読み込みが開始されてから、ページのコンテンツのいずれかの部分が画面にレンダリングされるまでの時間を測定します。*([ラボ環境](#in-the-lab), [実際のユーザー環境](#in-the-field))*
- **[Largest Contentful Paint (最大視覚コンテンツの表示時間、LCP)](/lcp/):** この指標は、ページの読み込みが開始されてから、最もサイズの大きいテキスト ブロックまたは画像要素が画面にレンダリングされるまでの時間を測定します。*([ラボ環境](#in-the-lab), [実際のユーザー環境](#in-the-field))*
- **[First Input Delay (初回入力までの遅延時間、FID)](/fid/):** この指標は、ユーザーが最初にサイトを操作したとき (リンクをクリックしたり、ボタンをタップしたり、JavaScript を使用して実装されたカスタム コントロールを使用したりしたとき) から、その操作に実際に応答するまでの時間を測定します。*([実際のユーザー環境](#in-the-field))*
- **[Time to Interactive (操作可能になるまでの時間、TTI)](/tti/):** この指標は、ページの読み込みが開始されてから視覚的なレンダリングが完了し、初期スクリプトが (あれば) 読み込まれ、ユーザーの入力に対してすばやく確実に応答できるようになるまでの時間を測定します。*([ラボ環境](#in-the-lab))*
- **[Total Blocking Time (合計ブロック時間、TBT)](/tbt/):** この指標は、長時間に渡りメイン スレッドがブロックされ、入力の応答性が妨げられることで発生する FCP と TTI の間の時間の合計を測定します。*([ラボ環境](#in-the-lab))*
- **[Cumulative Layout Shift (累積レイアウト シフト数、CLS)](/cls/):** この指標は、ページの読み込みが開始されてからページの[ライフサイクルの状態](https://developer.chrome.com/blog/page-lifecycle-api/)が hidden に変わるまでの間に発生した予期しないレイアウト シフトの累積スコアを測定します。*([ラボ環境](#in-the-lab), [実際のユーザー環境](#in-the-field))*

このリストにはユーザーに関連するパフォーマンスの様々な側面を測定する指標が含まれていますが、すべてを網羅しているわけではありません (たとえば、実行時の応答性や滑らかさについては、現在のところカバーされていません)。

不足する領域を補うために新しい指標が導入される場合も考えられますが、運営するサイトに合わせて調整された指標が最適な場合もあります。

## カスタム指標

上記のパフォーマンス指標は、Web 上に存在するほぼすべてのサイトのパフォーマンス特性について一般的な理解を得る場合に適しています。また、自身が運営するサイトのパフォーマンスを競合他社のサイトと比較する場合の共通指標としても有効です。

しかしながら、特定のサイトが何らかの特徴を持っていて、パフォーマンスの全体像を把握するためには別の指標が必要となる場合も考えられます。たとえば、LCP 指標はページのメイン コンテンツの読み込みが完了したタイミングを測定するための指標ですが、最もサイズの大きい要素がページのメイン コンテンツに含まれていない場合もあり、その場合には LCP が意味をなさないことも考えられます。

このようなケースに対応するために、Web Performance ワーキング グループでは独自のカスタム指標の実装に便利な低水準の API も標準化しています。

- [User Timing API](https://w3c.github.io/user-timing/)
- [Long Tasks API](https://w3c.github.io/longtasks/)
- [Element Timing API](https://wicg.github.io/element-timing/)
- [Navigation Timing API](https://w3c.github.io/navigation-timing/)
- [Resource Timing API](https://w3c.github.io/resource-timing/)
- [Server Timing](https://w3c.github.io/server-timing/)

これらの API を使用してサイト固有のパフォーマンス特性を測定する方法については、「[カスタム指標](/custom-metrics/)」に記載されているガイドを参照してください。
