---
layout: post
title: 遅延読み込みを使用して読み込み速度を向上しましょう
authors:
  - jlwagner
  - rachelandrew
date: 2019-08-16
updated: 2020-06-09
description: |2-

  この投稿では、遅延読み込みと、自分のサイトで要素を遅延読み込みする必要である理由について説明します。
tags:
  - performance
  - images
---

Webサイトの一般的なペイロードに含まれる[画像](http://beta.httparchive.org/reports/state-of-images?start=earliest&end=latest)と[ビデオ](http://beta.httparchive.org/reports/page-weight#bytesVideo)の部分は、重要になるかもしれません。残念ながら、プロジェクトの利害関係者は、既存のアプリケーションからメディアリソースを削減することを望まいようです。このような行き詰まりは、特にすべての関係者がサイトのパフォーマンスを向上させたいが、実施方法について合意を得ない場合、苛立たしいものになります。幸いことに、遅延読み込みは、初期ページのペイロード*と*読み込み時間を短縮するソリューションですが、コンテンツを無駄にすることはありません。

## 遅延読み込みとは何ですか？ {: #what }

遅延読み込みは、ページの読み込み時に重要ではないリソースの読み込みを延期する手法です。代わりに、こういった重要ではないリソースは、必要になる時点に読み込まれます。画像の場合、「重要ではない」は普通に「画面外」と同義です。 Lighthouseを使用して改善を検討したことがあれば、この領域で[オフスクリーン画像監査の延期](https://developer.chrome.com/docs/lighthouse/performance/offscreen-images/)のフォームでガイダンスを見たことがあるかもしれません。

<figure>{% Img src="image/admin/63NnMISWUUWD3mvAliwe.png", alt="Lighthouseでのオフスクリーン画像監査の延長のスクリーンショット。", width="800", height="102" %}<figcaption>Lighthouseのパフォーマンス監査の1つは、遅延読み込みの候補である画面外の画像を特定することです。</figcaption></figure>

おそらく、遅延読み込みが実際に行われているのを見たことがあるでしょう。これは次のようになります。

- ページに訪問し、コンテンツを読みながらスクロールを開始します。
- ある時点で、プレースホルダー画像をビューポートにスクロールします。
- プレースホルダー画像がいきなり最終画像に置き換えられます。

画像の遅延読み込みの例は、一般公開プラットフォーム[Medium](https://medium.com/)にあります。このプラットフォームは、ページの読み込み時に軽量のプレースホルダー画像を読み込み、そしてビューポートにスクロールすると遅延読み込みの画像に置き換えられます。

<figure>{% Img src="image/admin/p5ahQ67QtZ20bgto7Kpy.jpg", alt="ブラウジング中、かつ遅延読み込みの動作を示しているWebサイトMediumのスクリーンショット。ぼやけたプレースホルダーは左側にあり、読み込まれたリソースは右にあります。", width="800", height="493" %}<br><figcaption>実際の遅延読み込みの例の画像。プレースホルダー画像はページの読み込みに読み込まれ（左）、そしてビューポートにスクロールすると、必要なときに最終的な画像が読み込まれます。</figcaption></figure>

遅延読み込みに慣れていない場合は、この手法がどれほど有用であり、メリットは何であるか疑問に思われるかもしれません。ここで読んで調べましょう！

## なぜ画像や動画を単に*読み込む*のではなく、遅延読み込みますか？ {: #why }

ユーザーに表示されなさそうものを読み込んでいる可能性があるためです。これにはいくつかの理由でこの問題が起こります。

- データを浪費します。計測されていない接続では、これは発生する可能性のある最悪の事態ではありません（ただし、実際にユーザーに表示される他のリソースをダウンロードするためにその貴重な帯域幅を使用することはできます）。ただし、制限されたデータプランでは、ユーザーが見ることのないものを読み込むと、お金の無駄になるかもしれません。
- 処理時間、バッテリー、およびその他のシステムリソースを浪費します。メディアリソースがダウンロードされた後、ブラウザはそれをデコードし、ビューポートにそのコンテンツをレンダリングする必要があります。

画像と動画の遅延読み込みにより、初期ページの読み込み時間、初期ページの重さ、システムリソースの使用量が削減されます。これらはすべて、パフォーマンスにプラスの影響を及ぼします。

## 遅延読み込みの実装{: #implementing }

遅延読み込みを実装するにはいくつかの手段があります。ソリューションの選択では、サポートするブラウザーと、遅延読み込みしようとしているものを考慮する必要があります。

最新のブラウザは、画像とiframeの`loading`属性の使用によって有効にされる[ブラウザレベルの遅延読み込み](/browser-level-image-lazy-loading/)を実装しています。古いブラウザとの互換性を提供したり、埋め込む遅延読み込み無しで要素で遅延読み込みを実行したりするには、独自のJavaScriptを使用してソリューションを実装できます。これを行うのに役立つ既存のライブラリも多数あります。こういったすべてのアプローチの詳細については、このサイトの投稿を参照してください。

- [遅延読み込みの画像](/lazy-loading-images/)
- [遅延読み込みの動画](/lazy-loading-video/)

また、[遅延読み込みに関する潜在的な問題の](/lazy-loading-best-practices)リストと、実装時の注意すべき点をまとめました。

## 結論

画像と動画の遅延読み込みにより、サイトの初期読み込み時間とページペイロードが大幅に低下する可能性があるので、慎重にご使用ください。ユーザーは、不必要なネットワークアクティビティや、表示されない可能性のあるメディアリソースの処理コストを負担することはありませんが、必要に応じてそれらのリソースを表示することはできます。

パフォーマンス改善手法に関する限り、遅延読み込みについてはかなり議論の余地がありません。サイトにインライン画像がたくさんある場合は、不要なダウンロードを減らすのに最適な方法です。自分のサイトのユーザーとプロジェクトの利害関係者はそれを高く評価するでしょう！
