---
layout: post
title: 画像CDNを使用して画像を最適化する
authors:
  - katiehempenius
description: 画像CDNは、画像の最適化に優れています。画像CDNに切り替えると、画像のバイト数を40〜80%節約できます。
date: 2019-08-14
codelabs:
  - install-thumbor
tags:
  - performance
---

## 画像CDNを使用する理由

画像コンテンツ配信ネットワーク (CDN) は画像の最適化に優れています。画像CDNに切り替えると、画像のバイト数を[40〜80%節約](https://www.youtube.com/watch?v=YJGCZCaIZkQ&t=1010s)できます。理論的には、ビルドスクリプトのみを使用して同じ結果を得ることが可能ですが、実際にほとんどできません。

## 画像CDNとは何か

画像CDNは、画像の変換、最適化、配信に特化しています。サイトで使用されている画像にアクセスして操作するためのAPIと考えることもできます。画像CDNから読み込まれた画像の場合、画像URLは、読み込む画像だけでなく、サイズ、形式、品質などのパラメータも示します。これにより、さまざまなユースケースに合わせて画像のバリエーションを簡単に作成できます。

<figure>{% Img src="image/admin/OIF2VcXp8P6O7tQvw53B.jpg", alt="画像CDNとクライアント間の要求/応答フローを表示します。サイズや形式などのパラメータは、同じ画像のバリエーションを要求するために使用されます。", width="800", height="408" %} <figcaption>画像CDNが画像URLのパラメータに基づいて実行できる変換の例。</figcaption></figure>

画像CDNは、必要に応じて新しいバージョンの画像を作成するという点で、ビルド時の画像最適化スクリプトとは異なります。その結果、CDNは一般に、ビルドスクリプトよりも、個々のクライアントごとに大幅にカスタマイズされた画像の作成に適しています。

## 画像CDNがURLを使用して最適化オプションを示す方法

画像CDNで使用される画像URLは、画像に関する重要な情報と、画像に適用する変換と最適化を伝送します。 URL形式は画像のCDNによって異なりますが、大まかに言えば、すべて同様の機能を備えています。最も一般的な機能をいくつかを見ていきましょう。

<figure>{% Img src="image/admin/GA4udXeYUEjHSY4N0Qew.jpg", alt="通常、画像のURLはオリジン、画像、セキュリティキー、変換で構成されます。", width="800", height="127" %}</figure>

### オリジン

画像CDNは、独自のドメインまたは画像CDNのドメインに存在できます。通常、サードパーティの画像CDNは、カスタムドメインを有料で使用するオプションを提供しています。独自のドメインを使用すると、URLを変更する必要がないため、後から画像CDNを簡単に切り替えることができます。

上記の例では、カスタムドメインではなく、パーソナライズされたサブドメインを持つ画像CDNのドメイン (example-cdn.com) を使用しています。

### 画像

通常、画像CDNは、必要なときに既存の場所からイメージを自動的に取得するように構成できます。多くの場合、この機能は、画像CDNによって生成されたイメージのURL内に*既存の画像*の完全なURLを含めることによって実現されます。たとえば、次のようなURLが表示される場合があります。`https://my-site.example-cdn.com/https://flowers.com/daisy.jpg/quality=auto`。 このURLは、`https://flowers.com/daisy.jpg`に存在する画像を取得して最適化します。

画像を画像CDNにアップロードするためのもう一つの方法として、HTTP POST要求経由で画像CDNのAPIに画像を送信する方法も広くサポートされています。

### セキュリティキー

セキュリティキーは、他の人が画像の新しいバージョンを作成することを防ぎます。この機能が有効になっている場合、画像の新しいバージョンごとに一意のセキュリティキーが必要になります。誰かが画像のURLのパラメータを変更しようとして、有効なセキュリティキーを入力しなかった場合は、新しいバージョンを作成できません。画像CDNは、セキュリティキーの生成と追跡の詳細を管理します。

### 変換

画像CDNは、数十から数百種類ものさまざまな画像変換を提供します。これらの変換はURL文字列によって指定されます。また、同時に複数の変換を使用すること関する制限はありません。 Webパフォーマンスのコンテキストでは、最も重要な画像変換は、サイズ、ピクセル密度、フォーマット、および圧縮です。一般的に、このような変換により、画像CDNに切り替えるたときに、画像サイズが大幅に縮小されます。

パフォーマンス変換には客観的に最適な設定が存在する傾向があるため、一部の画像CDNは、このような変換に対して「自動」モードをサポートしています。たとえば、画像をWebP形式に変換するように指定するのではなく、CDNに最適な形式を自動的に選択させて提供させることができます。画像CDNが画像を変換する最善の方法を決定するために使用できるシグナルは次のとおりです。

- [クライアントのヒント](https://developer.chrome.com/blog/automating-resource-selection-with-client-hints/) (たとえば、ビューポートの幅、DPR、画像の幅)
- [`Save-Data`](https://developer.mozilla.org/docs/Web/HTTP/Headers/Save-Data)ヘッダー
- [User-Agent](https://developer.mozilla.org/docs/Web/HTTP/Headers/User-Agent)要求ヘッダー
- [ネットワーク情報API](https://developer.mozilla.org/docs/Web/API/Network_Information_API)

たとえば、画像CDNは、JPEG XRをEdgeブラウザに、WebPをChromeブラウザに、JPEGを非常に古いブラウザに提供する場合があります。自動設定が一般的です。画像CDNでいったんサポートされた後は、コードを変更して新しいテクノロジーを採用する必要がなく、画像の最適化に関する画像CDNの優れた能力を活用できるためです。

## 画像CDNの種類

画像CDNは、セルフマネージドとサードパーティマネージドの2つのカテゴリに分類できます。

### セルフマネージド画像CDN

セルフマネージドCDNは、独自のインフラストラクチャを維持管理する能力を備えた技術担当者が配置されているサイトに適しています。

[Thumbor](https://github.com/thumbor/thumbor)は、現在利用可能な唯一のセルフマネージド画像CDNです。オープンソースで無料で使用できますが、一般的に、ほとんどの商用CDNよりも機能が少なく、ドキュメントも充実していません。[Wikipedia](https://wikitech.wikimedia.org/wiki/Thumbor)、[Square](https://medium.com/square-corner-blog/dynamic-images-with-thumbor-a430a1cfcd87)、および[99designs](https://99designs.com/tech-blog/blog/2013/07/01/thumbnailing-with-thumbor/)は、Thumborを使用している3つのサイトです。設定手順については、[Thumbor画像CDNをインストールする方法](/install-thumbor)の投稿を参照してください。

### サードパーティの画像CDN

サードパーティの画像CDNは、画像CDNをサービスとして提供します。クラウドプロバイダがサーバーやその他のインフラストラクチャを有料で提供するのと同じように、画像CDNは画像の最適化と配信を有料で提供します。サードパーティの画像CDNは基盤となるテクノロジーを管理しているため、導入が非常に簡単で、通常は10〜15分で完了します。ただし、大規模なサイトの完全な移行には、それよりもかなり長い時間がかかる場合があります。通常、サードパーティの画像CDNは使用状況ティアに基づいて価格設定されます。ほとんどの画像CDNは、製品を試す機会を提供するために、無料のティアまたは無料トライアルのいずれかを提供しています。

## 画像CDNの選択

画像CDNには多くの優れたオプションがあります。画像CDNによって機能の多少がありますが、いずれも画像のバイト数を削減し、ページの読み込みを高速化するのに役立つ可能性があります。機能セットのほかに、画像CDNを選択する際に考慮すべき他の要素は、コスト、サポート、ドキュメント、およびセットアップまたは移行の容易さです。

決定する前に自分で試してみるのも役立つでしょう。いくつかの画像CDNを簡単に導入する方法については、次のコードラボをご覧ください。
