---
title: FLoCとは何ですか？
subhead: FLoCは、個々のユーザーのブラウジング動作を共有せずに、広告の選択を可能にします。
authors:
  - samdutton
date: 2021-03-30
updated: 2021-10-29
hero: image/80mq7dk16vVEg8BBhsVe42n6zn82/GA543wiVTwpbwp6Zmw0H.jpg
thumbnail: image/80mq7dk16vVEg8BBhsVe42n6zn82/OuORgPSvN06ntXT5xOii.jpg
alt: ブライトン・ピアでのムクドリのつぶやき
tags:
  - blog
  - privacy
  - security
feedback:
  - api
---

{% Aside %}この投稿では、FLoCの最初のオリジントライアルのためにChromeに実装されたAPIデザインの概要を説明します。

サードパーティのCookieやその他のクロスサイト追跡メカニズムを使用せずに嗜好ベースの広告を有効にするAPIの将来の反復は、現在開発中です。 {% endAside %}

FLoCは、嗜好ベースの広告選択のためのプライバシー保護メカニズムを提供します。

ユーザーがウェブ以内で行動すると、ブラウザーはFLoCアルゴリズムを使用して「インタレストコホート」を作成します。これは、最近の閲覧履歴が類似している何千のブラウザーでも同じです。ブラウザは、個人の閲覧データをブラウザベンダーや他の人と共有することなく、ユーザーのデバイス上で定期的にコホートを再計算します。

{% Aside %}最初のFLoCトライアルでは、次の2つの理由のいずれかにより、ページへのアクセスがブラウザのFLoC計算にのみ含まれていました。

- FLoC API（ `document.interestCohort()` ）がページで使用されます。
- Chromeは、ページが[広告または広告関連のリソースを読み込み](https://github.com/WICG/floc/issues/82)しいることを検出します。

他のクラスタリングアルゴリズムの場合、トライアルはさまざまな包含基準で実験することがあります。これは、オリジントライアルの実験プロセスの一部です。

Chrome 89から91まで実行されていたFLoCの初期バージョンのオリジントライアルは、 [現在終了してい](https://developer.chrome.com/origintrials/#/view_trial/213920982300098561)ます。 {% endAside %}

広告主（広告にお金を払うサイト）は、コホートデータを収集してアドテックプラットフォーム（広告を配信するためのソフトウェアとツールを提供する会社）に提供するために、独自のWebサイトにコードを含めることができます。たとえば、アドテックプラットフォームは、オンラインの靴店から、コホート1101および1354のブラウザが店のハイキング用品に興味を持っているように見えることを発現できます。他の広告主から、アドテックプラットフォームはそれらのコホートの他の興味について認識できます。

その後、これらのコホートの1つのブラウザが、ニュースWebサイトなどの広告を表示するサイトからページを要求すると、広告プラットフォームはこのデータを使用して関連する広告（靴屋のハイキングブーツの広告など）を選択できます。

プライバシーサンドボックスは、サードパーティのCookieやその他の追跡メカニズムを使用せずにサードパーティのユースケースを満たすための一連のプロポーザルです。すべてのプロポーザルの概要については[、プライバシーサンドボックスを掘り下げる](/digging-into-the-privacy-sandbox)を参照してください。

**このプロポーザルにはフィードバックが必要です。**コメントがあれば、 [FLoCExplainer](https://github.com/WICG/floc)リポジトリで[issueを作成してください。](https://github.com/WICG/floc/issues/new)このプロポーザルに関するChromeの実験についてフィードバックがあれば、 [Intent toExperiment](https://groups.google.com/a/chromium.org/g/blink-dev/c/MmijXrmwrJs)に返信を投稿してください。

## なぜFLoCが必要なのですか？

多くの企業は、サイトへのトラフィックを増やすために広告に依存しており、多くのサイト運営者のウェブサイトは、広告枠を販売することでコンテンツに資金を提供しています。人々は一般的に興味がありかつ有用な広告を見ることを好み、そして関連性のある広告はまた広告主により多くのビジネスと[それらを所有するウェブサイトにより多くの収入をもたらします](https://services.google.com/fh/files/misc/disabling_third-party_cookies_publisher_revenue.pdf)。言い換えれば、広告スペースは、関連する広告を表示すると、より価値をもたらします。したがって、関連する広告を選択すると、広告がサポートされているWebサイトの収益が増加します。つまり、関連する広告は、ユーザーに利益をもたらすコンテンツ作成に資金を提供するのに役立ちます。

ただし、人々は、現在、サイト全体の閲覧履歴を広告主や広告プラットフォームに公開する恐れがあるCookieの追跡やデバイスのフィンガープリントなどの手法に依存している、カスタマイズされた広告のプライバシーへの影響を懸念しています。 FLoCの提案は、プライバシーをより適切に保護する方法で広告を選択できるようにすることを目的としています。

## FLoCは何に使用できますか？

- 広告主のサイトに頻繁にアクセスすることが観察されている、または関連するトピックに関心を示しているコホートのブラウザが属しているユーザーに広告を表示します。
- 機械学習モデルを使用して、ユーザーがコホートに応じてコンバージョンする確率を予測し、広告オークションの入札行動を通知します。
- ユーザーにコンテンツをお進めします。例えば、ニュースサイトが、スポーツポッドキャストページがコホート1234およびコホート7からの訪問者に特に人気があることを観察したとします。彼らは、それらのコホートからの他の訪問者にもそのコンテンツを推奨できます。

## FLoCはどのように機能しますか？

以下の例では、FLoCを使用して広告を選択する際のさまざまな役割について説明します。

- この例の**広告主**（広告にお金を払う会社）は、オンラインの靴の小売業者です。<br>**<u>shoestore.example</u>**

- この例の**発行元**（広告スペースを販売するサイト）はニュースサイトです。<br> **<u>dailynews.example</u>**

- **adtechプラットフォーム**（広告を配信するためのソフトウェアとツールを提供する）は次のとおりです。<br> **<u>adnetwork.example</u>**

{% Img src="image/80mq7dk16vVEg8BBhsVe42n6zn82/wnJ1fSECf5STngywgE7V.png", alt="図は、FLoCを使用して広告を選択および配信する際のさまざまな役割を段階的に示しています：FLoCサービス、ブラウザー、広告主、パブリッシャー（コホートを観察するため） 、Adtech、Publisher（広告を表示するため", width="800", height="359" %}

この例では、ユーザーを**Yoshi**と**Alex**と呼びます。当初、彼らのブラウザは両方とも同じコホート、1354に属しています。

{% Aside %}ここではユーザーをYoshiとAlexと呼んでいますが、これは例の目的のためだけです。 FLoCを使用する広告主、発行者、またはアドテックプラットフォームには、名前と個人のIDは公開されません。

コホートを人々の集まりとは考えないでください。代わりに、コホートをブラウジングアクティビティのグループと考えてください。 {% endAside %}

### 1.FLoCサービス

1. ブラウザで使用されるFLoCサービスは、数千の「コホート」を含む数学モデルを作成します。コホートごとは、同様の最近の閲覧履歴を持つ数千のWebブラウザに対応します。これがどのように機能[するかについては、以下をご覧ください](#floc-server)。
2. コホートごとには番号が付けられています。

### 2.ブラウザ

1. Yoshiのブラウザは、FLoCサービスから、FLoCモデルを説明するデータを取得します。
2. Yoshiのブラウザは、[FLoCモデルのアルゴリズムを使用して](#floc-algorithm)自身の閲覧履歴に最も密接に対応しているコホートを計算します。この例では、それがコホート1354になります。YoshiのブラウザはFLoCサービスにデータを共有しないことに注意してください。
3. 同様に、AlexのブラウザはコホートIDを計算します。 Alexの閲覧履歴はYoshiの閲覧履歴とは異なりますが、ブラウザが両方ともコホート1354に属しているほど類似しています。

### 3.広告主： <span style="font-weight:normal">shoestore.example</span>

1. Yoshiが<u>shoestore.example</u>にアクセスします。
2. このサイトは、Yoshiのブラウザにそのコホート：1354を要求します。
3. Yoshiはハイキングブーツを見ます。
4. このサイトは、コホート1354のブラウザがハイキングブーツに興味を示したことを記録しています。
5. このサイトは後に、コホート1354および他のコホートからの製品への追加の関心を記録します。
6. このサイトは、コホートと製品の関心に関する情報を定期的に集約し、アドテックプラットフォーム<u>adnetwork.example</u>と共有しています。

次はAlexの番です。

### 4.発行元： <span style="font-weight:normal">dailynews.example</span>

1. Alexは<u>dailynews.example</u>にアクセスします。
2. このサイトは、Alexのブラウザにコホートを要求します。
3. 次に、サイトは、Alexのブラウザのコホート: 1354を含むアドテックプラットフォーム<u>adnetwork.example</u>に広告をリクエストします。

### 5.アドテックプラットフォーム： <span style="font-weight:normal">adnetwork.example</span>

1. <u>adnetwork.example</u>が発行元<u>dailynews.example</u>と広告主<u>shoestore.example</u>から取得したデータを組み合わせることによって、Alexに適した広告を選択することができます。

- <u>dailynews.exampleが</u>提供するAlexのブラウザのコホート（1354）。
- <u>shoestore.example</u>からのコホートと製品の嗜好に関するデータ：「コホート1354のブラウザは、ハイキングブーツに興味があるかもしれません。」

1. <u>adnetwork.exampleは</u>、Alexに適した広告を選択します：<u>shoestore.example</u>でのハイキングブーツの広告となります。
2. <u>dailynews.example</u>が広告🥾を表示します。

{% Aside %}広告選択の現在のアプローチは、Cookieの追跡やデバイスのフィンガープリントなどの手法に依存しています。これらの手法は、広告主などのサードパーティが個人のブラウジング動作を追跡するために使用します。

FLoCで、ブラウザは閲覧履歴をFLoCサービスや他の人と**共有しません。**ユーザーのデバイス上のブラウザーは、属しているコホートを判断します。ユーザーの閲覧履歴がデバイスから必ず離れません。 {% endAside %}

## FLoCモデルを作成するバックエンドサービスを実行するのは誰ですか？

すべてのブラウザベンダーは、ブラウザをコホートにグループ化する方法を独自に選択する必要があります。 Chromeは独自のFLoCサービスを実行しています。他のブラウザは、異なるクラスタリング手法でFLoCを実装することを選択し、そのために独自のサービスを実行する場合があります。

## FLoCサービスは、ブラウザがそのコホートをどのように処理できるようにしますか？ {：＃floc-server}

1. ブラウザが使用するFLoCサービスは、すべての潜在的なウェブ閲覧履歴の多次元の数学的表現を作成します。このモデルを「コホートスペース」と呼びます。
2. このサービスは、このスペースを数千のセグメントに分割します。セグメント毎は、何千もの同様の閲覧履歴のクラスターを表します。これらのグループ化は、実際の閲覧履歴を知ることを基にしていません。それらは単に「コホートスペース」でランダムな中心を選ぶか、ランダムな線でスペースを切り取ることをベースにしています。
3. 各セグメントにはコホート番号が付けられています。
4. Webブラウザーは、FLoCサービスから「コホートスペース」を説明するこのデータを取得します。
5. ユーザーがWウェブを行動すると、ブラウザー[はアルゴリズム](#floc-algorithm)を使用して、自身の閲覧履歴に最も近い「コホートスペース」内の領域を定期的に計算します。

<figure style="text-align: center">{% Img src="image/80mq7dk16vVEg8BBhsVe42n6zn82/32k5jByqLrgwSMwb9mqo.png", alt="FLoCサーバーによって作成された「閲覧履歴スペース」の図。それぞれにコホート番号が付いた複数のセグメントが表示されます。", width="400", height="359" %}<figcaption> FLoCサービスは、「コホートスペース」を数千のセグメントに分割します（ここではごく一部のみを示しています）。</figcaption></figure>

{% Aside %}このプロセスのどの時点でも、ユーザーの閲覧履歴はFLoCサービスまたはサードパーティと共有されません。ブラウザのコホートは、ユーザーのデバイス上のブラウザによって計算されます。 FLoCサービスによってユーザーデータが取得または保存されることはありません。 {% endAside %}

## ブラウザのコホートは変更できますか？

*はい*！ブラウザのコホートは間違いなく変わる可能性があります！おそらく毎週同じウェブサイトにアクセスすることはなく、ブラウザのコホートはそれを反映します。

コホートは、人々の集まりではなく、ブラウジングアクティビティのクラスターを表します。コホートのアクティビティ特性は一般に時間の経過とともに一貫しており、コホートは同様の最近のブラウジング動作をグループ化するため、広告の選択に役立ちます。個々の人々のブラウザは、ブラウジング動作が変化すると、コホートに出入りします。当初、ブラウザは7日ごとにコホートを再計算することを期待しています。

上記の例では、YoshiとAlexのブラウザのコホートはどちらも1354です。将来、YoshiのブラウザとAlexのブラウザは、関心が変わった場合に別のコホートに移動する可能性があります。以下の例では、Yoshiのブラウザはコホート1101に移動し、Alexのブラウザはコホート1378に移動します。他の人のブラウザは、閲覧の興味が変わると、コホートに出入りします。

<figure style="text-align: center">{% Img src="image/80mq7dk16vVEg8BBhsVe42n6zn82/LMkb62V3iJTqkOrFACnM.png", alt="FLoCサーバーによって作成された「閲覧履歴スペース」の図は複数のセグメントを表示し、それぞれのコホートを番号付いています。この図はAlexとYoshiユーザーのブラウザが閲覧の興味が時間とともに変化するにつれて、あるコホートから別のコホートに移動することを示します。 ", width="800", height="533" %}<figcaption>AlexとYoshiのブラウザコホートは、興味が変わると変わる可能性があります。</figcaption></figure>

{% Aside %}コホートは、人々のグループではなく、ブラウジングアクティビティのグループを定義します。ブラウザは、アクティビティが変化すると、コホートに出入りします。 {% endAside %}

## ブラウザはどのようにコホートを処理しますか？ {：＃floc-algorithm}

上記のように、ユーザーのブラウザーは、コホートの数学的モデル、つまりすべてのユーザーのブラウジングアクティビティを表す多次元空間を記述するFLoCサービスからデータを取得します。次に、ブラウザはアルゴリズムを使用して、この「コホートスペース」のどの領域（つまり、どのコホート）が自身の最近のブラウジング動作に最も近いかを判断します。

## FLoCはどのようにして適切なサイズのコホートを作成しますか？

コホート毎には何千ものブラウザが所有しています。

コホートのサイズが小さいほど、広告を個人化するのに役立つ場合がありますが、ユーザーの追跡を停止する可能性は低くなります。その逆も同様です。ブラウザをコホートに割り当てるメカニズムは、プライバシーとユーティリティの間でトレードオフを行う必要があります。プライバシーサンドボックスは、 [k-匿名性](https://en.wikipedia.org/wiki/K-anonymity)を使用して、ユーザーが「群衆の中に隠れること」を有効にします。コホートは、少なくともkのユーザーによって共有されている場合、k匿名となります。 k値が高いほど、コホートのプライバシーがより厳しく保護されます。

## FLoCを使用して、機密カテゴリを基にして人をグループ化できますか？

FLoCコホートモデルの構築に使用されるクラスタリングアルゴリズムは、カテゴリが機密である理由を学習せずに、コホートが機密カテゴリと相関する可能性があるかどうかを評価するように設計されています。人種、性的指向、病歴などのデリケートなカテゴリを公開する可能性のあるコホートはブロックされます。言い換えれば、そのコホートを処理するとき、ブラウザは機密カテゴリを表示しないコホートの中に選択します。

## FLoCは、オンラインで人々を分類するもう1つの方法ですか？

FLoCを使用すると、ユーザーのブラウザーは、他の何千ものユーザーのブラウザーとともに、何千ものコホートの1つに属します。サードパーティのCookieやその他のターゲティングメカニズムとは異なり、FLoCはユーザーのブラウザが含まれているコホートのみを表示し、個々のユーザーIDは表示しません。他の人がコホート内の個人を区別することはできません。さらに、ブラウザのコホートを計算するために使用されるブラウジングアクティビティに関する情報は、ブラウザまたはデバイス上でローカルに保持され、他の場所にはアップロードされません。ブラウザは、[差分プライバシー](https://en.wikipedia.org/wiki/Differential_privacy)などの他の匿名化方法をさらに活用する場合があります。

## ウェブサイトは参加して情報を共有する必要がありますか？

WebサイトはFLoCをオプトインまたはオプトアウトできるため、機密性の高いトピックに関するサイトは、サイトへのアクセスがFLoCの計算に含まれないようにすることができます。追加の保護として、FLoCサービスによる分析では、コホートが機密である理由を学習せずに、コホートがユーザーに関する機密情報を公開する可能性があるかどうかを評価します。コホートがデリケートなカテゴリのサイトにアクセスする通常よりも多くの人々を表す可能性がある場合、そのコホート全体が削除されます。ネガティブな財政状態とメンタルヘルスは、この分析の対象となるデリケートなカテゴリーの1つです。

Webサイトは、そのページに[Permissions-Policy](https://developer.chrome.com/docs/privacy-sandbox/permissions-policy/)ヘッダー`interest-cohort=()`を設定することにより、[FLoC計算からページを除外できます](https://developer.chrome.com/docs/privacy-sandbox/permissions-policy/)。除外されていないページの場合、ページで `document.interestCohort()`を使用していると、ページへのアクセスがブラウザのFLoC計算に含まれます。現在の[FLoCオリジントライアル](https://developer.chrome.com/origintrials/#/view_trial/213920982300098561)中に、ページが[広告または広告関連リソースをロード](https://github.com/WICG/floc/issues/82)していることをChromeが検出した場合、ページも計算に含まれます。 （[Chromiumの広告タグ付け](https://github.com/WICG/floc/issues/82)は、Chromeの広告検出メカニズムがどのように機能するかを説明しています。）

イントラネットページなどのプライベートIPアドレスから提供されるページは、FLoC計算の一部にはなりません。

## FLoC JavaScript APIはどのように機能しますか？

{% Aside %} Chrome 89から91まで実行されていたFLoCの初期バージョンのオリジントライアル[は終了しました](https://developer.chrome.com/origintrials/#/view_trial/213920982300098561)。 {% endAside %}

FLoC APIが単純に`id`と`version`提供するオブジェクトに解決されるpromiseを返す単一のメソッドです。

```javascript
const { id, version } = await document.interestCohort();
console.log('FLoC ID:', id);
console.log('FLoC version:', version);
```

利用可能になったコホートデータは次のようになります。

```js
{
  id: "14159",
  version: "chrome.2.1"
}
```

`version`値により、FLoCを使用しているサイトは、コホートIDが参照しているブラウザーとFLoCモデルを知ることができます。以下で説明するように、 `document.interestCohort()`に返されたpromiseは `interest-cohort`権限が有効にしないフレームに対して拒否されます。

## WebサイトはFLoC計算に含まれないようにオプトアウトできますか？

`interest-cohort`権限ポリシーを使用すると、サイトは、コホート計算の目的にしているユーザーのサイトリストに含めたくないことを宣言できます。ポリシーはディフォルトで`許可`されます。`document.interestCohort()`によって返されるpromiseは、 `interest-cohort`権限が許可されていないフレームを拒否します。メインフレームに`interest-cohort`権限がない場合、ページへのアクセスはインタレストコホートの計算に含まれません。

たとえば、サイトは次のHTTP応答ヘッダーを送信することですべてのFLoCコホート計算をオプトアウトできます。

```text
  Permissions-Policy: interest-cohort=()
```

## ユーザーは、サイトがブラウザーのFLoCコホートを取得するのを止めることができますか？

`chrome://settings/privacySandbox`でプライバシーサンドボックスを無効にした場合、JavaScriptを介して要求されたときに、ブラウザーはユーザーのコホートを提供しません。`document.interestCohort()`によって返されるpromiseは拒否されます。

## どうすれば提案をしたりフィードバックを提供したりできますか？

APIについてコメントがある場合は、 [FLoCExplainer](https://github.com/WICG/floc)リポジトリで[issueを作成してください。](https://github.com/WICG/floc/issues/new)

## 詳細はこちら

- [プライバシーサンドボックスを掘り下げる](/digging-into-the-privacy-sandbox/)
- [FLoC Explainer](https://github.com/WICG/floc)
- [FLoCOriginのトライアルとクラスタリング](https://sites.google.com/a/chromium.org/dev/Home/chromium-privacy/privacy-sandbox/floc)
- [FLoCAPIのコホートアルゴリズムの評価](https://github.com/google/ads-privacy/blob/master/proposals/FLoC/README.md)

---

写真: [Unsplash](https://unsplash.com/@rhyskentish) でアップロードされます。 [Sergey Zolkin](https://unsplash.com/photos/I5AYxsxSuVA)に撮影されました。
