---
title: CLS 指標の進化
subhead: 長期間有効なページに対する公平性を高めるための CLS 指標の改善計画について。
description: 長期間有効なページに対する公平性を高めるための CLS 指標の改善計画について。
authors:
  - anniesullie
  - hbsong
date: 2021-04-07
hero: image/admin/JSBg0yF1fatrTDQSKiTW.webp
alt: レイアウトシフトを測定するためのウィンドウアプローチの例。
tags:
  - blog
  - performance
  - web-vitals
---

{% Aside %} **2021年6月2日:** この記事で説明されている CLS のアップデートは、Chrome の Web ツール面全体に公開されました。詳細については、「[Web ツールでの累積レイアウトシフトの進化](/cls-web-tooling/)」をご覧ください。 {% endAside %}

私たち（Chrome Speed Metrics チーム）は最近、[CLS 指標を長期間開いているページに対してより公平にするためのオプション](/better-layout-shift-metric/)に関する初回調査の概要を説明しました。非常に有益なフィードバックを多数受け取り、大規模な分析を行った上で、指標に適用予定の変更を仕上げました。**5 秒を上限とする 1 秒間隔の最大セッションウィンドウ**です。

以下でその詳細をお読みください！

## オプションはどのように評価されましたか？

開発者コミュニティから受け取ったすべてのフィードバックを確認し、それを考慮しました。

また、Chromeに[上位のオプション](/better-layout-shift-metric/#best-strategies)を実装し、数百万もの Web ページに渡ってメトリックの大規模な分析を行いました。各オプションがどのタイプのサイトを改善したか、またオプションがどのように比較されたかを確認しました。特に、さまざまなオプションによってスコアが異なるサイトを調べ、全体として、以下のことがわかりました。

- **すべて**のオプションにより、ページで費やされた時間とレイアウトシフトスコアの間の相関関係が減少した。
- どのページでもスコアが悪くなるオプションは**なかった**。したがって、この変更によってサイトのスコアが悪化することを心配する必要はない。

## 決定点

### セッションウィンドウの理由

[以前の記事](/better-layout-shift-metric/)では、スコアが無制限に増加しないようにしながら、レイアウトシフトをグループ化するための[いくつかの異なるウィンドウ戦略](/better-layout-shift-metric/#windowing-strategies)について説明しました。開発者から受け取ったフィードバックは、レイアウトシフトを最も直感的にグループ化するセッションウィンドウ戦略を指示したものが圧倒的大多数でした。

セッションウィンドウを確認するために、次の例を示します。

<figure>
  <video controls autoplay loop muted>
    <source src="https://storage.googleapis.com/web-dev-assets/better-layout-shift-metric/session-window.webm" type="video/webm">
    <source src="https://storage.googleapis.com/web-dev-assets/better-layout-shift-metric/session-window.mp4" type="video/mp4">
  </source></source></video>
  <figcaption>セッションウィンドウの例。</figcaption></figure>

上記の例では、ユーザーがページを表示すると、時間の経過とともに多くのレイアウトシフトが発生します。各シフトは青いバーで表されています。上記では、青いバーの高さがそれぞれに異なっており、個別のレイアウトシフトの[スコア](/cls/#layout-shift-score)が表されています。セッションウィンドウは、最初のレイアウトシフトから始まり、レイアウトシフトのない間隔ができるまで拡大し続けます。次のレイアウトシフトが発生すると、新しいセッションウィンドウが開始されます。レイアウトシフトのない間隔が 3 つあるため、この例には 3 つのセッションウィンドウがあることになります。現在の CLS の定義と同様に、各シフトのスコアが合計されるため、各ウィンドウのスコアは個別のレイアウトシフトの合計になります。

[初回調査](/better-layout-shift-metric/#best-strategies)に基づいて、セッションウィンドウ間に 1 秒の間隔を選択したところこの間隔は、大規模な分析でうまく機能しました。したがって、上記の例に示されている「セッション間隔」は 1 秒です。

### 最大セッションウィンドウの理由

初回調査では、[要約戦略](/better-layout-shift-metric/#summarization)を 2 つのオプションに絞り込みました。

- 非常に大きなセッションウィンドウ（5 秒の間隔がある上限なしのウィンドウ）の場合、すべてのセッションウィンドウの**平均**スコア。
- 小さいセッションウィンドウ（上限 5 秒、間隔 1 秒）の場合、すべてのセッションウィンドウの**最大**スコア。

初回調査の後、数百万を超える URL で大規模な分析を実行できるように、各指標を Chrome に追加しました。大規模な分析では、以下のようなレイアウトシフトパターンを持つ URL が多数あることがわかりました。

{% Img src="image/MZfwZ8oVW8U6tzo5CXffcER0jR83/bW3lHZmss3cqGayZsq4P.png", alt="平均を引き下げる小さなレイアウトシフトの例", width="800", height="550" %}

右下では、Session Windows 2 に小さなレイアウトシフトが 1 つしかなく、スコアが非常に低くなってるのがわかります。つまり、平均スコアがかなり低くなります。しかし、開発者がその小さなレイアウトシフトを修正するとどうなるでしょうか。次に、スコアを Session Windows 1 のみで計算すると、ページのスコアが*ほぼ 2 倍*になります。レイアウトシフトを改善したのにスコアが悪化したとなれば、開発者は非常に混乱し、落胆してしまうことでしょう。この小さなレイアウトシフトを取り除くことでわずかながら明らかにユーザーエクスペリエンスを向上させたわけですから、スコアが悪化するはずがないのです。

平均に伴うこのような問題のため、私たちは、より小さく上限付きの最大ウィンドウで変更を進めることにしました。つまり、上記の例では、Session Window 2 は無視され、Session Window 1 のレイアウトシフトの合計のみが報告されるようになります。

### 5 秒の理由

複数のウィンドウサイズを評価したところ、以下の 2 つのことがわかりました。

- ウィンドウが短い場合、ページの読み込みとユーザー操作への応答が遅くなると、レイアウトシフトが複数のウィンドウに分割され、スコアが向上する可能性がある。このような速度低下でスコアが上がらない程度に、ウィンドウの大きさを維持する必要がある。
- 一部のページでは、小さなレイアウトシフトが絶え間なく発生している。たとえば、得点が更新されるたびに少しずつシフトするスポーツの得点表示ページなど。これらのシフトは煩わしいものではあるが、時間が経ってもその煩わしさが増加することはない。そのため、これらのタイプのレイアウトシフトに対してウィンドウが確実に制限されるようにする必要がある。

上記の 2 つのことを念頭に、多くの実際の Web ページでさまざまなウィンドウサイズを比較したところ、5 秒のウィンドウサイズが適切な制限であるとう結論に達しました。

## これは私のページの CLS スコアにどのように影響しますか？

このアップデートによって ページの CLS に上限がつくため、このアップデートの結果、**スコアが悪化するページはありません**。

また、私たちの分析に基づけば、**オリジンの 55％ は、75 パーセンタイルで CLS の変化にまったく気づくことはありません**。これは、現在ページにレイアウトシフトがないか、実際に存在するシフトがすでに単一のセッションウィンドウに制限されているためです。

**残りのオリジンでは、75パーセンタイルでこの変更によりスコアが向上します**。ほとんどの場合はわずかな改善しか見られませんが、約 3％ のスコアは、「改善が必要」または「悪い」の評価から「良い」の評価に改善されます。[以前の記事](/better-layout-shift-metric/)で説明したように、こういったページでは無限のスクローラーが使用されている、更新の遅い UI が多数ある傾向にあります。

## 新しい指標を試すには？

間もなく、新しい指標定義を使用するようにツールがアップデートされます。それまでは、[JavaScript の実装例](https://github.com/mmocny/web-vitals/wiki/Snippets-for-LSN-using-PerformanceObserver)または [Web Vitals 拡張機能のフォーク](https://github.com/mmocny/web-vitals-extension/tree/experimental-ls)を使用して、任意のサイトで 更新済みバージョンの CLS を試すことができます。

前の記事を読んでフィードバックを送っていただいたすべての方に感謝します！
