---
layout: post
title: Core Web Vitals の指標のしきい値の定義
subhead: Core Web Vitals のしきい値の背後にある調査と方法論
authors:
  - bmcquade
description: Core Web Vitals のしきい値の根拠となる調査および方法論
date: 2020-05-21
updated: 2022-07-18
hero: image/admin/WNrgCVjmp8Gyc8EbZ9Jv.png
alt: Core Web Vitals のしきい値の根拠となる調査および方法論
tags:
  - blog
  - performance
  - web-vitals
---

[Core Web Vitals](/vitals/#core-web-vitals) は、Web 上で実際にユーザーが体験するユーザー エクスペリエンスに関する重要な観点の測定を目的とした一連のフィールド指標です。Core Web Vitals には指標と各指標のターゲットとなるしきい値が含まれており、これらを参考にすることで、運営するサイトでのユーザー体験が "良い"、"改善が必要"、"悪い" のいずれの状態にあるかを開発者が定性的に理解できるようになります。この投稿では、Core Web Vitals の指標のしきい値の選択に一般的に使用されるアプローチと、Core Web Vitals の指標それぞれのしきい値がどのように選択されたかについて説明します。

## Core Web Vitals の指標およびしきい値についての復習

2020 年時点で Core Web Vitals は、Largest Contentful Paint (最大視覚コンテンツの表示時間、LCP)、First Input Delay (初回入力までの遅延時間、FID)、Cumulative Layout Shift (累積レイアウト シフト数、CLS) という 3 つの指標により構成されています。それぞれの指標は、ユーザー エクスペリエンスに関する様々な観点を測定します。LCP は、ページの読み込みタイムラインにおいてページのメイン コンテンツの読み込みが完了したと思われる時点を示し、知覚される読み込み速度を測定するための指標です。FID は、応答性を測定し、ユーザーがページで初めて操作を試みるときに感じるエクスペリエンスを数値化するための指標です。CLS は、視覚的な安定性を測定し、表示されているページ コンテンツの予期しないレイアウト シフトの量を数値化するための指標です。

それぞれの Core Web Vitals 指標には、パフォーマンスを"良い"、"改善が必要"、"悪い" のいずれかへと分類するしきい値が関連付けられています。

<style>
  .cluster > img {
    max-width: 30%;
  }
</style>
<div class="cluster">
  {% Img src="image/tcFciHGuF3MxnTr1y5ue01OGLBn2/ZZU8Z7TMKXmzZT2mCjJU.svg", alt="Largest Contentful Paint のしきい値に関する推奨事項", width="400", height="350" %}
  {% Img src="image/tcFciHGuF3MxnTr1y5ue01OGLBn2/iHYrrXKe4QRcb2uu8eV8.svg", alt="First Input Delay のしきい値に関する推奨事項", width="400", height="350" %}
  {% Img src="image/tcFciHGuF3MxnTr1y5ue01OGLBn2/dgpDFckbHwwOKdIGDa3N.svg", alt="Cumulative Layout Shift のしきい値に関する推奨事項", width="400", height="350" %}
</div>

<div>
  <table>
    <tr>
      <th> </th>
      <th>良い</th>
      <th>悪い</th>
      <th>パーセンタイル</th>
    </tr>
    <tr>
      <td>Largest Contentful Paint</td>
      <td>≤2500ms</td>
      <td>4000 ミリ秒より大きい</td>
      <td>75</td>
    </tr>
    <tr>
      <td>First Input Delay</td>
      <td>100 ミリ秒以下</td>
      <td>300 ミリ秒より大きい</td>
      <td>75</td>
    </tr>
    <tr>
      <td>Cumulative Layout Shift</td>
      <td>≤0.1</td>
      <td>0.25 より大きい</td>
      <td>75</td>
    </tr>
</table>
</div>
<p data-md-type="paragraph">加えて、あるページやサイトの全体的なパフォーマンスを分類するために、そのページやサイトの全ページ ビューの 75 パーセンタイル値を使用します。つまり、あるサイトのページ ビューの 75% 以上が "良い" に該当するしきい値を満たしていれば、そのサイトはその指標について "良い" パフォーマンスを維持しているとして分類されます。逆に、ページ ビューの少なくとも 25% が "悪い" に該当するしきい値を満たしていれば、そのサイトは "悪い" パフォーマンスを維持しているとして分類されます。たとえば、75 パーセンタイルの LCP が 2 秒の場合には "良い" として分類され、75 パーセンタイルの LCP が 5 秒の場合には "悪い" として分類されます。</p>
<h2 data-md-type="header" data-md-header-level="2">Core Web Vitals の指標のしきい値の基準</h2>
<p data-md-type="paragraph">Core Web Vitals 指標のしきい値を設定する際には、まずそれぞれのしきい値が満たすべき基準を特定しました。以下では、2020 年の Core Web Vitals 指標のしきい値を評価するために Google が使用した基準について説明します。以降のセクションでは、2020 年の各指標のしきい値を選択するためにこれらの基準がどのように適用されたかについて、より詳しく説明します。将来的には、Web 上での優れたユーザー エクスペリエンスを測定する能力をさらに向上させるために、基準やしきい値の改善および追加を行う予定です。</p>
<h3 data-md-type="header" data-md-header-level="3">質の高いユーザー エクスペリエンス</h3>
<p data-md-type="paragraph">私たちの第一の目標は、ユーザーおよびそのユーザー体験の質の最適化です。そのため、Core Web Vitals の "良い" の基準を満たしているページが質の高いユーザー エクスペリエンスを確実に提供することを目指しています。</p>
<p data-md-type="paragraph">質の高いユーザー エクスペリエンスに関連のあるしきい値を特定するために、私たちは人間の知覚と HCI に関する研究に着目しました。こういった研究については、固定された単一のしきい値を用いてまとめられる場合もありますが、基礎的な研究は通常ある程度の範囲を持った値によって表現されます。たとえば、ユーザーが集中力を失うまでの時間を 1 秒と表現する場合がありますが、実際には数百ミリ秒から数秒に渡る範囲によって表現されています。知覚のしきい値はユーザーやコンテキストによって異なるという事実は、匿名化された Chrome の指標データの集計結果によっても裏付けられています。このデータによれば、ユーザーがページの読み込みを中止するまでに Web ページのコンテンツ表示を待っていた時間は、1 つのパターンのみではありませんでした。むしろこのデータは、滑らかで連続的な分布を示していたのです。人間の知覚のしきい値と関連する HCI に関する研究については、「<a href="https://blog.chromium.org/2020/05/the-science-behind-web-vitals.html" data-md-type="link">Web Vitals の根拠となる科学</a>」を参照してください。</p>
<p data-md-type="paragraph">ある指標について関連するユーザー エクスペリエンス調査が利用可能であり、文献で示されている値の範囲について妥当なコンセンサスが得られている場合には、この範囲を入力値として使用してしきい値の選択プロセスを進めます。また、Cumulative Layout Shift のような新しい指標について、関連するユーザー エクスペリエンス調査が利用不可能な場合には、その代替として、ある指標に関して異なるしきい値の候補を満たしている実際のページを評価し、良好なユーザー エクスペリエンスをもたらすしきい値を特定します。</p>
<h3 data-md-type="header" data-md-header-level="3">既存の Web コンテンツで達成可能</h3>
<p data-md-type="paragraph">さらに、サイトの所有者が "良い" しきい値を満たすサイトの最適化を達成できるように、Web 上にある既存のコンテンツでこのしきい値が達成可能であることが求められます。たとえば、0 ミリ秒は LCP に関して理想的な "良い" しきい値であり、結果的に瞬時に読み込みが行われるはずですが、0 ミリ秒というしきい値は、ネットワークやデバイスの処理の遅延を利用として、ほとんどの場合において現実的には達成が不可能です。したがって、0 ミリ秒という値は、Core Web Vitals に含まれる LCP の "良い" しきい値としては妥当ではありません。</p>
<p data-md-type="paragraph">Core Web Vitals の "良い" しきい値の候補を評価する際には、<a href="https://developer.chrome.com/docs/crux/" data-md-type="link">Chrome User Experience Report</a> (CrUX) のデータに基づいてそのしきい値が達成可能かどうかを検証します。あるしきい値が達成可能であることを確認するには、少なくとも<a href="/same-site-same-origin/#origin" data-md-type="link">オリジン</a>の 10% が現時点で "良い" しきい値を満たしていることが求められます。また、最適化されたサイトがフィールド データのばらつきによって誤って分類されてしまわないように、最適化されたコンテンツが "良い" しきい値を一貫して満たしているかどうかについても確認します。</p>
<p data-md-type="paragraph">逆に、少数のオリジンのみが現時点で満たすことができていないパフォーマンス レベルを特定することにより、"悪い" しきい値を確立します。"悪い" しきい値の定義に関連する研究がない限りは、最もパフォーマンスの悪い 10% から 30% のオリジンがデフォルトで "悪い" として分類されます。</p>
<h3 data-md-type="header" data-md-header-level="3">基準についての最終的な見解</h3>
<p data-md-type="paragraph">候補となるしきい値を評価していくと、しきい値が互いに矛盾している場合が散見されました。たとえば、しきい値が一貫して達成が可能であることと、しきい値が一貫して良好なユーザー エクスペリエンスを確保することは、緊張関係にあります。また、人間の知覚に関する研究では一般的に値が範囲で提供されており、ユーザーの行動指標においては行動に緩やかな変化が見られることから、指標における "正しい" しきい値が 1 つではない場合が多いことが分かりました。このように、2020 年の Core Web Vitals では、完璧なしきい値というものは存在せず、時には複数の合理的なしきい値の候補の中から選択する必要があることを認識しつつ、上記の基準に最もよく適合する値を選択するというアプローチを取っています。「完璧なしきい値とは？」という問いではなく、「どれが私たちの基準に最もよく当てはまるしきい値の候補なのか？」という問いに焦点を当てました。</p>
<h2 data-md-type="header" data-md-header-level="2">パーセンタイルの選択</h2>
<p data-md-type="paragraph">先に述べたとおり、ページやサイトの総合的なパフォーマンスの分類には、そのページやサイトの全訪問者数の 75 パーセンタイルという値が使用されています。75 パーセンタイルという値は、次の 2 つの基準に基づいて選択されています。1 つ目の基準は、このパーセンタイルが、ページやサイトの訪問者の大多数が目標とするレベルのパフォーマンスを体験できることを確約するものでなければならないということです。そして 2 つ目の基準は、選択したパーセンタイルの値が外れ値による影響を受けすぎないということです。</p>
<p data-md-type="paragraph">これらの目標は、お互いにやや相反する部分があります。1 つ目の目標を達成するには、一般的にパーセンタイルが高ければ高いほど良い結果となります。しかしながら、パーセンタイルが高くなるにつれて結果的に得られる値が外れ値の影響を受ける可能性も高くなります。あるサイトに対する少数の訪問が、ネットワーク接続がたまたま不安定であったために過剰に大きい LCP サンプルとなってしまった場合、サイトの分類がこういった外れ値のサンプルによって決定されてしまうことは避けたいものです。たとえば、訪問数が 100 回となるサイトのパフォーマンスを 95 などの高いパーセンタイル値を用いて評価する場合、95 というパーセンタイル値が外れ値による影響を受けるために必要な外れ値のサンプル数は、たったの 5 つです。</p>
<p data-md-type="paragraph">これらの目標については多少相反する部分があるのですが、分析の結果、75 パーセンタイルが妥当なバランスであるという結論に至りました。75 パーセンタイルという値を使用することにより、ほとんどのサイト訪問者 (4 人中 3 人) が目標とするレベル以上のパフォーマンスを体験できたことが分かったのです。また、75 パーセンタイルという値は、外れ値による影響を受けにくくなっています。例に戻って見てみると、訪問数が 100 回となるサイトでは、75 というパーセンタイルの値が外れ値の影響を受けるため必要な外れ値のサンプル数は、25 です。100 件のサンプルのうち 25 件が外れ値となる可能性がありますが、95 パーセンタイルの場合に比べると確率ははるかに低くなります。</p>
<h2 data-md-type="header" data-md-header-level="2">Largest Contentful Paint</h2>
<h3 data-md-type="header" data-md-header-level="3">ユーザー体験の質</h3>
<p data-md-type="paragraph">ユーザーがタスクに集中できなくなるまでの時間として "1秒" という数字がよく挙げられます。しかしながら、関連する調査を詳しく調べてみると、1 秒というのはおおよそ数百ミリ秒から数秒までの値の範囲を示す近似値であることが分かりました。</p>
<p data-md-type="paragraph">1 秒のしきい値については、<a href="https://dl.acm.org/doi/10.1145/108844.108874" data-md-type="link">Card など</a>および <a href="https://dl.acm.org/doi/10.1145/1476589.1476628" data-md-type="link">Miller</a> による 2 つの論文がよく引用されています。Card は、Newell の「<a href="https://dl.acm.org/doi/book/10.5555/86564" data-md-type="link">認知の統一理論</a>」を引用して、1 秒という "即時反応" のしきい値を定義しています。Newell は、即時反応を「ある刺激に対して<em data-md-type="emphasis">約 1 秒</em> (つまり、おおよそ 0.3 秒から 3 秒) 以内に行われる必要がある反応」として説明しています。これは、Newell の "認知についてのリアルタイムの制約" の議論に続くもので、「認知的考察を喚起するような環境との相互作用は、おおよそ 0.5 秒から 2-3 秒の範囲内で行われる」と述べています。また、1 秒というしきい値に関するもう 1 つの一般的な引用元に挙げられている Miller は、「反応の遅れが 2 秒を超え、さらに 1 秒程度延長される可能性がある場合、人間が機械コミュニケーションを使用して行うことのできるタスクは、その性格を大きく変えるだろう」と述べています。</p>
<p data-md-type="paragraph">Miller および Card の研究では、ユーザーが集中力を失うまでの待ち時間がおおよそ 0.3 秒から 3 秒の範囲であることを記述しており、LCP の "良い" しきい値がこの範囲内に含まれるべきであることを示唆しています。また、既存の First Contentful Paint (視覚コンテンツの初期表示時間、FCP) の "良い" しきい値が 1 秒であり、Largest Contentful Paint が通常 First Contentful Paint の後に発生することを考慮し、LCP のしきい値の候補の範囲を 1 秒から 3 秒へとさらに制限しています。この範囲内で最も基準に適合するしきい値を選択するために、以下ではこれらのしきい値の候補の達成可能性について見ていきます。</p>
<h3 data-md-type="header" data-md-header-level="3">達成可能性</h3>
<p data-md-type="paragraph">CrUX のデータを使用することで、候補となる LCP の "良い" しきい値を満たす Web 上のオリジンのパーセンテージを決定することができます。</p>
<p data-md-type="paragraph"><strong data-md-type="double_emphasis">(候補となる LCP のしきい値について) "良い" に分類された CrUX のオリジンのパーセンテージ</strong></p>
<div data-md-type="block_html"><div>
  <table>
    <tr>
      <th> </th>
      <th>1 秒</th>
      <th>1.5 秒</th>
      <th>2 秒</th>
      <th>2.5 秒</th>
      <th>3 秒</th>
    </tr>
    <tr>
      <td><strong>スマートフォン</strong></td>
      <td>3.5%</td>
      <td>13％</td>
      <td>27％</td>
      <td>42％</td>
      <td>55％</td>
    </tr>
    <tr>
      <td><strong>デスクトップ</strong></td>
      <td>6.9％</td>
      <td>19％</td>
      <td>36％</td>
      <td>51％</td>
      <td>64％</td>
    </tr>
  </table>
</div></div>
<p data-md-type="paragraph">1 秒のしきい値を満たしているオリジンは 10% 未満ですが、1.5 秒から 3 秒までの他のしきい値を見てみると、少なくとも 10% のオリジンが "良い" しきい値を満たしているという条件に適合しており、したがって、これらは有効な候補であると言えます。</p>
<p data-md-type="paragraph">加えて、最適化されているサイトが一貫して達成することができるしきい値を確実に選択するために、Web 全体においてパフォーマンスが上位に数えられるサイトの LCP パフォーマンスを分析し、これらのサイトにおいて一貫して達成が可能となるしきい値の決定を行う必要がありました。具体的には、パフォーマンスの高いサイトの 75 パーセンタイルにおいて一貫して達成が可能なしきい値の特定を目標としました。その結果として、1.5 秒や 2 秒のしきい値については一貫して達成することができないものの、2.5 秒であれば一貫して達成可能であることが分かりました。</p>
<p data-md-type="paragraph">LCP の "悪い" しきい値の特定には CrUX のデータを使用し、ほぼすべてのオリジンが満たすしきい値を特定しました。</p>
<p data-md-type="paragraph"><strong data-md-type="double_emphasis">(候補となる LCP のしきい値について) "悪い" に分類された CrUX のオリジンのパーセンテージ</strong></p>
<div data-md-type="block_html"><div>
  <table>
    <tr>
      <th> </th>
      <th>3 秒</th>
      <th>3.5 秒</th>
      <th>4 秒</th>
      <th>4.5 秒</th>
      <th>5 秒</th>
    </tr>
    <tr>
      <td><strong>スマートフォン</strong></td>
      <td>45％</td>
      <td>35％</td>
      <td>26％</td>
      <td>20％</td>
      <td>15％</td>
    </tr>
    <tr>
      <td><strong>デスクトップ</strong></td>
      <td>36％</td>
      <td>26％</td>
      <td>19％</td>
      <td>14％</td>
      <td>10％</td>
    </tr>
  </table>
</div></div>
<p data-md-type="paragraph">4 秒のしきい値では、スマートフォンからのアクセスの約 26%、デスクトップからのアクセスの約 21％ が "悪い" として分類されています。これは、Google が目標としている 10% から 30％ の範囲に含まれているため、4 秒というしきい値は "悪い" しきい値として許容範囲内であると結論付けました。</p>
<p data-md-type="paragraph">このように、Largest Contentful Paint については 2.5 秒が "良い" しきい値として妥当であり、4 秒が "悪い" しきい値として妥当であるとして結論付けました。</p>
<h2 data-md-type="header" data-md-header-level="2">First Input Delay</h2>
<h3 data-md-type="header" data-md-header-level="3">ユーザー体験の質</h3>
<p data-md-type="paragraph">研究によれば、100 ミリ秒程度までの視覚的なフィードバックの遅延は、ユーザーによる入力などといった関連するソースによって引き起こされたものであるとして認識されるという結論が合理的な一貫性を持っています。このことから、First Input Delay の "良い" しきい値の最低基準として、100 ミリ秒という値が適切であると考えられます。入力処理の遅延が 100 ミリ秒を超えてくると、他の処理やレンダリングなどのステップが間に合わなくなってしまうのです。</p>
<p data-md-type="paragraph">よく引用される Jakob Nielsen の「<a href="https://www.nngroup.com/articles/response-times-3-important-limits/" data-md-type="link">応答時間: ３つの重要な限界値</a>」では、システムが瞬時に応答しているとユーザーに感じさせるための限界値を 0.1 秒と定義しています。Nielsen は Miller と Card の研究を引用し、Card は Michotte による「<a href="https://psycnet.apa.org/record/1964-05029-000" data-md-type="link">因果関係の知覚</a>」(1962) を引用しています。Michotte の研究では、実験参加者に対してスクリーンに映った 2 つの物体を見せます。物体 A は 物体 B に向かって移動を開始し、物体 B に接触した瞬間に停止し、その後物体 B は移動を開始して物体 A から離れていきます。そして Michotte は、物体 A の動作が停止してから物体 B が動作を開始するまでの時間の間隔を変化させていきます。およそ 100 ミリ秒までの遅延では、物体 A が物体 B の動作を引き起こしているという印象を受けます。およそ 100 ミリ秒から 200 ミリ秒までの遅延では因果関係の知覚は混在し、200 ミリ秒以上の遅延では、物体 B の動作はもはや物体 A によって引き起こされたものではないと考えられます。</p>
<p data-md-type="paragraph">同様に、Miller は "制御装置の起動に対する応答" についての応答のしきい値を「一般的にキーやスイッチなどを含む制御装置の物理的な起動を示す動作によって表現される操作の現れ」と定義し、「この応答は、(中略) 操作者によって引き起こされる機械的な動作の一部として知覚される必要があり、遅延時間は 0.1 秒以下にとどめる必要がある」と述べています。その後、「キーを押下してから視覚的なフィードバックを得るまでの遅延は、0.1 秒から 0.2 秒以下にとどめる必要がある」とも述べています。</p>
<p data-md-type="paragraph">さらに最近では、Kaaresoja らが「<a href="https://dl.acm.org/doi/10.1145/2611387" data-md-type="link">時間的に完璧な仮想的なボタンへ向けて</a>」の中で、タッチスクリーンに表示された仮想的なボタンをタッチすることと、ボタンがタッチされたことを後から示す視覚的なフィードバックの同時性の知覚に関して、さまざまな遅延に関する調査を実施しています。ボタンを押してから視覚的なフィードバックが得られるまでの 遅延が 85 ミリ秒以下となる場合、参加者は 75% の割合でボタンを押したと同時に視覚的なフィードバックが得られたと回答しました。また、遅延時間が 100 ミリ秒以下となる場合には、参加者はボタン押下の知覚品質が一貫して高いと回答しましたが、100 ミリ秒から 150 ミリ秒の遅延時間では知覚品質は低下し、300 ミリ秒では非常に低いレベルにまで達しました。</p>
<p data-md-type="paragraph">以上のことから、調査の結果として Web Vitals の 1 つである First Input Delay のしきい値としては、100 ミリ秒前後の値が適切であると結論付けられました。また、300 ミリ秒以上の遅延についてユーザーが低品質であるとして報告していることから、"悪い" しきい値としては 300 ミリ秒が妥当であると判断しました。</p>
<h3 data-md-type="header" data-md-header-level="3">達成可能性</h3>
<p data-md-type="paragraph">CrUX のデータを使用し、Web 上のオリジンの大多数 (75 パーセンタイル) が 100 ミリ秒という FID の "良い" しきい値を満たしていることを特定しました。</p>
<p data-md-type="paragraph"><strong data-md-type="double_emphasis">(100 ミリ秒という FID のしきい値について) "良い" に分類された CrUX のオリジンのパーセンテージ</strong></p>
<div data-md-type="block_html"><div>
  <table>
    <tr>
      <th></th>
      <th>100 ミリ秒</th>
    </tr>
    <tr>
      <td><strong>スマートフォン</strong></td>
      <td>78％</td>
    </tr>
    <tr>
      <td><strong>デスクトップ</strong></td>
      <td>99％ より大きい</td>
    </tr>
  </table>
</div></div>
<p data-md-type="paragraph">また、Web 上における上位のサイトの 75 パーセンタイルがこのしきい値を常に満たすことができる (95 パーセンタイルが満たしている場合も多い) ことが確認できました。</p>
<p data-md-type="paragraph">以上のことから、FID のしきい値については、100 ミリ秒が "良い" しきい値として妥当であることが結論付けられました。</p>
<h2 data-md-type="header" data-md-header-level="2">Cumulative Layout Shift</h2>
<h3 data-md-type="header" data-md-header-level="3">ユーザー体験の質</h3>
<p data-md-type="paragraph">Cumulative Layout Shift (CLS) は、ページに表示されているコンテンツがどの程度移動するかを測定するための新しい指標です。CLS は新しい指標であるため、この指標での理想的なしきい値を直接的に知ることができるような研究はありません。そこで、ユーザーの期待に沿ったしきい値を特定するために、レイアウト シフトの大きさが様々に異なる実際のページを評価し、ページ コンテンツの消費に大きな混乱をもたらすことのない、許容範囲内として考えられる最大のレイアウト シフトの大きさを決定しました。Google の社内テストでは、0.15 を超えるレイアウト シフトは一貫して不快に感じられ、0.1 以下のレイアウト シフトは目立ちはするものの、過剰に不快に感じられるものではないことが明らかになりました。したがって、レイアウト シフトが発生しない場合が理想ではありますが、0.1 までの値であれば、"良い" CLS のしきい値の候補になると結論付けました。</p>
<h3 data-md-type="header" data-md-header-level="3">達成可能性</h3>
<p data-md-type="paragraph">CrUX のデータによると、オリジン全体の約 50％ において CLS が 0.05 以下となっていることがわかりました。</p>
<p data-md-type="paragraph"><strong data-md-type="double_emphasis">「良好」として分類されたCrUXオリジンの割合（候補CLSしきい値の場合）</strong></p>
<div data-md-type="block_html"><div>
  <table>
    <tr>
      <th> </th>
      <th>0.05</th>
      <th>0.1</th>
      <th>0.15</th>
    </tr>
    <tr>
      <td><strong>スマートフォン</strong></td>
      <td>49％</td>
      <td>60％</td>
      <td>69％</td>
    </tr>
    <tr>
      <td><strong>デスクトップ</strong></td>
      <td>42％</td>
      <td>59％</td>
      <td>69％</td>
    </tr>
  </table>
</div></div>
<p data-md-type="paragraph">CrUX のデータは 0.05 が CLS の "良い" しきい値として妥当であることを示唆していますが、現在は混乱をもたらすようなレイアウト シフトの回避が困難となるユース ケースが存在することも認識しています。たとえば、ソーシャルメディアの埋め込みなどを含むサードパーティ製の埋め込みコンテンツでは、埋め込まれているコンテンツの高さが読み込みが完了するまで分からないという場合もあり、その場合には 0.05 よりも大きいレイアウト シフトが発生してしまう可能性があります。このように、0.05 という CLS のしきい値を多くのオリジンが満たしてはいるものの、しきい値を 0.1 と多少緩めに設定することでユーザー体験の質と達成可能性のバランスを取ることができると結論付けました。Web の世界のエコシステムが機能することでサードパーティ製の埋め込みコンテンツによるレイアウト シフトへの対処方法が今後特定され、将来的な Core Web Vitals のバージョンにおいてより厳格な CLSの "良い" しきい値である 0.05 や 0 を使用できるようになることを期待しています。</p>
<p data-md-type="paragraph">加えて、CLS の "悪い" しきい値を決定するために、CrUX のデータを使用して大半のオリジンが満たしているしきい値を特定しました。</p>
<p data-md-type="paragraph"><strong data-md-type="double_emphasis">(候補となる CLS のしきい値について) "悪い" に分類された CrUX のオリジンのパーセンテージ</strong></p>
<div data-md-type="block_html"><div>
  <table>
    <tr>
      <th> </th>
      <th>0.15</th>
      <th>0.2</th>
      <th>0.25</th>
      <th>0.3</th>
    </tr>
    <tr>
      <td><strong>スマートフォン</strong></td>
      <td>31％</td>
      <td>25％</td>
      <td>20％</td>
      <td>18％</td>
    </tr>
    <tr>
      <td><strong>デスクトップ</strong></td>
      <td>31％</td>
      <td>23％</td>
      <td>18％</td>
      <td>16％</td>
    </tr>
  </table>
</div></div>
<p data-md-type="paragraph">0.25 のしきい値では、スマートフォンからのアクセスの約 20%、デスクトップからのアクセスの約 18％ が "悪い" として分類されています。これは、Google が目標としている 10% から 30％ の範囲に含まれているため、0.25 というしきい値は "悪い" しきい値として許容範囲内であると結論付けました。</p>
