---
layout: post
title: "¿Por qué es importante la velocidad?"
authors:
  - bojanpavic
  - ansteychris
  - jlwagner
description: Cuando se trata de la experiencia del usuario, la velocidad importa, y los retrasos provocados por la velocidad móvil no solo son frustrantes, también puede tener un impacto negativo en los resultados comerciales.
web_lighthouse: N/A
date: 2019-05-01
updated: 2020-07-23
tags:
  - performance
---

Los consumidores confían cada vez más en los dispositivos móviles para acceder a contenido y servicios digitales, y si observa la analítica de su sitio, probablemente verá esta historia en sus propios datos. Los consumidores también son más exigentes que nunca, y cuando evalúan la experiencia en su sitio, no solo lo comparan con sus competidores, sino que lo evalúan en comparación con los mejores servicios de su clase que utilizan todos los días.

Este artículo resume algunas de las investigaciones que se han realizado sobre la relación entre el rendimiento y el éxito empresarial.

## El rendimiento se trata de retener a los usuarios

<figure data-float="right">
  <blockquote>
    <p>El rendimiento ha tenido un impacto directo en los resultados de la empresa.</p>
    <cite>
      <p data-md-type="paragraph"><a href="https://www.youtube.com/watch?v=Xryhxi45Q5M&amp;feature=youtu.be&amp;t=1366">Pinterest</a></p>
    </cite>
  </blockquote></figure>

El rendimiento juega un papel importante en el éxito de cualquier empresa en línea. Los sitios de alto rendimiento atraen y retienen a los usuarios mejor que los de bajo rendimiento.

Pinterest redujo los tiempos de espera percibidos en un 40% y esto [aumentó el tráfico de motores de búsqueda y los registros en un 15%](https://medium.com/@Pinterest_Engineering/driving-user-growth-with-performance-improvements-cfc50dafadd7).

COOK redujo el tiempo promedio de carga de la página en 850 milisegundos, lo que [aumentó las conversiones en un 7%, disminuyó las tasas de rebote en un 7% y aumentó las páginas por sesión en un 10%](https://www.nccgroup.trust/globalassets/resources/uk/case-studies/web-performance/cook-case-study.pdf).

Los estudios también han demostrado el impacto negativo que puede tener un desempeño deficiente en los objetivos comerciales. Por ejemplo, [la BBC](https://www.creativebloq.com/features/how-the-bbc-builds-websites-that-scale) descubrió que perdían un 10% adicional de usuarios por cada segundo adicional que tardaba en cargar su sitio.

## El rendimiento se trata de mejorar las conversiones

Retener a los usuarios es fundamental para mejorar las conversiones. Los sitios lentos tienen un impacto negativo en los ingresos y se muestra que los sitios rápidos aumentan sus tasas de conversión.

Para [Mobify](http://resources.mobify.com/2016-Q2-mobile-insights-benchmark-report.html) , cada disminución de 100ms en la velocidad de carga de la página de inicio resultó en un aumento del 1,11% en la conversión basada en sesiones, lo que arrojó un aumento de ingresos anual promedio de casi $380 000. Además, una disminución de 100ms en la velocidad de carga de la página de pago ascendió a un aumento del 1,55% en la conversión basada en sesiones, lo que a su vez produjo un aumento de ingresos anual promedio de casi $530 000.

Cuando [AutoAnything redujo el tiempo de carga de la página a la mitad](https://www.digitalcommerce360.com/2010/08/19/web-accelerator-revs-conversion-and-sales-autoanything/), vieron un aumento del 12% al 13% en las ventas.

La distribuidora minorista [Furniture Village](https://www.thinkwithgoogle.com/intl/en-gb/success-stories/uk-success-stories/furniture-village-and-greenlight-slash-page-load-times-boosting-user-experience/) auditó la velocidad de su sitio y desarrolló un plan para abordar los problemas que encontraron, lo que resultó en una reducción del 20% en el tiempo de carga de la página y un aumento del 10% en la tasa de conversión.

## El rendimiento se trata de la experiencia del usuario

Cuando se trata de la experiencia del usuario, la velocidad importa. Un [estudio de consumidores](https://www.ericsson.com/en/press-releases/2016/2/streaming-delays-mentally-taxing-for-smartphone-users-ericsson-mobility-report) muestra que la respuesta de estrés a los retrasos en la velocidad de los dispositivos móviles, es similar a la de ver una película de terror o resolver un problema matemático, y mayor que esperar en una fila para pagar en una tienda minorista.

A medida que un sitio comienza a cargarse, hay un período de tiempo en el que los usuarios esperan a que aparezca el contenido. Hasta que esto suceda, no hay experiencia de usuario de la que hablar. Esta falta de experiencia es fugaz en conexiones rápidas. Sin embargo, en conexiones más lentas, los usuarios se ven obligados a esperar. Los usuarios pueden experimentar más problemas a medida que los recursos de la página ingresan lentamente.

<figure>{% Img src="image/admin/W0ctiX3cMOfWnNF6AQMg.png", alt="Una comparación de dos carretes de tira de película de una página que se carga. La primera muestra una página que se carga en una conexión lenta, mientras que la segunda muestra la misma página que se carga en una conexión rápida.", width="800", height="264" %}<figcaption> Una comparación de la carga de la página en una conexión muy lenta (arriba) versus una conexión más rápida (abajo).</figcaption></figure>

El rendimiento es un aspecto fundamental de las buenas experiencias de usuario. Cuando los sitios envían mucho código, los navegadores deben usar megabytes del plan de datos del usuario para descargar el código. Los dispositivos móviles tienen memoria y potencia de CPU limitadas, a menudo se sienten abrumados con lo que podríamos considerar una pequeña cantidad de código no optimizado. Esto crea un rendimiento deficiente que conduce a la falta de respuesta. Sabiendo lo que sabemos sobre el comportamiento humano, los usuarios solo tolerarán aplicaciones de bajo rendimiento durante un tiempo antes de abandonarlas.

## El rendimiento se trata de personas

Los sitios y aplicaciones con un rendimiento deficiente también pueden representar costos reales para las personas que los utilizan.

[Dado que los usuarios móviles continúan constituyendo una parte mayor de los usuarios de Internet en todo el mundo](http://gs.statcounter.com/platform-market-share/desktop-mobile-tablet), es importante tener en cuenta que muchos de estos usuarios acceden a la web a través de redes móviles LTE, 4G, 3G e incluso 2G. Como señala Ben Schwarz de Caliber en [este estudio sobre el rendimiento en el mundo real](https://calibreapp.com/blog/beyond-the-bubble), el costo de los planes de datos prepago está disminuyendo, lo que a su vez hace que el acceso a Internet sea más asequible en lugares donde antes no lo era. Los dispositivos móviles y el acceso a Internet ya no son lujos, son herramientas comunes necesarias para navegar y funcionar en un mundo cada vez más interconectado.

[El tamaño total de la página ha aumentado constantemente desde al menos 2011](http://beta.httparchive.org/reports/state-of-the-web#bytesTotal), y la tendencia parece continuar. A medida que la página típica envía más datos, los usuarios deben reabastecer sus planes de datos medidos con más frecuencia, lo que les cuesta dinero.

Además de ahorrar dinero a sus usuarios, las experiencias de usuario rápidas y ligeras también pueden resultar cruciales para los usuarios en crisis. Los recursos públicos como hospitales, clínicas y centros de crisis tienen recursos en línea que brindan a los usuarios información importante y específica que necesitan durante una crisis. [Si bien el diseño es fundamental para presentar información importante de manera eficiente en momentos estresantes](https://aneventapart.com/news/post/eric-meyer-designing-for-crisis), la importancia de entregar esta información rápidamente no puede subestimarse. Es parte de nuestro trabajo.

## Empiece a mejorar la velocidad de su sitio web {: #get-started }

Lea sobre [Core Web Vitals](/vitals/#core-web-vitals) para conocer las métricas en las que Google cree que todos los sitios web deberían centrarse.

<blockquote>
  <p>Hoy, nos basamos en este trabajo y proporcionamos una mirada anticipada a un próximo cambio de clasificación de búsqueda que incorpora estas métricas de experiencia de la página. Presentaremos una nueva señal que combina Core Web Vitals con nuestras señales existentes para la experiencia de la página para proporcionar una imagen holística de la calidad de la experiencia de un usuario en una página web.</p>
  <cite><a href="https://webmasters.googleblog.com/2020/05/evaluating-page-experience.html">Evaluación de la experiencia de la página para mejorar la web</a>, Blog oficial del Centro para webmasters de Google</cite>
</blockquote>

Luego, consulte [Tiempos de carga rápidos](/fast/) para obtener muchos consejos y trucos relacionados con cómo ser y mantenerse rápido.
